/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.common;

import java.util.HashMap;
import java.util.Map;

public enum MarkdomContentType {
    CODE("Code"),
    EMPHASIS("Emphasis"),
    IMAGE("Image"),
    LINE_BREAK("LineBreak"),
    LINK("Link"),
    TEXT("Text");

    private static final Map<String, MarkdomContentType> MAP;
    private final String name;

    public String toName() {
        return this.name;
    }

    public static MarkdomContentType fromName(String value) throws IllegalArgumentException {
        MarkdomContentType type = MAP.get(value);
        if (null == type) {
            throw new IllegalArgumentException("There is no content type with the given string value: " + value);
        }
        return type;
    }

    private MarkdomContentType(String name) {
        this.name = name;
    }

    static {
        MAP = new HashMap<String, MarkdomContentType>();
        for (MarkdomContentType type : MarkdomContentType.values()) {
            MAP.put(type.name, type);
        }
    }
}

