/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.mybatis.cache;

import io.lsn.spring.mybatis.cache.DummyReadWriteLock;
import io.lsn.spring.mybatis.cache.MybatisRedissonClientHolder;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.redisson.api.RMap;

public class MybatisRedisCache
implements Cache {
    private final ReadWriteLock readWriteLock = new DummyReadWriteLock();
    private String id;

    private RMap<Object, Object> getCache() {
        return MybatisRedissonClientHolder.getClient().getMap(this.id);
    }

    public MybatisRedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    public void putObject(Object key, Object value) {
        this.getCache().put((Object)key.toString(), value);
    }

    public Object getObject(Object key) {
        return this.getCache().get((Object)key.toString());
    }

    public Object removeObject(Object key) {
        return this.getCache().remove((Object)key.toString());
    }

    public void clear() {
        this.getCache().clear();
    }

    public int getSize() {
        return this.getCache().size();
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public String getId() {
        return this.id;
    }

    public MybatisRedisCache setId(String id) {
        this.id = id;
        return this;
    }
}

