package io.lsn.spring.mybatis.cache;

import org.apache.ibatis.cache.Cache;
import org.redisson.api.RMap;

import java.util.concurrent.locks.ReadWriteLock;

public class MybatisRedisCache implements Cache {

    private final ReadWriteLock readWriteLock = new DummyReadWriteLock();
    private String id;

    private RMap<Object, Object> getCache() {
        return MybatisRedissonClientHolder.getClient().getMap(id);
    }

    public MybatisRedisCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
    }

    @Override
    public void putObject(Object key, Object value) {
        getCache().put(key.toString(), value);
    }

    @Override
    public Object getObject(Object key) {
        return getCache().get(key.toString());
    }

    @Override
    public Object removeObject(Object key) {
        return getCache().remove(key.toString());
    }

    @Override
    public void clear() {
        getCache().clear();
    }

    @Override
    public int getSize() {
        return getCache().size();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return readWriteLock;
    }

    @Override
    public String getId() {
        return id;
    }

    public MybatisRedisCache setId(String id) {
        this.id = id;
        return this;
    }
}
