/*
 * Decompiled with CFR 0.152.
 */
package io.liveqa.web;

import io.liveqa.Config;
import io.liveqa.LiveQA;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiveQAFilter
implements Filter {
    private static final ThreadLocal<Map> STORE = new ThreadLocal();
    private static final String TRACKER_NAME = "liveqa_tracker_id";
    private Map<String, Object> store;
    private HttpServletRequest request;

    public static Map getStore() {
        return STORE.get();
    }

    public LiveQAFilter() {
    }

    public LiveQAFilter(Config config) {
        LiveQA.configure((Config)config);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String accountToken = filterConfig.getInitParameter("accountToken");
        String spaceName = filterConfig.getInitParameter("spaceName");
        String environmentName = filterConfig.getInitParameter("environmentName");
        if (accountToken != null) {
            Config config = Config.builder((String)accountToken, (String)spaceName, (String)environmentName).build();
            LiveQA.configure((Config)config);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.store = new HashMap<String, Object>();
        this.request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        STORE.set(this.store);
        this.storeTrackerId();
        this.storeRequestData();
        response.addCookie(new Cookie(TRACKER_NAME, this.store.get("sessionTrackerId").toString()));
        chain.doFilter(req, res);
        STORE.remove();
    }

    public void destroy() {
        LiveQA.shutdown();
    }

    private void storeTrackerId() {
        String value = null;
        if (this.request.getCookies() != null) {
            for (Cookie cookie : this.request.getCookies()) {
                if (!TRACKER_NAME.equals(cookie.getName())) continue;
                value = cookie.getValue();
            }
        }
        this.store.put("sessionTrackerId", value == null || value.isEmpty() ? UUID.randomUUID() : value);
    }

    private void storeRequestData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("url", this.getFullUrl());
        data.put("ssl", this.httpsRequest());
        data.put("host", this.request.getServerName());
        data.put("port", this.request.getServerPort());
        data.put("path", this.request.getRequestURI());
        data.put("referrer", this.request.getHeader("Referer"));
        data.put("method", this.request.getMethod());
        data.put("xhr", "XMLHttpRequest".equals(this.request.getHeader("X-Requested-With")));
        data.put("userAgent", this.request.getHeader("User-Agent"));
        data.put("ip", this.request.getRemoteAddr());
        data.put("headers", this.getHeaders());
        if (this.request.getMethod().equals("POST")) {
            data.put("postParams", this.getParams());
        } else {
            data.put("getParams", this.getParams());
        }
        this.store.put("request", data);
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        String[] skipHeaders = new String[]{"host", "user-agent", "cookie"};
        Enumeration headerNames = this.request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (Arrays.stream(skipHeaders).anyMatch(headerName::equals)) continue;
            headers.put(headerName, this.request.getHeader(headerName));
        }
        return headers;
    }

    private Map<String, List<String>> getParams() {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        Map paramNames = this.request.getParameterMap();
        for (Map.Entry param : paramNames.entrySet()) {
            if (param.getValue() == null || ((String[])param.getValue()).length <= 0) continue;
            params.put((String)param.getKey(), (List<String>)Arrays.asList((Object[])param.getValue()));
        }
        return params;
    }

    private boolean httpsRequest() {
        if ("https".equals(this.request.getHeader("X-Forwarded-Proto"))) {
            return true;
        }
        return "https".equals(this.request.getScheme());
    }

    public String getFullUrl() {
        StringBuilder requestUrl = new StringBuilder(this.request.getRequestURL().toString());
        String queryString = this.request.getQueryString();
        if (queryString == null) {
            return requestUrl.toString();
        }
        return requestUrl.append('?').append(queryString).toString();
    }
}

