/*
 * Decompiled with CFR 0.152.
 */
package io.kvision.remote;

import io.kvision.remote.HttpMethod;
import io.kvision.remote.KVServerRequest;
import io.kvision.remote.KVServiceManager;
import io.kvision.remote.KotlinxObjectDeSerializerKt;
import jakarta.annotation.PostConstruct;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.reactive.function.server.ServerResponseExtensionsKt;

@Component
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B!\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0016\u001a\u00020\u0017H\u0017J\b\u0010\u0018\u001a\u00020\u0012H\u0017J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0017J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u001dR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/kvision/remote/KVHandler;", "", "services", "", "Lio/kvision/remote/KVServiceManager;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "<init>", "(Ljava/util/List;Lorg/springframework/context/ApplicationContext;)V", "getServices", "()Ljava/util/List;", "getApplicationContext", "()Lorg/springframework/context/ApplicationContext;", "serializersModules", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModules", "threadLocalRequest", "Ljava/lang/ThreadLocal;", "Lorg/springframework/web/reactive/function/server/ServerRequest;", "threadLocalHeadersBuilder", "Lorg/springframework/web/reactive/function/server/ServerResponse$HeadersBuilder;", "Lorg/springframework/web/reactive/function/server/ServerResponse$BodyBuilder;", "init", "", "serverRequest", "headersBuilder", "handle", "Lorg/springframework/web/reactive/function/server/ServerResponse;", "request", "(Lorg/springframework/web/reactive/function/server/ServerRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleSse", "kvision-server-spring-boot"})
@SourceDebugExtension(value={"SMAP\nKVRouterConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KVRouterConfiguration.kt\nio/kvision/remote/KVHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,136:1\n1863#2,2:137\n*S KotlinDebug\n*F\n+ 1 KVRouterConfiguration.kt\nio/kvision/remote/KVHandler\n*L\n85#1:137,2\n*E\n"})
public class KVHandler {
    @NotNull
    private final List<KVServiceManager<?>> services;
    @NotNull
    private final ApplicationContext applicationContext;
    @Autowired(required=false)
    @Nullable
    private final List<SerializersModule> serializersModules;
    @NotNull
    private final ThreadLocal<ServerRequest> threadLocalRequest;
    @NotNull
    private final ThreadLocal<ServerResponse.HeadersBuilder<ServerResponse.BodyBuilder>> threadLocalHeadersBuilder;

    public KVHandler(@NotNull List<? extends KVServiceManager<?>> services, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.services = services;
        this.applicationContext = applicationContext;
        this.threadLocalRequest = new ThreadLocal();
        this.threadLocalHeadersBuilder = new ThreadLocal();
    }

    @NotNull
    public final List<KVServiceManager<?>> getServices() {
        return this.services;
    }

    @NotNull
    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Nullable
    public final List<SerializersModule> getSerializersModules() {
        return this.serializersModules;
    }

    @PostConstruct
    public void init() {
        Iterable $this$forEach$iv = this.services;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KVServiceManager it = (KVServiceManager)((Object)element$iv);
            boolean bl = false;
            it.setDeSerializer(KotlinxObjectDeSerializerKt.kotlinxObjectDeSerializer(this.serializersModules));
        }
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public ServerRequest serverRequest() {
        ServerRequest serverRequest = this.threadLocalRequest.get();
        if (serverRequest == null) {
            serverRequest = new KVServerRequest();
        }
        return serverRequest;
    }

    @Bean
    @Scope(value="prototype")
    @NotNull
    public ServerResponse.HeadersBuilder<ServerResponse.BodyBuilder> headersBuilder() {
        ServerResponse.HeadersBuilder headersBuilder = this.threadLocalHeadersBuilder.get();
        if (headersBuilder == null) {
            ServerResponse.BodyBuilder bodyBuilder = ServerResponse.ok();
            Intrinsics.checkNotNullExpressionValue((Object)bodyBuilder, (String)"ok(...)");
            headersBuilder = (ServerResponse.HeadersBuilder)bodyBuilder;
        }
        return headersBuilder;
    }

    @Nullable
    public Object handle(@NotNull ServerRequest request, @NotNull Continuation<? super ServerResponse> $completion) {
        return KVHandler.handle$suspendImpl(this, request, $completion);
    }

    static /* synthetic */ Object handle$suspendImpl(KVHandler $this, ServerRequest request, Continuation<? super ServerResponse> $completion) {
        Function5<ServerRequest, ThreadLocal<ServerRequest>, ThreadLocal<ServerResponse.HeadersBuilder<ServerResponse.BodyBuilder>>, ApplicationContext, Continuation<? super ServerResponse>, Object> function5 = KVHandler.handle$getHandler(request, $this);
        if (function5 == null) {
            ServerResponse.HeadersBuilder headersBuilder = ServerResponse.notFound();
            Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"notFound(...)");
            return ServerResponseExtensionsKt.buildAndAwait((ServerResponse.HeadersBuilder)headersBuilder, $completion);
        }
        return function5.invoke((Object)request, $this.threadLocalRequest, $this.threadLocalHeadersBuilder, (Object)$this.applicationContext, $completion);
    }

    @Nullable
    public Object handleSse(@NotNull ServerRequest request, @NotNull Continuation<? super ServerResponse> $completion) {
        return KVHandler.handleSse$suspendImpl(this, request, $completion);
    }

    static /* synthetic */ Object handleSse$suspendImpl(KVHandler $this, ServerRequest request, Continuation<? super ServerResponse> $completion) {
        Function5<ServerRequest, ThreadLocal<ServerRequest>, ThreadLocal<ServerResponse.HeadersBuilder<ServerResponse.BodyBuilder>>, ApplicationContext, Continuation<? super ServerResponse>, Object> function5 = KVHandler.handleSse$getSseHandler(request, $this);
        if (function5 == null) {
            ServerResponse.HeadersBuilder headersBuilder = ServerResponse.notFound();
            Intrinsics.checkNotNullExpressionValue((Object)headersBuilder, (String)"notFound(...)");
            return ServerResponseExtensionsKt.buildAndAwait((ServerResponse.HeadersBuilder)headersBuilder, $completion);
        }
        return function5.invoke((Object)request, $this.threadLocalRequest, $this.threadLocalHeadersBuilder, (Object)$this.applicationContext, $completion);
    }

    private static final Function5 handle$getHandler$lambda$1(HttpMethod $kvMethod, String $routeUrl, KVServiceManager it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return (Function5)it.getRouteMapRegistry().findHandler($kvMethod, $routeUrl);
    }

    private static final Function5<ServerRequest, ThreadLocal<ServerRequest>, ThreadLocal<ServerResponse.HeadersBuilder<ServerResponse.BodyBuilder>>, ApplicationContext, Continuation<? super ServerResponse>, Object> handle$getHandler(ServerRequest $request, KVHandler this$0) {
        String string = $request.method().name();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
        String springMethod = string;
        HttpMethod httpMethod = HttpMethod.Companion.fromStringOrNull(springMethod);
        if (httpMethod == null) {
            return null;
        }
        HttpMethod kvMethod = httpMethod;
        String string2 = $request.path();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path(...)");
        String routeUrl = string2;
        return (Function5)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this$0.services), arg_0 -> KVHandler.handle$getHandler$lambda$1(kvMethod, routeUrl, arg_0)));
    }

    private static final Function5 handleSse$getSseHandler$lambda$2(String $routeUrl, KVServiceManager it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return (Function5)it.getSseRequests().get($routeUrl);
    }

    private static final Function5<ServerRequest, ThreadLocal<ServerRequest>, ThreadLocal<ServerResponse.HeadersBuilder<ServerResponse.BodyBuilder>>, ApplicationContext, Continuation<? super ServerResponse>, Object> handleSse$getSseHandler(ServerRequest $request, KVHandler this$0) {
        String string = $request.path();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path(...)");
        String routeUrl = string;
        return (Function5)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this$0.services), arg_0 -> KVHandler.handleSse$getSseHandler$lambda$2(routeUrl, arg_0)));
    }
}

