/*
 * Decompiled with CFR 0.152.
 */
package io.kcache.mapdb;

import io.kcache.KeyValueIterator;
import io.kcache.KeyValueIterators;
import io.kcache.exceptions.CacheInitializationException;
import io.kcache.mapdb.CustomSerializerByteArray;
import io.kcache.utils.PersistentCache;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.mapdb.BTreeMap;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDBCache<K, V>
extends PersistentCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(MapDBCache.class);
    private static final String DB_FILE_DIR = "mapdb";
    private DB db;
    private BTreeMap<byte[], byte[]> map;

    public MapDBCache(String name, String rootDir, Serde<K> keySerde, Serde<V> valueSerde) {
        this(name, DB_FILE_DIR, rootDir, keySerde, valueSerde);
    }

    public MapDBCache(String name, String rootDir, Serde<K> keySerde, Serde<V> valueSerde, Comparator<K> comparator) {
        this(name, DB_FILE_DIR, rootDir, keySerde, valueSerde, comparator);
    }

    public MapDBCache(String name, String parentDir, String rootDir, Serde<K> keySerde, Serde<V> valueSerde) {
        this(name, parentDir, rootDir, keySerde, valueSerde, null);
    }

    public MapDBCache(String name, String parentDir, String rootDir, Serde<K> keySerde, Serde<V> valueSerde, Comparator<K> comparator) {
        super(name, parentDir, rootDir, keySerde, valueSerde, comparator);
    }

    protected void openDB() {
        try {
            this.db = DBMaker.fileDB((File)new File(this.dbDir(), "map.db")).fileMmapEnableIfSupported().make();
            this.map = this.db.treeMap(this.name()).keySerializer(new CustomSerializerByteArray(this.keySerde(), this.comparator())).valueSerializer(Serializer.BYTE_ARRAY).counterEnable().createOrOpen();
        }
        catch (Exception e) {
            throw new CacheInitializationException("Error opening store " + this.name() + " at location " + this.dbDir(), (Throwable)e);
        }
    }

    public int size() {
        this.validateStoreOpen();
        return this.map.size();
    }

    public V put(K key, V value) {
        Objects.requireNonNull(key, "key cannot be null");
        this.validateStoreOpen();
        byte[] keyBytes = this.keySerde().serializer().serialize(null, key);
        byte[] valueBytes = this.valueSerde().serializer().serialize(null, value);
        byte[] oldValueBytes = (byte[])this.map.put((Object)keyBytes, (Object)valueBytes);
        this.db.commit();
        return (V)this.valueSerde().deserializer().deserialize(null, oldValueBytes);
    }

    public void putAll(Map<? extends K, ? extends V> entries) {
        this.validateStoreOpen();
        for (Map.Entry<K, V> entry : entries.entrySet()) {
            byte[] keyBytes = this.keySerde().serializer().serialize(null, entry.getKey());
            byte[] valueBytes = this.valueSerde().serializer().serialize(null, entry.getValue());
            this.map.put((Object)keyBytes, (Object)valueBytes);
        }
        this.db.commit();
    }

    public V get(Object key) {
        this.validateStoreOpen();
        byte[] keyBytes = this.keySerde().serializer().serialize(null, key);
        byte[] valueBytes = (byte[])this.map.get((Object)keyBytes);
        return (V)this.valueSerde().deserializer().deserialize(null, valueBytes);
    }

    public V remove(Object key) {
        Objects.requireNonNull(key, "key cannot be null");
        byte[] keyBytes = this.keySerde().serializer().serialize(null, key);
        byte[] oldValueBytes = (byte[])this.map.remove((Object)keyBytes);
        this.db.commit();
        return (V)this.valueSerde().deserializer().deserialize(null, oldValueBytes);
    }

    protected KeyValueIterator<K, V> range(K from, boolean fromInclusive, K to, boolean toInclusive, boolean isDescending) {
        this.validateStoreOpen();
        byte[] fromBytes = this.keySerde().serializer().serialize(null, from);
        byte[] toBytes = this.keySerde().serializer().serialize(null, to);
        Iterator iter = isDescending ? this.map.descendingEntryIterator((Object)toBytes, toInclusive, (Object)fromBytes, fromInclusive) : this.map.entryIterator((Object)fromBytes, fromInclusive, (Object)toBytes, toInclusive);
        return KeyValueIterators.transformRawIterator((Serde)this.keySerde(), (Serde)this.valueSerde(), (Iterator)iter);
    }

    protected KeyValueIterator<K, V> all(boolean isDescending) {
        this.validateStoreOpen();
        Iterator iter = isDescending ? this.map.descendingEntryIterator() : this.map.entryIterator();
        return KeyValueIterators.transformRawIterator((Serde)this.keySerde(), (Serde)this.valueSerde(), (Iterator)iter);
    }

    public void flush() {
    }

    protected void closeDB() {
        try {
            if (this.db != null) {
                this.db.close();
            }
            this.db = null;
        }
        catch (Exception e) {
            log.warn("Error during close", (Throwable)e);
        }
    }
}

