package io.jvm.asm

import java.io.{FileOutputStream, FileInputStream, BufferedInputStream}

object Main {

  def main(args: Array[String]): Unit = {
    println("start")
    for (arg <- args) {
      println(s"Reading $arg !!")
      val source = new BufferedInputStream(new FileInputStream(arg))
      val ba = Stream.continually(source.read).takeWhile(-1 !=).map(_.toByte).toArray
      val privatezed = Privatization.apply(ba)

      val fis: FileOutputStream = new FileOutputStream(arg + ".p")
      try fis.write(ba) finally fis.close()

      println(s"Provided class is ${if (privatezed) "privatized" else "not privatized"}")
    }
  }

}
