/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.utils;

import io.shiftleft.semanticcpg.utils.ExternalCommandResult;
import io.shiftleft.semanticcpg.utils.ExternalCommandResult$;
import io.shiftleft.utils.IOUtils$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Properties$;
import scala.util.control.NonFatal$;

public final class ExternalCommand$
implements Serializable {
    private static final Logger logger;
    public static final ExternalCommand$ MODULE$;

    private ExternalCommand$() {
    }

    static {
        MODULE$ = new ExternalCommand$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExternalCommand$.class);
    }

    public Logger logger() {
        return logger;
    }

    public ExternalCommandResult run(Seq<String> command, Option<Path> workingDir, boolean mergeStdErrInStdOut, Map<String, String> extraEnv, boolean isShellCommand, Duration timeout, String additionalContext) {
        ExternalCommandResult externalCommandResult;
        block6: {
            Seq<String> cmd = this.createCommand(command, isShellCommand);
            ProcessBuilder builder = new ProcessBuilder(new String[0]).command((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class)));
            builder.environment().putAll(CollectionConverters$.MODULE$.MapHasAsJava(extraEnv).asJava());
            builder.redirectErrorStream(mergeStdErrInStdOut);
            workingDir.foreach((Function1 & Serializable)dir -> builder.directory(dir.toFile()));
            File stdOutFile = File.createTempFile("x2cpg", "stdout");
            Option stdErrFile = Option$.MODULE$.when(!mergeStdErrInStdOut, ExternalCommand$::$anonfun$1);
            builder.redirectOutput(stdOutFile);
            stdErrFile.foreach((Function1 & Serializable)x$0 -> builder.redirectError((File)x$0));
            Comparable actualWorkingDir = (Comparable)workingDir.getOrElse(ExternalCommand$::$anonfun$2);
            String input = "cmd: `" + cmd.mkString(" ") + "`, workingDir: " + actualWorkingDir + ", extraEnv: " + extraEnv;
            Option additionalContextMaybe = Option$.MODULE$.apply((Object)additionalContext).filter((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1)));
            try {
                try {
                    this.logger().debug("executing command: " + input);
                    int exitValue = this.execute(builder, timeout);
                    this.logger().debug("command finished");
                    Seq stdOut = IOUtils$.MODULE$.readLinesInFile(stdOutFile.toPath());
                    Seq stdErr = (Seq)stdErrFile.map((Function1 & Serializable)_$2 -> _$2.toPath()).map((Function1 & Serializable)path -> IOUtils$.MODULE$.readLinesInFile(path)).getOrElse(ExternalCommand$::$anonfun$6);
                    externalCommandResult = ExternalCommandResult$.MODULE$.apply(exitValue, (Seq<String>)stdOut, (Seq<String>)stdErr, input, (Option<String>)additionalContextMaybe);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable exception = throwable3 = (Throwable)option.get();
                        Seq stdOut = IOUtils$.MODULE$.readLinesInFile(stdOutFile.toPath());
                        Seq stdErr = (Seq)((SeqOps)stdErrFile.map((Function1 & Serializable)f -> IOUtils$.MODULE$.readLinesInFile(f.toPath())).getOrElse(ExternalCommand$::$anonfun$8)).$colon$plus((Object)exception.getMessage());
                        this.logger().debug("command did not finish successfully. Input was: " + input);
                        externalCommandResult = ExternalCommandResult$.MODULE$.apply(1, (Seq<String>)stdOut, (Seq<String>)stdErr, input, (Option<String>)additionalContextMaybe);
                        break block6;
                    }
                    throw throwable;
                }
            }
            finally {
                stdOutFile.delete();
                stdErrFile.foreach((Function1 & Serializable)_$3 -> _$3.delete());
            }
        }
        return externalCommandResult;
    }

    public Option<Path> run$default$2() {
        return None$.MODULE$;
    }

    public boolean run$default$3() {
        return false;
    }

    public Map<String, String> run$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public boolean run$default$5() {
        return false;
    }

    public Duration run$default$6() {
        return Duration$.MODULE$.Inf();
    }

    public String run$default$7() {
        return "";
    }

    private Seq<String> createCommand(Seq<String> command, boolean isShellCommand) {
        if (isShellCommand) {
            Seq invokeShell = Properties$.MODULE$.isWin() ? (Seq)((SeqOps)new .colon.colon((Object)"cmd.exe", (List)new .colon.colon((Object)"/C", (List)Nil$.MODULE$))) : (Seq)((SeqOps)new .colon.colon((Object)"sh", (List)new .colon.colon((Object)"-c", (List)Nil$.MODULE$)));
            return (Seq)invokeShell.$plus$plus(command);
        }
        return command;
    }

    private int execute(ProcessBuilder processBuilder, Duration timeout) {
        Integer n;
        Process process = processBuilder.start();
        if (timeout.isFinite()) {
            this.logger().debug("waiting until command completes (with timeout=" + timeout + ")");
            boolean finished = process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (!finished) {
                this.logger().warn("timeout reached - will now kill the external command");
                process.destroy();
                String command = CollectionConverters$.MODULE$.ListHasAsScala(processBuilder.command()).asScala().mkString(" ");
                throw new TimeoutException("command '" + command + "' has timed out after " + timeout);
            }
            n = BoxedUnit.UNIT;
        } else {
            this.logger().debug("waiting until command completes (without a timeout)");
            n = BoxesRunTime.boxToInteger((int)process.waitFor());
        }
        return process.exitValue();
    }

    public Path executableDir(Path packagePath) {
        Path path;
        Path packagePathAbsolute = packagePath.toAbsolutePath();
        if (packagePathAbsolute.toString().contains("lib")) {
            Path dir = packagePathAbsolute;
            while (dir.toString().contains("lib")) {
                dir = dir.getParent();
            }
            path = dir;
        } else if (packagePathAbsolute.toString().contains("target")) {
            Path dir = packagePathAbsolute;
            while (dir.toString().contains("target")) {
                dir = dir.getParent();
            }
            path = dir;
        } else {
            path = Paths.get(".", new String[0]);
        }
        Path fixedDir = path;
        return fixedDir.resolve("bin/").toAbsolutePath();
    }

    private static final File $anonfun$1() {
        return File.createTempFile("x2cpg", "stderr");
    }

    private static final Comparable $anonfun$2() {
        return Paths.get(".", new String[0]).toAbsolutePath().toString();
    }

    private static final Seq $anonfun$6() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static final Seq $anonfun$8() {
        return (Seq)package$.MODULE$.Seq().empty();
    }
}

