/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.utils;

import io.shiftleft.semanticcpg.utils.ExternalCommandImpl$ExternalCommandResult$;
import io.shiftleft.utils.IOUtils$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Failure$;
import scala.util.Properties$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public interface ExternalCommandImpl {
    public static void $init$(ExternalCommandImpl $this) {
        $this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$_setter_$io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger_$eq(LoggerFactory.getLogger($this.getClass()));
    }

    public Logger io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger();

    public void io$shiftleft$semanticcpg$utils$ExternalCommandImpl$_setter_$io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger_$eq(Logger var1);

    public static ExternalCommandImpl$ExternalCommandResult$ ExternalCommandResult$(ExternalCommandImpl $this) {
        return $this.ExternalCommandResult();
    }

    default public ExternalCommandImpl$ExternalCommandResult$ ExternalCommandResult() {
        return new ExternalCommandImpl$ExternalCommandResult$(this);
    }

    public static ExternalCommandResult run$(ExternalCommandImpl $this, Seq command, Option workingDir, boolean mergeStdErrInStdOut, Map extraEnv, boolean isShellCommand, Duration timeout) {
        return $this.run((Seq<String>)command, (Option<String>)workingDir, mergeStdErrInStdOut, (Map<String, String>)extraEnv, isShellCommand, timeout);
    }

    default public ExternalCommandResult run(Seq<String> command, Option<String> workingDir, boolean mergeStdErrInStdOut, Map<String, String> extraEnv, boolean isShellCommand, Duration timeout) {
        ExternalCommandResult externalCommandResult;
        block11: {
            Seq seq;
            if (isShellCommand) {
                Seq invokeShell = Properties$.MODULE$.isWin() ? (Seq)((SeqOps)new .colon.colon((Object)"cmd.exe", (List)new .colon.colon((Object)"/C", (List)Nil$.MODULE$))) : (Seq)((SeqOps)new .colon.colon((Object)"sh", (List)new .colon.colon((Object)"-c", (List)Nil$.MODULE$)));
                seq = (Seq)invokeShell.$plus$plus(command);
            } else {
                seq = command;
            }
            Seq cmd = seq;
            ProcessBuilder builder = new ProcessBuilder(new String[0]).command((String[])cmd.toArray(ClassTag$.MODULE$.apply(String.class)));
            builder.environment().putAll(CollectionConverters$.MODULE$.MapHasAsJava(extraEnv).asJava());
            builder.redirectErrorStream(mergeStdErrInStdOut);
            workingDir.map((Function1 & Serializable)_$1 -> new File((String)_$1)).foreach((Function1 & Serializable)x$0 -> builder.directory((File)x$0));
            File stdOutFile = File.createTempFile("x2cpg", "stdout");
            Option stdErrFile = Option$.MODULE$.when(!mergeStdErrInStdOut, ExternalCommandImpl::$anonfun$1);
            builder.redirectOutput(stdOutFile);
            stdErrFile.foreach((Function1 & Serializable)x$0 -> builder.redirectError((File)x$0));
            String commandInfo = "cmd: `" + cmd.mkString(" ") + "`, workingDir: " + workingDir.getOrElse(ExternalCommandImpl::$anonfun$2) + ", extraEnv: " + extraEnv;
            try {
                try {
                    Integer n;
                    this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger().debug("executing command: " + commandInfo);
                    Process process = builder.start();
                    if (timeout.isFinite()) {
                        this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger().debug("waiting until command completes (but max " + timeout + ")");
                        boolean finished = process.waitFor(timeout.toMillis(), TimeUnit.MILLISECONDS);
                        if (!finished) {
                            this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger().warn("timeout reached - will now kill the external command");
                            process.destroy();
                            throw new TimeoutException("command '" + command.mkString(" ") + "' with timeout='" + timeout + "' has timed out");
                        }
                        n = BoxedUnit.UNIT;
                    } else {
                        this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger().debug("waiting (indefinitely) until command completes");
                        n = BoxesRunTime.boxToInteger((int)process.waitFor());
                    }
                    this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger().debug("command finished successfully");
                    Seq stdOut = IOUtils$.MODULE$.readLinesInFile(stdOutFile.toPath());
                    Seq stdErr = (Seq)stdErrFile.map((Function1 & Serializable)_$2 -> _$2.toPath()).map((Function1 & Serializable)path -> IOUtils$.MODULE$.readLinesInFile(path)).getOrElse(ExternalCommandImpl::$anonfun$5);
                    externalCommandResult = this.ExternalCommandResult().apply(process.exitValue(), (Seq<String>)stdOut, (Seq<String>)stdErr);
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable exception = throwable3 = (Throwable)option.get();
                        Seq stdOut = IOUtils$.MODULE$.readLinesInFile(stdOutFile.toPath());
                        Seq stdErr = (Seq)((SeqOps)stdErrFile.map((Function1 & Serializable)f -> IOUtils$.MODULE$.readLinesInFile(f.toPath())).getOrElse(ExternalCommandImpl::$anonfun$7)).$colon$plus((Object)exception.getMessage());
                        this.io$shiftleft$semanticcpg$utils$ExternalCommandImpl$$logger().warn("command did not finish successfully. Input was: " + commandInfo);
                        externalCommandResult = this.ExternalCommandResult().apply(1, (Seq<String>)stdOut, (Seq<String>)stdErr);
                        break block11;
                    }
                    throw throwable;
                }
            }
            finally {
                stdOutFile.delete();
                stdErrFile.foreach((Function1 & Serializable)_$3 -> _$3.delete());
            }
        }
        return externalCommandResult;
    }

    public static Option run$default$2$(ExternalCommandImpl $this) {
        return $this.run$default$2();
    }

    default public Option<String> run$default$2() {
        return None$.MODULE$;
    }

    public static boolean run$default$3$(ExternalCommandImpl $this) {
        return $this.run$default$3();
    }

    default public boolean run$default$3() {
        return false;
    }

    public static Map run$default$4$(ExternalCommandImpl $this) {
        return $this.run$default$4();
    }

    default public Map<String, String> run$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public static boolean run$default$5$(ExternalCommandImpl $this) {
        return $this.run$default$5();
    }

    default public boolean run$default$5() {
        return false;
    }

    public static Duration run$default$6$(ExternalCommandImpl $this) {
        return $this.run$default$6();
    }

    default public Duration run$default$6() {
        return Duration$.MODULE$.Inf();
    }

    public static Path executableDir$(ExternalCommandImpl $this, Path packagePath) {
        return $this.executableDir(packagePath);
    }

    default public Path executableDir(Path packagePath) {
        Path path;
        Path packagePathAbsolute = packagePath.toAbsolutePath();
        if (packagePathAbsolute.toString().contains("lib")) {
            Path dir = packagePathAbsolute;
            while (dir.toString().contains("lib")) {
                dir = dir.getParent();
            }
            path = dir;
        } else if (packagePathAbsolute.toString().contains("target")) {
            Path dir = packagePathAbsolute;
            while (dir.toString().contains("target")) {
                dir = dir.getParent();
            }
            path = dir;
        } else {
            path = Paths.get(".", new String[0]);
        }
        Path fixedDir = path;
        return fixedDir.resolve("bin/").toAbsolutePath();
    }

    private static File $anonfun$1() {
        return File.createTempFile("x2cpg", "stderr");
    }

    private static String $anonfun$2() {
        return System.getProperty("user.dir");
    }

    private static Seq $anonfun$5() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private static Seq $anonfun$7() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public class ExternalCommandResult
    implements Product,
    Serializable {
        private final int exitCode;
        private final Seq<String> stdOut;
        private final Seq<String> stdErr;
        private final /* synthetic */ ExternalCommandImpl $outer;

        public ExternalCommandResult(ExternalCommandImpl $outer, int exitCode, Seq<String> stdOut, Seq<String> stdErr) {
            this.exitCode = exitCode;
            this.stdOut = stdOut;
            this.stdErr = stdErr;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.exitCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stdOut()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.stdErr()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ExternalCommandResult)) return false;
            if (((ExternalCommandResult)object).io$shiftleft$semanticcpg$utils$ExternalCommandImpl$ExternalCommandResult$$$outer() != this.$outer) return false;
            ExternalCommandResult externalCommandResult = (ExternalCommandResult)object;
            if (this.exitCode() != externalCommandResult.exitCode()) return false;
            Seq<String> seq = this.stdOut();
            Seq<String> seq2 = externalCommandResult.stdOut();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<String> seq3 = this.stdErr();
            Seq<String> seq4 = externalCommandResult.stdErr();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!externalCommandResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ExternalCommandResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ExternalCommandResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger((int)this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "exitCode";
                }
                case 1: {
                    return "stdOut";
                }
                case 2: {
                    return "stdErr";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int exitCode() {
            return this.exitCode;
        }

        public Seq<String> stdOut() {
            return this.stdOut;
        }

        public Seq<String> stdErr() {
            return this.stdErr;
        }

        public Option<Seq<String>> successOption() {
            int n = this.exitCode();
            if (0 == n) {
                return Some$.MODULE$.apply(this.stdOut());
            }
            return None$.MODULE$;
        }

        public Try<Seq<String>> toTry() {
            int n = this.exitCode();
            if (0 == n) {
                return Success$.MODULE$.apply(this.stdOut());
            }
            int nonZeroExitCode = n;
            Seq allOutput = (Seq)this.stdOut().$plus$plus(this.stdErr());
            String message = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Process exited with code " + nonZeroExitCode + ". Output:\n                         |" + allOutput.mkString(System.lineSeparator()) + "\n                         |"));
            return Failure$.MODULE$.apply((Throwable)new RuntimeException(message));
        }

        public ExternalCommandResult copy(int exitCode, Seq<String> stdOut, Seq<String> stdErr) {
            return new ExternalCommandResult(this.$outer, exitCode, stdOut, stdErr);
        }

        public int copy$default$1() {
            return this.exitCode();
        }

        public Seq<String> copy$default$2() {
            return this.stdOut();
        }

        public Seq<String> copy$default$3() {
            return this.stdErr();
        }

        public int _1() {
            return this.exitCode();
        }

        public Seq<String> _2() {
            return this.stdOut();
        }

        public Seq<String> _3() {
            return this.stdErr();
        }

        public final /* synthetic */ ExternalCommandImpl io$shiftleft$semanticcpg$utils$ExternalCommandImpl$ExternalCommandResult$$$outer() {
            return this.$outer;
        }
    }
}

