/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.layers;

import better.files.File$;
import io.shiftleft.SerializedCpg;
import io.shiftleft.passes.CpgPassBase;
import io.shiftleft.semanticcpg.Overlays$;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class LayerCreator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<String> dependsOn = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    private final boolean storeOverlayName;

    public LayerCreator() {
        this.storeOverlayName = true;
    }

    public abstract String overlayName();

    public abstract String description();

    public List<String> dependsOn() {
        return this.dependsOn;
    }

    public boolean storeOverlayName() {
        return this.storeOverlayName;
    }

    public void run(LayerCreatorContext context) {
        scala.collection.immutable.Set appliedOverlays = Overlays$.MODULE$.appliedOverlays(context.cpg()).toSet();
        if (!this.dependsOn().toSet().subsetOf((Set)appliedOverlays)) {
            this.logger.warn(this.getClass().getName() + " depends on " + this.dependsOn() + " but CPG only has " + appliedOverlays + " - skipping creation");
            return;
        }
        if (appliedOverlays.contains((Object)this.overlayName())) {
            this.logger.warn("The overlay " + this.overlayName() + " already exists - skipping creation");
            return;
        }
        this.create(context);
        if (this.storeOverlayName()) {
            Overlays$.MODULE$.appendOverlayName(context.cpg(), this.overlayName());
            return;
        }
    }

    public SerializedCpg initSerializedCpg(Option<String> outputDir, String passName, int index) {
        Option<String> option = outputDir;
        if (option instanceof Some) {
            String dir = (String)((Some)option).value();
            return new SerializedCpg(File$.MODULE$.apply(dir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).$div(index + "_" + passName).path().toAbsolutePath().toString());
        }
        if (None$.MODULE$.equals(option)) {
            return new SerializedCpg();
        }
        throw new MatchError(option);
    }

    public int initSerializedCpg$default$3() {
        return 0;
    }

    public void runPass(CpgPassBase pass, LayerCreatorContext context, int index) {
        SerializedCpg serializedCpg = this.initSerializedCpg(context.outputDir(), pass.name(), index);
        pass.createApplySerializeAndStore(serializedCpg, pass.createApplySerializeAndStore$default$2());
        serializedCpg.close();
    }

    public int runPass$default$3() {
        return 0;
    }

    public abstract void create(LayerCreatorContext var1);
}

