/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.dotgenerator;

import io.shiftleft.codepropertygraph.generated.nodes.AnnotationParameter;
import io.shiftleft.codepropertygraph.generated.nodes.AnnotationParameterAssign;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CallRepr;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.ControlStructure;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Identifier;
import io.shiftleft.codepropertygraph.generated.nodes.JumpTarget;
import io.shiftleft.codepropertygraph.generated.nodes.Literal;
import io.shiftleft.codepropertygraph.generated.nodes.Local;
import io.shiftleft.codepropertygraph.generated.nodes.Member;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterIn;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import io.shiftleft.codepropertygraph.generated.nodes.MethodRef;
import io.shiftleft.codepropertygraph.generated.nodes.MethodReturn;
import io.shiftleft.codepropertygraph.generated.nodes.Modifier;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.codepropertygraph.generated.nodes.Type;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer$Edge$;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer$Graph$;
import io.shiftleft.semanticcpg.language.nodemethods.ExpressionMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.utils.MemberAccess$;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import overflowdb.Element;
import overflowdb.Node;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DotSerializer$
implements Serializable {
    private static final int charLimit;
    public static final DotSerializer$Graph$ Graph;
    public static final DotSerializer$Edge$ Edge;
    public static final DotSerializer$ MODULE$;

    private DotSerializer$() {
    }

    static {
        MODULE$ = new DotSerializer$();
        charLimit = 50;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DotSerializer$.class);
    }

    public String dotGraph(Option<AstNode> root, DotSerializer.Graph graph, boolean withEdgeTypes) {
        StringBuilder stringBuilder;
        Option<AstNode> option = root;
        if (option instanceof Some) {
            AstNode r = (AstNode)((Some)option).value();
            stringBuilder = this.namedGraphBegin(r);
        } else if (None$.MODULE$.equals(option)) {
            stringBuilder = this.defaultGraphBegin();
        } else {
            throw new MatchError(option);
        }
        StringBuilder sb = stringBuilder;
        List nodeStrings = graph.vertices().map((Function1 & Serializable)node -> this.nodeToDot((StoredNode)node));
        List edgeStrings = graph.edges().map((Function1 & Serializable)e -> this.edgeToDot((DotSerializer.Edge)e, withEdgeTypes));
        Iterable subgraphStrings = (Iterable)((IterableOps)graph.subgraph().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String subgraph = (String)tuple2._1();
                Seq nodes = (Seq)tuple2._2();
                int idx = BoxesRunTime.unboxToInt((Object)tuple22._2());
                return this.nodesToSubGraphs(subgraph, (Seq<StoredNode>)nodes, idx);
            }
            throw new MatchError((Object)tuple22);
        });
        sb.append(((IterableOnceOps)((IterableOps)nodeStrings.$plus$plus((IterableOnce)edgeStrings)).$plus$plus((IterableOnce)subgraphStrings)).mkString("\n"));
        return this.graphEnd(sb);
    }

    public Option<AstNode> dotGraph$default$1() {
        return None$.MODULE$;
    }

    public boolean dotGraph$default$3() {
        return false;
    }

    private StringBuilder namedGraphBegin(AstNode root) {
        String string;
        StringBuilder sb = new StringBuilder();
        AstNode astNode = root;
        if (astNode instanceof Method) {
            Method method = (Method)astNode;
            string = method.name();
        } else {
            string = "";
        }
        String name = StringEscapeUtils.escapeHtml4((String)string);
        return sb.append("digraph \"" + name + "\" {  \n");
    }

    private StringBuilder defaultGraphBegin() {
        StringBuilder sb = new StringBuilder();
        String name = "CPG";
        return sb.append("digraph \"" + name + "\" {  \n");
    }

    private String limit(String str) {
        if (str.length() > charLimit) {
            return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(str), charLimit - 3) + "...";
        }
        return str;
    }

    private String stringRepr(StoredNode vertex) {
        String string;
        Optional maybeLineNo = ((Element)vertex).propertyOption("LINE_NUMBER");
        StoredNode storedNode = vertex;
        if (storedNode instanceof Call) {
            Call call = (Call)storedNode;
            string = Tuple2$.MODULE$.apply((Object)call.name(), (Object)this.limit(call.code())).toString();
        } else if (storedNode instanceof ControlStructure) {
            ControlStructure contrl = (ControlStructure)storedNode;
            string = Tuple3$.MODULE$.apply((Object)contrl.label(), (Object)contrl.controlStructureType(), (Object)contrl.code()).toString();
        } else if (storedNode instanceof Expression) {
            Expression expr = (Expression)storedNode;
            string = Tuple3$.MODULE$.apply((Object)expr.label(), (Object)this.limit(expr.code()), (Object)this.limit(this.toCfgNode((StoredNode)expr).code())).toString();
        } else if (storedNode instanceof Method) {
            Method method = (Method)storedNode;
            string = Tuple2$.MODULE$.apply((Object)method.label(), (Object)method.name()).toString();
        } else if (storedNode instanceof MethodReturn) {
            MethodReturn ret = (MethodReturn)storedNode;
            string = Tuple2$.MODULE$.apply((Object)ret.label(), (Object)ret.typeFullName()).toString();
        } else if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn param = (MethodParameterIn)storedNode;
            string = Tuple2$.MODULE$.apply((Object)"PARAM", (Object)param.code()).toString();
        } else if (storedNode instanceof Local) {
            Local local = (Local)storedNode;
            string = Tuple2$.MODULE$.apply((Object)local.label(), (Object)(local.code() + ": " + local.typeFullName())).toString();
        } else if (storedNode instanceof JumpTarget) {
            JumpTarget target = (JumpTarget)storedNode;
            string = Tuple2$.MODULE$.apply((Object)target.label(), (Object)target.name()).toString();
        } else if (storedNode instanceof Modifier) {
            Modifier modifier = (Modifier)storedNode;
            string = Tuple2$.MODULE$.apply((Object)modifier.label(), (Object)modifier.modifierType()).toString();
        } else if (storedNode instanceof AnnotationParameterAssign) {
            AnnotationParameterAssign annoAssign = (AnnotationParameterAssign)storedNode;
            string = Tuple2$.MODULE$.apply((Object)annoAssign.label(), (Object)annoAssign.code()).toString();
        } else if (storedNode instanceof AnnotationParameter) {
            AnnotationParameter annoParam = (AnnotationParameter)storedNode;
            string = Tuple2$.MODULE$.apply((Object)annoParam.label(), (Object)annoParam.code()).toString();
        } else if (storedNode instanceof Type) {
            Type typ = (Type)storedNode;
            string = Tuple2$.MODULE$.apply((Object)typ.label(), (Object)typ.name()).toString();
        } else if (storedNode instanceof TypeDecl) {
            TypeDecl typeDecl = (TypeDecl)storedNode;
            string = Tuple2$.MODULE$.apply((Object)typeDecl.label(), (Object)typeDecl.name()).toString();
        } else if (storedNode instanceof Member) {
            Member member = (Member)storedNode;
            string = Tuple2$.MODULE$.apply((Object)member.label(), (Object)member.name()).toString();
        } else {
            string = "";
        }
        return StringEscapeUtils.escapeHtml4((String)string) + (String)(maybeLineNo.isPresent() ? "<SUB>" + maybeLineNo.get() + "</SUB>" : "");
    }

    private CfgNode toCfgNode(StoredNode node) {
        Call node2;
        StoredNode storedNode = node;
        if (storedNode instanceof Identifier) {
            Identifier node3 = (Identifier)storedNode;
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node3)).get();
        }
        if (storedNode instanceof MethodRef) {
            MethodRef node4 = (MethodRef)storedNode;
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node4)).get();
        }
        if (storedNode instanceof Literal) {
            Literal node5 = (Literal)storedNode;
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node5)).get();
        }
        if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn node6 = (MethodParameterIn)storedNode;
            return node6.method();
        }
        if (storedNode instanceof MethodParameterOut) {
            MethodParameterOut node7 = (MethodParameterOut)storedNode;
            return node7.method().methodReturn();
        }
        if (storedNode instanceof Call && MemberAccess$.MODULE$.isGenericMemberAccessName((node2 = (Call)storedNode).name())) {
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node2)).get();
        }
        if (storedNode instanceof CallRepr) {
            CallRepr node8 = (CallRepr)storedNode;
            return node8;
        }
        if (storedNode instanceof MethodReturn) {
            MethodReturn node9 = (MethodReturn)storedNode;
            return node9;
        }
        if (storedNode instanceof Expression) {
            Expression node10 = (Expression)storedNode;
            return node10;
        }
        throw new MatchError((Object)storedNode);
    }

    private String nodeToDot(StoredNode node) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\"" + ((Node)node).id() + "\" [label = <" + this.stringRepr(node) + "> ]"));
    }

    private String edgeToDot(DotSerializer.Edge edge, boolean withEdgeTypes) {
        String edgeLabel = withEdgeTypes ? edge.edgeType() + ": " + StringEscapeUtils.escapeHtml4((String)edge.label()) : StringEscapeUtils.escapeHtml4((String)edge.label());
        String labelStr = (String)Some$.MODULE$.apply((Object)(" [ label = \"" + edgeLabel + "\"] ")).filter((Function1 & Serializable)_$1 -> {
            String string = edgeLabel;
            String string2 = "";
            return string == null ? string2 != null : !string.equals(string2);
        }).getOrElse(this::$anonfun$5);
        return "  \"" + ((Node)edge.src()).id() + "\" -> \"" + ((Node)edge.dst()).id() + "\" " + labelStr;
    }

    public String nodesToSubGraphs(String subgraph, Seq<StoredNode> children, int idx) {
        String escapedName = StringEscapeUtils.escapeHtml4((String)subgraph);
        String childString = ((IterableOnceOps)children.map((Function1 & Serializable)c -> "    \"" + ((Node)c).id() + "\";")).mkString("\n");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("  subgraph cluster_" + idx + " {\n       |" + childString + "\n       |    label = \"" + escapedName + "\";\n       |  }\n       |"));
    }

    private String graphEnd(StringBuilder sb) {
        sb.append("\n}\n");
        return sb.toString();
    }

    private final String $anonfun$5() {
        return "";
    }
}

