/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.dotgenerator;

import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CallRepr;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Identifier;
import io.shiftleft.codepropertygraph.generated.nodes.JumpTarget;
import io.shiftleft.codepropertygraph.generated.nodes.Literal;
import io.shiftleft.codepropertygraph.generated.nodes.Local;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterIn;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import io.shiftleft.codepropertygraph.generated.nodes.MethodRef;
import io.shiftleft.codepropertygraph.generated.nodes.MethodReturn;
import io.shiftleft.codepropertygraph.generated.nodes.Modifier;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer$Edge$;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer$Graph$;
import io.shiftleft.semanticcpg.language.nodemethods.ExpressionMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.utils.MemberAccess$;
import java.io.Serializable;
import overflowdb.Node;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;

public final class DotSerializer$
implements Serializable {
    public static final DotSerializer$Graph$ Graph;
    public static final DotSerializer$Edge$ Edge;
    public static final DotSerializer$ MODULE$;

    private DotSerializer$() {
    }

    static {
        MODULE$ = new DotSerializer$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DotSerializer$.class);
    }

    public String dotGraph(AstNode root, DotSerializer.Graph graph, boolean withEdgeTypes) {
        scala.collection.mutable.StringBuilder sb = this.namedGraphBegin(root);
        List nodeStrings = graph.vertices().map((Function1 & Serializable)node -> this.nodeToDot((StoredNode)node));
        List edgeStrings = graph.edges().map((Function1 & Serializable)e -> this.edgeToDot((DotSerializer.Edge)e, withEdgeTypes));
        sb.append(((IterableOnceOps)nodeStrings.$plus$plus((IterableOnce)edgeStrings)).mkString("\n"));
        return this.graphEnd(sb);
    }

    public boolean dotGraph$default$3() {
        return false;
    }

    private scala.collection.mutable.StringBuilder namedGraphBegin(AstNode root) {
        String string;
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        AstNode astNode = root;
        if (astNode instanceof Method) {
            Method method = (Method)astNode;
            string = method.name();
        } else {
            string = "";
        }
        String name = this.escape(string);
        return sb.append(new StringBuilder(15).append("digraph \"").append(name).append("\" {  \n").toString());
    }

    private String stringRepr(StoredNode vertex) {
        String string;
        StoredNode storedNode = vertex;
        if (storedNode instanceof Call) {
            Call call = (Call)storedNode;
            string = Tuple2$.MODULE$.apply((Object)call.name(), (Object)call.code()).toString();
        } else if (storedNode instanceof Expression) {
            Expression expr = (Expression)storedNode;
            string = Tuple3$.MODULE$.apply((Object)expr.label(), (Object)expr.code(), (Object)this.toCfgNode((StoredNode)expr).code()).toString();
        } else if (storedNode instanceof Method) {
            Method method = (Method)storedNode;
            string = Tuple2$.MODULE$.apply((Object)method.label(), (Object)method.name()).toString();
        } else if (storedNode instanceof MethodReturn) {
            MethodReturn ret = (MethodReturn)storedNode;
            string = Tuple2$.MODULE$.apply((Object)ret.label(), (Object)ret.typeFullName()).toString();
        } else if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn param = (MethodParameterIn)storedNode;
            string = Tuple2$.MODULE$.apply((Object)"PARAM", (Object)param.code()).toString();
        } else if (storedNode instanceof Local) {
            Local local = (Local)storedNode;
            string = Tuple2$.MODULE$.apply((Object)local.label(), (Object)new StringBuilder(2).append(local.code()).append(": ").append(local.typeFullName()).toString()).toString();
        } else if (storedNode instanceof JumpTarget) {
            JumpTarget target = (JumpTarget)storedNode;
            string = Tuple2$.MODULE$.apply((Object)target.label(), (Object)target.name()).toString();
        } else if (storedNode instanceof Modifier) {
            Modifier modifier = (Modifier)storedNode;
            string = Tuple2$.MODULE$.apply((Object)"MODIFIER", (Object)modifier.modifierType()).toString();
        } else {
            string = "";
        }
        return this.escape(string);
    }

    private CfgNode toCfgNode(StoredNode node) {
        Call node2;
        CfgNode cfgNode;
        StoredNode storedNode = node;
        if (storedNode instanceof Identifier) {
            Identifier node3 = (Identifier)storedNode;
            cfgNode = (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node3)).get();
        } else if (storedNode instanceof MethodRef) {
            MethodRef node4 = (MethodRef)storedNode;
            cfgNode = (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node4)).get();
        } else if (storedNode instanceof Literal) {
            Literal node5 = (Literal)storedNode;
            cfgNode = (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node5)).get();
        } else if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn node6 = (MethodParameterIn)storedNode;
            cfgNode = node6.method();
        } else if (storedNode instanceof MethodParameterOut) {
            MethodParameterOut node7 = (MethodParameterOut)storedNode;
            cfgNode = node7.method().methodReturn();
        } else if (storedNode instanceof Call && MemberAccess$.MODULE$.isGenericMemberAccessName((node2 = (Call)storedNode).name())) {
            cfgNode = (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node2)).get();
        } else if (storedNode instanceof CallRepr) {
            CallRepr node8 = (CallRepr)storedNode;
            cfgNode = node8;
        } else if (storedNode instanceof MethodReturn) {
            MethodReturn node9 = (MethodReturn)storedNode;
            cfgNode = node9;
        } else if (storedNode instanceof Expression) {
            Expression node10 = (Expression)storedNode;
            cfgNode = node10;
        } else {
            throw new MatchError((Object)storedNode);
        }
        return cfgNode;
    }

    private String nodeToDot(StoredNode node) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(16).append("\"").append(((Node)node).id()).append("\" [label = \"").append(this.stringRepr(node)).append("\" ]").toString()));
    }

    private String edgeToDot(DotSerializer.Edge edge, boolean withEdgeTypes) {
        String edgeLabel = withEdgeTypes ? new StringBuilder(2).append(edge.edgeType()).append(": ").append(this.escape(edge.label())).toString() : this.escape(edge.label());
        String labelStr = (String)Some$.MODULE$.apply((Object)new StringBuilder(15).append(" [ label = \"").append(edgeLabel).append("\"] ").toString()).filter((Function1 & Serializable)_$1 -> {
            String string = edgeLabel;
            String string2 = "";
            return string == null ? string2 != null : !string.equals(string2);
        }).getOrElse(this::$anonfun$4);
        return new StringBuilder(11).append("  \"").append(((Node)edge.src()).id()).append("\" -> \"").append(((Node)edge.dst()).id()).append("\" ").append(labelStr).toString();
    }

    private String escapedChar(char ch) {
        String string;
        char c = ch;
        switch (c) {
            case '\b': {
                string = "\\b";
                break;
            }
            case '\t': {
                string = "\\t";
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\f': {
                string = "\\f";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            case '\"': {
                string = "\\\"";
                break;
            }
            case '\'': {
                string = "\\'";
                break;
            }
            case '\\': {
                string = "\\\\";
                break;
            }
            default: {
                if (RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(ch))) {
                    string = new StringBuilder(2).append("\\0").append(Integer.toOctalString(ch)).toString();
                    break;
                }
                string = String.valueOf(ch);
                break;
            }
        }
        return string;
    }

    private String escape(String str) {
        return str == null ? "" : StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)ch -> this.escape$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)));
    }

    private String graphEnd(scala.collection.mutable.StringBuilder sb) {
        sb.append("\n}\n");
        return sb.toString();
    }

    private final String $anonfun$4() {
        return "";
    }

    private final /* synthetic */ String escape$$anonfun$1(char ch) {
        return this.escapedChar(ch);
    }
}

