/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.dotgenerator;

import io.shiftleft.codepropertygraph.generated.nodes.AnnotationParameter;
import io.shiftleft.codepropertygraph.generated.nodes.AnnotationParameterAssign;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.CallRepr;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNode;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Identifier;
import io.shiftleft.codepropertygraph.generated.nodes.JumpTarget;
import io.shiftleft.codepropertygraph.generated.nodes.Literal;
import io.shiftleft.codepropertygraph.generated.nodes.Local;
import io.shiftleft.codepropertygraph.generated.nodes.Member;
import io.shiftleft.codepropertygraph.generated.nodes.Method;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterIn;
import io.shiftleft.codepropertygraph.generated.nodes.MethodParameterOut;
import io.shiftleft.codepropertygraph.generated.nodes.MethodRef;
import io.shiftleft.codepropertygraph.generated.nodes.MethodReturn;
import io.shiftleft.codepropertygraph.generated.nodes.Modifier;
import io.shiftleft.codepropertygraph.generated.nodes.StoredNode;
import io.shiftleft.codepropertygraph.generated.nodes.Type;
import io.shiftleft.codepropertygraph.generated.nodes.TypeDecl;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer$Edge$;
import io.shiftleft.semanticcpg.dotgenerator.DotSerializer$Graph$;
import io.shiftleft.semanticcpg.language.nodemethods.ExpressionMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.utils.MemberAccess$;
import java.io.Serializable;
import java.util.Optional;
import overflowdb.Element;
import overflowdb.Node;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;

public final class DotSerializer$
implements Serializable {
    public static final DotSerializer$Graph$ Graph;
    public static final DotSerializer$Edge$ Edge;
    public static final DotSerializer$ MODULE$;

    private DotSerializer$() {
    }

    static {
        MODULE$ = new DotSerializer$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DotSerializer$.class);
    }

    public String dotGraph(Option<AstNode> root, DotSerializer.Graph graph, boolean withEdgeTypes) {
        StringBuilder stringBuilder;
        Option<AstNode> option = root;
        if (option instanceof Some) {
            AstNode r = (AstNode)((Some)option).value();
            stringBuilder = this.namedGraphBegin(r);
        } else if (None$.MODULE$.equals(option)) {
            stringBuilder = this.defaultGraphBegin();
        } else {
            throw new MatchError(option);
        }
        StringBuilder sb = stringBuilder;
        List nodeStrings = graph.vertices().map((Function1 & Serializable)node -> this.nodeToDot((StoredNode)node));
        List edgeStrings = graph.edges().map((Function1 & Serializable)e -> this.edgeToDot((DotSerializer.Edge)e, withEdgeTypes));
        Iterable subgraphStrings = (Iterable)((IterableOps)graph.subgraph().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String subgraph = (String)tuple2._1();
                Seq nodes = (Seq)tuple2._2();
                int idx = BoxesRunTime.unboxToInt((Object)tuple22._2());
                return this.nodesToSubGraphs(subgraph, (Seq<StoredNode>)nodes, idx);
            }
            throw new MatchError((Object)tuple22);
        });
        sb.append(((IterableOnceOps)((IterableOps)nodeStrings.$plus$plus((IterableOnce)edgeStrings)).$plus$plus((IterableOnce)subgraphStrings)).mkString("\n"));
        return this.graphEnd(sb);
    }

    public Option<AstNode> dotGraph$default$1() {
        return None$.MODULE$;
    }

    public boolean dotGraph$default$3() {
        return false;
    }

    private StringBuilder namedGraphBegin(AstNode root) {
        String string;
        StringBuilder sb = new StringBuilder();
        AstNode astNode = root;
        if (astNode instanceof Method) {
            Method method = (Method)astNode;
            string = method.name();
        } else {
            string = "";
        }
        String name = this.escape(string);
        return sb.append(new java.lang.StringBuilder(15).append("digraph \"").append(name).append("\" {  \n").toString());
    }

    private StringBuilder defaultGraphBegin() {
        StringBuilder sb = new StringBuilder();
        String name = "CPG";
        return sb.append(new java.lang.StringBuilder(15).append("digraph \"").append(name).append("\" {  \n").toString());
    }

    private String stringRepr(StoredNode vertex) {
        String string;
        Optional maybeLineNo = ((Element)vertex).propertyOption("LINE_NUMBER");
        java.lang.StringBuilder stringBuilder = new java.lang.StringBuilder(0);
        StoredNode storedNode = vertex;
        if (storedNode instanceof Call) {
            Call call = (Call)storedNode;
            string = Tuple2$.MODULE$.apply((Object)call.name(), (Object)call.code()).toString();
        } else if (storedNode instanceof Expression) {
            Expression expr = (Expression)storedNode;
            string = Tuple3$.MODULE$.apply((Object)expr.label(), (Object)expr.code(), (Object)this.toCfgNode((StoredNode)expr).code()).toString();
        } else if (storedNode instanceof Method) {
            Method method = (Method)storedNode;
            string = Tuple2$.MODULE$.apply((Object)method.label(), (Object)method.name()).toString();
        } else if (storedNode instanceof MethodReturn) {
            MethodReturn ret = (MethodReturn)storedNode;
            string = Tuple2$.MODULE$.apply((Object)ret.label(), (Object)ret.typeFullName()).toString();
        } else if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn param = (MethodParameterIn)storedNode;
            string = Tuple2$.MODULE$.apply((Object)"PARAM", (Object)param.code()).toString();
        } else if (storedNode instanceof Local) {
            Local local = (Local)storedNode;
            string = Tuple2$.MODULE$.apply((Object)local.label(), (Object)new java.lang.StringBuilder(2).append(local.code()).append(": ").append(local.typeFullName()).toString()).toString();
        } else if (storedNode instanceof JumpTarget) {
            JumpTarget target = (JumpTarget)storedNode;
            string = Tuple2$.MODULE$.apply((Object)target.label(), (Object)target.name()).toString();
        } else if (storedNode instanceof Modifier) {
            Modifier modifier = (Modifier)storedNode;
            string = Tuple2$.MODULE$.apply((Object)modifier.label(), (Object)modifier.modifierType()).toString();
        } else if (storedNode instanceof AnnotationParameterAssign) {
            AnnotationParameterAssign annoAssign = (AnnotationParameterAssign)storedNode;
            string = Tuple2$.MODULE$.apply((Object)annoAssign.label(), (Object)annoAssign.code()).toString();
        } else if (storedNode instanceof AnnotationParameter) {
            AnnotationParameter annoParam = (AnnotationParameter)storedNode;
            string = Tuple2$.MODULE$.apply((Object)annoParam.label(), (Object)annoParam.code()).toString();
        } else if (storedNode instanceof Type) {
            Type typ = (Type)storedNode;
            string = Tuple2$.MODULE$.apply((Object)typ.label(), (Object)typ.name()).toString();
        } else if (storedNode instanceof TypeDecl) {
            TypeDecl typeDecl = (TypeDecl)storedNode;
            string = Tuple2$.MODULE$.apply((Object)typeDecl.label(), (Object)typeDecl.name()).toString();
        } else if (storedNode instanceof Member) {
            Member member = (Member)storedNode;
            string = Tuple2$.MODULE$.apply((Object)member.label(), (Object)member.name()).toString();
        } else {
            string = "";
        }
        return stringBuilder.append(this.escape(string)).append(maybeLineNo.isPresent() ? new java.lang.StringBuilder(11).append("<SUB>").append(maybeLineNo.get()).append("</SUB>").toString() : "").toString();
    }

    private CfgNode toCfgNode(StoredNode node) {
        Call node2;
        StoredNode storedNode = node;
        if (storedNode instanceof Identifier) {
            Identifier node3 = (Identifier)storedNode;
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node3)).get();
        }
        if (storedNode instanceof MethodRef) {
            MethodRef node4 = (MethodRef)storedNode;
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node4)).get();
        }
        if (storedNode instanceof Literal) {
            Literal node5 = (Literal)storedNode;
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node5)).get();
        }
        if (storedNode instanceof MethodParameterIn) {
            MethodParameterIn node6 = (MethodParameterIn)storedNode;
            return node6.method();
        }
        if (storedNode instanceof MethodParameterOut) {
            MethodParameterOut node7 = (MethodParameterOut)storedNode;
            return node7.method().methodReturn();
        }
        if (storedNode instanceof Call && MemberAccess$.MODULE$.isGenericMemberAccessName((node2 = (Call)storedNode).name())) {
            return (CfgNode)ExpressionMethods$.MODULE$.parentExpression$extension(package$.MODULE$.toExpressionMethods((Expression)node2)).get();
        }
        if (storedNode instanceof CallRepr) {
            CallRepr node8 = (CallRepr)storedNode;
            return node8;
        }
        if (storedNode instanceof MethodReturn) {
            MethodReturn node9 = (MethodReturn)storedNode;
            return node9;
        }
        if (storedNode instanceof Expression) {
            Expression node10 = (Expression)storedNode;
            return node10;
        }
        throw new MatchError((Object)storedNode);
    }

    private String nodeToDot(StoredNode node) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(16).append("\"").append(((Node)node).id()).append("\" [label = <").append(this.stringRepr(node)).append("> ]").toString()));
    }

    private String edgeToDot(DotSerializer.Edge edge, boolean withEdgeTypes) {
        String edgeLabel = withEdgeTypes ? new java.lang.StringBuilder(2).append(edge.edgeType()).append(": ").append(this.escape(edge.label())).toString() : this.escape(edge.label());
        String labelStr = (String)Some$.MODULE$.apply((Object)new java.lang.StringBuilder(15).append(" [ label = \"").append(edgeLabel).append("\"] ").toString()).filter((Function1 & Serializable)_$1 -> {
            String string = edgeLabel;
            String string2 = "";
            return string == null ? string2 != null : !string.equals(string2);
        }).getOrElse(this::$anonfun$5);
        return new java.lang.StringBuilder(11).append("  \"").append(((Node)edge.src()).id()).append("\" -> \"").append(((Node)edge.dst()).id()).append("\" ").append(labelStr).toString();
    }

    public String nodesToSubGraphs(String subgraph, Seq<StoredNode> children, int idx) {
        String escapedName = this.escape(subgraph);
        String childString = ((IterableOnceOps)children.map((Function1 & Serializable)c -> new java.lang.StringBuilder(7).append("    \"").append(((Node)c).id()).append("\";").toString())).mkString("\n");
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(75).append("  subgraph cluster_").append(idx).append(" {\n       |").append(childString).append("\n       |    label = \"").append(escapedName).append("\";\n       |  }\n       |").toString()));
    }

    private String escapedChar(char ch) {
        char c = ch;
        switch (c) {
            case '\"': {
                return "&quot;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        if (RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(ch))) {
            return new java.lang.StringBuilder(2).append("\\0").append(Integer.toOctalString(ch)).toString();
        }
        return String.valueOf(ch);
    }

    private String escape(String str) {
        if (str == null) {
            return "";
        }
        return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)ch -> this.escape$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)));
    }

    private String graphEnd(StringBuilder sb) {
        sb.append("\n}\n");
        return sb.toString();
    }

    private final String $anonfun$5() {
        return "";
    }

    private final /* synthetic */ String escape$$anonfun$1(char ch) {
        return this.escapedChar(ch);
    }
}

