/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.semanticcpg.layers;

import io.shiftleft.semanticcpg.Overlays$;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class LayerCreator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<String> dependsOn = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    private final boolean storeOverlayName;

    public LayerCreator() {
        this.storeOverlayName = true;
    }

    public abstract String overlayName();

    public abstract String description();

    public List<String> dependsOn() {
        return this.dependsOn;
    }

    public boolean storeOverlayName() {
        return this.storeOverlayName;
    }

    public void run(LayerCreatorContext context) {
        scala.collection.immutable.Set appliedOverlays = Overlays$.MODULE$.appliedOverlays(context.cpg()).toSet();
        if (!this.dependsOn().toSet().subsetOf((Set)appliedOverlays)) {
            this.logger.warn(this.getClass().getName() + " depends on " + this.dependsOn() + " but CPG only has " + appliedOverlays + " - skipping creation");
            return;
        }
        if (appliedOverlays.contains((Object)this.overlayName())) {
            this.logger.warn("The overlay " + this.overlayName() + " already exists - skipping creation");
            return;
        }
        this.create(context);
        if (this.storeOverlayName()) {
            Overlays$.MODULE$.appendOverlayName(context.cpg(), this.overlayName());
            return;
        }
    }

    public abstract void create(LayerCreatorContext var1);
}

