/* PythonParser.java */
/* Generated By:JavaCC: Do not edit this line. PythonParser.java */
package io.joern.pythonparser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Stack;
import io.joern.pythonparser.ast.Module;
import io.joern.pythonparser.ast.*;
public class PythonParser implements PythonParserConstants {
  static class BoxedObject<T> {
    T object;
    BoxedObject(T object) {
      this.object = object;
    }
  }
  TokenAttributeProvider attributes(Token startToken, Token endToken) {
    return new TokenAttributeProvider(startToken, endToken);
  }
  NodeAttributeProvider attributes(iattributes attributeAstNode, Token endToken) {
    return new NodeAttributeProvider(attributeAstNode, endToken);
  }

  private ArrayList<ErrorStatement> errors = new ArrayList<ErrorStatement>();
  ArrayList<ErrorStatement> getErrors() {
    return errors;
  }

  ErrorStatement recoverAndCreateErrorStmt(Token lastCorrectToken, Exception exception) {
    Token lastErrorToken = null;
    try {
      getNextToken();
      lastErrorToken = token;
      while (token.kind != SEMICOLON && token.kind != NEWLINE && token.kind != EOF) {
        lastErrorToken = token;
        getNextToken();
      }
    } catch (Exception e) {
      // We are already in error handling/recovery mode and try to advance the token stream
      // to a point where we have hope to parse something meaningful again. If we get an
      // exception during this advancing we end up here.
      // We just stop advancing, store the previous error which brought us here in the first
      // place and hope the parse can recover from the current state.
    }

    Token errorStartToken = lastCorrectToken.next;
    ErrorStatement errorStmt = new ErrorStatement(exception, attributes(errorStartToken, lastErrorToken));
    errors.add(errorStmt);
    return errorStmt;
  }

  // Since this grammar is handling python3 and python2 code, we need to deal with
  // abiguities between those two python versions.
  // One such ambiguity is caused by the print statements (not expressions) like:
  //   print (x), y
  // In python3 this is a Tuple(elts = [Call(func = print, args = [x]), y])
  // whereas in python this is a Call(func = print, args = [Tuple(elts = [x]), y]).
  // Our grammar parses this as a python3 style tuple and this method rewrites the
  // tuple to the python2 style call.
  // The reasoning for this is that a statement with a top level tuple used in no
  // expression is superfluous and thus a rare unexpected case. One could argue
  // that this case is also expected to be rare in python2 so only time will tell
  // whether this was the right choice.
  istmt printStatmentToPython2StyleRewrite(istmt stmt) {
    if (stmt instanceof Expr) {
      Expr expr = (Expr) stmt;
      if (expr.value() instanceof Tuple) {
        Tuple tuple = (Tuple)expr.value();
        if (tuple.elts().nonEmpty() && tuple.elts().head() instanceof Call) {
          Call call = (Call) tuple.elts().head();
          if (call.func() instanceof Name) {
            Name name = (Name) call.func();
            if (name.id().equals("print") && call.keywords().isEmpty()) {
              ArrayList<iexpr> combinedArgs = new ArrayList<iexpr>();
              int argCount = call.args().size();
              for (int i = 0; i < argCount; i++) {
                combinedArgs.add(call.args().apply(i));
              }
              int elementCount = tuple.elts().size();
              for (int i = 1; i < elementCount; i++) {
                combinedArgs.add(tuple.elts().apply(i));
              }
              return stmt = new Expr(
                new Call(call.func(), combinedArgs, new ArrayList<Keyword>(),
                 call.attributeProvider()));
            }
          }
        }
      }
    }
    return stmt;
  }

  void setCurrentToken(Token setTo) {
    token = setTo;
    jj_ntk = -1;
  }

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Parser rules start:
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Notes for PythonParser variables:
// token:
//  - The current token. Contains chain of all already obtained tokens via .next field.
// jj_nt:
//  - Likely full name: next token
//  - Initialised to null
//  - Written by jj_ntk_f
//  - Only used in jj_ntk_f itself to set next jj_ntk.
//  -> Is redundant as it is defined by token.next at the start of jj_ntk_f
// jj_ntk:
//  - Likely full name: next token kind
//  - Initialised to -1
//  - Written by jj_ntk_f
//  - jj_consume_token and getNextToken set it to -1
//  -> We set this to -1 when we set token
// jj_scanpos:
//  - Likely full name: scan position
//  - Same as jj_lastpos
// jj_lastpos:
//  - Likely full name: last position
//  - Is set to token at entry for each lookahead function jj_2_<X> and by jj_scan_token
//    which is called below the call tree of the jj_2_<X> functions.
//  -> Used for lookahead functionality only. Since it at entry of lookahed function we
//     dont need to handle it.
// jj_la:
//  - Likely full name: lookahead
//  - Used in call tree below generateParseException and jj_scan_token
//  - Is set at entry for each lookahead function jj_2_<X>.
//  - Ends up in the gen filed of JJCalls chains.
//  -> Used for lookahead functionality only. Since it at entry of lookahed function we
//     dont need to handle it.
// jj_gen:
//  - Initialised to zero
//  - Incremented in jj_consume_token and getNextToken for each token.
//  - Used/read in call tree below generateParseException and jj_save
//  -> Unclear if this needs to be touched
// jj_la1:
//  - Array size of the number of token switch blocks generated. A token switch block is "switch ((jj_ntk==-1)..."
//  - In each switch block the default case writes jj_gen to its slot in jj_la1.
//  - Only realy used/read from in generateParseException
//  -> Unclear if this needs to be touched
// jj_la1_<X>:
//  - Static effective final data arrays. Used in generateParseException
//  -> Unclear if this needs to be touched
// jj_2_rtns:
//  - rtn likely means Recursive Transition Network
//  - Initialized in PythonParser constructors to an array the size of the amount jj_2_<X> methods.
//    Each entry at start contains and "empty" JJCalls class/chain.
//  - Somehow garbage collected in jj_consume_token. GC is controlled by jj_gc
//  - New elements to the JJCalls chains are added in jj_save
//  -> Unclear if this needs to be touched
// jj_rescan:
//  - Is only true in call tree below jj_rescan_token which is only called from generateParseException
//  - Used to guard call to jj_add_error_token in jj_scan_token
// jj_gc:
//  - Likely full name: GarbageCollectCounter
//  - Used to trigger some kind of cleanup of JJCalls chains in jj_2_rtns
// jj_ls:
//  - Static final variable for jj_scan_token
// jj_expentries:
//  - Likely full name: ExpectedEntries
//  - Used to calculated expected tokens in call tree below generateParseException
// jj_expentry:
//  - Likely full name: ExpectedEntry
//  - Used to calculated expected tokens in call tree below generateParseException
// jj_kind:
//  - Used to communicate the token kind of jj_consume_token to generateParseException
// jj_lasttokens:
//  - Internal state for jj_add_error_token
// jj_endpos:
//  - Used in call tree below generateParseException as index into jj_lasttokens and
//    as limit to iterate over jj_expentry
  final public 
Module module() throws ParseException {ArrayList<istmt> allStmts = new ArrayList<istmt>();
  ArrayList<istmt> stmts;
    try {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IF:
      case NOT:
      case DEF:
      case ASYNC:
      case LAMBDA:
      case FOR:
      case WITH:
      case RETURN:
      case TRY:
      case CLASS:
      case WHILE:
      case IMPORT:
      case FROM:
      case RAISE:
      case PASS:
      case DEL:
      case YIELD:
      case ASSERT:
      case BREAK:
      case CONTINUE:
      case GLOBAL:
      case NONLOCAL:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case AT:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case STAR:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        stmts = statementsAndDedentOrEof();
allStmts.addAll(stmts);
        break;
        }
      case 0:{
        jj_consume_token(0);
        break;
        }
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return new Module(allStmts, new ArrayList<TypeIgnore>());}
    } catch (ParseException exception) {
ErrorStatement errorStmt = recoverAndCreateErrorStmt(token, exception);
    allStmts.add(errorStmt);
    if (token.kind != EOF) {
      ArrayList<istmt> postRecoverStmts = statementsAndDedentOrEof();
      allStmts.addAll(postRecoverStmts);
    }
    {if ("" != null) return new Module(allStmts, new ArrayList<TypeIgnore>());}
    }
    throw new Error("Missing return statement in function");
}

// This is the "statements" rule from the CPython 3.9 grammar with a modification:
// Also consume the <DEDENT> or <EOF> which must follow.
// We do this for easy of error handling.
  final public ArrayList<istmt> statementsAndDedentOrEof() throws ParseException {ArrayList<istmt> allStmts = new ArrayList<istmt>();
  ArrayList<istmt> simpleStmts;
  istmt stmt;
    try {
      label_1:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IF:
        case DEF:
        case ASYNC:
        case FOR:
        case WITH:
        case TRY:
        case CLASS:
        case WHILE:
        case AT:{
          stmt = compoundStatement();
allStmts.add(stmt);
          break;
          }
        case NOT:
        case LAMBDA:
        case RETURN:
        case IMPORT:
        case FROM:
        case RAISE:
        case PASS:
        case DEL:
        case YIELD:
        case ASSERT:
        case BREAK:
        case CONTINUE:
        case GLOBAL:
        case NONLOCAL:
        case AWAIT:
        case NONE:
        case TRUE:
        case FALSE:
        case ELLIPSIS:
        case PLUS:
        case MINUS:
        case INVERT:
        case PAREN_OPEN:
        case SQUARE_OPEN:
        case CURLY_OPEN:
        case STAR:
        case DEC_INTEGER:
        case BIN_INTEGER:
        case OCT_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case IMAGINARY:
        case NAME:
        case STRING_PREFIX:
        case FORMAT_STRING_PREFIX:
        case STRING_QUOTE_OPEN:{
          simpleStmts = simpleStatement();
allStmts.addAll(simpleStmts);
          break;
          }
        default:
          jj_la1[1] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case IF:
        case NOT:
        case DEF:
        case ASYNC:
        case LAMBDA:
        case FOR:
        case WITH:
        case RETURN:
        case TRY:
        case CLASS:
        case WHILE:
        case IMPORT:
        case FROM:
        case RAISE:
        case PASS:
        case DEL:
        case YIELD:
        case ASSERT:
        case BREAK:
        case CONTINUE:
        case GLOBAL:
        case NONLOCAL:
        case AWAIT:
        case NONE:
        case TRUE:
        case FALSE:
        case ELLIPSIS:
        case PLUS:
        case MINUS:
        case AT:
        case INVERT:
        case PAREN_OPEN:
        case SQUARE_OPEN:
        case CURLY_OPEN:
        case STAR:
        case DEC_INTEGER:
        case BIN_INTEGER:
        case OCT_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case IMAGINARY:
        case NAME:
        case STRING_PREFIX:
        case FORMAT_STRING_PREFIX:
        case STRING_QUOTE_OPEN:{
          ;
          break;
          }
        default:
          jj_la1[2] = jj_gen;
          break label_1;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DEDENT:{
        jj_consume_token(DEDENT);
        break;
        }
      case 0:{
        jj_consume_token(0);
        break;
        }
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return allStmts;}
    } catch (ParseException exception) {
ErrorStatement errorStmt = recoverAndCreateErrorStmt(token, exception);
    allStmts.add(errorStmt);
    if (token.kind != EOF) {
      ArrayList<istmt> postRecoverStmts = statementsAndDedentOrEof();
      allStmts.addAll(postRecoverStmts);
    }
    {if ("" != null) return allStmts;}
    }
    throw new Error("Missing return statement in function");
}

// Error handling strategy:
// In case of a parse exception we search in the token stream for the next
// <SEMICOLON>, <NEWLINE> or <EOF> and than return the so far parsed statements.
// To not return "accidental" statements, a small statement is considered pending
// until a following <SEMICOLON>, <NEWLINE> or <EOF> was parsed.
// An "accidental" statement would be the "x" in "x y = 1". At first we successfully
// parse a <NAME> and after that we are missing a ";" or got one "y" too much. But
// only in the first case returning an "x" statement would be ok and since we dont
// know that we rather not return anything that was not terminated by the above
// special characters.
  final public ArrayList<istmt> simpleStatement() throws ParseException {istmt pendingStmt = null;
  ArrayList<istmt> stmts = new ArrayList<istmt>();
  Token reparseStartToken = null;
    try {
reparseStartToken = token;
      pendingStmt = smallStatement();
      label_2:
      while (true) {
        if (jj_2_1(2)) {
          ;
        } else {
          break label_2;
        }
        jj_consume_token(SEMICOLON);
reparseStartToken = token;
        if (pendingStmt != null) stmts.add(pendingStmt);
        pendingStmt = null;
        pendingStmt = smallStatement();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case SEMICOLON:{
        jj_consume_token(SEMICOLON);
if (pendingStmt != null) stmts.add(pendingStmt);
        pendingStmt = null;
        break;
        }
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NEWLINE:{
        jj_consume_token(NEWLINE);
        break;
        }
      case 0:{
        jj_consume_token(0);
        break;
        }
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
if (pendingStmt != null) stmts.add(pendingStmt);
      {if ("" != null) return stmts;}
    } catch (ParseException exception) {
Token lastCorrectToken = token;
    try {
      token = reparseStartToken;
      setCurrentToken(reparseStartToken);
      Name name = name();

      // We now test for parse alternatives which would either require a hugh
      // "factor out" effort or are not expressible at all with an LL(k) parser.
      // This means we need to reparse some of the input and thus give up on
      // strict linear time parsing but in practice the observed performance is
      // quite good since this only affects a usually small part of the input.
      if (name.id().equals("print")) {
        // We got a parsing failure after a "print" Name expression.
        // Try to interpret as python2 print statement.
        istmt printStmt = printStatementPython2(name);
        stmts.add(printStmt);
        {if ("" != null) return stmts;}
      } else if (name.id().equals("exec")) {
        // We got a parsing failure after a "exec" Name expression.
        // Try to interpret as python2 exec statement.
        istmt execStmt = execStatementPython2(name);
        stmts.add(execStmt);
        {if ("" != null) return stmts;}
      } else if (name.id().equals("match")) {
        Match matchStmt = matchStmt(name);
        stmts.add(matchStmt);
        {if ("" != null) return stmts;}
      } else if (name.id().equals("type")) {
        TypeAlias typeAlias = typeAlias(name);
        stmts.add(typeAlias);
        {if ("" != null) return stmts;}
      }
    } catch (ParseException printException) {
      // If something goes wrong trying to parse as python2 or match
      // statement, we can rely on the error recovery already for
      // the initial parse error.
    }

    setCurrentToken(lastCorrectToken);
    ErrorStatement errorStmt = recoverAndCreateErrorStmt(lastCorrectToken, exception);
    stmts.add(errorStmt);
    // We do not need to recursively invoke simpleStatement() here because the surrounding
    // rule does that already.
    {if ("" != null) return stmts;}
    }
    throw new Error("Missing return statement in function");
}

  final public Name name() throws ParseException {
    jj_consume_token(NAME);
{if ("" != null) return new Name(token.image, attributes(token, token));}
    throw new Error("Missing return statement in function");
}

// printName is the already parsed "print" Name expression.
// Since this rule is only expected to be called in error
// recovery, it needs to consume trailing semicolons and
// newline to finish the simpleStatement context and
// allow normal parsing to continue.
  final public istmt printStatementPython2(Name printName) throws ParseException {iexpr expr;
  ArrayList<iexpr> arguments = new ArrayList<iexpr>();
    expr = expression();
arguments.add(expr);
    label_3:
    while (true) {
      if (jj_2_2(2)) {
        ;
      } else {
        break label_3;
      }
      jj_consume_token(COMMA);
      expr = expression();
arguments.add(expr);
    }
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[6] = jj_gen;
        break label_4;
      }
      jj_consume_token(COMMA);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 0:
      case NEWLINE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NEWLINE:{
          jj_consume_token(NEWLINE);
          break;
          }
        case 0:{
          jj_consume_token(0);
          break;
          }
        default:
          jj_la1[7] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[8] = jj_gen;
        ;
      }
      break;
      }
    case NEWLINE:{
      jj_consume_token(NEWLINE);
      break;
      }
    case 0:{
      jj_consume_token(0);
      break;
      }
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new Expr(
      new Call(printName, arguments, new ArrayList<Keyword>(), attributes(printName, token)));}
    throw new Error("Missing return statement in function");
}

// execName is the already parsed "exec" Name expression.
// Since this rule is only expected to be called in error
// recovery, it needs to consume trailing semicolons and
// newline to finish the simpleStatement context and
// allow normal parsing to continue.
  final public istmt execStatementPython2(Name execName) throws ParseException {iexpr codeExpr;
  iexpr globalsExpr = null;
  iexpr localsExpr = null;
    codeExpr = bitwiseOr();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IN:{
      jj_consume_token(IN);
      globalsExpr = expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        localsExpr = expression();
        break;
        }
      default:
        jj_la1[10] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[11] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SEMICOLON:{
      jj_consume_token(SEMICOLON);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case 0:
      case NEWLINE:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NEWLINE:{
          jj_consume_token(NEWLINE);
          break;
          }
        case 0:{
          jj_consume_token(0);
          break;
          }
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[13] = jj_gen;
        ;
      }
      break;
      }
    case NEWLINE:{
      jj_consume_token(NEWLINE);
      break;
      }
    case 0:{
      jj_consume_token(0);
      break;
      }
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
ArrayList<iexpr> arguments = new ArrayList<iexpr>();
    arguments.add(codeExpr);
    if (globalsExpr != null) {
      arguments.add(globalsExpr);
    }
    if (localsExpr != null) {
      arguments.add(localsExpr);
    }
    {if ("" != null) return new Expr(
      new Call(execName, arguments, new ArrayList<Keyword>(), attributes(execName, token)));}
    throw new Error("Missing return statement in function");
}

  final public iexpr starNamedExpression() throws ParseException {iexpr expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expr = namedExpression();
      break;
      }
    case STAR:{
      expr = starredBitwiseOr();
      break;
      }
    default:
      jj_la1[15] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

// "match" is a so called "soft" keyword introduced in Python 3.10.
// Only in the specific pattern match statement constellation it is
// considered a keyword and otherwise it is a regular NAME token
// which means we cannot have something like a MATCH token.
  final public Match matchStmt(Name matchKeyword) throws ParseException {ArrayList<iexpr> expressions = new ArrayList<>();
  iexpr subjectExpr;
  boolean isTuple = false;
  MatchCase matchCase;
  ArrayList<MatchCase> cases = new ArrayList<>();
    subjectExpr = starNamedExpression();
expressions.add(subjectExpr);
    label_5:
    while (true) {
      if (jj_2_3(2)) {
        ;
      } else {
        break label_5;
      }
      jj_consume_token(COMMA);
isTuple = true;
      subjectExpr = starNamedExpression();
expressions.add(subjectExpr);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
isTuple = true;
      break;
      }
    default:
      jj_la1[16] = jj_gen;
if (expressions == null && subjectExpr instanceof Starred) {
        {if (true) throw new ParseException("Single starred subject requires trailing comma.");}
      }
    }
if (isTuple) {
      subjectExpr = new Tuple(expressions, attributes(expressions.get(0), token));
    }
    jj_consume_token(COLON);
    jj_consume_token(NEWLINE);
    jj_consume_token(INDENT);
    label_6:
    while (true) {
      matchCase = caseBlock();
cases.add(matchCase);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NAME:{
        ;
        break;
        }
      default:
        jj_la1[17] = jj_gen;
        break label_6;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DEDENT:{
      jj_consume_token(DEDENT);
      break;
      }
    case 0:{
      jj_consume_token(0);
      break;
      }
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return new Match(subjectExpr, cases, attributes(matchKeyword, token));}
    throw new Error("Missing return statement in function");
}

  final public MatchCase caseBlock() throws ParseException {ArrayList<ipattern> patterns = new ArrayList<>();
  boolean isSequence;
  Token patternEndToken;
  iexpr guard = null;
  ArrayList<istmt> blockStmts;
    jj_consume_token(NAME);
if (!token.image.equals("case")) {if (true) throw new ParseException("case keyword expected");}
    isSequence = groupOrSequenceCore(patterns);
patternEndToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      guard = guard();
      break;
      }
    default:
      jj_la1[19] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    blockStmts = block();
ipattern pattern;
    if (isSequence) {
      pattern = new MatchSequence(patterns, attributes(patterns.get(0), patternEndToken));
    } else {
      pattern = patterns.get(0);
    }
    {if ("" != null) return new MatchCase(pattern, guard, blockStmts);}
    throw new Error("Missing return statement in function");
}

  final public iexpr guard() throws ParseException {iexpr expr;
    jj_consume_token(IF);
    expr = namedExpression();
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public ipattern pattern() throws ParseException {ipattern pattern;
    pattern = asPattern();
{if ("" != null) return pattern;}
    throw new Error("Missing return statement in function");
}

  final public ipattern asPattern() throws ParseException {ipattern pattern;
  String target;
    pattern = orPattern();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      target = patternCaptureTarget();
pattern = new MatchAs(pattern, target, attributes(pattern, token));
      break;
      }
    default:
      jj_la1[20] = jj_gen;
      ;
    }
{if ("" != null) return pattern;}
    throw new Error("Missing return statement in function");
}

  final public ipattern orPattern() throws ParseException {ipattern pattern;
  ArrayList<ipattern> patterns = null;
    pattern = closedPattern();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_OR:{
        ;
        break;
        }
      default:
        jj_la1[21] = jj_gen;
        break label_7;
      }
      jj_consume_token(BIT_OR);
if (patterns == null) {
        patterns = new ArrayList<>();
        patterns.add(pattern);
      }
      pattern = closedPattern();
patterns.add(pattern);
    }
if (patterns != null) {
      {if ("" != null) return new MatchOr(patterns, attributes(patterns.get(0), token));}
    } else {
      {if ("" != null) return pattern;}
    }
    throw new Error("Missing return statement in function");
}

  final public ipattern closedPattern() throws ParseException {ipattern pattern;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:
    case TRUE:
    case FALSE:
    case MINUS:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      pattern = literalPattern();
      break;
      }
    case NAME:{
      pattern = captureOrWildcardOrValueOrClassPattern();
      break;
      }
    case PAREN_OPEN:
    case SQUARE_OPEN:{
      pattern = groupOrSequencePattern();
      break;
      }
    case CURLY_OPEN:{
      pattern = mappingPattern();
      break;
      }
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return pattern;}
    throw new Error("Missing return statement in function");
}

  final public ipattern literalPattern() throws ParseException {iexpr expr;
    expr = literalExpr();
if (expr instanceof Constant) {
      Constant constant = (Constant)expr;
      if (constant.value() instanceof BoolConstant || constant.value() instanceof NoneConstant$) {
        {if ("" != null) return new MatchSingleton(constant.value(), attributes(token, token));}
      }
    }
    {if ("" != null) return new MatchValue(expr, attributes(expr, token));}
    throw new Error("Missing return statement in function");
}

  final public iexpr literalExpr() throws ParseException {iexpr expr = null;
  Constant leftNumber;
  Constant rightNumber;
  Token leftMinusToken = null;
  ioperator binOp;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case MINUS:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case MINUS:{
        jj_consume_token(MINUS);
leftMinusToken = token;
        break;
        }
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      leftNumber = number();
if (leftMinusToken != null) {
          expr = new UnaryOp(USub$.MODULE$, leftNumber, attributes(leftMinusToken, token));
        } else {
          expr = leftNumber;
        }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case PLUS:{
          jj_consume_token(PLUS);
binOp = Add$.MODULE$;
          break;
          }
        case MINUS:{
          jj_consume_token(MINUS);
binOp = Sub$.MODULE$;
          break;
          }
        default:
          jj_la1[24] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        rightNumber = number();
expr = new BinOp(expr, binOp, rightNumber, attributes(expr, token));
        break;
        }
      default:
        jj_la1[25] = jj_gen;
        ;
      }
{if ("" != null) return expr;}
      break;
      }
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expr = strings();
{if ("" != null) return expr;}
      break;
      }
    case NONE:{
      jj_consume_token(NONE);
{if ("" != null) return new Constant(NoneConstant$.MODULE$, attributes(token, token));}
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return new Constant(new BoolConstant(true), attributes(token, token));}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return new Constant(new BoolConstant(false), attributes(token, token));}
      break;
      }
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

// The python grammar has separate capture, wildcard, value and class pattern rules.
// We need to merge them in order to factor out the leading nameOrAttr expression which they
// all share.
  final public ipattern captureOrWildcardOrValueOrClassPattern() throws ParseException {iexpr expr;
    expr = nameOrAttr();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PAREN_OPEN:{
ArrayList<ipattern> patterns = new ArrayList<>();
      ArrayList<String> kwd_attrs = new ArrayList<>();
      ArrayList<ipattern> kwd_patterns = new ArrayList<>();
      jj_consume_token(PAREN_OPEN);
      patternArguments(patterns, kwd_attrs, kwd_patterns);
      jj_consume_token(PAREN_CLOSE);
{if ("" != null) return new MatchClass(expr, patterns, kwd_attrs, kwd_patterns, attributes(expr, token));}
      break;
      }
    default:
      jj_la1[27] = jj_gen;
      ;
    }
// We only get here if it is not a class pattern.
    if (expr instanceof Name) {
      // A plain name is interpreted as pattern not as value.
      String target = token.image;
      if (!target.equals("_")) {
        // Capture pattern
        {if ("" != null) return new MatchAs(null, target, attributes(token, token));}
      } else {
        // Wildcard pattern
        {if ("" != null) return new MatchAs((ipattern)null, null, attributes(token, token));}
      }
    } else {
      // Value pattern
      {if ("" != null) return new MatchValue(expr, attributes(expr, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr nameOrAttr() throws ParseException {iexpr expr;
    jj_consume_token(NAME);
expr = new Name(token.image, attributes(token, token));
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[28] = jj_gen;
        break label_8;
      }
      jj_consume_token(DOT);
      jj_consume_token(NAME);
expr = new Attribute(expr, token.image, attributes(expr, token));
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public void patternArguments(ArrayList<ipattern> patterns, ArrayList<String> kwd_attrs, ArrayList<ipattern> kwd_patterns) throws ParseException {String keyword = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:
    case TRUE:
    case FALSE:
    case MINUS:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      keyword = patternArgument(keyword, patterns, kwd_attrs, kwd_patterns);
      label_9:
      while (true) {
        if (jj_2_4(2)) {
          ;
        } else {
          break label_9;
        }
        jj_consume_token(COMMA);
        keyword = patternArgument(keyword, patterns, kwd_attrs, kwd_patterns);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[29] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[30] = jj_gen;
      ;
    }
}

  final public String patternArgument(String lastKeyword, ArrayList<ipattern> patterns, ArrayList<String> kwd_attrs, ArrayList<ipattern> kwd_patterns) throws ParseException {ipattern pattern;
  String keyword = lastKeyword;
    if (jj_2_5(2)) {
      jj_consume_token(NAME);
keyword = token.image;
      jj_consume_token(ASSIGN);
    } else {
if (keyword != null) {if (true) throw new ParseException("No non keyword pattern allowed after keyword pattern.");}
    }
    pattern = pattern();
if (keyword != null) {
      kwd_attrs.add(keyword);
      kwd_patterns.add(pattern);
    } else {
      patterns.add(pattern);
    }
    {if ("" != null) return keyword;}
    throw new Error("Missing return statement in function");
}

  final public ipattern groupOrSequencePattern() throws ParseException {Token startToken;
  ArrayList<ipattern> patterns = new ArrayList<>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SQUARE_OPEN:{
      jj_consume_token(SQUARE_OPEN);
startToken = token;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NONE:
      case TRUE:
      case FALSE:
      case MINUS:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case STAR:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        groupOrSequenceCore(patterns);
        break;
        }
      default:
        jj_la1[31] = jj_gen;
        ;
      }
      jj_consume_token(SQUARE_CLOSE);
{if ("" != null) return new MatchSequence(patterns, attributes(startToken, token));}
      break;
      }
    case PAREN_OPEN:{
boolean isSequence = true;
      jj_consume_token(PAREN_OPEN);
startToken = token;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NONE:
      case TRUE:
      case FALSE:
      case MINUS:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case STAR:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        isSequence = groupOrSequenceCore(patterns);
        break;
        }
      default:
        jj_la1[32] = jj_gen;
        ;
      }
      jj_consume_token(PAREN_CLOSE);
if (isSequence) {
          {if ("" != null) return new MatchSequence(patterns, attributes(startToken, token));}
        } else {
          // Group pattern
          {if ("" != null) return patterns.get(0);}
        }
      break;
      }
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public boolean groupOrSequenceCore(ArrayList<ipattern> patterns) throws ParseException {ipattern pattern;
  boolean starPatternExists = false;
  boolean isSequence = false;
    pattern = maybeStarPattern();
if (pattern instanceof MatchStar) starPatternExists = true;
    patterns.add(pattern);
    label_10:
    while (true) {
      if (jj_2_6(2)) {
        ;
      } else {
        break label_10;
      }
      jj_consume_token(COMMA);
      pattern = maybeStarPattern();
if (starPatternExists) {
        {if (true) throw new ParseException("Only one star pattern allowed per sequence");}
      }
      isSequence = true;
      if (pattern instanceof MatchStar) starPatternExists = true;
      patterns.add(pattern);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
isSequence = true;
      break;
      }
    default:
      jj_la1[34] = jj_gen;
      ;
    }
{if ("" != null) return isSequence;}
    throw new Error("Missing return statement in function");
}

  final public ipattern maybeStarPattern() throws ParseException {ipattern pattern;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STAR:{
      pattern = starPattern();
      break;
      }
    case NONE:
    case TRUE:
    case FALSE:
    case MINUS:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      pattern = pattern();
      break;
      }
    default:
      jj_la1[35] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return pattern;}
    throw new Error("Missing return statement in function");
}

  final public MatchStar starPattern() throws ParseException {
    jj_consume_token(STAR);
    jj_consume_token(NAME);
String target = token.image;
    if (!target.equals("_")) {
      // Capture pattern
      {if ("" != null) return new MatchStar(target, attributes(token, token));}
    } else {
      // Wildcard pattern
      {if ("" != null) return new MatchStar((String)null, attributes(token, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public String patternCaptureTarget() throws ParseException {
    jj_consume_token(NAME);
if (token.image.equals("_")) {if (true) throw new ParseException("Invalid capture pattern.");}
    {if ("" != null) return token.image;}
    throw new Error("Missing return statement in function");
}

  final public MatchMapping mappingPattern() throws ParseException {Token startToken;
  ArrayList<iexpr> keys = new ArrayList<>();
  ArrayList<ipattern> patterns = new ArrayList<>();
  String rest = null;
    jj_consume_token(CURLY_OPEN);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:
    case TRUE:
    case FALSE:
    case MINUS:
    case DOUBLE_STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      rest = keyValuePattern(rest, keys, patterns);
      label_11:
      while (true) {
        if (jj_2_7(2)) {
          ;
        } else {
          break label_11;
        }
        jj_consume_token(COMMA);
        rest = keyValuePattern(rest, keys, patterns);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(CURLY_CLOSE);
{if ("" != null) return new MatchMapping(keys, patterns, rest, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public String keyValuePattern(String lastRest, ArrayList<iexpr> keys, ArrayList<ipattern> patterns) throws ParseException {iexpr key;
  ipattern pattern;
  String target;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:
    case TRUE:
    case FALSE:
    case MINUS:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NONE:
      case TRUE:
      case FALSE:
      case MINUS:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        key = literalExpr();
        break;
        }
      case NAME:{
        key = nameOrAttr();
        break;
        }
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(COLON);
      pattern = pattern();
if (key instanceof Name) {if (true) throw new ParseException("Pure name not allowed.");}
        keys.add(key);
        patterns.add(pattern);
        {if ("" != null) return lastRest;}
      break;
      }
    case DOUBLE_STAR:{
      jj_consume_token(DOUBLE_STAR);
      target = patternCaptureTarget();
if (lastRest != null) {if (true) throw new ParseException("Only one double star pattern allowed.");}
        {if ("" != null) return target;}
      break;
      }
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public istmt smallStatement() throws ParseException {istmt stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      stmt = assignmentOrExpr();
stmt = printStatmentToPython2StyleRewrite(stmt);
      break;
      }
    case RETURN:{
      stmt = returnStatement();
      break;
      }
    case IMPORT:
    case FROM:{
      stmt = importStatement();
      break;
      }
    case RAISE:{
      stmt = raiseStatement();
      break;
      }
    case PASS:{
      stmt = passStatement();
      break;
      }
    case DEL:{
      stmt = delStatement();
      break;
      }
    case YIELD:{
      stmt = yieldStatement();
      break;
      }
    case ASSERT:{
      stmt = assertStatement();
      break;
      }
    case BREAK:{
      stmt = breakStatement();
      break;
      }
    case CONTINUE:{
      stmt = continueStatement();
      break;
      }
    case GLOBAL:{
      stmt = globalStatement();
      break;
      }
    case NONLOCAL:{
      stmt = nonlocalStatement();
      break;
      }
    default:
      jj_la1[40] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
}

// "type" is a so called "soft" keyword introduced in Python 3.12.
// Only in the specific type alias statement constellation it is
// considered a keyword and otherwise it is a regular NAME token
// which means we cannot have something like a TYPE token.
  final public TypeAlias typeAlias(Name typeKeyword) throws ParseException {Name name;
  ArrayList<itypeParam> typeParams = new ArrayList<>();
  iexpr value;
    jj_consume_token(NAME);
name = new Name(token.image, attributes(token, token));
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SQUARE_OPEN:{
      typeParams(typeParams);
      break;
      }
    default:
      jj_la1[41] = jj_gen;
      ;
    }
    jj_consume_token(ASSIGN);
    value = expression();
{if ("" != null) return new TypeAlias(name, typeParams, value, attributes(typeKeyword, token));}
    throw new Error("Missing return statement in function");
}

  final public void typeParams(ArrayList<itypeParam> typeParams) throws ParseException {itypeParam typeParam;
    jj_consume_token(SQUARE_OPEN);
    typeParam = typeParam();
typeParams.add(typeParam);
    label_12:
    while (true) {
      if (jj_2_8(2)) {
        ;
      } else {
        break label_12;
      }
      jj_consume_token(COMMA);
      typeParam = typeParam();
typeParams.add(typeParam);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[42] = jj_gen;
      ;
    }
    jj_consume_token(SQUARE_CLOSE);
}

  final public itypeParam typeParam() throws ParseException {Token startToken;
  iexpr bound = null;
  itypeParam typeParam;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      jj_consume_token(NAME);
startToken = token;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        bound = expression();
        break;
        }
      default:
        jj_la1[43] = jj_gen;
        ;
      }
typeParam = new TypeVar(startToken.image, bound, attributes(startToken, token));
      break;
      }
    case STAR:{
      jj_consume_token(STAR);
startToken = token;
      jj_consume_token(NAME);
typeParam = new TypeVarTuple(token.image, attributes(startToken, token));
      break;
      }
    case DOUBLE_STAR:{
      jj_consume_token(DOUBLE_STAR);
startToken = token;
      jj_consume_token(NAME);
typeParam = new ParamSpec(token.image, attributes(startToken, token));
      break;
      }
    default:
      jj_la1[44] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return typeParam;}
    throw new Error("Missing return statement in function");
}

// We are little bit less restrictive than the python 3.9 grammar because
// we allow logical expressions in star expressions to be returned.
// E.g. "return * x and y" the python 3.9 grammar would require parenthesis:
// "return *(x and y)".
  final public Return returnStatement() throws ParseException {iexpr expression = null;
  Token startToken;
    jj_consume_token(RETURN);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expression = starExpressions();
      break;
      }
    default:
      jj_la1[45] = jj_gen;
      ;
    }
{if ("" != null) return new Return(expression, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public istmt importStatement() throws ParseException {istmt stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IMPORT:{
      stmt = importName();
      break;
      }
    case FROM:{
      stmt = importFrom();
      break;
      }
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
}

  final public Import importName() throws ParseException {ArrayList<Alias> names;
  Token startToken;
    jj_consume_token(IMPORT);
startToken = token;
    names = dottedAsNames();
{if ("" != null) return new Import(names, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public ArrayList<Alias> dottedAsNames() throws ParseException {Alias name;
  ArrayList<Alias> names = new ArrayList<Alias>();
    name = dottedAsName();
names.add(name);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[47] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      name = dottedAsName();
names.add(name);
    }
{if ("" != null) return names;}
    throw new Error("Missing return statement in function");
}

  final public Alias dottedAsName() throws ParseException {String dottedName;
  String asName = null;
    dottedName = dottedName();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      jj_consume_token(NAME);
asName = token.image;
      break;
      }
    default:
      jj_la1[48] = jj_gen;
      ;
    }
{if ("" != null) return new Alias(dottedName, asName);}
    throw new Error("Missing return statement in function");
}

  final public String dottedName() throws ParseException {String dottedName;
    jj_consume_token(NAME);
dottedName = token.image;
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[49] = jj_gen;
        break label_14;
      }
      jj_consume_token(DOT);
      jj_consume_token(NAME);
dottedName = dottedName + "." + token.image;
    }
{if ("" != null) return dottedName;}
    throw new Error("Missing return statement in function");
}

  final public ImportFrom importFrom() throws ParseException {int level = 0;
  String module = null;
  ArrayList<Alias> names;
  Token startToken;
    jj_consume_token(FROM);
startToken = token;
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ELLIPSIS:
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[50] = jj_gen;
        break label_15;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DOT:{
        jj_consume_token(DOT);
level += 1;
        break;
        }
      case ELLIPSIS:{
        jj_consume_token(ELLIPSIS);
level += 3;
        break;
        }
      default:
        jj_la1[51] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      module = dottedName();
      break;
      }
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    jj_consume_token(IMPORT);
    names = importFromTargets();
if (level != 0 || module != null) {
      {if ("" != null) return new ImportFrom(module, names, level, attributes(startToken, token));}
    } else {
      {if (true) throw new ParseException("TODO");}
    }
    throw new Error("Missing return statement in function");
}

  final public ArrayList<Alias> importFromTargets() throws ParseException {Alias name;
  ArrayList<Alias> names;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STAR:{
      jj_consume_token(STAR);
names = new ArrayList<Alias>();
    names.add(new Alias(token.image, (String)null));
      break;
      }
    case PAREN_OPEN:{
      jj_consume_token(PAREN_OPEN);
      names = importFromAsNames();
      jj_consume_token(PAREN_CLOSE);
      break;
      }
    case NAME:{
      names = importFromAsNames();
      break;
      }
    default:
      jj_la1[53] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return names;}
    throw new Error("Missing return statement in function");
}

  final public ArrayList<Alias> importFromAsNames() throws ParseException {Alias name;
  ArrayList<Alias> names = new ArrayList<Alias>();
    name = importFromAsName();
names.add(name);
    label_16:
    while (true) {
      if (jj_2_9(2)) {
        ;
      } else {
        break label_16;
      }
      jj_consume_token(COMMA);
      name = importFromAsName();
names.add(name);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[54] = jj_gen;
      ;
    }
{if ("" != null) return names;}
    throw new Error("Missing return statement in function");
}

  final public Alias importFromAsName() throws ParseException {String name;
  String asName = null;
    jj_consume_token(NAME);
name = token.image;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      jj_consume_token(NAME);
asName = token.image;
      break;
      }
    default:
      jj_la1[55] = jj_gen;
      ;
    }
{if ("" != null) return new Alias(name, asName);}
    throw new Error("Missing return statement in function");
}

  final public istmt raiseStatement() throws ParseException {Token startToken;
  iexpr exceptionExpr = null;
  iexpr causeExpr = null;
  iexpr instExpr = null;
  iexpr tracebackExpr = null;
    jj_consume_token(RAISE);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      exceptionExpr = expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FROM:
      case COMMA:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FROM:{
          jj_consume_token(FROM);
          causeExpr = expression();
          break;
          }
        case COMMA:{
          jj_consume_token(COMMA);
          instExpr = expression();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            tracebackExpr = expression();
            break;
            }
          default:
            jj_la1[56] = jj_gen;
            ;
          }
          break;
          }
        default:
          jj_la1[57] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[58] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[59] = jj_gen;
      ;
    }
if (instExpr != null) {
      {if ("" != null) return new RaiseP2(exceptionExpr, instExpr, tracebackExpr, attributes(startToken, token));}
    } else {
      {if ("" != null) return new Raise(exceptionExpr, causeExpr, attributes(startToken, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public Pass passStatement() throws ParseException {
    jj_consume_token(PASS);
{if ("" != null) return new Pass(attributes(token, token));}
    throw new Error("Missing return statement in function");
}

// This is not as restrictive as the corresponding CPython 3.9 rule
// because we except a primary as target which includes e.g. number literals
// which would be invalid Python code.
  final public Delete delStatement() throws ParseException {Token startToken;
  iexpr target;
  ArrayList<iexpr> targets = new ArrayList<iexpr>();
    jj_consume_token(DEL);
startToken = token;
    target = primary();
targets.add(target);
    label_17:
    while (true) {
      if (jj_2_10(2)) {
        ;
      } else {
        break label_17;
      }
      jj_consume_token(COMMA);
      target = primary();
targets.add(target);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[60] = jj_gen;
      ;
    }
{if ("" != null) return new Delete(targets, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public Expr yieldStatement() throws ParseException {iexpr yieldExpr;
    yieldExpr = yieldExpression();
{if ("" != null) return new Expr(yieldExpr);}
    throw new Error("Missing return statement in function");
}

  final public Assert assertStatement() throws ParseException {Token startToken;
  iexpr testExpr;
  iexpr msgExpr = null;
    jj_consume_token(ASSERT);
startToken = token;
    testExpr = expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      msgExpr = expression();
      break;
      }
    default:
      jj_la1[61] = jj_gen;
      ;
    }
{if ("" != null) return new Assert(testExpr, msgExpr, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public Break breakStatement() throws ParseException {
    jj_consume_token(BREAK);
{if ("" != null) return new Break(attributes(token, token));}
    throw new Error("Missing return statement in function");
}

  final public Continue continueStatement() throws ParseException {
    jj_consume_token(CONTINUE);
{if ("" != null) return new Continue(attributes(token, token));}
    throw new Error("Missing return statement in function");
}

  final public Global globalStatement() throws ParseException {Token startToken;
  ArrayList<String> names = new ArrayList<String>();
    jj_consume_token(GLOBAL);
startToken = token;
    jj_consume_token(NAME);
names.add(token.image);
    label_18:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[62] = jj_gen;
        break label_18;
      }
      jj_consume_token(COMMA);
      jj_consume_token(NAME);
names.add(token.image);
    }
{if ("" != null) return new Global(names, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public Nonlocal nonlocalStatement() throws ParseException {Token startToken;
  ArrayList<String> names = new ArrayList<String>();
    jj_consume_token(NONLOCAL);
startToken = token;
    jj_consume_token(NAME);
names.add(token.image);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        ;
        break;
        }
      default:
        jj_la1[63] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      jj_consume_token(NAME);
names.add(token.image);
    }
{if ("" != null) return new Nonlocal(names, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public istmt compoundStatement() throws ParseException {istmt stmt;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AT:{
      stmt = decoratedStatement();
      break;
      }
    case ASYNC:{
      stmt = asyncStatement();
      break;
      }
    case DEF:{
      stmt = functionDef(new ArrayList<iexpr>(), false, null);
      break;
      }
    case IF:{
      stmt = ifStatement();
      break;
      }
    case CLASS:{
      stmt = classDef(new ArrayList<iexpr>());
      break;
      }
    case FOR:{
      stmt = forStatement(false, null);
      break;
      }
    case WITH:{
      stmt = withStatement(false, null);
      break;
      }
    case TRY:{
      stmt = tryStatement();
      break;
      }
    case WHILE:{
      stmt = whileStatement();
      break;
      }
    default:
      jj_la1[64] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
}

  final public istmt decoratedStatement() throws ParseException {ArrayList<iexpr> decorators;
  Token asyncToken;
  istmt stmt;
    decorators = decorators();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DEF:{
      stmt = functionDef(decorators, false, null);
      break;
      }
    case ASYNC:{
      jj_consume_token(ASYNC);
asyncToken = token;
      stmt = functionDef(decorators, true, asyncToken);
      break;
      }
    case CLASS:{
      stmt = classDef(decorators);
      break;
      }
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
}

  final public istmt asyncStatement() throws ParseException {Token asyncToken;
  istmt stmt;
    jj_consume_token(ASYNC);
asyncToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DEF:{
      stmt = functionDef(new ArrayList<iexpr>(), true, asyncToken);
      break;
      }
    case FOR:{
      stmt = forStatement(true, asyncToken);
      break;
      }
    case WITH:{
      stmt = withStatement(true, asyncToken);
      break;
      }
    default:
      jj_la1[66] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmt;}
    throw new Error("Missing return statement in function");
}

  final public istmt functionDef(ArrayList<iexpr> decorators, boolean isAsync, Token asyncToken) throws ParseException {Token startToken = asyncToken;
  String name;
  Arguments parameters;
  iexpr returnExpr = null;
  ArrayList<istmt> blockStmts;
  ArrayList<itypeParam> typeParams = new ArrayList<>();
    jj_consume_token(DEF);
if (!isAsync) {startToken = token;}
    jj_consume_token(NAME);
name = token.image;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SQUARE_OPEN:{
      typeParams(typeParams);
      break;
      }
    default:
      jj_la1[67] = jj_gen;
      ;
    }
    jj_consume_token(PAREN_OPEN);
    parameters = parameters();
    jj_consume_token(PAREN_CLOSE);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ARROW:{
      jj_consume_token(ARROW);
      returnExpr = expression();
      break;
      }
    default:
      jj_la1[68] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    blockStmts = block();
if (isAsync) {
      {if ("" != null) return new AsyncFunctionDef(name, parameters, blockStmts, decorators,
        returnExpr, null, typeParams, attributes(startToken, token));}
    } else {
      {if ("" != null) return new FunctionDef(name, parameters, blockStmts, decorators,
        returnExpr, null, typeParams, attributes(startToken, token));}
    }
    throw new Error("Missing return statement in function");
}

// Sister function of lambdaParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
// This rule matches always because its contend is purely optional.
//
// This is a fully factored out version of the CPython 3.9 parameters parser rule
// minus the support for type comments which are currently swallowed by the lexer.
// Dont be confused by the inconsistent use of argument and parameter identifiers.
// Arg, Arguments, Arg and Argument class names are part of the user facing API
// with which we mimic the CPython AST API and thus their names are what they are.
// They should rather be named iparam, iparameters etc..
  final public Arguments parameters() throws ParseException {ArrayList<Arg> posOnlyArgs = new ArrayList<Arg>();
  ArrayList<Arg> args = new ArrayList<Arg>();
  // Contains the defaults for posOnlyArgs and args.
  ArrayList<iexpr> defaults = new ArrayList<iexpr>();
  BoxedObject<Arg> varArg = new BoxedObject<Arg>(null);
  ArrayList<Arg> kwOnlyArgs = new ArrayList<Arg>();
  // Contains the defaults for kwOnlyArgs. If such an
  // argument has no default, null is added instead.
  ArrayList<iexpr> kwDefaults = new ArrayList<iexpr>();
  BoxedObject<Arg> kwArg = new BoxedObject<Arg>(null);

  boolean defaultRequired = false;
  ArrayList<Arg> tmpArgs = new ArrayList<Arg>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      defaultRequired = positionalParameters(defaultRequired, args, defaults);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DIV:{
          jj_consume_token(DIV);
posOnlyArgs = args; args = new ArrayList<Arg>();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case NAME:{
              positionalParameters(defaultRequired, args, defaults);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case COMMA:{
                jj_consume_token(COMMA);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case STAR:{
                  starAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
                  break;
                  }
                case DOUBLE_STAR:{
                  kwArg.object = doubleStarParameters();
                  break;
                  }
                default:
                  jj_la1[69] = jj_gen;

                }
                break;
                }
              default:
                jj_la1[70] = jj_gen;
                ;
              }
              break;
              }
            case STAR:{
              starAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
              break;
              }
            case DOUBLE_STAR:{
              kwArg.object = doubleStarParameters();
              break;
              }
            default:
              jj_la1[71] = jj_gen;

            }
            break;
            }
          default:
            jj_la1[72] = jj_gen;
            ;
          }
          break;
          }
        case STAR:{
          starAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
          break;
          }
        case DOUBLE_STAR:{
          kwArg.object = doubleStarParameters();
          break;
          }
        default:
          jj_la1[73] = jj_gen;

        }
        break;
        }
      default:
        jj_la1[74] = jj_gen;
        ;
      }
      break;
      }
    case STAR:{
      starAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
      break;
      }
    case DOUBLE_STAR:{
      kwArg.object = doubleStarParameters();
      break;
      }
    default:
      jj_la1[75] = jj_gen;

    }
{if ("" != null) return new Arguments(posOnlyArgs, args, varArg.object, kwOnlyArgs,
     kwDefaults, kwArg.object, defaults);}
    throw new Error("Missing return statement in function");
}

// Sister function of lambdaStarAndFollowingParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public void starAndFollowingParameters(BoxedObject<Arg> varArg,
                                ArrayList<Arg> kwOnlyArgs,
                                ArrayList<iexpr> kwDefaults,
                                BoxedObject<Arg> kwArg) throws ParseException {
    jj_consume_token(STAR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      varArg.object = typedFunctionParameterDef();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAME:{
          kwOnlyParameters(kwOnlyArgs, kwDefaults);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DOUBLE_STAR:{
              kwArg.object = doubleStarParameters();
              break;
              }
            default:
              jj_la1[76] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[77] = jj_gen;
            ;
          }
          break;
          }
        case DOUBLE_STAR:{
          kwArg.object = doubleStarParameters();
          break;
          }
        default:
          jj_la1[78] = jj_gen;

        }
        break;
        }
      default:
        jj_la1[79] = jj_gen;
        ;
      }
      break;
      }
    case COMMA:{
      jj_consume_token(COMMA);
      kwOnlyParameters(kwOnlyArgs, kwDefaults);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOUBLE_STAR:{
          kwArg.object = doubleStarParameters();
          break;
          }
        default:
          jj_la1[80] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[81] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[82] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// Sister function of lambdaDoubleStarParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public Arg doubleStarParameters() throws ParseException {Arg kwArg;
    jj_consume_token(DOUBLE_STAR);
    kwArg = typedFunctionParameterDef();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[83] = jj_gen;
      ;
    }
{if ("" != null) return kwArg;}
    throw new Error("Missing return statement in function");
}

// Sister function of lambdaPositionalParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public boolean positionalParameters(boolean initialDefaultRequired,
                             ArrayList<Arg> params, ArrayList<iexpr> defaults) throws ParseException {Arg param;
  iexpr defaultExpr;
  boolean defaultRequired = initialDefaultRequired;
    param = typedFunctionParameterDef();
params.add(param);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      defaultExpr = expression();
defaults.add(defaultExpr); defaultRequired = true;
      break;
      }
    default:
      jj_la1[84] = jj_gen;
if (defaultRequired) { {if (true) throw new ParseException("TODO");} }
    }
    label_20:
    while (true) {
      if (jj_2_11(2)) {
        ;
      } else {
        break label_20;
      }
      jj_consume_token(COMMA);
      param = typedFunctionParameterDef();
params.add(param);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSIGN:{
        jj_consume_token(ASSIGN);
        defaultExpr = expression();
defaults.add(defaultExpr); defaultRequired = true;
        break;
        }
      default:
        jj_la1[85] = jj_gen;
if (defaultRequired) { {if (true) throw new ParseException("TODO");} }
      }
    }
{if ("" != null) return defaultRequired;}
    throw new Error("Missing return statement in function");
}

// Sister function of lambdaKwOnlyParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public void kwOnlyParameters(ArrayList<Arg> params, ArrayList<iexpr> defaults) throws ParseException {Arg param;
  iexpr defaultExpr;
    param = typedFunctionParameterDef();
params.add(param);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      defaultExpr = expression();
defaults.add(defaultExpr);
      break;
      }
    default:
      jj_la1[86] = jj_gen;
defaults.add(null);
    }
    label_21:
    while (true) {
      if (jj_2_12(2)) {
        ;
      } else {
        break label_21;
      }
      jj_consume_token(COMMA);
      param = typedFunctionParameterDef();
params.add(param);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSIGN:{
        jj_consume_token(ASSIGN);
        defaultExpr = expression();
defaults.add(defaultExpr);
        break;
        }
      default:
        jj_la1[87] = jj_gen;
defaults.add(null);
      }
    }
}

  final public Arg typedFunctionParameterDef() throws ParseException {Token startToken;
  String name;
  iexpr defaultExpr = null;
    jj_consume_token(NAME);
startToken = token; name = token.image;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      defaultExpr = expression();
      break;
      }
    default:
      jj_la1[88] = jj_gen;
      ;
    }
{if ("" != null) return new Arg(name, defaultExpr, null, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

// Sister function of parameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public Arguments lambdaParameters() throws ParseException {ArrayList<Arg> posOnlyArgs = new ArrayList<Arg>();
  ArrayList<Arg> args = new ArrayList<Arg>();
  // Contains the defaults for posOnlyArgs and args.
  ArrayList<iexpr> defaults = new ArrayList<iexpr>();
  BoxedObject<Arg> varArg = new BoxedObject<Arg>(null);
  ArrayList<Arg> kwOnlyArgs = new ArrayList<Arg>();
  // Contains the defaults for kwOnlyArgs. If such an
  // argument has no default, null is added instead.
  ArrayList<iexpr> kwDefaults = new ArrayList<iexpr>();
  BoxedObject<Arg> kwArg = new BoxedObject<Arg>(null);

  boolean defaultRequired = false;
  ArrayList<Arg> tmpArgs = new ArrayList<Arg>();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      defaultRequired = lambdaPositionalParameters(defaultRequired, args, defaults);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DIV:{
          jj_consume_token(DIV);
posOnlyArgs = args; args = new ArrayList<Arg>();
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case NAME:{
              lambdaPositionalParameters(defaultRequired, args, defaults);
              switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
              case COMMA:{
                jj_consume_token(COMMA);
                switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
                case STAR:{
                  lambdaStarAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
                  break;
                  }
                case DOUBLE_STAR:{
                  kwArg.object = lambdaDoubleStarParameters();
                  break;
                  }
                default:
                  jj_la1[89] = jj_gen;

                }
                break;
                }
              default:
                jj_la1[90] = jj_gen;
                ;
              }
              break;
              }
            case STAR:{
              lambdaStarAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
              break;
              }
            case DOUBLE_STAR:{
              kwArg.object = lambdaDoubleStarParameters();
              break;
              }
            default:
              jj_la1[91] = jj_gen;

            }
            break;
            }
          default:
            jj_la1[92] = jj_gen;
            ;
          }
          break;
          }
        case STAR:{
          lambdaStarAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
          break;
          }
        case DOUBLE_STAR:{
          kwArg.object = lambdaDoubleStarParameters();
          break;
          }
        default:
          jj_la1[93] = jj_gen;

        }
        break;
        }
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      break;
      }
    case STAR:{
      lambdaStarAndFollowingParameters(varArg, kwOnlyArgs, kwDefaults, kwArg);
      break;
      }
    case DOUBLE_STAR:{
      kwArg.object = lambdaDoubleStarParameters();
      break;
      }
    default:
      jj_la1[95] = jj_gen;

    }
{if ("" != null) return new Arguments(posOnlyArgs, args, varArg.object, kwOnlyArgs,
     kwDefaults, kwArg.object, defaults);}
    throw new Error("Missing return statement in function");
}

// Sister function of starAndFollowingParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public void lambdaStarAndFollowingParameters(BoxedObject<Arg> varArg,
                                      ArrayList<Arg> kwOnlyArgs,
                                      ArrayList<iexpr> kwDefaults,
                                      BoxedObject<Arg> kwArg) throws ParseException {
    jj_consume_token(STAR);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      varArg.object = lambdaFunctionParameterDef();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NAME:{
          lambdaKwOnlyParameters(kwOnlyArgs, kwDefaults);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COMMA:{
            jj_consume_token(COMMA);
            switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
            case DOUBLE_STAR:{
              kwArg.object = lambdaDoubleStarParameters();
              break;
              }
            default:
              jj_la1[96] = jj_gen;
              ;
            }
            break;
            }
          default:
            jj_la1[97] = jj_gen;
            ;
          }
          break;
          }
        case DOUBLE_STAR:{
          kwArg.object = lambdaDoubleStarParameters();
          break;
          }
        default:
          jj_la1[98] = jj_gen;

        }
        break;
        }
      default:
        jj_la1[99] = jj_gen;
        ;
      }
      break;
      }
    case COMMA:{
      jj_consume_token(COMMA);
      lambdaKwOnlyParameters(kwOnlyArgs, kwDefaults);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case DOUBLE_STAR:{
          kwArg.object = lambdaDoubleStarParameters();
          break;
          }
        default:
          jj_la1[100] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[101] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

// Sister function of doubleStarParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public Arg lambdaDoubleStarParameters() throws ParseException {Arg kwArg;
    jj_consume_token(DOUBLE_STAR);
    kwArg = lambdaFunctionParameterDef();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[103] = jj_gen;
      ;
    }
{if ("" != null) return kwArg;}
    throw new Error("Missing return statement in function");
}

// Sister function of positionalParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public boolean lambdaPositionalParameters(boolean initialDefaultRequired,
                                   ArrayList<Arg> params, ArrayList<iexpr> defaults) throws ParseException {Arg param;
  iexpr defaultExpr;
  boolean defaultRequired = initialDefaultRequired;
    param = lambdaFunctionParameterDef();
params.add(param);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      defaultExpr = expression();
defaults.add(defaultExpr); defaultRequired = true;
      break;
      }
    default:
      jj_la1[104] = jj_gen;
if (defaultRequired) { {if (true) throw new ParseException("TODO");} }
    }
    label_22:
    while (true) {
      if (jj_2_13(2)) {
        ;
      } else {
        break label_22;
      }
      jj_consume_token(COMMA);
      param = lambdaFunctionParameterDef();
params.add(param);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSIGN:{
        jj_consume_token(ASSIGN);
        defaultExpr = expression();
defaults.add(defaultExpr); defaultRequired = true;
        break;
        }
      default:
        jj_la1[105] = jj_gen;
if (defaultRequired) { {if (true) throw new ParseException("TODO");} }
      }
    }
{if ("" != null) return defaultRequired;}
    throw new Error("Missing return statement in function");
}

// Sister function of kwOnlyParameters.
// Only difference that type annotations and type comment are not allowed in this
// version. Changes made here should also be done in the sister function.
  final public void lambdaKwOnlyParameters(ArrayList<Arg> params, ArrayList<iexpr> defaults) throws ParseException {Arg param;
  iexpr defaultExpr;
    param = lambdaFunctionParameterDef();
params.add(param);
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
      defaultExpr = expression();
defaults.add(defaultExpr);
      break;
      }
    default:
      jj_la1[106] = jj_gen;
defaults.add(null);
    }
    label_23:
    while (true) {
      if (jj_2_14(2)) {
        ;
      } else {
        break label_23;
      }
      jj_consume_token(COMMA);
      param = lambdaFunctionParameterDef();
params.add(param);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSIGN:{
        jj_consume_token(ASSIGN);
        defaultExpr = expression();
defaults.add(defaultExpr);
        break;
        }
      default:
        jj_la1[107] = jj_gen;
defaults.add(null);
      }
    }
}

  final public Arg lambdaFunctionParameterDef() throws ParseException {Token startToken;
  String name;
    jj_consume_token(NAME);
startToken = token; name = token.image;
{if ("" != null) return new Arg(name, null, (String)null, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public If ifStatement() throws ParseException {Token startToken;
  iexpr testExpr;
  ArrayList<istmt> blockStmts;
  ArrayList<istmt> elseStmts;
    jj_consume_token(IF);
startToken = token;
    testExpr = namedExpression();
    jj_consume_token(COLON);
    blockStmts = block();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELIF:{
      elseStmts = elifBlock();
      break;
      }
    case ELSE:{
      elseStmts = elseBlock();
      break;
      }
    default:
      jj_la1[108] = jj_gen;
elseStmts = new ArrayList<istmt>();
    }
{if ("" != null) return new If(testExpr, blockStmts, elseStmts, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

// Returns a list with one If statement to ease usage of this rule.
  final public ArrayList<istmt> elifBlock() throws ParseException {Token startToken;
  iexpr testExpr;
  ArrayList<istmt> blockStmts;
  ArrayList<istmt> elseStmts;
    jj_consume_token(ELIF);
startToken = token;
    testExpr = namedExpression();
    jj_consume_token(COLON);
    blockStmts = block();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELIF:{
      elseStmts = elifBlock();
      break;
      }
    case ELSE:{
      elseStmts = elseBlock();
      break;
      }
    default:
      jj_la1[109] = jj_gen;
elseStmts = new ArrayList<istmt>();
    }
ArrayList<istmt> stmts = new ArrayList<istmt>();
    stmts.add(new If(testExpr, blockStmts, elseStmts, attributes(startToken, token)));
    {if ("" != null) return stmts;}
    throw new Error("Missing return statement in function");
}

  final public ArrayList<istmt> elseBlock() throws ParseException {ArrayList<istmt> stmts;
    jj_consume_token(ELSE);
    jj_consume_token(COLON);
    stmts = block();
{if ("" != null) return stmts;}
    throw new Error("Missing return statement in function");
}

  final public ClassDef classDef(ArrayList<iexpr> decorators) throws ParseException {Token startToken;
  String name;
  ArrayList<iexpr> bases = new ArrayList<iexpr>();
  ArrayList<Keyword> keywords = new ArrayList<Keyword>();
  ArrayList<itypeParam> typeParams = new ArrayList<>();
  ArrayList<istmt> blockStmts;
    jj_consume_token(CLASS);
startToken = token;
    jj_consume_token(NAME);
name = token.image;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case SQUARE_OPEN:{
      typeParams(typeParams);
      break;
      }
    default:
      jj_la1[110] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PAREN_OPEN:{
      jj_consume_token(PAREN_OPEN);
      arguments(bases, keywords);
      jj_consume_token(PAREN_CLOSE);
      break;
      }
    default:
      jj_la1[111] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    blockStmts = block();
{if ("" != null) return new ClassDef(name, bases, keywords, blockStmts, decorators, typeParams,
     attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public ArrayList<iexpr> decorators() throws ParseException {iexpr namedExpression;
  ArrayList<iexpr> decoratorExpressions = new ArrayList<iexpr>();
    label_24:
    while (true) {
      jj_consume_token(AT);
      namedExpression = namedExpression();
decoratorExpressions.add(namedExpression);
      jj_consume_token(NEWLINE);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:{
        ;
        break;
        }
      default:
        jj_la1[112] = jj_gen;
        break label_24;
      }
    }
{if ("" != null) return decoratorExpressions;}
    throw new Error("Missing return statement in function");
}

  final public istmt forStatement(boolean isAsync, Token asyncToken) throws ParseException {Token startToken = asyncToken;
  iexpr target;
  iexpr iter;
  ArrayList<istmt> blockStmts;
  ArrayList<istmt> elseStmts;
    jj_consume_token(FOR);
if (!isAsync) {startToken = token;}
    target = starTargets();
    jj_consume_token(IN);
    iter = starExpressions();
    jj_consume_token(COLON);
    blockStmts = block();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELSE:{
      elseStmts = elseBlock();
      break;
      }
    default:
      jj_la1[113] = jj_gen;
elseStmts = new ArrayList<istmt>();
    }
if (isAsync) {
      {if ("" != null) return new AsyncFor(target, iter, blockStmts, elseStmts, null, attributes(startToken, token));}
    } else {
      {if ("" != null) return new For(target, iter, blockStmts, elseStmts, null, attributes(startToken, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public istmt withStatement(boolean isAsync, Token asyncToken) throws ParseException {Token startToken = asyncToken;
  ArrayList<Withitem> items;
  ArrayList<istmt> blockStmts;
    jj_consume_token(WITH);
if (!isAsync) {startToken = token;}
    if (jj_2_15(2)) {
      jj_consume_token(PAREN_OPEN);
      items = withItems();
      jj_consume_token(PAREN_CLOSE);
    } else {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        items = withItems();
        break;
        }
      default:
        jj_la1[114] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(COLON);
    blockStmts = block();
if (isAsync) {
      {if ("" != null) return new AsyncWith(items, blockStmts, null, attributes(startToken, token));}
    } else {
      {if ("" != null) return new With(items, blockStmts, null, attributes(startToken, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public ArrayList<Withitem> withItems() throws ParseException {ArrayList<Withitem> items = new ArrayList<Withitem>();
  Withitem item;
    item = withItem();
items.add(item);
    label_25:
    while (true) {
      if (jj_2_16(2)) {
        ;
      } else {
        break label_25;
      }
      jj_consume_token(COMMA);
      item = withItem();
items.add(item);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[115] = jj_gen;
      ;
    }
{if ("" != null) return items;}
    throw new Error("Missing return statement in function");
}

  final public Withitem withItem() throws ParseException {iexpr contextExpr;
  iexpr optionalVars = null;
    contextExpr = expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case AS:{
      jj_consume_token(AS);
      optionalVars = starTarget();
      break;
      }
    default:
      jj_la1[116] = jj_gen;
      ;
    }
{if ("" != null) return new Withitem(contextExpr, optionalVars);}
    throw new Error("Missing return statement in function");
}

  final public Try tryStatement() throws ParseException {Token startToken;
  ArrayList<istmt> blockStmts;
  ExceptHandler exceptHandler;
  ArrayList<ExceptHandler> exceptHandlers = new ArrayList<ExceptHandler>();
  ArrayList<istmt> elseStmts;
  ArrayList<istmt> finallyStmts;
    jj_consume_token(TRY);
startToken = token;
    jj_consume_token(COLON);
    blockStmts = block();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FINALLY:{
      finallyStmts = finallyBlock();
{if ("" != null) return new Try(blockStmts, exceptHandlers, new ArrayList<istmt>(), finallyStmts,
     attributes(startToken, token));}
      break;
      }
    case EXCEPT:{
      label_26:
      while (true) {
        exceptHandler = exceptBlock();
exceptHandlers.add(exceptHandler);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case EXCEPT:{
          ;
          break;
          }
        default:
          jj_la1[117] = jj_gen;
          break label_26;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ELSE:{
        elseStmts = elseBlock();
        break;
        }
      default:
        jj_la1[118] = jj_gen;
elseStmts = new ArrayList<istmt>();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case FINALLY:{
        finallyStmts = finallyBlock();
        break;
        }
      default:
        jj_la1[119] = jj_gen;
finallyStmts = new ArrayList<istmt>();
      }
{if ("" != null) return new Try(blockStmts, exceptHandlers, elseStmts, finallyStmts,
       attributes(startToken, token));}
      break;
      }
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public ExceptHandler exceptBlock() throws ParseException {Token startToken;
  iexpr typeExpr = null;
  String name = null;
  ArrayList<istmt> blockStmts;
    jj_consume_token(EXCEPT);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      typeExpr = expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AS:
      case COMMA:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case AS:{
          jj_consume_token(AS);
          break;
          }
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[121] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        jj_consume_token(NAME);
name = token.image;
        break;
        }
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[123] = jj_gen;
      ;
    }
    jj_consume_token(COLON);
    blockStmts = block();
{if ("" != null) return new ExceptHandler(typeExpr, name, blockStmts, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public ArrayList<istmt> finallyBlock() throws ParseException {ArrayList<istmt> blockStmts;
    jj_consume_token(FINALLY);
    jj_consume_token(COLON);
    blockStmts = block();
{if ("" != null) return blockStmts;}
    throw new Error("Missing return statement in function");
}

  final public While whileStatement() throws ParseException {Token startToken;
  iexpr testExpr;
  ArrayList<istmt> blockStmts;
  ArrayList<istmt> elseStmts;
    jj_consume_token(WHILE);
startToken = token;
    testExpr = namedExpression();
    jj_consume_token(COLON);
    blockStmts = block();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ELSE:{
      elseStmts = elseBlock();
      break;
      }
    default:
      jj_la1[124] = jj_gen;
elseStmts = new ArrayList<istmt>();
    }
{if ("" != null) return new While(testExpr, blockStmts, elseStmts, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public ArrayList<istmt> block() throws ParseException {ArrayList<istmt> stmts;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NEWLINE:{
      jj_consume_token(NEWLINE);
      jj_consume_token(INDENT);
      stmts = statementsAndDedentOrEof();
      break;
      }
    case NOT:
    case LAMBDA:
    case RETURN:
    case IMPORT:
    case FROM:
    case RAISE:
    case PASS:
    case DEL:
    case YIELD:
    case ASSERT:
    case BREAK:
    case CONTINUE:
    case GLOBAL:
    case NONLOCAL:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      stmts = simpleStatement();
      break;
      }
    default:
      jj_la1[125] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return stmts;}
    throw new Error("Missing return statement in function");
}

  final public istmt assignmentOrExpr() throws ParseException {iexpr targetExpr;
  iexpr expr = null;
  iexpr valueExpr = null;
  iexpr annotationExpr = null;
  boolean isSimple = false;
  ArrayList<iexpr> targets;
  ioperator op;
    targetExpr = starExpressions();
isSimple = token.kind == NAME;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      annotationExpr = expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSIGN:{
        jj_consume_token(ASSIGN);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case YIELD:{
          valueExpr = yieldExpression();
          break;
          }
        case NOT:
        case LAMBDA:
        case AWAIT:
        case NONE:
        case TRUE:
        case FALSE:
        case ELLIPSIS:
        case PLUS:
        case MINUS:
        case INVERT:
        case PAREN_OPEN:
        case SQUARE_OPEN:
        case CURLY_OPEN:
        case STAR:
        case DEC_INTEGER:
        case BIN_INTEGER:
        case OCT_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case IMAGINARY:
        case NAME:
        case STRING_PREFIX:
        case FORMAT_STRING_PREFIX:
        case STRING_QUOTE_OPEN:{
          valueExpr = starExpressions();
          break;
          }
        default:
          jj_la1[126] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
        }
      default:
        jj_la1[127] = jj_gen;
        ;
      }
{if ("" != null) return new AnnAssign(targetExpr, annotationExpr, valueExpr, isSimple,
         attributes(targetExpr, token));}
      break;
      }
    case PLUS_ASSIGN:
    case MINUS_ASSIGN:
    case STAR_ASSIGN:
    case AT_ASSIGN:
    case DIV_ASSIGN:
    case MOD_ASSIGN:
    case BIT_AND_ASSIGN:
    case BIT_OR_ASSIGN:
    case BIT_XOR_ASSIGN:
    case LSHIFT_ASSIGN:
    case RSHIFT_ASSIGN:
    case POW_ASSIGN:
    case FLOOR_DIV_ASSIGN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS_ASSIGN:{
        jj_consume_token(PLUS_ASSIGN);
op = Add$.MODULE$;
        break;
        }
      case MINUS_ASSIGN:{
        jj_consume_token(MINUS_ASSIGN);
op = Sub$.MODULE$;
        break;
        }
      case STAR_ASSIGN:{
        jj_consume_token(STAR_ASSIGN);
op = Mult$.MODULE$;
        break;
        }
      case AT_ASSIGN:{
        jj_consume_token(AT_ASSIGN);
op = MatMult$.MODULE$;
        break;
        }
      case DIV_ASSIGN:{
        jj_consume_token(DIV_ASSIGN);
op = Div$.MODULE$;
        break;
        }
      case MOD_ASSIGN:{
        jj_consume_token(MOD_ASSIGN);
op = Mod$.MODULE$;
        break;
        }
      case BIT_AND_ASSIGN:{
        jj_consume_token(BIT_AND_ASSIGN);
op = BitAnd$.MODULE$;
        break;
        }
      case BIT_OR_ASSIGN:{
        jj_consume_token(BIT_OR_ASSIGN);
op = BitOr$.MODULE$;
        break;
        }
      case BIT_XOR_ASSIGN:{
        jj_consume_token(BIT_XOR_ASSIGN);
op = BitXor$.MODULE$;
        break;
        }
      case LSHIFT_ASSIGN:{
        jj_consume_token(LSHIFT_ASSIGN);
op = LShift$.MODULE$;
        break;
        }
      case RSHIFT_ASSIGN:{
        jj_consume_token(RSHIFT_ASSIGN);
op = RShift$.MODULE$;
        break;
        }
      case POW_ASSIGN:{
        jj_consume_token(POW_ASSIGN);
op = Pow$.MODULE$;
        break;
        }
      case FLOOR_DIV_ASSIGN:{
        jj_consume_token(FLOOR_DIV_ASSIGN);
op = FloorDiv$.MODULE$;
        break;
        }
      default:
        jj_la1[128] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case YIELD:{
        valueExpr = yieldExpression();
        break;
        }
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case STAR:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        valueExpr = starExpressions();
        break;
        }
      default:
        jj_la1[129] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return new AugAssign(targetExpr, op, valueExpr, attributes(targetExpr, token));}
      break;
      }
    case ASSIGN:{
targets = new ArrayList<iexpr>();
        targets.add(targetExpr);
      label_27:
      while (true) {
        jj_consume_token(ASSIGN);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case YIELD:{
          expr = yieldExpression();
          break;
          }
        case NOT:
        case LAMBDA:
        case AWAIT:
        case NONE:
        case TRUE:
        case FALSE:
        case ELLIPSIS:
        case PLUS:
        case MINUS:
        case INVERT:
        case PAREN_OPEN:
        case SQUARE_OPEN:
        case CURLY_OPEN:
        case STAR:
        case DEC_INTEGER:
        case BIN_INTEGER:
        case OCT_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case IMAGINARY:
        case NAME:
        case STRING_PREFIX:
        case FORMAT_STRING_PREFIX:
        case STRING_QUOTE_OPEN:{
          expr = starExpressions();
          break;
          }
        default:
          jj_la1[130] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
targets.add(expr);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case ASSIGN:{
          ;
          break;
          }
        default:
          jj_la1[131] = jj_gen;
          break label_27;
        }
      }
valueExpr = targets.remove(targets.size() - 1);
        {if ("" != null) return new Assign(targets, valueExpr, attributes(targetExpr, token));}
      break;
      }
    default:
      jj_la1[132] = jj_gen;
{if ("" != null) return new Expr(targetExpr);}
    }
    throw new Error("Missing return statement in function");
}

// Returns the expression list elements as tuple or
// a single express if the expression list contains only
// one element and does not end with a comma.
  final public iexpr expressionsAsTuple() throws ParseException {iexpr firstExpression;
  iexpr expression;
  ArrayList<iexpr> expressions = new ArrayList<iexpr>();
    firstExpression = expression();
expressions.add(firstExpression);
    label_28:
    while (true) {
      if (jj_2_17(2)) {
        ;
      } else {
        break label_28;
      }
      jj_consume_token(COMMA);
      expression = expression();
expressions.add(expression);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[133] = jj_gen;
      ;
    }
if (token.kind != COMMA && expressions.size() == 1) {
      {if ("" != null) return expressions.get(0);}
    } else {
      {if ("" != null) return new Tuple(expressions, attributes(firstExpression, token));}
    }
    throw new Error("Missing return statement in function");
}

// Returns a tuple for multiple expressions and single expression with trailing comma.
// Otherwise returns the single expression.
// Grammar: (expression | starredBitwiseOr) ("," expression | starredBitwiseOr)* [","]
  final public iexpr starExpressions() throws ParseException {iexpr firstExpression;
  iexpr expression;
  ArrayList<iexpr> expressions = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      firstExpression = expression();
      break;
      }
    case STAR:{
      firstExpression = starredBitwiseOr();
      break;
      }
    default:
      jj_la1[134] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_29:
    while (true) {
      if (jj_2_18(2)) {
        ;
      } else {
        break label_29;
      }
      jj_consume_token(COMMA);
if (expressions == null) {
        expressions = new ArrayList<iexpr>();
        expressions.add(firstExpression);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        expression = expression();
        break;
        }
      case STAR:{
        expression = starredBitwiseOr();
        break;
        }
      default:
        jj_la1[135] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
expressions.add(expression);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[136] = jj_gen;
      ;
    }
if (expressions == null && token.kind != COMMA) {
      // Single expression no trailing comma.
      {if ("" != null) return firstExpression;}
    }
    if (expressions == null) {
      // Single expression, trailing comma.
      expressions = new ArrayList<iexpr>();
      expressions.add(firstExpression);
    }
    {if ("" != null) return new Tuple(expressions, attributes(firstExpression, token));}
    throw new Error("Missing return statement in function");
}

// This method is the same as starExpressions except that instead of expression it
// expects conditionalExpression.
// Returns a tuple for multiple expressions and single expression with trailing comma.
// Otherwise returns the single expression.
// Grammar: (conditionalExpression | starredBitwiseOr) ("," conditionalExpression | starredBitwiseOr)* [","]
  final public iexpr starConditionalExpressions() throws ParseException {iexpr firstExpression;
  iexpr expression;
  ArrayList<iexpr> expressions = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      firstExpression = conditionalExpression();
      break;
      }
    case STAR:{
      firstExpression = starredBitwiseOr();
      break;
      }
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    label_30:
    while (true) {
      if (jj_2_19(2)) {
        ;
      } else {
        break label_30;
      }
      jj_consume_token(COMMA);
if (expressions == null) {
        expressions = new ArrayList<iexpr>();
        expressions.add(firstExpression);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        expression = conditionalExpression();
        break;
        }
      case STAR:{
        expression = starredBitwiseOr();
        break;
        }
      default:
        jj_la1[138] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
expressions.add(expression);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[139] = jj_gen;
      ;
    }
if (expressions == null && token.kind != COMMA) {
      // Single expression no trailing comma.
      {if ("" != null) return firstExpression;}
    }
    if (expressions == null) {
      // Single expression, trailing comma.
      expressions = new ArrayList<iexpr>();
      expressions.add(firstExpression);
    }
    {if ("" != null) return new Tuple(expressions, attributes(firstExpression, token));}
    throw new Error("Missing return statement in function");
}

  final public iexpr yieldExpression() throws ParseException {Token startToken;
  iexpr valueExpr = null;
    jj_consume_token(YIELD);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case FROM:{
      jj_consume_token(FROM);
      valueExpr = expression();
{if ("" != null) return new YieldFrom(valueExpr, attributes(startToken, token));}
      break;
      }
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      valueExpr = starExpressions();
{if ("" != null) return new Yield(valueExpr, attributes(startToken, token));}
      break;
      }
    default:
      jj_la1[140] = jj_gen;
{if ("" != null) return new Yield((iexpr)null, attributes(startToken, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr namedExpression() throws ParseException {iexpr expression;
  iexpr value;
    expression = expression();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON_ASSIGN:{
      jj_consume_token(COLON_ASSIGN);
      value = expression();
// To only accept valid code we would need to check that expression is
    // a NAME at this point. But since we want to work on best effort basis
    // we just dont check.
    expression = new NamedExpr(expression, value, attributes(expression, token));
      break;
      }
    default:
      jj_la1[141] = jj_gen;
      ;
    }
{if ("" != null) return expression;};
    throw new Error("Missing return statement in function");
}

  final public iexpr expression() throws ParseException {iexpr expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expression = conditionalExpression();
      break;
      }
    case LAMBDA:{
      expression = lambda();
      break;
      }
    default:
      jj_la1[142] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
}

  final public iexpr conditionalExpression() throws ParseException {iexpr expression;
  iexpr testExpression = null;
  iexpr elseExpression = null;
    expression = disjunction();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case IF:{
      jj_consume_token(IF);
      testExpression = disjunction();
      jj_consume_token(ELSE);
      elseExpression = expression();
      break;
      }
    default:
      jj_la1[143] = jj_gen;
      ;
    }
if (testExpression != null) {
      {if ("" != null) return new IfExp(testExpression, expression, elseExpression, attributes(expression, token));}
    }
    {if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
}

  final public iexpr lambda() throws ParseException {Token startToken;
  Arguments parameters;
  iexpr body;
    jj_consume_token(LAMBDA);
startToken = token;
    parameters = lambdaParameters();
    jj_consume_token(COLON);
    body = expression();
{if ("" != null) return new Lambda(parameters, body, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public iexpr disjunction() throws ParseException {iexpr expression;
  iexpr nextExpression;
  ArrayList<iexpr> allExpressions = null;
    expression = conjunction();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case OR:{
        ;
        break;
        }
      default:
        jj_la1[144] = jj_gen;
        break label_31;
      }
      jj_consume_token(OR);
      nextExpression = conjunction();
if (allExpressions == null) {
      allExpressions = new ArrayList<iexpr>();
      allExpressions.add(expression);
    }
    allExpressions.add(nextExpression);
    }
if (allExpressions != null) {
      {if ("" != null) return new BoolOp(Or$.MODULE$, allExpressions, attributes(expression, token));}
    } else {
      {if ("" != null) return expression;}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr conjunction() throws ParseException {iexpr expression;
  iexpr nextExpression;
  ArrayList<iexpr> allExpressions = null;
    expression = inversion();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AND:{
        ;
        break;
        }
      default:
        jj_la1[145] = jj_gen;
        break label_32;
      }
      jj_consume_token(AND);
      nextExpression = inversion();
if (allExpressions == null) {
      allExpressions = new ArrayList<iexpr>();
      allExpressions.add(expression);
    }
    allExpressions.add(nextExpression);
    }
if (allExpressions != null) {
      {if ("" != null) return new BoolOp(And$.MODULE$, allExpressions, attributes(expression, token));}
    } else {
      {if ("" != null) return expression;}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr inversion() throws ParseException {iexpr expression;
  Token startToken;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:{
      jj_consume_token(NOT);
startToken = token;
      expression = inversion();
{if ("" != null) return new UnaryOp(Not$.MODULE$, expression, attributes(startToken, token));}
      break;
      }
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expression = comparison();
{if ("" != null) return expression;}
      break;
      }
    default:
      jj_la1[146] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr comparison() throws ParseException {iexpr expression;
  iexpr nextExpression = null;
  icompop op;
  boolean isNot = false;
  ArrayList<icompop> operators = null;
  ArrayList<iexpr> comparators = null;
    expression = bitwiseOr();
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case EQ:
      case NEQ:
      case LT:
      case LTE:
      case GT:
      case GTE:
      case IS:
      case IN:{
        ;
        break;
        }
      default:
        jj_la1[147] = jj_gen;
        break label_33;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case EQ:{
        jj_consume_token(EQ);
op = Eq$.MODULE$;
        break;
        }
      case NEQ:{
        jj_consume_token(NEQ);
op = NotEq$.MODULE$;
        break;
        }
      case LT:{
        jj_consume_token(LT);
op = Lt$.MODULE$;
        break;
        }
      case LTE:{
        jj_consume_token(LTE);
op = LtE$.MODULE$;
        break;
        }
      case GT:{
        jj_consume_token(GT);
op = Gt$.MODULE$;
        break;
        }
      case GTE:{
        jj_consume_token(GTE);
op = GtE$.MODULE$;
        break;
        }
      case IS:{
        jj_consume_token(IS);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NOT:{
          jj_consume_token(NOT);
isNot = true;
          break;
          }
        default:
          jj_la1[148] = jj_gen;
          ;
        }
op = isNot ? IsNot$.MODULE$:Is$.MODULE$;
        break;
        }
      case IN:{
        jj_consume_token(IN);
op = In$.MODULE$;
        break;
        }
      case NOT:{
        jj_consume_token(NOT);
        jj_consume_token(IN);
op = NotIn$.MODULE$;
        break;
        }
      default:
        jj_la1[149] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      nextExpression = bitwiseOr();
if (operators == null) {
      operators = new ArrayList<icompop>();
    }
    operators.add(op);

    if (comparators == null) {
      comparators = new ArrayList<iexpr>();
    }
    comparators.add(nextExpression);
    }
if (nextExpression != null) {
      {if ("" != null) return new Compare(expression, operators, comparators, attributes(expression, token));}
    } else {
      {if ("" != null) return expression;}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr bitwiseOr() throws ParseException {iexpr expression;
  iexpr nextExpression;
    expression = bitwiseXor();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_OR:{
        ;
        break;
        }
      default:
        jj_la1[150] = jj_gen;
        break label_34;
      }
      jj_consume_token(BIT_OR);
      nextExpression = bitwiseXor();
expression =
        new BinOp(expression, BitOr$.MODULE$, nextExpression, attributes(expression, token));
    }
{if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
}

  final public iexpr bitwiseXor() throws ParseException {iexpr expression;
  iexpr nextExpression;
    expression = bitwiseAnd();
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_XOR:{
        ;
        break;
        }
      default:
        jj_la1[151] = jj_gen;
        break label_35;
      }
      jj_consume_token(BIT_XOR);
      nextExpression = bitwiseAnd();
expression =
        new BinOp(expression, BitXor$.MODULE$, nextExpression, attributes(expression, token));
    }
{if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
}

  final public iexpr bitwiseAnd() throws ParseException {iexpr expression;
  iexpr nextExpression;
    expression = shiftExpr();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case BIT_AND:{
        ;
        break;
        }
      default:
        jj_la1[152] = jj_gen;
        break label_36;
      }
      jj_consume_token(BIT_AND);
      nextExpression = shiftExpr();
expression =
        new BinOp(expression, BitAnd$.MODULE$, nextExpression, attributes(expression, token));
    }
{if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
}

  final public iexpr shiftExpr() throws ParseException {iexpr expr;
  iexpr nextExpr;
  ioperator op;
    expr = sum();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSHIFT:
      case RSHIFT:{
        ;
        break;
        }
      default:
        jj_la1[153] = jj_gen;
        break label_37;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case LSHIFT:{
        jj_consume_token(LSHIFT);
op = LShift$.MODULE$;
        break;
        }
      case RSHIFT:{
        jj_consume_token(RSHIFT);
op = RShift$.MODULE$;
        break;
        }
      default:
        jj_la1[154] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      nextExpr = sum();
expr = new BinOp(expr, op, nextExpr, attributes(expr, token));
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public iexpr sum() throws ParseException {iexpr expr;
  iexpr nextExpr;
  ioperator op;
    expr = term();
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:
      case MINUS:{
        ;
        break;
        }
      default:
        jj_la1[155] = jj_gen;
        break label_38;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = Add$.MODULE$;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = Sub$.MODULE$;
        break;
        }
      default:
        jj_la1[156] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      nextExpr = term();
expr = new BinOp(expr, op, nextExpr, attributes(expr, token));
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public iexpr term() throws ParseException {iexpr expr;
  iexpr nextExpr;
  ioperator op;
    expr = factor();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case AT:
      case DIV:
      case FLOOR_DIV:
      case MOD:
      case STAR:{
        ;
        break;
        }
      default:
        jj_la1[157] = jj_gen;
        break label_39;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STAR:{
        jj_consume_token(STAR);
op = Mult$.MODULE$;
        break;
        }
      case DIV:{
        jj_consume_token(DIV);
op = Div$.MODULE$;
        break;
        }
      case FLOOR_DIV:{
        jj_consume_token(FLOOR_DIV);
op = FloorDiv$.MODULE$;
        break;
        }
      case MOD:{
        jj_consume_token(MOD);
op = Mod$.MODULE$;
        break;
        }
      case AT:{
        jj_consume_token(AT);
op = MatMult$.MODULE$;
        break;
        }
      default:
        jj_la1[158] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      nextExpr = factor();
expr = new BinOp(expr, op, nextExpr, attributes(expr, token));
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public iexpr factor() throws ParseException {Token startToken;
  iexpr expr;
  iunaryop op;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case PLUS:
    case MINUS:
    case INVERT:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PLUS:{
        jj_consume_token(PLUS);
op = UAdd$.MODULE$;
        break;
        }
      case MINUS:{
        jj_consume_token(MINUS);
op = USub$.MODULE$;
        break;
        }
      case INVERT:{
        jj_consume_token(INVERT);
op = Invert$.MODULE$;
        break;
        }
      default:
        jj_la1[159] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
startToken = token;
      expr = factor();
expr = new UnaryOp(op, expr, attributes(startToken, token));
      break;
      }
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expr = power();
      break;
      }
    default:
      jj_la1[160] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public iexpr power() throws ParseException {iexpr expr;
  iexpr exponentExpr;
    expr = awaitPrimary();
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DOUBLE_STAR:{
      jj_consume_token(DOUBLE_STAR);
      exponentExpr = factor();
expr = new BinOp(expr, Pow$.MODULE$, exponentExpr, attributes(expr, token));
      break;
      }
    default:
      jj_la1[161] = jj_gen;
      ;
    }
{if ("" != null) return expr;}
    throw new Error("Missing return statement in function");
}

  final public iexpr awaitPrimary() throws ParseException {iexpr expr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expr = primary();
{if ("" != null) return expr;}
      break;
      }
    case AWAIT:{
      jj_consume_token(AWAIT);
      expr = primary();
{if ("" != null) return new Await(expr);}
      break;
      }
    default:
      jj_la1[162] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr primary() throws ParseException {iexpr expression;
  ArrayList<iexpr> posArgs;
  ArrayList<Keyword> keyArgs;
  iexpr sliceExpression;
    expression = atom();
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case DOT:{
        ;
        break;
        }
      default:
        jj_la1[163] = jj_gen;
        break label_40;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case PAREN_OPEN:{
        jj_consume_token(PAREN_OPEN);
posArgs = new ArrayList<iexpr>(); keyArgs = new ArrayList<Keyword>();
        arguments(posArgs, keyArgs);
        jj_consume_token(PAREN_CLOSE);
expression = new Call(expression, posArgs, keyArgs, attributes(expression, token));
        break;
        }
      case SQUARE_OPEN:{
        jj_consume_token(SQUARE_OPEN);
        sliceExpression = slices();
        jj_consume_token(SQUARE_CLOSE);
expression = new Subscript(expression, sliceExpression, attributes(expression, token));
        break;
        }
      case DOT:{
        jj_consume_token(DOT);
        jj_consume_token(NAME);
expression = new Attribute(expression, token.image, attributes(expression, token));
        break;
        }
      default:
        jj_la1[164] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
{if ("" != null) return expression;}
    throw new Error("Missing return statement in function");
}

// Does no sanity checks like only allowing one GeneratorExp argument or only allowing ** after
// positional arguments. For our purposes thats fine.
  final public void arguments(ArrayList<iexpr> positionalArgs, ArrayList<Keyword> keywordArgs) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DOUBLE_STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      argument(positionalArgs, keywordArgs);
      label_41:
      while (true) {
        if (jj_2_20(2)) {
          ;
        } else {
          break label_41;
        }
        jj_consume_token(COMMA);
        argument(positionalArgs, keywordArgs);
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COMMA:{
        jj_consume_token(COMMA);
        break;
        }
      default:
        jj_la1[165] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[166] = jj_gen;
      ;
    }
}

  final public void argument(ArrayList<iexpr> positionalArgs, ArrayList<Keyword> keywordArgs) throws ParseException {iexpr expression;
  iexpr valueExpression;
  Token startToken;
  ArrayList<Comprehension> comprehensions;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STAR:{
      expression = starredExpression();
positionalArgs.add(expression);
      break;
      }
    case DOUBLE_STAR:{
      jj_consume_token(DOUBLE_STAR);
startToken = token;
      expression = expression();
keywordArgs.add(new Keyword((String)null, expression, attributes(startToken, token)));
      break;
      }
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expression = expression();
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASSIGN:{
        jj_consume_token(ASSIGN);
        valueExpression = expression();
if (expression instanceof Name) {
          String keywordName = ((Name)expression).id();
          keywordArgs.add(new Keyword(keywordName, valueExpression, attributes(expression, token)));
        } else {
          {if (true) throw new ParseException("TODO");}
        }
        break;
        }
      case COLON_ASSIGN:{
        jj_consume_token(COLON_ASSIGN);
        valueExpression = expression();
positionalArgs.add(new NamedExpr(expression, valueExpression, attributes(expression, token)));
        break;
        }
      case ASYNC:
      case FOR:{
        comprehensions = forIfClauses();
positionalArgs.add(new GeneratorExp(expression, comprehensions, attributes(expression, token)));
        break;
        }
      default:
        jj_la1[167] = jj_gen;
positionalArgs.add(expression);
      }
      break;
      }
    default:
      jj_la1[168] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
}

  final public iexpr slices() throws ParseException {iexpr expression;
  iexpr nextExpression;
  ArrayList<iexpr> tupleExpressions = null;
    expression = slice();
    label_42:
    while (true) {
      if (jj_2_21(2)) {
        ;
      } else {
        break label_42;
      }
      jj_consume_token(COMMA);
      nextExpression = slice();
if (tupleExpressions == null) {
        tupleExpressions = new ArrayList<iexpr>();
        tupleExpressions.add(expression);
      }
      if (nextExpression != null) {
        tupleExpressions.add(nextExpression);
      }
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[169] = jj_gen;
      ;
    }
if (tupleExpressions != null) {
      {if ("" != null) return new Tuple(tupleExpressions, attributes(expression, token));}
    } else {
      {if ("" != null) return expression;}
    }
    throw new Error("Missing return statement in function");
}

// This rule matches any input in which case null is returned.
// We do this because the slice grammar cannot by properly handled
// by a ll(k) grammar.
  final public iexpr slice() throws ParseException {iexpr lower = null;
  iexpr upper = null;
  iexpr step = null;
  Token startToken = null;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      lower = expression();
      break;
      }
    default:
      jj_la1[170] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
startToken = token;
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        upper = expression();
        break;
        }
      default:
        jj_la1[171] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case COLON:{
        jj_consume_token(COLON);
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NOT:
        case LAMBDA:
        case AWAIT:
        case NONE:
        case TRUE:
        case FALSE:
        case ELLIPSIS:
        case PLUS:
        case MINUS:
        case INVERT:
        case PAREN_OPEN:
        case SQUARE_OPEN:
        case CURLY_OPEN:
        case DEC_INTEGER:
        case BIN_INTEGER:
        case OCT_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case IMAGINARY:
        case NAME:
        case STRING_PREFIX:
        case FORMAT_STRING_PREFIX:
        case STRING_QUOTE_OPEN:{
          step = expression();
          break;
          }
        default:
          jj_la1[172] = jj_gen;
          ;
        }
        break;
        }
      default:
        jj_la1[173] = jj_gen;
        ;
      }
      break;
      }
    default:
      jj_la1[174] = jj_gen;
      ;
    }
if (startToken != null) {
      if (lower != null) {
        {if ("" != null) return new Slice(lower, upper, step, attributes(lower, token));}
      } else {
        {if ("" != null) return new Slice(lower, upper, step, attributes(startToken, token));}
      }
    } else {
      {if ("" != null) return lower;}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr starredExpression() throws ParseException {iexpr value;
  Token startToken;
    jj_consume_token(STAR);
startToken = token;
    value = expression();
{if ("" != null) return new Starred(value, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public iexpr starredBitwiseOr() throws ParseException {iexpr value;
  Token startToken;
    jj_consume_token(STAR);
startToken = token;
    value = bitwiseOr();
{if ("" != null) return new Starred(value, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

  final public iexpr atom() throws ParseException {iexpr expression;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NAME:{
      jj_consume_token(NAME);
{if ("" != null) return new Name(token.image, attributes(token, token));}
      break;
      }
    case TRUE:{
      jj_consume_token(TRUE);
{if ("" != null) return new Constant(new BoolConstant(true), attributes(token, token));}
      break;
      }
    case FALSE:{
      jj_consume_token(FALSE);
{if ("" != null) return new Constant(new BoolConstant(false), attributes(token, token));}
      break;
      }
    case NONE:{
      jj_consume_token(NONE);
{if ("" != null) return new Constant(NoneConstant$.MODULE$, attributes(token, token));}
      break;
      }
    case ELLIPSIS:{
      jj_consume_token(ELLIPSIS);
{if ("" != null) return new Constant(EllipsisConstant$.MODULE$, attributes(token, token));}
      break;
      }
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:{
      expression = number();
{if ("" != null) return expression;}
      break;
      }
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expression = strings();
{if ("" != null) return expression;}
      break;
      }
    case SQUARE_OPEN:{
      expression = listOrListComprehension();
{if ("" != null) return expression;}
      break;
      }
    case PAREN_OPEN:{
      expression = tupleOrGeneratorExpOrGroup();
{if ("" != null) return expression;}
      break;
      }
    case CURLY_OPEN:{
      expression = setOrDictOrSetCompOrDictComp();
{if ("" != null) return expression;}
      break;
      }
    default:
      jj_la1[175] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public Constant number() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case DEC_INTEGER:{
        jj_consume_token(DEC_INTEGER);
        break;
        }
      case BIN_INTEGER:{
        jj_consume_token(BIN_INTEGER);
        break;
        }
      case OCT_INTEGER:{
        jj_consume_token(OCT_INTEGER);
        break;
        }
      case HEX_INTEGER:{
        jj_consume_token(HEX_INTEGER);
        break;
        }
      default:
        jj_la1[176] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
{if ("" != null) return new Constant(new IntConstant(token.image), attributes(token, token));}
      break;
      }
    case FLOAT:{
      jj_consume_token(FLOAT);
{if ("" != null) return new Constant(new FloatConstant(token.image), attributes(token, token));}
      break;
      }
    case IMAGINARY:{
      jj_consume_token(IMAGINARY);
{if ("" != null) return new Constant(new ImaginaryConstant(token.image), attributes(token, token));}
      break;
      }
    default:
      jj_la1[177] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr strings() throws ParseException {iexpr expr;
  ArrayList<iexpr> strings = null;
    expr = string();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        ;
        break;
        }
      default:
        jj_la1[178] = jj_gen;
        break label_43;
      }
if (strings == null) {
        strings = new ArrayList<iexpr>();
        strings.add(expr);
      }
      expr = string();
strings.add(expr);
    }
if (strings == null) {
      {if ("" != null) return expr;}
    } else {
      {if ("" != null) return new StringExpList(strings);}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr string() throws ParseException {Token startToken = null;
  Token formatStartToken;
  String prefix = "";
  String quote;
  String content;
  ArrayList<iexpr> values;
  FormattedValue formattedValue;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STRING_PREFIX:{
        jj_consume_token(STRING_PREFIX);
prefix = token.image; startToken = token;
        break;
        }
      default:
        jj_la1[179] = jj_gen;
        ;
      }
      jj_consume_token(STRING_QUOTE_OPEN);
quote = token.image; if (startToken == null) startToken = token;
      jj_consume_token(STRING_CONTENT);
content = token.image;
{if ("" != null) return new Constant(new StringConstant(content, quote, prefix),
    attributes(startToken, token));}
      break;
      }
    case FORMAT_STRING_PREFIX:{
      jj_consume_token(FORMAT_STRING_PREFIX);
prefix = token.image; formatStartToken = token; values = new ArrayList<iexpr>();
      jj_consume_token(FORMAT_STRING_QUOTE_OPEN);
quote = token.image;
      jj_consume_token(FORMAT_STRING_CONTENT);
if (!token.image.equals("")) {
        Constant constant = new Constant(new JoinedStringConstant(token.image), attributes(token, token));
        values.add(constant);
      }
      label_44:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case FORMAT_STRING_CURLY_OPEN:{
          ;
          break;
          }
        default:
          jj_la1[180] = jj_gen;
          break label_44;
        }
        formattedValue = replacementField();
values.add(formattedValue);
        jj_consume_token(FORMAT_STRING_CONTENT);
if (!token.image.equals("")) {
          Constant constant = new Constant(new JoinedStringConstant(token.image), attributes(token, token));
          values.add(constant);
        }
      }
      jj_consume_token(FORMAT_STRING_QUOTE_CLOSE);
{if ("" != null) return new JoinedString(values, quote, prefix, attributes(formatStartToken, token));}
      break;
      }
    default:
      jj_la1[181] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
}

  final public FormattedValue replacementField() throws ParseException {Token startToken;
  iexpr expression;
  boolean equalSign = false;
  int conversion = -1;
  String formatSpec = null;
    jj_consume_token(FORMAT_STRING_CURLY_OPEN);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      expression = starConditionalExpressions();
      break;
      }
    case YIELD:{
      expression = yieldExpression();
      break;
      }
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASSIGN:{
      jj_consume_token(ASSIGN);
equalSign = true;
      break;
      }
    default:
      jj_la1[183] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STR_CONVERSION:
    case REPR_CONVERSION:
    case ASCII_CONVERSION:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case STR_CONVERSION:{
        jj_consume_token(STR_CONVERSION);
conversion = 115;
        break;
        }
      case REPR_CONVERSION:{
        jj_consume_token(REPR_CONVERSION);
conversion = 114;
        break;
        }
      case ASCII_CONVERSION:{
        jj_consume_token(ASCII_CONVERSION);
conversion = 97;
        break;
        }
      default:
        jj_la1[184] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
      }
    default:
      jj_la1[185] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COLON:{
      jj_consume_token(COLON);
      jj_consume_token(FORMAT_SPEC);
formatSpec = token.image;
      break;
      }
    default:
      jj_la1[186] = jj_gen;
      ;
    }
    jj_consume_token(CURLY_CLOSE);
{if ("" != null) return new FormattedValue(expression, conversion, formatSpec, equalSign, attributes(startToken, token));}
    throw new Error("Missing return statement in function");
}

// Returns a tuple for multiple targets and single target with trailing comma.
// Otherwise returns the single target expression.
  final public iexpr starTargets() throws ParseException {ArrayList<iexpr> targets = null;
  iexpr firstTarget;
  iexpr target;
    firstTarget = starTarget();
    label_45:
    while (true) {
      if (jj_2_22(2)) {
        ;
      } else {
        break label_45;
      }
      jj_consume_token(COMMA);
if (targets == null) {
        targets = new ArrayList<iexpr>();
        targets.add(firstTarget);
      }
      target = starTarget();
targets.add(target);
    }
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case COMMA:{
      jj_consume_token(COMMA);
      break;
      }
    default:
      jj_la1[187] = jj_gen;
      ;
    }
if (targets == null && token.kind != COMMA) {
      // Single target no trailing comma.
      {if ("" != null) return firstTarget;}
    }
    if (targets == null) {
      // Single target, trailing comma.
      targets = new ArrayList<iexpr>();
      targets.add(firstTarget);
    }
    {if ("" != null) return new Tuple(targets, attributes(firstTarget, token));}
    throw new Error("Missing return statement in function");
}

// This is not as restrictive as the corresponding CPython 3.9 star_target rule
// because we except a primary as target which includes e.g. number literals
// which would be invalid Python code.
  final public iexpr starTarget() throws ParseException {boolean starred = false;
  Token startToken = null;
  iexpr targetExpr;
  iexpr baseExpr;
  iexpr sliceExpr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case STAR:{
      jj_consume_token(STAR);
starred = true; startToken = token;
      break;
      }
    default:
      jj_la1[188] = jj_gen;
      ;
    }
    targetExpr = primary();
if (starred) {
      {if ("" != null) return new Starred(targetExpr, attributes(startToken, token));}
    } else {
      {if ("" != null) return targetExpr;}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr listOrListComprehension() throws ParseException {Token startToken;
  iexpr expr = null;
  ArrayList<Comprehension> comprehensions = null;
  ArrayList<iexpr> expressions = null;
    jj_consume_token(SQUARE_OPEN);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        expr = namedExpression();
        break;
        }
      case STAR:{
        expr = starredBitwiseOr();
        break;
        }
      default:
        jj_la1[189] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASYNC:
      case FOR:{
        comprehensions = forIfClauses();
        break;
        }
      default:
        jj_la1[192] = jj_gen;
expressions = new ArrayList<iexpr>();
            expressions.add(expr);
        label_46:
        while (true) {
          if (jj_2_23(2)) {
            ;
          } else {
            break label_46;
          }
          jj_consume_token(COMMA);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NOT:
          case LAMBDA:
          case AWAIT:
          case NONE:
          case TRUE:
          case FALSE:
          case ELLIPSIS:
          case PLUS:
          case MINUS:
          case INVERT:
          case PAREN_OPEN:
          case SQUARE_OPEN:
          case CURLY_OPEN:
          case DEC_INTEGER:
          case BIN_INTEGER:
          case OCT_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case IMAGINARY:
          case NAME:
          case STRING_PREFIX:
          case FORMAT_STRING_PREFIX:
          case STRING_QUOTE_OPEN:{
            expr = namedExpression();
            break;
            }
          case STAR:{
            expr = starredBitwiseOr();
            break;
            }
          default:
            jj_la1[190] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
expressions.add(expr);
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[191] = jj_gen;
          ;
        }
      }
      break;
      }
    default:
      jj_la1[193] = jj_gen;
expressions = new ArrayList<iexpr>();
    }
    jj_consume_token(SQUARE_CLOSE);
if (comprehensions == null) {
      {if ("" != null) return new List(expressions, attributes(startToken, token));}
    } else {
      {if ("" != null) return new ListComp(expr, comprehensions, attributes(startToken, token));}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr tupleOrGeneratorExpOrGroup() throws ParseException {Token startToken;
  iexpr yieldExpr = null;
  iexpr expr = null;
  ArrayList<Comprehension> comprehensions = null;
  ArrayList<iexpr> expressions = null;
  boolean isTuple = false;
    jj_consume_token(PAREN_OPEN);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case YIELD:{
      yieldExpr = yieldExpression();
      break;
      }
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        expr = namedExpression();
        break;
        }
      case STAR:{
        expr = starredBitwiseOr();
        break;
        }
      default:
        jj_la1[194] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASYNC:
      case FOR:{
        comprehensions = forIfClauses();
        break;
        }
      default:
        jj_la1[197] = jj_gen;
expressions = new ArrayList<iexpr>();
            expressions.add(expr);
        label_47:
        while (true) {
          if (jj_2_24(2)) {
            ;
          } else {
            break label_47;
          }
          jj_consume_token(COMMA);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NOT:
          case LAMBDA:
          case AWAIT:
          case NONE:
          case TRUE:
          case FALSE:
          case ELLIPSIS:
          case PLUS:
          case MINUS:
          case INVERT:
          case PAREN_OPEN:
          case SQUARE_OPEN:
          case CURLY_OPEN:
          case DEC_INTEGER:
          case BIN_INTEGER:
          case OCT_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case IMAGINARY:
          case NAME:
          case STRING_PREFIX:
          case FORMAT_STRING_PREFIX:
          case STRING_QUOTE_OPEN:{
            expr = namedExpression();
            break;
            }
          case STAR:{
            expr = starredBitwiseOr();
            break;
            }
          default:
            jj_la1[195] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
expressions.add(expr); isTuple = true;
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
isTuple = true;
          break;
          }
        default:
          jj_la1[196] = jj_gen;
          ;
        }
      }
      break;
      }
    default:
      jj_la1[198] = jj_gen;
expressions = new ArrayList<iexpr>(); isTuple = true;
    }
    jj_consume_token(PAREN_CLOSE);
if (yieldExpr != null) {
      {if ("" != null) return yieldExpr;}
    } else if (comprehensions != null) {
      {if ("" != null) return new GeneratorExp(expr, comprehensions, attributes(startToken, token));}
    } else if (isTuple) {
      {if ("" != null) return new Tuple(expressions, attributes(startToken, token));}
    } else {
      {if ("" != null) return expr;}
    }
    throw new Error("Missing return statement in function");
}

  final public iexpr setOrDictOrSetCompOrDictComp() throws ParseException {Token startToken;
  iexpr dictKeyOrSetValueExpr = null;
  iexpr doubleStarExpr = null;
  iexpr dictValueExpr = null;
  ArrayList<iexpr> keyExpressions = new ArrayList<iexpr>();
  ArrayList<iexpr> valueExpressions = new ArrayList<iexpr>();
  ArrayList<Comprehension> comprehensions = null;
  // If isSet is false it is a dict.
  boolean isSet = false;
    jj_consume_token(CURLY_OPEN);
startToken = token;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case NOT:
    case LAMBDA:
    case AWAIT:
    case NONE:
    case TRUE:
    case FALSE:
    case ELLIPSIS:
    case PLUS:
    case MINUS:
    case INVERT:
    case PAREN_OPEN:
    case SQUARE_OPEN:
    case CURLY_OPEN:
    case STAR:
    case DOUBLE_STAR:
    case DEC_INTEGER:
    case BIN_INTEGER:
    case OCT_INTEGER:
    case HEX_INTEGER:
    case FLOAT:
    case IMAGINARY:
    case NAME:
    case STRING_PREFIX:
    case FORMAT_STRING_PREFIX:
    case STRING_QUOTE_OPEN:{
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case NOT:
      case LAMBDA:
      case AWAIT:
      case NONE:
      case TRUE:
      case FALSE:
      case ELLIPSIS:
      case PLUS:
      case MINUS:
      case INVERT:
      case PAREN_OPEN:
      case SQUARE_OPEN:
      case CURLY_OPEN:
      case STAR:
      case DEC_INTEGER:
      case BIN_INTEGER:
      case OCT_INTEGER:
      case HEX_INTEGER:
      case FLOAT:
      case IMAGINARY:
      case NAME:
      case STRING_PREFIX:
      case FORMAT_STRING_PREFIX:
      case STRING_QUOTE_OPEN:{
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case NOT:
        case LAMBDA:
        case AWAIT:
        case NONE:
        case TRUE:
        case FALSE:
        case ELLIPSIS:
        case PLUS:
        case MINUS:
        case INVERT:
        case PAREN_OPEN:
        case SQUARE_OPEN:
        case CURLY_OPEN:
        case DEC_INTEGER:
        case BIN_INTEGER:
        case OCT_INTEGER:
        case HEX_INTEGER:
        case FLOAT:
        case IMAGINARY:
        case NAME:
        case STRING_PREFIX:
        case FORMAT_STRING_PREFIX:
        case STRING_QUOTE_OPEN:{
          dictKeyOrSetValueExpr = expression();
          break;
          }
        case STAR:{
          dictKeyOrSetValueExpr = starredBitwiseOr();
          break;
          }
        default:
          jj_la1[199] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COLON:{
          jj_consume_token(COLON);
          dictValueExpr = expression();
if (doubleStarExpr != null) {
                  {if (true) throw new ParseException("TODO");}
                }
          break;
          }
        default:
          jj_la1[200] = jj_gen;
isSet = true;
        }
        break;
        }
      case DOUBLE_STAR:{
        jj_consume_token(DOUBLE_STAR);
        doubleStarExpr = expression();
        break;
        }
      default:
        jj_la1[201] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASYNC:
      case FOR:{
        comprehensions = forIfClauses();
        break;
        }
      default:
        jj_la1[205] = jj_gen;
keyExpressions = new ArrayList<iexpr>();
            valueExpressions = new ArrayList<iexpr>();
            if (dictKeyOrSetValueExpr != null) {
              keyExpressions.add(dictKeyOrSetValueExpr);
            }
            if (dictValueExpr != null) {
              valueExpressions.add(dictValueExpr);
            }
            if (doubleStarExpr != null) {
              keyExpressions.add(null);
              valueExpressions.add(doubleStarExpr);
            }
        label_48:
        while (true) {
          if (jj_2_25(2)) {
            ;
          } else {
            break label_48;
          }
          jj_consume_token(COMMA);
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case NOT:
          case LAMBDA:
          case AWAIT:
          case NONE:
          case TRUE:
          case FALSE:
          case ELLIPSIS:
          case PLUS:
          case MINUS:
          case INVERT:
          case PAREN_OPEN:
          case SQUARE_OPEN:
          case CURLY_OPEN:
          case DEC_INTEGER:
          case BIN_INTEGER:
          case OCT_INTEGER:
          case HEX_INTEGER:
          case FLOAT:
          case IMAGINARY:
          case NAME:
          case STRING_PREFIX:
          case FORMAT_STRING_PREFIX:
          case STRING_QUOTE_OPEN:{
            dictKeyOrSetValueExpr = expression();
keyExpressions.add(dictKeyOrSetValueExpr); doubleStarExpr = null;
            break;
            }
          case STAR:{
            dictKeyOrSetValueExpr = starredBitwiseOr();
keyExpressions.add(dictKeyOrSetValueExpr); doubleStarExpr = null;
            break;
            }
          case DOUBLE_STAR:{
            jj_consume_token(DOUBLE_STAR);
            doubleStarExpr = expression();
if (isSet) {
                    {if (true) throw new ParseException("TODO");}
                  }
                  keyExpressions.add(null);
                  valueExpressions.add(doubleStarExpr);
            break;
            }
          default:
            jj_la1[202] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
          case COLON:{
            jj_consume_token(COLON);
            dictValueExpr = expression();
if (isSet) {
                    {if (true) throw new ParseException("TODO");}
                  }
                  valueExpressions.add(dictValueExpr);
            break;
            }
          default:
            jj_la1[203] = jj_gen;
if (!isSet && doubleStarExpr == null) {
                  {if (true) throw new ParseException("TODO");}
                }
          }
        }
        switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
        case COMMA:{
          jj_consume_token(COMMA);
          break;
          }
        default:
          jj_la1[204] = jj_gen;
          ;
        }
      }
      break;
      }
    default:
      jj_la1[206] = jj_gen;

    }
    jj_consume_token(CURLY_CLOSE);
if (isSet) {
      if (comprehensions == null) {
        {if ("" != null) return new Set(keyExpressions, attributes(startToken, token));}
      } else {
        {if ("" != null) return new SetComp(dictKeyOrSetValueExpr, comprehensions, attributes(startToken, token));}
      }
    } else {
      if (comprehensions == null) {
        {if ("" != null) return new Dict(keyExpressions, valueExpressions, attributes(startToken, token));}
      } else {
        if (doubleStarExpr != null) {
          {if (true) throw new ParseException("TODO");}
        }
        {if ("" != null) return new DictComp(dictKeyOrSetValueExpr, dictValueExpr, comprehensions,
         attributes(startToken, token));}
      }
    }
    throw new Error("Missing return statement in function");
}

  final public ArrayList<Comprehension> forIfClauses() throws ParseException {ArrayList<Comprehension> comprehensions = new ArrayList<Comprehension>();
  Comprehension comprehension;
    label_49:
    while (true) {
      comprehension = forIfClause();
comprehensions.add(comprehension);
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case ASYNC:
      case FOR:{
        ;
        break;
        }
      default:
        jj_la1[207] = jj_gen;
        break label_49;
      }
    }
{if ("" != null) return comprehensions;}
    throw new Error("Missing return statement in function");
}

  final public Comprehension forIfClause() throws ParseException {boolean isAsync = false;
  iexpr target;
  iexpr iter;
  ArrayList<iexpr> ifs = new ArrayList<iexpr>();
  iexpr ifExpr;
    switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
    case ASYNC:{
      jj_consume_token(ASYNC);
isAsync = true;
      break;
      }
    default:
      jj_la1[208] = jj_gen;
      ;
    }
    jj_consume_token(FOR);
    target = starTargets();
    jj_consume_token(IN);
    iter = disjunction();
    label_50:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk_f():jj_ntk) {
      case IF:{
        ;
        break;
        }
      default:
        jj_la1[209] = jj_gen;
        break label_50;
      }
      jj_consume_token(IF);
      ifExpr = disjunction();
ifs.add(ifExpr);
    }
{if ("" != null) return new Comprehension(target, iter, ifs, isAsync);}
    throw new Error("Missing return statement in function");
}

  private boolean jj_2_1(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_1()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_2()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_3()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_4()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_5()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_6()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_7()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_8()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_9()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_10()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_11()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_12()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_13()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_14()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_15()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_16()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_17()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_18()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_19()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_20()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_21()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_22()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_23()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_24()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla)
 {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return (!jj_3_25()); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_3R_returnStatement_1903_3_114()
 {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  private boolean jj_3R_orPattern_1519_3_146()
 {
    if (jj_3R_closedPattern_1542_3_159()) return true;
    return false;
  }

  private boolean jj_3R_string_3431_3_176()
 {
    if (jj_scan_token(FORMAT_STRING_PREFIX)) return true;
    return false;
  }

  private boolean jj_3R_withItem_2662_3_63()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3R_comparison_3043_3_184()
 {
    if (jj_3R_bitwiseOr_3080_3_187()) return true;
    return false;
  }

  private boolean jj_3R_string_3419_6_183()
 {
    if (jj_scan_token(STRING_PREFIX)) return true;
    return false;
  }

  private boolean jj_3R_asPattern_1505_3_126()
 {
    if (jj_3R_orPattern_1519_3_146()) return true;
    return false;
  }

  private boolean jj_3R_typeParam_1886_5_102()
 {
    if (jj_scan_token(DOUBLE_STAR)) return true;
    return false;
  }

  private boolean jj_3R_string_3418_3_175()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_string_3419_6_183()) jj_scanpos = xsp;
    if (jj_scan_token(STRING_QUOTE_OPEN)) return true;
    return false;
  }

  private boolean jj_3R_string_3418_3_168()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_string_3418_3_175()) {
    jj_scanpos = xsp;
    if (jj_3R_string_3431_3_176()) return true;
    }
    return false;
  }

  private boolean jj_3R_typeParam_1883_5_101()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3_16()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_withItem_2662_3_63()) return true;
    return false;
  }

  private boolean jj_3R_inversion_3032_3_178()
 {
    if (jj_3R_comparison_3043_3_184()) return true;
    return false;
  }

  private boolean jj_3R_withItems_2649_3_62()
 {
    if (jj_3R_withItem_2662_3_63()) return true;
    return false;
  }

  private boolean jj_3R_typeParam_1880_5_100()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_pattern_1497_3_95()
 {
    if (jj_3R_asPattern_1505_3_126()) return true;
    return false;
  }

  private boolean jj_3R_inversion_3028_3_177()
 {
    if (jj_scan_token(NOT)) return true;
    return false;
  }

  private boolean jj_3R_inversion_3028_3_169()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_inversion_3028_3_177()) {
    jj_scanpos = xsp;
    if (jj_3R_inversion_3032_3_178()) return true;
    }
    return false;
  }

  private boolean jj_3R_typeParam_1879_3_57()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_typeParam_1880_5_100()) {
    jj_scanpos = xsp;
    if (jj_3R_typeParam_1883_5_101()) {
    jj_scanpos = xsp;
    if (jj_3R_typeParam_1886_5_102()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_8()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_typeParam_1879_3_57()) return true;
    return false;
  }

  private boolean jj_3_15()
 {
    if (jj_scan_token(PAREN_OPEN)) return true;
    if (jj_3R_withItems_2649_3_62()) return true;
    return false;
  }

  private boolean jj_3R_conjunction_3007_3_154()
 {
    if (jj_3R_inversion_3028_3_169()) return true;
    return false;
  }

  private boolean jj_3R_strings_3390_3_150()
 {
    if (jj_3R_string_3418_3_168()) return true;
    return false;
  }

  private boolean jj_3R_number_3379_5_167()
 {
    if (jj_scan_token(IMAGINARY)) return true;
    return false;
  }

  private boolean jj_3R_number_3375_5_166()
 {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_number_3371_5_165()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(86)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(88)) {
    jj_scanpos = xsp;
    if (jj_scan_token(89)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_smallStatement_1838_3_89()
 {
    if (jj_3R_nonlocalStatement_2101_3_124()) return true;
    return false;
  }

  private boolean jj_3R_number_3370_3_149()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_number_3371_5_165()) {
    jj_scanpos = xsp;
    if (jj_3R_number_3375_5_166()) {
    jj_scanpos = xsp;
    if (jj_3R_number_3379_5_167()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_smallStatement_1837_3_88()
 {
    if (jj_3R_globalStatement_2091_3_123()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1836_3_87()
 {
    if (jj_3R_continueStatement_2084_3_122()) return true;
    return false;
  }

  private boolean jj_3R_disjunction_2985_3_140()
 {
    if (jj_3R_conjunction_3007_3_154()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1835_3_86()
 {
    if (jj_3R_breakStatement_2079_3_121()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1834_3_85()
 {
    if (jj_3R_assertStatement_2071_3_120()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1833_3_84()
 {
    if (jj_3R_yieldStatement_2062_3_119()) return true;
    return false;
  }

  private boolean jj_3R_atom_3365_3_139()
 {
    if (jj_3R_setOrDictOrSetCompOrDictComp_3633_3_153()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1832_3_83()
 {
    if (jj_3R_delStatement_2049_3_118()) return true;
    return false;
  }

  private boolean jj_3R_atom_3364_3_138()
 {
    if (jj_3R_tupleOrGeneratorExpOrGroup_3583_3_152()) return true;
    return false;
  }

  private boolean jj_3R_starNamedExpression_1420_31_93()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1831_3_82()
 {
    if (jj_3R_passStatement_2038_3_117()) return true;
    return false;
  }

  private boolean jj_3R_keyValuePattern_1804_30_129()
 {
    if (jj_3R_nameOrAttr_1644_3_148()) return true;
    return false;
  }

  private boolean jj_3R_atom_3363_3_137()
 {
    if (jj_3R_listOrListComprehension_3543_3_151()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1830_3_81()
 {
    if (jj_3R_raiseStatement_2014_3_116()) return true;
    return false;
  }

  private boolean jj_3R_atom_3362_3_136()
 {
    if (jj_3R_strings_3390_3_150()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1829_3_80()
 {
    if (jj_3R_importStatement_1912_3_115()) return true;
    return false;
  }

  private boolean jj_3R_atom_3361_3_135()
 {
    if (jj_3R_number_3370_3_149()) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1828_3_79()
 {
    if (jj_3R_returnStatement_1903_3_114()) return true;
    return false;
  }

  private boolean jj_3R_atom_3360_3_134()
 {
    if (jj_scan_token(ELLIPSIS)) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1827_3_78()
 {
    if (jj_3R_assignmentOrExpr_2756_3_113()) return true;
    return false;
  }

  private boolean jj_3R_atom_3359_3_133()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_smallStatement_1826_3_51()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_smallStatement_1827_3_78()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1828_3_79()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1829_3_80()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1830_3_81()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1831_3_82()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1832_3_83()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1833_3_84()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1834_3_85()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1835_3_86()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1836_3_87()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1837_3_88()) {
    jj_scanpos = xsp;
    if (jj_3R_smallStatement_1838_3_89()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_atom_3358_3_132()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_lambda_2974_3_125()
 {
    if (jj_scan_token(LAMBDA)) return true;
    return false;
  }

  private boolean jj_3R_atom_3357_3_131()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_atom_3356_3_103()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_atom_3356_3_130()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3357_3_131()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3358_3_132()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3359_3_133()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3360_3_134()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3361_3_135()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3362_3_136()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3363_3_137()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3364_3_138()) {
    jj_scanpos = xsp;
    if (jj_3R_atom_3365_3_139()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_atom_3356_3_130()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3_3()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_starNamedExpression_1420_3_53()) return true;
    return false;
  }

  private boolean jj_3R_keyValuePattern_1812_5_99()
 {
    if (jj_scan_token(DOUBLE_STAR)) return true;
    return false;
  }

  private boolean jj_3R_starredBitwiseOr_3346_3_104()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_conditionalExpression_2959_3_105()
 {
    if (jj_3R_disjunction_2985_3_140()) return true;
    return false;
  }

  private boolean jj_3R_keyValuePattern_1804_8_128()
 {
    if (jj_3R_literalExpr_1573_3_147()) return true;
    return false;
  }

  private boolean jj_3R_keyValuePattern_1803_5_98()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_keyValuePattern_1804_8_128()) {
    jj_scanpos = xsp;
    if (jj_3R_keyValuePattern_1804_30_129()) return true;
    }
    return false;
  }

  private boolean jj_3R_starNamedExpression_1420_4_92()
 {
    if (jj_3R_namedExpression_2928_3_112()) return true;
    return false;
  }

  private boolean jj_3R_starNamedExpression_1420_3_53()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_starNamedExpression_1420_4_92()) {
    jj_scanpos = xsp;
    if (jj_3R_starNamedExpression_1420_31_93()) return true;
    }
    return false;
  }

  private boolean jj_3R_starredExpression_3335_3_141()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_keyValuePattern_1802_3_56()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_keyValuePattern_1803_5_98()) {
    jj_scanpos = xsp;
    if (jj_3R_keyValuePattern_1812_5_99()) return true;
    }
    return false;
  }

  private boolean jj_3R_expression_2947_5_91()
 {
    if (jj_3R_lambda_2974_3_125()) return true;
    return false;
  }

  private boolean jj_3R_expression_2946_5_90()
 {
    if (jj_3R_conditionalExpression_2959_3_105()) return true;
    return false;
  }

  private boolean jj_3R_expression_2945_3_52()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_expression_2946_5_90()) {
    jj_scanpos = xsp;
    if (jj_3R_expression_2947_5_91()) return true;
    }
    return false;
  }

  private boolean jj_3_7()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_keyValuePattern_1802_3_56()) return true;
    return false;
  }

  private boolean jj_3R_slice_3317_4_110()
 {
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  private boolean jj_3R_slice_3316_4_109()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3R_mappingPattern_1784_3_182()
 {
    if (jj_scan_token(CURLY_OPEN)) return true;
    return false;
  }

  private boolean jj_3R_slice_3316_3_69()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_slice_3316_4_109()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_slice_3317_4_110()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_setOrDictOrSetCompOrDictComp_3687_15_77()
 {
    if (jj_scan_token(DOUBLE_STAR)) return true;
    return false;
  }

  private boolean jj_3R_setOrDictOrSetCompOrDictComp_3683_15_76()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_namedExpression_2928_3_112()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3R_setOrDictOrSetCompOrDictComp_3679_15_75()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3_25()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_setOrDictOrSetCompOrDictComp_3679_15_75()) {
    jj_scanpos = xsp;
    if (jj_3R_setOrDictOrSetCompOrDictComp_3683_15_76()) {
    jj_scanpos = xsp;
    if (jj_3R_setOrDictOrSetCompOrDictComp_3687_15_77()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_yieldExpression_2914_3_145()
 {
    if (jj_scan_token(YIELD)) return true;
    return false;
  }

  private boolean jj_3R_starPattern_1756_3_127()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3_21()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_slice_3316_3_69()) return true;
    return false;
  }

  private boolean jj_3R_lambdaFunctionParameterDef_2517_3_61()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_maybeStarPattern_1748_5_97()
 {
    if (jj_3R_pattern_1497_3_95()) return true;
    return false;
  }

  private boolean jj_3R_maybeStarPattern_1747_5_96()
 {
    if (jj_3R_starPattern_1756_3_127()) return true;
    return false;
  }

  private boolean jj_3_2()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3R_starConditionalExpressions_2892_7_67()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_maybeStarPattern_1746_3_55()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_maybeStarPattern_1747_5_96()) {
    jj_scanpos = xsp;
    if (jj_3R_maybeStarPattern_1748_5_97()) return true;
    }
    return false;
  }

  private boolean jj_3R_starConditionalExpressions_2891_7_66()
 {
    if (jj_3R_conditionalExpression_2959_3_105()) return true;
    return false;
  }

  private boolean jj_3_14()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_lambdaFunctionParameterDef_2517_3_61()) return true;
    return false;
  }

  private boolean jj_3_19()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_starConditionalExpressions_2891_7_66()) {
    jj_scanpos = xsp;
    if (jj_3R_starConditionalExpressions_2892_7_67()) return true;
    }
    return false;
  }

  private boolean jj_3R_argument_3260_5_108()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3_6()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_maybeStarPattern_1746_3_55()) return true;
    return false;
  }

  private boolean jj_3R_argument_3258_5_107()
 {
    if (jj_scan_token(DOUBLE_STAR)) return true;
    return false;
  }

  private boolean jj_3R_argument_3257_5_106()
 {
    if (jj_3R_starredExpression_3335_3_141()) return true;
    return false;
  }

  private boolean jj_3R_argument_3256_3_68()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_argument_3257_5_106()) {
    jj_scanpos = xsp;
    if (jj_3R_argument_3258_5_107()) {
    jj_scanpos = xsp;
    if (jj_3R_argument_3260_5_108()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_tupleOrGeneratorExpOrGroup_3598_41_74()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_nonlocalStatement_2101_3_124()
 {
    if (jj_scan_token(NONLOCAL)) return true;
    return false;
  }

  private boolean jj_3R_setOrDictOrSetCompOrDictComp_3633_3_153()
 {
    if (jj_scan_token(CURLY_OPEN)) return true;
    return false;
  }

  private boolean jj_3_13()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_lambdaFunctionParameterDef_2517_3_61()) return true;
    return false;
  }

  private boolean jj_3_20()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_argument_3256_3_68()) return true;
    return false;
  }

  private boolean jj_3R_globalStatement_2091_3_123()
 {
    if (jj_scan_token(GLOBAL)) return true;
    return false;
  }

  private boolean jj_3R_starExpressions_2850_7_65()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_starExpressions_2849_7_64()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3R_continueStatement_2084_3_122()
 {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  private boolean jj_3R_groupOrSequencePattern_1698_5_186()
 {
    if (jj_scan_token(PAREN_OPEN)) return true;
    return false;
  }

  private boolean jj_3R_breakStatement_2079_3_121()
 {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  private boolean jj_3R_tupleOrGeneratorExpOrGroup_3598_14_73()
 {
    if (jj_3R_namedExpression_2928_3_112()) return true;
    return false;
  }

  private boolean jj_3R_groupOrSequencePattern_1690_5_185()
 {
    if (jj_scan_token(SQUARE_OPEN)) return true;
    return false;
  }

  private boolean jj_3_18()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_starExpressions_2849_7_64()) {
    jj_scanpos = xsp;
    if (jj_3R_starExpressions_2850_7_65()) return true;
    }
    return false;
  }

  private boolean jj_3R_starExpressions_2838_5_156()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_starExpressions_2837_5_155()
 {
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3_24()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_tupleOrGeneratorExpOrGroup_3598_14_73()) {
    jj_scanpos = xsp;
    if (jj_3R_tupleOrGeneratorExpOrGroup_3598_41_74()) return true;
    }
    return false;
  }

  private boolean jj_3R_groupOrSequencePattern_1689_3_181()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_groupOrSequencePattern_1690_5_185()) {
    jj_scanpos = xsp;
    if (jj_3R_groupOrSequencePattern_1698_5_186()) return true;
    }
    return false;
  }

  private boolean jj_3R_assertStatement_2071_3_120()
 {
    if (jj_scan_token(ASSERT)) return true;
    return false;
  }

  private boolean jj_3R_starExpressions_2836_3_142()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_starExpressions_2837_5_155()) {
    jj_scanpos = xsp;
    if (jj_3R_starExpressions_2838_5_156()) return true;
    }
    return false;
  }

  private boolean jj_3R_primary_3215_3_59()
 {
    if (jj_3R_atom_3356_3_103()) return true;
    return false;
  }

  private boolean jj_3R_listOrListComprehension_3557_41_72()
 {
    if (jj_3R_starredBitwiseOr_3346_3_104()) return true;
    return false;
  }

  private boolean jj_3R_yieldStatement_2062_3_119()
 {
    if (jj_3R_yieldExpression_2914_3_145()) return true;
    return false;
  }

  private boolean jj_3R_patternArgument_1671_7_94()
 {
    return false;
  }

  private boolean jj_3R_awaitPrimary_3206_3_202()
 {
    if (jj_scan_token(AWAIT)) return true;
    return false;
  }

  private boolean jj_3R_awaitPrimary_3205_3_201()
 {
    if (jj_3R_primary_3215_3_59()) return true;
    return false;
  }

  private boolean jj_3R_awaitPrimary_3205_3_200()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_awaitPrimary_3205_3_201()) {
    jj_scanpos = xsp;
    if (jj_3R_awaitPrimary_3206_3_202()) return true;
    }
    return false;
  }

  private boolean jj_3_5()
 {
    if (jj_scan_token(NAME)) return true;
    if (jj_scan_token(ASSIGN)) return true;
    return false;
  }

  private boolean jj_3R_patternArgument_1669_3_54()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_patternArgument_1671_7_94()) return true;
    }
    if (jj_3R_pattern_1497_3_95()) return true;
    return false;
  }

  private boolean jj_3_10()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_primary_3215_3_59()) return true;
    return false;
  }

  private boolean jj_3R_tupleOrGeneratorExpOrGroup_3583_3_152()
 {
    if (jj_scan_token(PAREN_OPEN)) return true;
    return false;
  }

  private boolean jj_3_17()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_expression_2945_3_52()) return true;
    return false;
  }

  private boolean jj_3R_delStatement_2049_3_118()
 {
    if (jj_scan_token(DEL)) return true;
    return false;
  }

  private boolean jj_3_1()
 {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_3R_smallStatement_1826_3_51()) return true;
    return false;
  }

  private boolean jj_3R_power_3194_3_199()
 {
    if (jj_3R_awaitPrimary_3205_3_200()) return true;
    return false;
  }

  private boolean jj_3_4()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_patternArgument_1669_3_54()) return true;
    return false;
  }

  private boolean jj_3R_passStatement_2038_3_117()
 {
    if (jj_scan_token(PASS)) return true;
    return false;
  }

  private boolean jj_3R_factor_3185_3_195()
 {
    if (jj_3R_power_3194_3_199()) return true;
    return false;
  }

  private boolean jj_3R_listOrListComprehension_3557_14_71()
 {
    if (jj_3R_namedExpression_2928_3_112()) return true;
    return false;
  }

  private boolean jj_3R_factor_3179_7_198()
 {
    if (jj_scan_token(INVERT)) return true;
    return false;
  }

  private boolean jj_3R_factor_3178_7_197()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_factor_3177_7_196()
 {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3_23()
 {
    if (jj_scan_token(COMMA)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_listOrListComprehension_3557_14_71()) {
    jj_scanpos = xsp;
    if (jj_3R_listOrListComprehension_3557_41_72()) return true;
    }
    return false;
  }

  private boolean jj_3R_nameOrAttr_1644_3_148()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_factor_3175_3_194()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_factor_3177_7_196()) {
    jj_scanpos = xsp;
    if (jj_3R_factor_3178_7_197()) {
    jj_scanpos = xsp;
    if (jj_3R_factor_3179_7_198()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_factor_3174_3_193()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_factor_3175_3_194()) {
    jj_scanpos = xsp;
    if (jj_3R_factor_3185_3_195()) return true;
    }
    return false;
  }

  private boolean jj_3R_raiseStatement_2014_3_116()
 {
    if (jj_scan_token(RAISE)) return true;
    return false;
  }

  private boolean jj_3R_listOrListComprehension_3543_3_151()
 {
    if (jj_scan_token(SQUARE_OPEN)) return true;
    return false;
  }

  private boolean jj_3R_term_3154_3_192()
 {
    if (jj_3R_factor_3174_3_193()) return true;
    return false;
  }

  private boolean jj_3R_importFromAsName_2003_3_58()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_starTarget_3526_4_111()
 {
    if (jj_scan_token(STAR)) return true;
    return false;
  }

  private boolean jj_3R_starTarget_3526_3_70()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_starTarget_3526_4_111()) jj_scanpos = xsp;
    if (jj_3R_primary_3215_3_59()) return true;
    return false;
  }

  private boolean jj_3_9()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_importFromAsName_2003_3_58()) return true;
    return false;
  }

  private boolean jj_3R_sum_3140_3_191()
 {
    if (jj_3R_term_3154_3_192()) return true;
    return false;
  }

  private boolean jj_3R_captureOrWildcardOrValueOrClassPattern_1608_3_180()
 {
    if (jj_3R_nameOrAttr_1644_3_148()) return true;
    return false;
  }

  private boolean jj_3R_assignmentOrExpr_2756_3_113()
 {
    if (jj_3R_starExpressions_2836_3_142()) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1598_5_164()
 {
    if (jj_scan_token(FALSE)) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1597_5_163()
 {
    if (jj_scan_token(TRUE)) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1596_5_162()
 {
    if (jj_scan_token(NONE)) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1595_5_161()
 {
    if (jj_3R_strings_3390_3_150()) return true;
    return false;
  }

  private boolean jj_3R_shiftExpr_3126_3_190()
 {
    if (jj_3R_sum_3140_3_191()) return true;
    return false;
  }

  private boolean jj_3R_typedFunctionParameterDef_2350_3_60()
 {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1575_8_174()
 {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_bitwiseAnd_3110_3_189()
 {
    if (jj_3R_shiftExpr_3126_3_190()) return true;
    return false;
  }

  private boolean jj_3_22()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_starTarget_3526_3_70()) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1574_5_160()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_literalExpr_1575_8_174()) jj_scanpos = xsp;
    if (jj_3R_number_3370_3_149()) return true;
    return false;
  }

  private boolean jj_3R_importFrom_1958_3_158()
 {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  private boolean jj_3R_literalExpr_1573_3_147()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_literalExpr_1574_5_160()) {
    jj_scanpos = xsp;
    if (jj_3R_literalExpr_1595_5_161()) {
    jj_scanpos = xsp;
    if (jj_3R_literalExpr_1596_5_162()) {
    jj_scanpos = xsp;
    if (jj_3R_literalExpr_1597_5_163()) {
    jj_scanpos = xsp;
    if (jj_3R_literalExpr_1598_5_164()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_12()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_typedFunctionParameterDef_2350_3_60()) return true;
    return false;
  }

  private boolean jj_3R_bitwiseXor_3095_3_188()
 {
    if (jj_3R_bitwiseAnd_3110_3_189()) return true;
    return false;
  }

  private boolean jj_3R_literalPattern_1554_3_179()
 {
    if (jj_3R_literalExpr_1573_3_147()) return true;
    return false;
  }

  private boolean jj_3_11()
 {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_typedFunctionParameterDef_2350_3_60()) return true;
    return false;
  }

  private boolean jj_3R_bitwiseOr_3080_3_187()
 {
    if (jj_3R_bitwiseXor_3095_3_188()) return true;
    return false;
  }

  private boolean jj_3R_closedPattern_1546_5_173()
 {
    if (jj_3R_mappingPattern_1784_3_182()) return true;
    return false;
  }

  private boolean jj_3R_closedPattern_1545_5_172()
 {
    if (jj_3R_groupOrSequencePattern_1689_3_181()) return true;
    return false;
  }

  private boolean jj_3R_closedPattern_1544_5_171()
 {
    if (jj_3R_captureOrWildcardOrValueOrClassPattern_1608_3_180()) return true;
    return false;
  }

  private boolean jj_3R_closedPattern_1543_5_170()
 {
    if (jj_3R_literalPattern_1554_3_179()) return true;
    return false;
  }

  private boolean jj_3R_closedPattern_1542_3_159()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_closedPattern_1543_5_170()) {
    jj_scanpos = xsp;
    if (jj_3R_closedPattern_1544_5_171()) {
    jj_scanpos = xsp;
    if (jj_3R_closedPattern_1545_5_172()) {
    jj_scanpos = xsp;
    if (jj_3R_closedPattern_1546_5_173()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_importName_1923_3_157()
 {
    if (jj_scan_token(IMPORT)) return true;
    return false;
  }

  private boolean jj_3R_importStatement_1914_5_144()
 {
    if (jj_3R_importFrom_1958_3_158()) return true;
    return false;
  }

  private boolean jj_3R_importStatement_1913_5_143()
 {
    if (jj_3R_importName_1923_3_157()) return true;
    return false;
  }

  private boolean jj_3R_importStatement_1912_3_115()
 {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_importStatement_1913_5_143()) {
    jj_scanpos = xsp;
    if (jj_3R_importStatement_1914_5_144()) return true;
    }
    return false;
  }

  /** Generated Token Manager. */
  public PythonParserTokenManager token_source;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[210];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static {
	   jj_la1_init_0();
	   jj_la1_init_1();
	   jj_la1_init_2();
	   jj_la1_init_3();
	   jj_la1_init_4();
	   jj_la1_init_5();
	}
	private static void jj_la1_init_0() {
	   jj_la1_0 = new int[] {0xffef3fc3,0xffef3fc2,0xffef3fc2,0x1,0x0,0x1,0x0,0x1,0x1,0x1,0x0,0x0,0x1,0x1,0x1,0xc0000240,0x0,0x0,0x1,0x2,0x100000,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x0,0x0,0x0,0x80000000,0x80000000,0x80000000,0x0,0x0,0x80000000,0x0,0x80000000,0x80000000,0x80000000,0xffec1240,0x0,0x0,0x0,0x0,0xc0000240,0xc0000,0x0,0x100000,0x0,0x0,0x0,0x0,0x0,0x0,0x100000,0x0,0x80000,0x80000,0xc0000240,0x0,0x0,0x0,0x0,0x32d82,0x10180,0xc80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc,0x0,0x0,0x0,0x4,0xc0000240,0x0,0x100000,0x4000,0x4,0x8000,0xc000,0x100000,0x100000,0xc0000240,0x4,0xffec1240,0xc1000240,0x0,0x0,0xc1000240,0xc1000240,0x0,0x0,0x0,0xc0000240,0xc0000240,0x0,0xc0000040,0xc0000040,0x0,0xc0080240,0x0,0xc0000240,0x2,0x10,0x20,0xc0000040,0x40,0x40,0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000000,0x0,0xc0000000,0x0,0x0,0x0,0xc0000240,0x500,0xc0000240,0x0,0xc0000240,0xc0000240,0xc0000240,0x0,0x0,0x80000000,0x0,0x0,0x0,0x0,0x0,0x0,0xc1000040,0x0,0x0,0x0,0x0,0x0,0x0,0xc0000240,0xc0000240,0x0,0x500,0xc0000240,0xc0000240,0xc0000240,0x0,0x500,0xc1000240,0xc0000240,0x0,0xc0000240,0xc0000240,0x0,0x0,0x500,0xc0000240,0x500,0x100,0x2,};
	}
	private static void jj_la1_init_1() {
	   jj_la1_1 = new int[] {0xc000000b,0xc000000b,0xc000000b,0x0,0x20,0x0,0x40,0x0,0x0,0x20,0x40,0x20000000,0x0,0x0,0x20,0xc000000b,0x40,0x0,0x0,0x0,0x0,0x0,0x80000003,0x80000000,0xc0000000,0xc0000000,0x80000003,0x0,0x0,0x40,0x80000003,0x80000003,0x80000003,0x0,0x40,0x80000003,0x40,0x80000003,0x80000003,0x80000003,0xc000000b,0x0,0x40,0x10,0x0,0xc000000b,0x0,0x40,0x0,0x0,0x8,0x8,0x0,0x0,0x40,0x0,0x40,0x40,0x40,0xc000000b,0x40,0x40,0x40,0x40,0x0,0x0,0x0,0x0,0x4,0x0,0x40,0x0,0x40,0x0,0x40,0x0,0x0,0x40,0x0,0x40,0x0,0x40,0x40,0x40,0x80,0x80,0x80,0x80,0x10,0x0,0x40,0x0,0x40,0x0,0x40,0x0,0x0,0x40,0x0,0x40,0x0,0x40,0x40,0x40,0x80,0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000b,0x40,0x0,0x0,0x0,0x0,0x0,0x40,0x40,0xc000000b,0x0,0xc000000b,0xc000000b,0x80,0x3ffe00,0xc000000b,0xc000000b,0x80,0x3ffe90,0x40,0xc000000b,0xc000000b,0x40,0xc000000b,0xc000000b,0x40,0xc000000b,0x100,0xc000000b,0x0,0x0,0x0,0xc000000b,0x3fc00000,0x0,0x3fc00000,0x0,0x0,0x0,0x0,0x0,0xc0000000,0xc0000000,0x0,0x0,0xc0000000,0xc000000b,0x0,0xb,0x0,0x0,0x40,0xc000000b,0x180,0xc000000b,0x40,0xc000000b,0xc000000b,0xc000000b,0x10,0x10,0xb,0x0,0x0,0x0,0x0,0x0,0x0,0xc000000b,0x80,0x0,0x0,0x10,0x40,0x0,0xc000000b,0xc000000b,0x40,0x0,0xc000000b,0xc000000b,0xc000000b,0x40,0x0,0xc000000b,0xc000000b,0x10,0xc000000b,0xc000000b,0x10,0x40,0x0,0xc000000b,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_2() {
	   jj_la1_2 = new int[] {0x83c25411,0x83c25411,0x83c25411,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x83c25410,0x0,0x0,0x0,0x0,0x0,0x80,0x83c05400,0x0,0x0,0x0,0x83c00000,0x400,0x10000,0x0,0x83c05400,0x83c25400,0x83c25400,0x1400,0x0,0x83c25400,0x0,0x83c40000,0x83c00000,0x83c40000,0x83c25410,0x1000,0x0,0x0,0x60000,0x83c25410,0x0,0x0,0x0,0x10000,0x10000,0x10000,0x0,0x20400,0x0,0x0,0x0,0x0,0x0,0x83c05410,0x0,0x0,0x0,0x0,0x1,0x0,0x0,0x1000,0x0,0x60000,0x0,0x60000,0x0,0x60002,0x0,0x60000,0x40000,0x0,0x40000,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x60000,0x0,0x60000,0x0,0x60002,0x0,0x60000,0x40000,0x0,0x40000,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000,0x400,0x1,0x0,0x83c05410,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x83c05410,0x0,0x83c25410,0x83c25410,0x0,0x0,0x83c25410,0x83c25410,0x0,0x0,0x0,0x83c25410,0x83c25410,0x0,0x83c25410,0x83c25410,0x0,0x83c25410,0x0,0x83c05410,0x0,0x0,0x0,0x83c05410,0x0,0x0,0x0,0x80,0x100,0x200,0x60,0x60,0x0,0x0,0x2000f,0x2000f,0x10,0x83c05410,0x40000,0x83c05400,0x11400,0x11400,0x0,0x83c65410,0x0,0x83c65410,0x0,0x83c05410,0x83c05410,0x83c05410,0x0,0x0,0x83c05400,0x3c00000,0x83c00000,0x0,0x0,0x0,0x0,0x83c25410,0x0,0x380000,0x380000,0x0,0x0,0x20000,0x83c25410,0x83c25410,0x0,0x0,0x83c25410,0x83c25410,0x83c25410,0x0,0x0,0x83c25410,0x83c25410,0x0,0x83c65410,0x83c65410,0x0,0x0,0x0,0x83c65410,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_3() {
	   jj_la1_3 = new int[] {0x2a0000c,0x2a0000c,0x2a0000c,0x80000,0x0,0x100000,0x0,0x100000,0x100000,0x100000,0x0,0x0,0x100000,0x100000,0x100000,0x2a0000c,0x0,0x8,0x80000,0x0,0x0,0x0,0x2a0000c,0x0,0x0,0x0,0x2a00004,0x0,0x0,0x0,0x2a0000c,0x2a0000c,0x2a0000c,0x0,0x0,0x2a0000c,0x0,0x2a0000c,0x2a0000c,0x2a0000c,0x2a0000c,0x0,0x0,0x0,0x8,0x2a0000c,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x2a0000c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x8,0x0,0x0,0x0,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2a0000c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2a0000c,0x0,0x2b0000c,0x2a0000c,0x0,0x0,0x2a0000c,0x2a0000c,0x0,0x0,0x0,0x2a0000c,0x2a0000c,0x0,0x2a0000c,0x2a0000c,0x0,0x2a0000c,0x0,0x2a0000c,0x0,0x0,0x0,0x2a0000c,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2a0000c,0x0,0x2a0000c,0x0,0x0,0x0,0x2a0000c,0x0,0x2a0000c,0x0,0x2a0000c,0x2a0000c,0x2a0000c,0x0,0x0,0x2a0000c,0x0,0x4,0x2a00000,0x200000,0x0,0x2a00000,0x2a0000c,0x0,0x0,0x0,0x0,0x0,0x0,0x2a0000c,0x2a0000c,0x0,0x0,0x2a0000c,0x2a0000c,0x2a0000c,0x0,0x0,0x2a0000c,0x2a0000c,0x0,0x2a0000c,0x2a0000c,0x0,0x0,0x0,0x2a0000c,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_4() {
	   jj_la1_4 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
	private static void jj_la1_init_5() {
	   jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
	}
  final private JJCalls[] jj_2_rtns = new JJCalls[25];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with user supplied CharStream. */
  public PythonParser(CharStream stream) {
	 token_source = new PythonParserTokenManager(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 210; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CharStream stream) {
	 token_source.ReInit(stream);
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 210; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public PythonParser(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 210; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(PythonParserTokenManager tm) {
	 token_source = tm;
	 token = new Token();
	 jj_ntk = -1;
	 jj_gen = 0;
	 for (int i = 0; i < 210; i++) jj_la1[i] = -1;
	 for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
	 Token oldToken;
	 if ((oldToken = token).next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 if (token.kind == kind) {
	   jj_gen++;
	   if (++jj_gc > 100) {
		 jj_gc = 0;
		 for (int i = 0; i < jj_2_rtns.length; i++) {
		   JJCalls c = jj_2_rtns[i];
		   while (c != null) {
			 if (c.gen < jj_gen) c.first = null;
			 c = c.next;
		   }
		 }
	   }
	   return token;
	 }
	 token = oldToken;
	 jj_kind = kind;
	 throw generateParseException();
  }

  @SuppressWarnings("serial")
  static private final class LookaheadSuccess extends java.lang.Error {
    @Override
    public Throwable fillInStackTrace() {
      return this;
    }
  }
  static private final LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
	 if (jj_scanpos == jj_lastpos) {
	   jj_la--;
	   if (jj_scanpos.next == null) {
		 jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
	   } else {
		 jj_lastpos = jj_scanpos = jj_scanpos.next;
	   }
	 } else {
	   jj_scanpos = jj_scanpos.next;
	 }
	 if (jj_rescan) {
	   int i = 0; Token tok = token;
	   while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
	   if (tok != null) jj_add_error_token(kind, i);
	 }
	 if (jj_scanpos.kind != kind) return true;
	 if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
	 return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
	 if (token.next != null) token = token.next;
	 else token = token.next = token_source.getNextToken();
	 jj_ntk = -1;
	 jj_gen++;
	 return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
	 Token t = token;
	 for (int i = 0; i < index; i++) {
	   if (t.next != null) t = t.next;
	   else t = t.next = token_source.getNextToken();
	 }
	 return t;
  }

  private int jj_ntk_f() {
	 if ((jj_nt=token.next) == null)
	   return (jj_ntk = (token.next=token_source.getNextToken()).kind);
	 else
	   return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
	 if (pos >= 100) {
		return;
	 }

	 if (pos == jj_endpos + 1) {
	   jj_lasttokens[jj_endpos++] = kind;
	 } else if (jj_endpos != 0) {
	   jj_expentry = new int[jj_endpos];

	   for (int i = 0; i < jj_endpos; i++) {
		 jj_expentry[i] = jj_lasttokens[i];
	   }

	   for (int[] oldentry : jj_expentries) {
		 if (oldentry.length == jj_expentry.length) {
		   boolean isMatched = true;

		   for (int i = 0; i < jj_expentry.length; i++) {
			 if (oldentry[i] != jj_expentry[i]) {
			   isMatched = false;
			   break;
			 }

		   }
		   if (isMatched) {
			 jj_expentries.add(jj_expentry);
			 break;
		   }
		 }
	   }

	   if (pos != 0) {
		 jj_lasttokens[(jj_endpos = pos) - 1] = kind;
	   }
	 }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
	 jj_expentries.clear();
	 boolean[] la1tokens = new boolean[183];
	 if (jj_kind >= 0) {
	   la1tokens[jj_kind] = true;
	   jj_kind = -1;
	 }
	 for (int i = 0; i < 210; i++) {
	   if (jj_la1[i] == jj_gen) {
		 for (int j = 0; j < 32; j++) {
		   if ((jj_la1_0[i] & (1<<j)) != 0) {
			 la1tokens[j] = true;
		   }
		   if ((jj_la1_1[i] & (1<<j)) != 0) {
			 la1tokens[32+j] = true;
		   }
		   if ((jj_la1_2[i] & (1<<j)) != 0) {
			 la1tokens[64+j] = true;
		   }
		   if ((jj_la1_3[i] & (1<<j)) != 0) {
			 la1tokens[96+j] = true;
		   }
		   if ((jj_la1_4[i] & (1<<j)) != 0) {
			 la1tokens[128+j] = true;
		   }
		   if ((jj_la1_5[i] & (1<<j)) != 0) {
			 la1tokens[160+j] = true;
		   }
		 }
	   }
	 }
	 for (int i = 0; i < 183; i++) {
	   if (la1tokens[i]) {
		 jj_expentry = new int[1];
		 jj_expentry[0] = i;
		 jj_expentries.add(jj_expentry);
	   }
	 }
	 jj_endpos = 0;
	 jj_rescan_token();
	 jj_add_error_token(0, 0);
	 int[][] exptokseq = new int[jj_expentries.size()][];
	 for (int i = 0; i < jj_expentries.size(); i++) {
	   exptokseq[i] = jj_expentries.get(i);
	 }
	 return new ParseException(token, exptokseq, tokenImage);
  }

  private boolean trace_enabled;

/** Trace enabled. */
  final public boolean trace_enabled() {
	 return trace_enabled;
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
	 jj_rescan = true;
	 for (int i = 0; i < 25; i++) {
	   try {
		 JJCalls p = jj_2_rtns[i];

		 do {
		   if (p.gen > jj_gen) {
			 jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
			 switch (i) {
			   case 0: jj_3_1(); break;
			   case 1: jj_3_2(); break;
			   case 2: jj_3_3(); break;
			   case 3: jj_3_4(); break;
			   case 4: jj_3_5(); break;
			   case 5: jj_3_6(); break;
			   case 6: jj_3_7(); break;
			   case 7: jj_3_8(); break;
			   case 8: jj_3_9(); break;
			   case 9: jj_3_10(); break;
			   case 10: jj_3_11(); break;
			   case 11: jj_3_12(); break;
			   case 12: jj_3_13(); break;
			   case 13: jj_3_14(); break;
			   case 14: jj_3_15(); break;
			   case 15: jj_3_16(); break;
			   case 16: jj_3_17(); break;
			   case 17: jj_3_18(); break;
			   case 18: jj_3_19(); break;
			   case 19: jj_3_20(); break;
			   case 20: jj_3_21(); break;
			   case 21: jj_3_22(); break;
			   case 22: jj_3_23(); break;
			   case 23: jj_3_24(); break;
			   case 24: jj_3_25(); break;
			 }
		   }
		   p = p.next;
		 } while (p != null);

		 } catch(LookaheadSuccess ls) { }
	 }
	 jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
	 JJCalls p = jj_2_rtns[index];
	 while (p.gen > jj_gen) {
	   if (p.next == null) { p = p.next = new JJCalls(); break; }
	   p = p.next;
	 }

	 p.gen = jj_gen + xla - jj_la; 
	 p.first = token;
	 p.arg = xla;
  }

  static final class JJCalls {
	 int gen;
	 Token first;
	 int arg;
	 JJCalls next;
  }

}
