/*
 * Decompiled with CFR 0.152.
 */
package io.joern.pythonparser;

import io.joern.pythonparser.AstVisitor;
import io.joern.pythonparser.ast.Add$;
import io.joern.pythonparser.ast.Alias;
import io.joern.pythonparser.ast.And$;
import io.joern.pythonparser.ast.AnnAssign;
import io.joern.pythonparser.ast.Arg;
import io.joern.pythonparser.ast.Arguments;
import io.joern.pythonparser.ast.Assert;
import io.joern.pythonparser.ast.Assign;
import io.joern.pythonparser.ast.AsyncFor;
import io.joern.pythonparser.ast.AsyncFunctionDef;
import io.joern.pythonparser.ast.AsyncWith;
import io.joern.pythonparser.ast.Attribute;
import io.joern.pythonparser.ast.AugAssign;
import io.joern.pythonparser.ast.Await;
import io.joern.pythonparser.ast.BinOp;
import io.joern.pythonparser.ast.BitAnd$;
import io.joern.pythonparser.ast.BitOr$;
import io.joern.pythonparser.ast.BitXor$;
import io.joern.pythonparser.ast.BoolConstant;
import io.joern.pythonparser.ast.BoolOp;
import io.joern.pythonparser.ast.Break;
import io.joern.pythonparser.ast.Call;
import io.joern.pythonparser.ast.ClassDef;
import io.joern.pythonparser.ast.Compare;
import io.joern.pythonparser.ast.Comprehension;
import io.joern.pythonparser.ast.Constant;
import io.joern.pythonparser.ast.Continue;
import io.joern.pythonparser.ast.Delete;
import io.joern.pythonparser.ast.Dict;
import io.joern.pythonparser.ast.DictComp;
import io.joern.pythonparser.ast.Div$;
import io.joern.pythonparser.ast.EllipsisConstant$;
import io.joern.pythonparser.ast.Eq$;
import io.joern.pythonparser.ast.ErrorStatement;
import io.joern.pythonparser.ast.ExceptHandler;
import io.joern.pythonparser.ast.Expr;
import io.joern.pythonparser.ast.FloatConstant;
import io.joern.pythonparser.ast.FloorDiv$;
import io.joern.pythonparser.ast.For;
import io.joern.pythonparser.ast.FormattedValue;
import io.joern.pythonparser.ast.FunctionDef;
import io.joern.pythonparser.ast.GeneratorExp;
import io.joern.pythonparser.ast.Global;
import io.joern.pythonparser.ast.Gt$;
import io.joern.pythonparser.ast.GtE$;
import io.joern.pythonparser.ast.If;
import io.joern.pythonparser.ast.IfExp;
import io.joern.pythonparser.ast.ImaginaryConstant;
import io.joern.pythonparser.ast.Import;
import io.joern.pythonparser.ast.ImportFrom;
import io.joern.pythonparser.ast.In$;
import io.joern.pythonparser.ast.IntConstant;
import io.joern.pythonparser.ast.Invert$;
import io.joern.pythonparser.ast.Is$;
import io.joern.pythonparser.ast.IsNot$;
import io.joern.pythonparser.ast.JoinedString;
import io.joern.pythonparser.ast.JoinedStringConstant;
import io.joern.pythonparser.ast.Keyword;
import io.joern.pythonparser.ast.LShift$;
import io.joern.pythonparser.ast.Lambda;
import io.joern.pythonparser.ast.List;
import io.joern.pythonparser.ast.ListComp;
import io.joern.pythonparser.ast.Lt$;
import io.joern.pythonparser.ast.LtE$;
import io.joern.pythonparser.ast.MatMult$;
import io.joern.pythonparser.ast.Match;
import io.joern.pythonparser.ast.MatchAs;
import io.joern.pythonparser.ast.MatchCase;
import io.joern.pythonparser.ast.MatchClass;
import io.joern.pythonparser.ast.MatchMapping;
import io.joern.pythonparser.ast.MatchOr;
import io.joern.pythonparser.ast.MatchSequence;
import io.joern.pythonparser.ast.MatchSingleton;
import io.joern.pythonparser.ast.MatchStar;
import io.joern.pythonparser.ast.MatchValue;
import io.joern.pythonparser.ast.Mod$;
import io.joern.pythonparser.ast.Module;
import io.joern.pythonparser.ast.Mult$;
import io.joern.pythonparser.ast.Name;
import io.joern.pythonparser.ast.NamedExpr;
import io.joern.pythonparser.ast.NoneConstant$;
import io.joern.pythonparser.ast.Nonlocal;
import io.joern.pythonparser.ast.Not$;
import io.joern.pythonparser.ast.NotEq$;
import io.joern.pythonparser.ast.NotIn$;
import io.joern.pythonparser.ast.Or$;
import io.joern.pythonparser.ast.ParamSpec;
import io.joern.pythonparser.ast.Pass;
import io.joern.pythonparser.ast.Pow$;
import io.joern.pythonparser.ast.RShift$;
import io.joern.pythonparser.ast.Raise;
import io.joern.pythonparser.ast.RaiseP2;
import io.joern.pythonparser.ast.Return;
import io.joern.pythonparser.ast.Set;
import io.joern.pythonparser.ast.SetComp;
import io.joern.pythonparser.ast.Slice;
import io.joern.pythonparser.ast.Starred;
import io.joern.pythonparser.ast.StringConstant;
import io.joern.pythonparser.ast.StringExpList;
import io.joern.pythonparser.ast.Sub$;
import io.joern.pythonparser.ast.Subscript;
import io.joern.pythonparser.ast.Try;
import io.joern.pythonparser.ast.Tuple;
import io.joern.pythonparser.ast.TypeAlias;
import io.joern.pythonparser.ast.TypeIgnore;
import io.joern.pythonparser.ast.TypeVar;
import io.joern.pythonparser.ast.TypeVarTuple;
import io.joern.pythonparser.ast.UAdd$;
import io.joern.pythonparser.ast.USub$;
import io.joern.pythonparser.ast.UnaryOp;
import io.joern.pythonparser.ast.While;
import io.joern.pythonparser.ast.With;
import io.joern.pythonparser.ast.Withitem;
import io.joern.pythonparser.ast.Yield;
import io.joern.pythonparser.ast.YieldFrom;
import io.joern.pythonparser.ast.iast;
import io.joern.pythonparser.ast.iboolop;
import io.joern.pythonparser.ast.icompop;
import io.joern.pythonparser.ast.iconstant;
import io.joern.pythonparser.ast.iexpr;
import io.joern.pythonparser.ast.imod;
import io.joern.pythonparser.ast.ioperator;
import io.joern.pythonparser.ast.ipattern;
import io.joern.pythonparser.ast.istmt;
import io.joern.pythonparser.ast.itypeParam;
import io.joern.pythonparser.ast.iunaryop;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List$;
import scala.collection.mutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class AstPrinter
implements AstVisitor<String> {
    private final String indentStr;
    private final String ls;

    public AstPrinter(String indentStr) {
        this.indentStr = indentStr;
        this.ls = "\n";
    }

    public String print(iast astNode) {
        return astNode.accept(this);
    }

    public String printIndented(iast astNode) {
        String printStr = astNode.accept(this);
        return this.indentStr + printStr.replaceAll(this.ls, this.ls + this.indentStr);
    }

    private String printTypeParams(Seq<itypeParam> typeParams) {
        if (typeParams.nonEmpty()) {
            return "[" + ((IterableOnceOps)typeParams.map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + "]";
        }
        return "";
    }

    @Override
    public String visit(iast ast) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(imod mod) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(Module module) {
        return ((IterableOnceOps)module.stmts().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(this.ls);
    }

    @Override
    public String visit(istmt stmt) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(FunctionDef functionDef) {
        return ((IterableOnceOps)functionDef.decorator_list().map((Function1 & Serializable)d -> "@" + this.print((iast)d) + this.ls)).mkString("") + "def " + functionDef.name() + this.printTypeParams(functionDef.type_params()) + "(" + this.print(functionDef.args()) + ")" + functionDef.returns().map((Function1 & Serializable)r -> " -> " + this.print((iast)r)).getOrElse(AstPrinter::visit$$anonfun$4) + ":" + ((IterableOnceOps)functionDef.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(AsyncFunctionDef functionDef) {
        return ((IterableOnceOps)functionDef.decorator_list().map((Function1 & Serializable)d -> "@" + this.print((iast)d) + this.ls)).mkString("") + "async def " + functionDef.name() + this.printTypeParams(functionDef.type_params()) + "(" + this.print(functionDef.args()) + ")" + functionDef.returns().map((Function1 & Serializable)r -> " -> " + this.print((iast)r)).getOrElse(AstPrinter::visit$$anonfun$8) + ":" + ((IterableOnceOps)functionDef.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(ClassDef classDef) {
        String optionArgEndComma = classDef.bases().nonEmpty() && classDef.keywords().nonEmpty() ? ", " : "";
        return ((IterableOnceOps)classDef.decorator_list().map((Function1 & Serializable)d -> "@" + this.print((iast)d) + this.ls)).mkString("") + "class " + classDef.name() + this.printTypeParams(classDef.type_params()) + "(" + ((IterableOnceOps)classDef.bases().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + optionArgEndComma + ((IterableOnceOps)classDef.keywords().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + "):" + ((IterableOnceOps)classDef.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(Return ret) {
        return "return" + ret.value().map((Function1 & Serializable)v -> " " + this.print((iast)v)).getOrElse(AstPrinter::visit$$anonfun$15);
    }

    @Override
    public String visit(Delete delete) {
        return "del " + ((IterableOnceOps)delete.targets().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ");
    }

    @Override
    public String visit(Assign assign) {
        return ((IterableOnceOps)assign.targets().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("", " = ", " = ") + this.print(assign.value());
    }

    @Override
    public String visit(TypeAlias typeAlias) {
        return "type " + this.print(typeAlias.name()) + this.printTypeParams(typeAlias.type_params()) + " = " + this.print(typeAlias.value());
    }

    @Override
    public String visit(AnnAssign annAssign) {
        return this.print(annAssign.target()) + ": " + this.print(annAssign.annotation()) + annAssign.value().map((Function1 & Serializable)v -> " = " + this.print((iast)v)).getOrElse(AstPrinter::visit$$anonfun$19);
    }

    @Override
    public String visit(AugAssign augAssign) {
        return this.print(augAssign.target()) + " " + this.print(augAssign.op()) + "= " + this.print(augAssign.value());
    }

    @Override
    public String visit(For forStmt) {
        return "for " + this.print(forStmt.target()) + " in " + this.print(forStmt.iter()) + ":" + ((IterableOnceOps)forStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") + (String)(forStmt.orelse().nonEmpty() ? this.ls + "else:" + ((IterableOnceOps)forStmt.orelse().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") : "");
    }

    @Override
    public String visit(AsyncFor forStmt) {
        return "async for " + this.print(forStmt.target()) + " in " + this.print(forStmt.iter()) + ":" + ((IterableOnceOps)forStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") + (String)(forStmt.orelse().nonEmpty() ? this.ls + "else:" + ((IterableOnceOps)forStmt.orelse().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") : "");
    }

    @Override
    public String visit(While whileStmt) {
        return "while " + this.print(whileStmt.test()) + ":" + ((IterableOnceOps)whileStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") + (String)(whileStmt.orelse().nonEmpty() ? this.ls + "else:" + ((IterableOnceOps)whileStmt.orelse().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") : "");
    }

    @Override
    public String visit(If ifStmt) {
        int n = ifStmt.orelse().size();
        String elseString = 0 == n ? "" : (1 == n && ifStmt.orelse().head() instanceof If ? this.ls + "el" + this.print((iast)ifStmt.orelse().head()) : this.ls + "else:" + ((IterableOnceOps)ifStmt.orelse().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, ""));
        return "if " + this.print(ifStmt.test()) + ":" + ((IterableOnceOps)ifStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") + elseString;
    }

    @Override
    public String visit(With withStmt) {
        return "with " + ((IterableOnceOps)withStmt.items().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + ":" + ((IterableOnceOps)withStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(AsyncWith withStmt) {
        return "async with " + ((IterableOnceOps)withStmt.items().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + ":" + ((IterableOnceOps)withStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(Match matchStmt) {
        iexpr iexpr2 = matchStmt.subject();
        String subjectSuffix = iexpr2 instanceof Starred ? "," : "";
        return "match " + this.print(matchStmt.subject()) + subjectSuffix + ":" + ((IterableOnceOps)matchStmt.cases().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(Raise raise) {
        return "raise" + raise.exc().map((Function1 & Serializable)e -> " " + this.print((iast)e)).getOrElse(AstPrinter::visit$$anonfun$33) + raise.cause().map((Function1 & Serializable)c -> " from " + this.print((iast)c)).getOrElse(AstPrinter::visit$$anonfun$35);
    }

    @Override
    public String visit(Try tryStmt) {
        String elseString = tryStmt.orelse().nonEmpty() ? this.ls + "else:" + ((IterableOnceOps)tryStmt.orelse().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") : "";
        String finallyString = tryStmt.finalbody().nonEmpty() ? this.ls + "finally:" + ((IterableOnceOps)tryStmt.finalbody().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") : "";
        String handlersString = tryStmt.handlers().nonEmpty() ? ((IterableOnceOps)tryStmt.handlers().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(this.ls, this.ls, "") : "";
        return "try:" + ((IterableOnceOps)tryStmt.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "") + handlersString + elseString + finallyString;
    }

    @Override
    public String visit(Assert assert_) {
        return "assert " + this.print(assert_.test()) + assert_.msg().map((Function1 & Serializable)m -> ", " + this.print((iast)m)).getOrElse(AstPrinter::visit$$anonfun$38);
    }

    @Override
    public String visit(Import importStmt) {
        return "import " + ((IterableOnceOps)importStmt.names().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ");
    }

    @Override
    public String visit(ImportFrom importFrom) {
        String relativeImportDots = importFrom.level() != 0 ? " " + StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("."), importFrom.level()) : "";
        return "from" + relativeImportDots + importFrom.module().map((Function1 & Serializable)m -> " " + m).getOrElse(AstPrinter::visit$$anonfun$41) + " import " + ((IterableOnceOps)importFrom.names().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ");
    }

    @Override
    public String visit(Global global) {
        return "global " + global.names().mkString(", ");
    }

    @Override
    public String visit(Nonlocal nonlocal) {
        return "nonlocal " + nonlocal.names().mkString(", ");
    }

    @Override
    public String visit(Expr expr) {
        return this.print(expr.value());
    }

    @Override
    public String visit(Pass pass) {
        return "pass";
    }

    @Override
    public String visit(Break break_) {
        return "break";
    }

    @Override
    public String visit(Continue continue_) {
        return "continue";
    }

    @Override
    public String visit(RaiseP2 raise) {
        return "raise" + raise.typ().map((Function1 & Serializable)t -> " " + this.print((iast)t)).getOrElse(AstPrinter::visit$$anonfun$44) + raise.inst().map((Function1 & Serializable)i -> ", " + this.print((iast)i)).getOrElse(AstPrinter::visit$$anonfun$46) + raise.tback().map((Function1 & Serializable)t -> ", " + this.print((iast)t)).getOrElse(AstPrinter::visit$$anonfun$48);
    }

    @Override
    public String visit(ErrorStatement errorStmt) {
        return "<error>";
    }

    @Override
    public String visit(iexpr expr) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(BoolOp boolOp) {
        String opString = " " + this.print(boolOp.op()) + " ";
        return ((IterableOnceOps)boolOp.values().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(opString);
    }

    @Override
    public String visit(NamedExpr namedExpr) {
        return this.print(namedExpr.target()) + " := " + this.print(namedExpr.value());
    }

    @Override
    public String visit(BinOp binOp) {
        return this.print(binOp.left()) + " " + this.print(binOp.op()) + " " + this.print(binOp.right());
    }

    @Override
    public String visit(UnaryOp unaryOp) {
        iunaryop iunaryop2 = unaryOp.op();
        Object opString = Not$.MODULE$.equals(iunaryop2) ? this.print(unaryOp.op()) + " " : this.print(unaryOp.op());
        return (String)opString + this.print(unaryOp.operand());
    }

    @Override
    public String visit(Lambda lambda) {
        String argStr = this.print(lambda.args());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(argStr))) {
            return "lambda " + argStr + ": " + this.print(lambda.body());
        }
        return "lambda: " + this.print(lambda.body());
    }

    @Override
    public String visit(IfExp ifExp) {
        return this.print(ifExp.body()) + " if " + this.print(ifExp.test()) + " else " + this.print(ifExp.orelse());
    }

    @Override
    public String visit(Dict dict) {
        return "{" + ((IterableOnceOps)((IterableOps)dict.keys().zip(dict.values())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option key = (Option)tuple2._1();
                iexpr value = (iexpr)tuple2._2();
                Option option = key;
                if (option instanceof Some) {
                    iexpr k = (iexpr)((Some)option).value();
                    return this.print(k) + ":" + this.print(value);
                }
                if (None$.MODULE$.equals(option)) {
                    return "**" + this.print(value);
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ") + "}";
    }

    @Override
    public String visit(Set set) {
        return "{" + ((IterableOnceOps)set.elts().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + "}";
    }

    @Override
    public String visit(ListComp listComp) {
        return "[" + this.print(listComp.elt()) + ((IterableOnceOps)listComp.generators().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("") + "]";
    }

    @Override
    public String visit(SetComp setComp) {
        return "{" + this.print(setComp.elt()) + ((IterableOnceOps)setComp.generators().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("") + "}";
    }

    @Override
    public String visit(DictComp dictComp) {
        return "{" + this.print(dictComp.key()) + ":" + this.print(dictComp.value()) + ((IterableOnceOps)dictComp.generators().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("") + "}";
    }

    @Override
    public String visit(GeneratorExp generatorExp) {
        return "(" + this.print(generatorExp.elt()) + ((IterableOnceOps)generatorExp.generators().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("") + ")";
    }

    @Override
    public String visit(Await await) {
        return "await " + this.print(await.value());
    }

    @Override
    public String visit(Yield yieldExpr) {
        return "yield" + yieldExpr.value().map((Function1 & Serializable)v -> " " + this.print((iast)v)).getOrElse(AstPrinter::visit$$anonfun$57);
    }

    @Override
    public String visit(YieldFrom yieldFrom) {
        return "yield from " + this.print(yieldFrom.value());
    }

    @Override
    public String visit(Compare compare) {
        return this.print(compare.left()) + ((IterableOnceOps)((IterableOps)compare.ops().zip(compare.comparators())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                icompop op = (icompop)tuple2._1();
                iexpr comparator = (iexpr)tuple2._2();
                return " " + this.print(op) + " " + this.print(comparator);
            }
            throw new MatchError((Object)tuple2);
        })).mkString("");
    }

    @Override
    public String visit(Call call) {
        if (call.args().size() == 1 && call.args().head() instanceof GeneratorExp) {
            return this.print(call.func()) + this.print((iast)call.args().head());
        }
        String optionArgEndComma = call.args().nonEmpty() && call.keywords().nonEmpty() ? ", " : "";
        return this.print(call.func()) + "(" + ((IterableOnceOps)call.args().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + optionArgEndComma + ((IterableOnceOps)call.keywords().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + ")";
    }

    @Override
    public String visit(FormattedValue formattedValue) {
        Object object;
        String string;
        String equalSignStr = formattedValue.equalSign() ? "=" : "";
        int n = formattedValue.conversion();
        switch (n) {
            case -1: {
                string = "";
                break;
            }
            case 115: {
                string = "!s";
                break;
            }
            case 114: {
                string = "!r";
                break;
            }
            case 97: {
                string = "!a";
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
        }
        String conversionStr = string;
        Option<String> option = formattedValue.format_spec();
        if (option instanceof Some) {
            String formatSpec = (String)((Some)option).value();
            object = ":" + formatSpec;
        } else if (None$.MODULE$.equals(option)) {
            object = "";
        } else {
            throw new MatchError(option);
        }
        Object formatSpecStr = object;
        return "{" + this.print(formattedValue.value()) + equalSignStr + conversionStr + (String)formatSpecStr + "}";
    }

    @Override
    public String visit(JoinedString joinedString) {
        return joinedString.prefix() + joinedString.quote() + ((IterableOnceOps)joinedString.values().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("") + joinedString.quote();
    }

    @Override
    public String visit(Constant constant) {
        return this.print(constant.value());
    }

    @Override
    public String visit(Attribute attribute) {
        return this.print(attribute.value()) + "." + attribute.attr();
    }

    @Override
    public String visit(Subscript subscript) {
        return this.print(subscript.value()) + "[" + this.print(subscript.slice()) + "]";
    }

    @Override
    public String visit(Starred starred) {
        return "*" + this.print(starred.value());
    }

    @Override
    public String visit(Name name) {
        return name.id();
    }

    @Override
    public String visit(List list) {
        return "[" + ((IterableOnceOps)list.elts().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + "]";
    }

    @Override
    public String visit(Tuple tuple) {
        if (tuple.elts().size() == 1) {
            return "(" + this.print((iast)tuple.elts().head()) + ",)";
        }
        return "(" + ((IterableOnceOps)tuple.elts().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(",") + ")";
    }

    @Override
    public String visit(Slice slice) {
        return (String)slice.lower().map((Function1 & Serializable)astNode -> this.print((iast)astNode)).getOrElse(AstPrinter::visit$$anonfun$65) + ":" + slice.upper().map((Function1 & Serializable)astNode -> this.print((iast)astNode)).getOrElse(AstPrinter::visit$$anonfun$67) + slice.step().map((Function1 & Serializable)expr -> ":" + this.print((iast)expr)).getOrElse(AstPrinter::visit$$anonfun$69);
    }

    @Override
    public String visit(StringExpList stringExpList) {
        return ((IterableOnceOps)stringExpList.elts().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(" ");
    }

    @Override
    public String visit(Alias alias) {
        return alias.name() + alias.asName().map((Function1 & Serializable)n -> " as " + n).getOrElse(AstPrinter::visit$$anonfun$72);
    }

    @Override
    public String visit(iboolop boolop) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(And$ and) {
        return "and";
    }

    @Override
    public String visit(Or$ or) {
        return "or";
    }

    @Override
    public String visit(icompop compop) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(Eq$ eq) {
        return "==";
    }

    @Override
    public String visit(NotEq$ noteq) {
        return "!=";
    }

    @Override
    public String visit(Lt$ lt) {
        return "<";
    }

    @Override
    public String visit(LtE$ ltE) {
        return "<=";
    }

    @Override
    public String visit(Gt$ gt) {
        return ">";
    }

    @Override
    public String visit(GtE$ gtE) {
        return ">=";
    }

    @Override
    public String visit(Is$ is) {
        return "is";
    }

    @Override
    public String visit(IsNot$ isNot) {
        return "is not";
    }

    @Override
    public String visit(In$ in) {
        return "in";
    }

    @Override
    public String visit(NotIn$ notIn) {
        return "not in";
    }

    @Override
    public String visit(iconstant constant) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(StringConstant stringConstant) {
        return stringConstant.prefix() + stringConstant.quote() + stringConstant.value() + stringConstant.quote();
    }

    @Override
    public String visit(JoinedStringConstant joinedStringConstant) {
        return joinedStringConstant.value();
    }

    @Override
    public String visit(BoolConstant boolConstant) {
        if (boolConstant.value()) {
            return "True";
        }
        return "False";
    }

    @Override
    public String visit(IntConstant intConstant) {
        return intConstant.value();
    }

    @Override
    public String visit(FloatConstant floatConstant) {
        return floatConstant.value();
    }

    @Override
    public String visit(ImaginaryConstant imaginaryConstant) {
        return imaginaryConstant.value();
    }

    @Override
    public String visit(NoneConstant$ noneConstant) {
        return "None";
    }

    @Override
    public String visit(EllipsisConstant$ ellipsisConstant) {
        return "...";
    }

    @Override
    public String visit(ExceptHandler exceptHandler) {
        return "except" + exceptHandler.typ().map((Function1 & Serializable)t -> " " + this.print((iast)t)).getOrElse(AstPrinter::visit$$anonfun$74) + exceptHandler.name().map((Function1 & Serializable)n -> " as " + n).getOrElse(AstPrinter::visit$$anonfun$76) + ":" + ((IterableOnceOps)exceptHandler.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(Keyword keyword) {
        Option<String> option = keyword.arg();
        if (option instanceof Some) {
            String argName = (String)((Some)option).value();
            return argName + " = " + this.print(keyword.value());
        }
        if (None$.MODULE$.equals(option)) {
            return "**" + this.print(keyword.value());
        }
        throw new MatchError(option);
    }

    @Override
    public String visit(ioperator operator) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(Add$ add) {
        return "+";
    }

    @Override
    public String visit(Sub$ sub) {
        return "-";
    }

    @Override
    public String visit(Mult$ mult) {
        return "*";
    }

    @Override
    public String visit(MatMult$ matMult) {
        return "@";
    }

    @Override
    public String visit(Div$ div) {
        return "/";
    }

    @Override
    public String visit(Mod$ mod) {
        return "%";
    }

    @Override
    public String visit(Pow$ pow) {
        return "**";
    }

    @Override
    public String visit(LShift$ lShift) {
        return "<<";
    }

    @Override
    public String visit(RShift$ rShift) {
        return ">>";
    }

    @Override
    public String visit(BitOr$ bitOr) {
        return "|";
    }

    @Override
    public String visit(BitXor$ bitXor) {
        return "^";
    }

    @Override
    public String visit(BitAnd$ bitAnd) {
        return "&";
    }

    @Override
    public String visit(FloorDiv$ floorDiv) {
        return "//";
    }

    @Override
    public String visit(iunaryop unaryop) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public String visit(Invert$ invert) {
        return "~";
    }

    @Override
    public String visit(Not$ not) {
        return "not";
    }

    @Override
    public String visit(UAdd$ uAdd) {
        return "+";
    }

    @Override
    public String visit(USub$ uSub) {
        return "-";
    }

    @Override
    public String visit(Arg arg) {
        return arg.arg() + arg.annotation().map((Function1 & Serializable)a -> ": " + this.print((iast)a)).getOrElse(AstPrinter::visit$$anonfun$79);
    }

    @Override
    public String visit(Arguments arguments) {
        Option<Arg> option;
        ObjectRef result = ObjectRef.create((Object)"");
        ObjectRef separatorString = ObjectRef.create((Object)"");
        int combinedPosArgSize = arguments.posonlyargs().size() + arguments.args().size();
        scala.collection.immutable.List defaultArgs = (scala.collection.immutable.List)List$.MODULE$.fill(combinedPosArgSize - arguments.defaults().size(), AstPrinter::$anonfun$5).$plus$plus((IterableOnce)arguments.defaults().map((Function1 & Serializable)x -> Option$.MODULE$.apply(x)));
        if (arguments.posonlyargs().nonEmpty()) {
            Object object;
            String posOnlyArgsString = ((IterableOnceOps)((IterableOps)arguments.posonlyargs().zip((IterableOnce)defaultArgs)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Arg arg = (Arg)tuple2._1();
                    Option defaultOption = (Option)tuple2._2();
                    return this.print(arg) + defaultOption.map((Function1 & Serializable)d -> " = " + this.print((iast)d)).getOrElse(AstPrinter::$anonfun$7$$anonfun$2);
                }
                throw new MatchError((Object)tuple2);
            })).mkString("", ", ", ", /");
            result.elem = object = (String)result.elem + posOnlyArgsString;
            object = null;
            String string = ", ";
            separatorString.elem = string;
            string = null;
        }
        if (arguments.args().nonEmpty()) {
            Object object;
            scala.collection.immutable.List defaultsForArgs = (scala.collection.immutable.List)defaultArgs.drop(arguments.posonlyargs().size());
            String argsString = ((IterableOnceOps)((IterableOps)arguments.args().zip((IterableOnce)defaultsForArgs)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Arg arg = (Arg)tuple2._1();
                    Option defaultOption = (Option)tuple2._2();
                    return this.print(arg) + defaultOption.map((Function1 & Serializable)d -> " = " + this.print((iast)d)).getOrElse(AstPrinter::$anonfun$8$$anonfun$2);
                }
                throw new MatchError((Object)tuple2);
            })).mkString((String)separatorString.elem, ", ", "");
            result.elem = object = (String)result.elem + argsString;
            object = null;
            String string = ", ";
            separatorString.elem = string;
            string = null;
        }
        if ((option = arguments.vararg()) instanceof Some) {
            Object object;
            Object object2;
            Arg v = (Arg)((Some)option).value();
            result.elem = object2 = (String)result.elem + (String)separatorString.elem;
            object2 = null;
            result.elem = object = (String)result.elem + ("*" + this.print(v));
            object = null;
            String string = ", ";
            separatorString.elem = string;
            string = null;
        } else if (None$.MODULE$.equals(option)) {
            if (arguments.kwonlyargs().nonEmpty()) {
                Object object;
                Object object3;
                result.elem = object3 = (String)result.elem + (String)separatorString.elem;
                object3 = null;
                result.elem = object = (String)result.elem + "*";
                object = null;
                String string = ", ";
                separatorString.elem = string;
                string = null;
            }
        } else {
            throw new MatchError(option);
        }
        if (arguments.kwonlyargs().nonEmpty()) {
            Object object;
            String kwOnlyArgsString = ((IterableOnceOps)((IterableOps)arguments.kwonlyargs().zip(arguments.kw_defaults())).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Arg arg = (Arg)tuple2._1();
                    Option defaultOption = (Option)tuple2._2();
                    return this.print(arg) + defaultOption.map((Function1 & Serializable)d -> " = " + this.print((iast)d)).getOrElse(AstPrinter::$anonfun$9$$anonfun$2);
                }
                throw new MatchError((Object)tuple2);
            })).mkString((String)separatorString.elem, ", ", "");
            result.elem = object = (String)result.elem + kwOnlyArgsString;
            object = null;
            String string = ", ";
            separatorString.elem = string;
            string = null;
        }
        arguments.kw_arg().foreach((Function1)(JProcedure1 & Serializable)k -> {
            Object object;
            Object object2;
            result$1.elem = object2 = (String)result$1.elem + (String)separatorString$1.elem;
            object2 = null;
            result$1.elem = object = (String)result$1.elem + ("**" + this.print((iast)k));
            object = null;
        });
        return (String)result.elem;
    }

    @Override
    public String visit(Withitem withItem) {
        return this.print(withItem.context_expr()) + withItem.optional_vars().map((Function1 & Serializable)o -> " as " + this.print((iast)o)).getOrElse(AstPrinter::visit$$anonfun$82);
    }

    @Override
    public String visit(MatchCase matchCase) {
        return "case " + this.print(matchCase.pattern()) + matchCase.guard().map((Function1 & Serializable)g -> " if " + this.print((iast)g)).getOrElse(AstPrinter::visit$$anonfun$84) + ":" + ((IterableOnceOps)matchCase.body().map((Function1 & Serializable)astNode -> this.printIndented((iast)astNode))).mkString(this.ls, this.ls, "");
    }

    @Override
    public String visit(MatchValue matchValue) {
        return this.print(matchValue.value());
    }

    @Override
    public String visit(MatchSingleton matchSingleton) {
        return this.print(matchSingleton.value());
    }

    @Override
    public String visit(MatchSequence matchSequence) {
        return ((IterableOnceOps)matchSequence.patterns().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString("[", ", ", "]");
    }

    @Override
    public String visit(MatchMapping matchMapping) {
        return "{" + ((IterableOnceOps)((IterableOps)matchMapping.keys().zip(matchMapping.patterns())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                iexpr key = (iexpr)tuple2._1();
                ipattern pattern = (ipattern)tuple2._2();
                return this.print(key) + ": " + this.print(pattern);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ") + matchMapping.rest().map((Function1 & Serializable)r -> {
            String separatorString = matchMapping.keys().nonEmpty() ? ", " : "";
            return separatorString + "**" + r;
        }).getOrElse(AstPrinter::visit$$anonfun$89) + "}";
    }

    @Override
    public String visit(MatchClass matchClass) {
        String separatorString = matchClass.patterns().nonEmpty() && matchClass.kwd_patterns().nonEmpty() ? ", " : "";
        return this.print(matchClass.cls()) + "(" + ((IterableOnceOps)matchClass.patterns().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(", ") + separatorString + ((IterableOnceOps)((IterableOps)matchClass.kwd_attrs().zip(matchClass.kwd_patterns())).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                ipattern pattern = (ipattern)tuple2._2();
                return name + " = " + this.print(pattern);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(", ") + ")";
    }

    @Override
    public String visit(MatchStar matchStar) {
        return "*" + matchStar.name().getOrElse(AstPrinter::visit$$anonfun$92);
    }

    @Override
    public String visit(MatchAs matchAs) {
        Option<ipattern> option = matchAs.pattern();
        if (option instanceof Some) {
            ipattern pattern = (ipattern)((Some)option).value();
            return this.print(pattern) + matchAs.name().map((Function1 & Serializable)name -> " as " + name).getOrElse(AstPrinter::visit$$anonfun$94);
        }
        if (None$.MODULE$.equals(option)) {
            return (String)matchAs.name().getOrElse(AstPrinter::visit$$anonfun$95);
        }
        throw new MatchError(option);
    }

    @Override
    public String visit(MatchOr matchOr) {
        return ((IterableOnceOps)matchOr.patterns().map((Function1 & Serializable)astNode -> this.print((iast)astNode))).mkString(" | ");
    }

    @Override
    public String visit(Comprehension comprehension) {
        String prefix = comprehension.is_async() ? " async for " : " for ";
        return prefix + this.print(comprehension.target()) + " in " + this.print(comprehension.iter()) + ((IterableOnceOps)comprehension.ifs().map((Function1 & Serializable)i -> " if " + this.print((iast)i))).mkString("");
    }

    @Override
    public String visit(TypeIgnore typeIgnore) {
        return typeIgnore.tag();
    }

    @Override
    public String visit(TypeVar typeVar) {
        return typeVar.name() + typeVar.bound().map((Function1 & Serializable)b -> ": " + this.print((iast)b)).getOrElse(AstPrinter::visit$$anonfun$99);
    }

    @Override
    public String visit(ParamSpec paramSpec) {
        return "**" + paramSpec.name();
    }

    @Override
    public String visit(TypeVarTuple typeVarTuple) {
        return "*" + typeVarTuple.name();
    }

    private static final String visit$$anonfun$4() {
        return "";
    }

    private static final String visit$$anonfun$8() {
        return "";
    }

    private static final String visit$$anonfun$15() {
        return "";
    }

    private static final String visit$$anonfun$19() {
        return "";
    }

    private static final String visit$$anonfun$33() {
        return "";
    }

    private static final String visit$$anonfun$35() {
        return "";
    }

    private static final String visit$$anonfun$38() {
        return "";
    }

    private static final String visit$$anonfun$41() {
        return "";
    }

    private static final String visit$$anonfun$44() {
        return "";
    }

    private static final String visit$$anonfun$46() {
        return "";
    }

    private static final String visit$$anonfun$48() {
        return "";
    }

    private static final String visit$$anonfun$57() {
        return "";
    }

    private static final String visit$$anonfun$65() {
        return "";
    }

    private static final String visit$$anonfun$67() {
        return "";
    }

    private static final String visit$$anonfun$69() {
        return "";
    }

    private static final String visit$$anonfun$72() {
        return "";
    }

    private static final String visit$$anonfun$74() {
        return "";
    }

    private static final String visit$$anonfun$76() {
        return "";
    }

    private static final String visit$$anonfun$79() {
        return "";
    }

    private static final None$ $anonfun$5() {
        return None$.MODULE$;
    }

    private static final String $anonfun$7$$anonfun$2() {
        return "";
    }

    private static final String $anonfun$8$$anonfun$2() {
        return "";
    }

    private static final String $anonfun$9$$anonfun$2() {
        return "";
    }

    private static final String visit$$anonfun$82() {
        return "";
    }

    private static final String visit$$anonfun$84() {
        return "";
    }

    private static final String visit$$anonfun$89() {
        return "";
    }

    private static final String visit$$anonfun$92() {
        return "_";
    }

    private static final String visit$$anonfun$94() {
        return "";
    }

    private static final String visit$$anonfun$95() {
        return "_";
    }

    private static final String visit$$anonfun$99() {
        return "";
    }
}

