/*
 * Decompiled with CFR 0.152.
 */
package io.joern.pysrc2cpg;

import io.joern.pysrc2cpg.Py2Cpg;
import io.joern.pysrc2cpg.Py2Cpg$InputPair$;
import io.joern.pysrc2cpg.Py2CpgOnFileSystemConfig;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure2;
import scala.util.Try;

public class Py2CpgOnFileSystem
implements X2CpgFrontend<Py2CpgOnFileSystemConfig> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Try<Cpg> createCpg(Py2CpgOnFileSystemConfig config) {
        this.logConfiguration(config);
        return X2Cpg$.MODULE$.withNewEmptyCpg(config.outputPath(), (X2CpgConfig)config, (Function2)(JProcedure2 & Serializable)(cpg, _$1) -> {
            Nil$ venvIgnorePath = config.ignoreVenvDir() ? (List)config.venvDir().toList().$plus$plus(config.venvDirs()) : package$.MODULE$.Nil();
            Path inputPath = Path.of(config.inputPath(), new String[0]);
            Set ignoreDirNamesSet = config.ignoreDirNames().toSet();
            Seq absoluteIgnorePaths = (Seq)((IterableOps)config.ignorePaths().$plus$plus((IterableOnce)venvIgnorePath)).map((Function1 & Serializable)x$0 -> inputPath.resolve((Path)x$0));
            String string = config.inputPath();
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".py"}));
            Option option = Option$.MODULE$.apply((Object)config.ignoredFilesRegex());
            Option option2 = Option$.MODULE$.apply((Object)config.ignoredFiles());
            Option option3 = SourceFiles$.MODULE$.determine$default$3();
            List inputFiles = SourceFiles$.MODULE$.determine(string, set, option3, option, option2, SourceFiles$.MODULE$.determine$default$6(string, set, option3, option, option2)).map((Function1 & Serializable)x -> Path.of(x, new String[0])).filterNot((Function1 & Serializable)file -> this.isAutoDetectedVenv(config, (Path)file, inputPath) || this.isIgnoredDir((Path)file, inputPath, (Set<String>)ignoreDirNamesSet) || this.isInIgnoredAbsolutePaths((Path)file, (Seq<Path>)absoluteIgnorePaths));
            List inputProviders = inputFiles.map((Function1 & Serializable)inputFile -> (Function0 & Serializable)() -> {
                String content = IOUtils$.MODULE$.readEntireFile(inputFile);
                return Py2Cpg$InputPair$.MODULE$.apply(content, inputPath.relativize((Path)inputFile).toString());
            });
            Py2Cpg py2Cpg = new Py2Cpg((Iterable<Function0<Py2Cpg.InputPair>>)inputProviders, (Cpg)cpg, config.inputPath(), config.requirementsTxt(), config.schemaValidation(), !config.disableFileContent());
            py2Cpg.buildCpg();
        });
    }

    private boolean isInIgnoredAbsolutePaths(Path file, Seq<Path> absoluteIgnorePaths) {
        return absoluteIgnorePaths.exists((Function1 & Serializable)ignorePath -> file.startsWith((Path)ignorePath));
    }

    private List<Path> elementsOfPath(Path path) {
        List elements = CollectionConverters$.MODULE$.IteratorHasAsScala(path.iterator()).asScala().toList();
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return (List)elements.dropRight(1);
        }
        return elements;
    }

    private boolean isAutoDetectedVenv(Py2CpgOnFileSystemConfig config, Path file, Path inputPath) {
        if (!config.ignoreVenvDir() || config.venvDirs().nonEmpty() || config.venvDir().isDefined()) {
            return false;
        }
        return this.elementsOfPath(inputPath.relativize(file)).exists((Function1 & Serializable)_$2 -> inputPath.resolve((Path)_$2).resolve("pyvenv.cfg").toFile().exists());
    }

    private boolean isIgnoredDir(Path file, Path inputPath, Set<String> ignoreDirNamesSet) {
        return this.elementsOfPath(inputPath.relativize(file)).exists((Function1 & Serializable)dir -> ignoreDirNamesSet.contains((Object)dir.toString()));
    }

    private void logConfiguration(Py2CpgOnFileSystemConfig config) {
        this.logger.info("Output file: " + config.outputPath());
        this.logger.info("Input directory: " + config.inputPath());
        this.logger.info("Venv directories: " + ((IterableOnceOps)config.venvDir().toList().$plus$plus(config.venvDirs())).mkString(", "));
        this.logger.info("IgnoreVenvDir: " + config.ignoreVenvDir());
        this.logger.info("IgnorePaths: " + config.ignorePaths().mkString(", "));
        this.logger.info("IgnoreDirNames: " + config.ignoreDirNames().mkString(", "));
        this.logger.info("No dummy types: " + config.disableDummyTypes());
    }
}

