/*
 * Decompiled with CFR 0.152.
 */
package io.joern.pythonparser;

import io.joern.pythonparser.CharStream;
import io.joern.pythonparser.CharStreamImpl$;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import scala.Array$;
import scala.Predef$;

public class CharStreamImpl
implements CharStream {
    private final int minimumReadSize;
    private final InputStreamReader inputReader;
    private char[] inputBuffer;
    private int[] posToLine;
    private int[] posToColumn;
    private int readPos;
    private int writePos;
    private int tokenBeginPos;
    private int inputBufferOffset;
    private int tabSize;

    public CharStreamImpl(InputStream inputStream, int inputBufferSize, int minimumReadSize) {
        this.minimumReadSize = minimumReadSize;
        this.inputReader = new InputStreamReader(inputStream);
        this.inputBuffer = new char[inputBufferSize];
        this.posToLine = new int[inputBufferSize];
        this.posToColumn = new int[inputBufferSize];
        this.readPos = 1;
        this.writePos = 1;
        this.tokenBeginPos = 1;
        this.inputBufferOffset = 0;
        this.tabSize = 1;
        this.inputBuffer[0] = 97;
        this.posToLine[0] = 1;
        this.posToColumn[0] = 0;
    }

    public CharStreamImpl(InputStream inputStream) {
        this(inputStream, CharStreamImpl$.io$joern$pythonparser$CharStreamImpl$$$defaultInputBufferSize, CharStreamImpl$.io$joern$pythonparser$CharStreamImpl$$$defaultMinimumReadSize);
    }

    public int getBeginPos() {
        return this.inputBufferOffset + this.tokenBeginPos - 1;
    }

    private void fillBuffer() {
        if (this.readPos == this.writePos) {
            int charsRed;
            if (this.writePos == this.inputBuffer.length) {
                int keepStartPos = this.tokenBeginPos - 1;
                int charsToKeep = this.writePos - keepStartPos;
                if (this.inputBuffer.length - charsToKeep < this.minimumReadSize) {
                    int newBufferLen = charsToKeep + this.minimumReadSize;
                    char[] newInputBuffer = new char[newBufferLen];
                    Array$.MODULE$.copy((Object)this.inputBuffer, keepStartPos, (Object)newInputBuffer, 0, charsToKeep);
                    this.inputBuffer = newInputBuffer;
                    int[] newPosToLine = new int[newBufferLen];
                    Array$.MODULE$.copy((Object)this.posToLine, keepStartPos, (Object)newPosToLine, 0, charsToKeep);
                    this.posToLine = newPosToLine;
                    int[] newPosToColumn = new int[newBufferLen];
                    Array$.MODULE$.copy((Object)this.posToColumn, keepStartPos, (Object)newPosToColumn, 0, charsToKeep);
                    this.posToColumn = newPosToColumn;
                } else {
                    Array$.MODULE$.copy((Object)this.inputBuffer, keepStartPos, (Object)this.inputBuffer, 0, charsToKeep);
                    Array$.MODULE$.copy((Object)this.posToLine, keepStartPos, (Object)this.posToLine, 0, charsToKeep);
                    Array$.MODULE$.copy((Object)this.posToColumn, keepStartPos, (Object)this.posToColumn, 0, charsToKeep);
                }
                this.writePos = charsToKeep;
                this.readPos -= keepStartPos;
                this.inputBufferOffset += keepStartPos;
                this.tokenBeginPos = 1;
            }
            if ((charsRed = this.inputReader.read(this.inputBuffer, this.writePos, this.inputBuffer.length - this.writePos)) != -1) {
                this.writePos += charsRed;
                return;
            }
            throw new IOException();
        }
    }

    private int lastRedPos() {
        return this.readPos - 1;
    }

    private void updateLineAndColumn(int pos, char c, char prevChar) {
        boolean newLine;
        char c2 = prevChar;
        boolean bl = '\n' == c2 ? true : ('\r' == c2 ? c != '\n' : (newLine = false));
        if (newLine) {
            this.posToLine[pos] = this.posToLine[pos - 1] + 1;
            this.posToColumn[pos] = 1;
        } else {
            this.posToLine[pos] = this.posToLine[pos - 1];
            this.posToColumn[pos] = this.posToColumn[pos - 1] + 1;
        }
        if (c == '\t') {
            int[] nArray = this.posToColumn;
            nArray[pos] = nArray[pos] + (-1 + (this.tabSize - this.posToColumn[pos] % this.tabSize));
            return;
        }
    }

    @Override
    public char readChar() {
        this.fillBuffer();
        char c = this.inputBuffer[this.readPos];
        char prevChar = this.inputBuffer[this.lastRedPos()];
        this.updateLineAndColumn(this.readPos, c, prevChar);
        ++this.readPos;
        return c;
    }

    @Override
    public int getColumn() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public int getLine() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public int getEndColumn() {
        return this.posToColumn[this.lastRedPos()];
    }

    @Override
    public int getEndLine() {
        return this.posToLine[this.lastRedPos()];
    }

    @Override
    public int getBeginColumn() {
        return this.posToColumn[this.tokenBeginPos];
    }

    @Override
    public int getBeginLine() {
        return this.posToLine[this.tokenBeginPos];
    }

    @Override
    public void backup(int amount) {
        this.readPos -= amount;
    }

    @Override
    public char BeginToken() {
        this.tokenBeginPos = this.readPos;
        return this.readChar();
    }

    @Override
    public String GetImage() {
        return new String(this.inputBuffer, this.tokenBeginPos, this.readPos - this.tokenBeginPos);
    }

    @Override
    public char[] GetSuffix(int len) {
        char[] suffix = new char[len];
        Array$.MODULE$.copy((Object)this.inputBuffer, this.readPos - len, (Object)suffix, 0, len);
        return suffix;
    }

    @Override
    public void Done() {
        this.inputReader.close();
    }

    @Override
    public void setTabSize(int i) {
        this.tabSize = i;
    }

    @Override
    public int getTabSize() {
        return this.tabSize;
    }

    @Override
    public boolean getTrackLineColumn() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void setTrackLineColumn(boolean trackLineColumn) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }
}

