/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg;

import io.joern.php2cpg.Config;
import io.joern.php2cpg.passes.AstCreationPass;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.TypeNodePass;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.joern.x2cpg.utils.ExternalCommand$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.runtime.function.JProcedure2;
import scala.util.Failure$;
import scala.util.Try;

public class Php2Cpg
implements X2CpgFrontend<Config> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private boolean isPhpInstalled() {
        return ExternalCommand$.MODULE$.run("php --version", ".", ExternalCommand$.MODULE$.run$default$3()).isSuccess();
    }

    public Try<Cpg> createCpg(Config config2) {
        if (this.isPhpInstalled()) {
            return X2Cpg$.MODULE$.withNewEmptyCpg(config2.outputPath(), (X2CpgConfig)config2, (Function2)(JProcedure2 & Serializable)(cpg, config) -> {
                new MetaDataPass(cpg, "PHP", config.inputPath()).createAndApply();
                AstCreationPass astCreationPass = new AstCreationPass(config.inputPath(), (Cpg)cpg);
                astCreationPass.createAndApply();
                new TypeNodePass(astCreationPass.allUsedTypes(), cpg, TypeNodePass$.MODULE$.$lessinit$greater$default$3()).createAndApply();
            });
        }
        this.logger.error("Skipping AST creation as php could not be executed. Is PHP installed and available on your path?");
        return Failure$.MODULE$.apply((Throwable)new RuntimeException("php not found"));
    }
}

