/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg.parser;

import better.files.File$;
import io.joern.php2cpg.parser.Domain;
import io.joern.php2cpg.parser.Domain$;
import io.joern.x2cpg.utils.ExternalCommand$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public final class PhpParser$
implements Serializable {
    private static final Logger logger;
    private static final String ExecutablePath;
    public static final PhpParser$ MODULE$;

    private PhpParser$() {
    }

    static {
        MODULE$ = new PhpParser$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        String dir = Paths.get(MODULE$.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath().toString();
        String fixedDir = new File(dir.substring(0, dir.indexOf("php2cpg"))).toString();
        ExecutablePath = Paths.get(fixedDir, "php2cpg", "bin", "vendor", "bin", "php-parse").toAbsolutePath().toString();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PhpParser$.class);
    }

    private String phpParseCommand(String filename) {
        return new StringBuilder(45).append(ExecutablePath).append(" --with-recovery --resolve-names --json-dump ").append(filename).toString();
    }

    public Option<Domain.PhpFile> parseFile(String inputPath) {
        better.files.File inputFile = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String inputDirectory = inputFile.parent().canonicalPath();
        String filename = inputFile.name();
        Try try_ = ExternalCommand$.MODULE$.run(this.phpParseCommand(filename), inputDirectory, true);
        if (try_ instanceof Success) {
            Seq outputLines = (Seq)((Success)try_).value();
            return this.processParserOutput((Seq<String>)outputLines, inputFile.canonicalPath());
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.error(new StringBuilder(38).append("php-parser failed to parse input file ").append(inputPath).toString(), exception);
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Option<Domain.PhpFile> processParserOutput(Seq<String> lines, String filename) {
        Option<Value> maybeJson = this.linesToJsonValue(lines, filename);
        return maybeJson.flatMap((Function1 & Serializable)_$1 -> this.jsonValueToPhpFile((Value)_$1, filename));
    }

    private Option<Value> linesToJsonValue(Seq<String> lines, String filename) {
        if (lines.exists((Function1 & Serializable)_$2 -> _$2.startsWith("["))) {
            String jsonString = ((IterableOnceOps)lines.dropWhile((Function1 & Serializable)_$3 -> _$3.charAt(0) != '[')).mkString("\n");
            Try try_ = Try$.MODULE$.apply(() -> this.linesToJsonValue$$anonfun$2(jsonString));
            if (try_ instanceof Success) {
                Option option = (Option)((Success)try_).value();
                if (option instanceof Some) {
                    Value value = (Value)((Some)option).value();
                    return Some$.MODULE$.apply((Object)value);
                }
                if (None$.MODULE$.equals(option)) {
                    logger.error(new StringBuilder(54).append("Parsing json string for ").append(filename).append(" resulted in null return value").toString());
                    return None$.MODULE$;
                }
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                logger.error(new StringBuilder(46).append("Parsing json string for ").append(filename).append(" failed with exception").toString(), exception);
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        }
        logger.warn(new StringBuilder(19).append("No JSON output for ").append(filename).toString());
        return None$.MODULE$;
    }

    private Option<Domain.PhpFile> jsonValueToPhpFile(Value json, String filename) {
        Try try_ = Try$.MODULE$.apply(() -> this.jsonValueToPhpFile$$anonfun$1(json));
        if (try_ instanceof Success) {
            Domain.PhpFile phpFile = (Domain.PhpFile)((Success)try_).value();
            return Some$.MODULE$.apply((Object)phpFile);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            logger.error(new StringBuilder(40).append("Failed to generate intermediate AST for ").append(filename).toString(), e);
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private final Option linesToJsonValue$$anonfun$2(String jsonString$1) {
        return Option$.MODULE$.apply((Object)package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(jsonString$1), package$.MODULE$.read$default$2()));
    }

    private final Domain.PhpFile jsonValueToPhpFile$$anonfun$1(Value json$1) {
        return Domain$.MODULE$.fromJson(json$1);
    }
}

