/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg.parser;

import better.files.File$;
import io.joern.php2cpg.parser.Domain;
import io.joern.php2cpg.parser.Domain$;
import io.joern.x2cpg.utils.ExternalCommand$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public final class PhpParser$ {
    public static final PhpParser$ MODULE$ = new PhpParser$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String ExecutablePath;

    static {
        String dir = ((Object)Paths.get(MODULE$.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath()).toString();
        String fixedDir = new File(dir.substring(0, dir.indexOf("php2cpg"))).toString();
        ExecutablePath = ((Object)Paths.get(fixedDir, "php2cpg", "bin", "vendor", "bin", "php-parse").toAbsolutePath()).toString();
    }

    private Logger logger() {
        return logger;
    }

    private String ExecutablePath() {
        return ExecutablePath;
    }

    private String phpParseCommand(String filename) {
        return new StringBuilder(45).append(this.ExecutablePath()).append(" --with-recovery --resolve-names --json-dump ").append(filename).toString();
    }

    public Option<Domain.PhpFile> parseFile(String inputPath) {
        None$ none$;
        better.files.File inputFile = File$.MODULE$.apply(inputPath, (Seq)Nil$.MODULE$);
        String inputDirectory = inputFile.parent().canonicalPath();
        String filename = inputFile.name();
        Try try_ = ExternalCommand$.MODULE$.run(this.phpParseCommand(filename), inputDirectory, true);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq outputLines = (Seq)success.value();
            none$ = this.processParserOutput((Seq<String>)outputLines, filename);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            this.logger().error(new StringBuilder(38).append("php-parser failed to parse input file ").append(inputPath).toString(), exception);
            none$ = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return none$;
    }

    private Option<Domain.PhpFile> processParserOutput(Seq<String> lines, String filename) {
        Option<Value> maybeJson = this.linesToJsonValue(lines, filename);
        return maybeJson.flatMap((Function1 & Serializable)x$1 -> MODULE$.jsonValueToPhpFile((Value)x$1, filename));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Value> linesToJsonValue(Seq<String> lines, String filename) {
        Option option;
        String jsonString = ((IterableOnceOps)lines.dropWhile((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PhpParser$.$anonfun$linesToJsonValue$1(x$2)))).mkString("\n");
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(jsonString), package$.MODULE$.read$default$2())));
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            Option option2 = (Option)success.value();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Value value = (Value)some.value();
                return new Some((Object)value);
            }
        }
        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
            this.logger().error(new StringBuilder(54).append("Parsing json string for ").append(filename).append(" resulted in null return value").toString());
            return None$.MODULE$;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable exception = failure.exception();
        this.logger().error(new StringBuilder(46).append("Parsing json string for ").append(filename).append(" failed with exception").toString(), exception);
        return None$.MODULE$;
    }

    private Option<Domain.PhpFile> jsonValueToPhpFile(Value json, String filename) {
        Some some;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> Domain$.MODULE$.fromJson(json));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Domain.PhpFile phpFile = (Domain.PhpFile)success.value();
            some = new Some((Object)phpFile);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            this.logger().error(new StringBuilder(40).append("Failed to generate intermediate AST for ").append(filename).toString(), e);
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$linesToJsonValue$1(String x$2) {
        return x$2.charAt(0) != '[';
    }

    private PhpParser$() {
    }
}

