/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import io.joern.javasrc2cpg.typesolvers.JmodClassPath$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPath;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.util.Try$;

public class JmodClassPath
implements ClassPath {
    private final JarFile jarfile;
    private final String jarfileURL;
    private final Map<String, JarEntry> entries;

    public static String JmodClassesPrefix() {
        return JmodClassPath$.MODULE$.JmodClassesPrefix();
    }

    public JmodClassPath(String jmodPath) {
        this.jarfile = new JarFile(jmodPath);
        this.jarfileURL = Paths.get(jmodPath, new String[0]).toUri().toURL().toString();
        this.entries = this.getEntriesMap(this.jarfile);
    }

    private String entryToClassName(JarEntry entry) {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(entry.getName()), JmodClassPath$.MODULE$.JmodClassesPrefix())), ".class").replace('/', '.');
    }

    private Map<String, JarEntry> getEntriesMap(JarFile jarfile) {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(jarfile.entries()).asScala().filter((Function1 & Serializable)_$1 -> _$1.getName().startsWith(JmodClassPath$.MODULE$.JmodClassesPrefix())).filter((Function1 & Serializable)_$2 -> _$2.getName().endsWith(".class")).map((Function1 & Serializable)entry -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)this.entryToClassName((JarEntry)entry));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, entry);
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public URL find(String classname) {
        String jarname = classname.replace('.', '/') + ".class";
        if (this.entries.contains((Object)classname)) {
            return (URL)Try$.MODULE$.apply(() -> this.find$$anonfun$1(jarname)).getOrElse(JmodClassPath::find$$anonfun$2);
        }
        return null;
    }

    public InputStream openClassfile(String classname) {
        Option option = this.entries.get((Object)classname);
        if (None$.MODULE$.equals(option)) {
            return null;
        }
        if (option instanceof Some) {
            JarEntry entry = (JarEntry)((Some)option).value();
            return this.jarfile.getInputStream(entry);
        }
        throw new MatchError((Object)option);
    }

    private final URL find$$anonfun$1(String jarname$1) {
        return new URL("jmod:" + this.jarfileURL + "!/" + jarname$1);
    }

    private static final URL find$$anonfun$2() {
        return null;
    }
}

