/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.JmodClassPath;
import io.joern.javasrc2cpg.typesolvers.NonCachingClassPool;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.JarFile;
import javassist.ClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public class JdkJarTypeSolverBuilder {
    private final boolean enableVerboseTypeLogging;
    private final Logger logger;
    private final NonCachingClassPool classPool;
    private final Set<String> knownPackagePrefixes;

    public JdkJarTypeSolverBuilder(boolean enableVerboseTypeLogging) {
        this.enableVerboseTypeLogging = enableVerboseTypeLogging;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.classPool = new NonCachingClassPool();
        this.knownPackagePrefixes = (Set)Set$.MODULE$.empty();
    }

    public JdkJarTypeSolver build() {
        return new JdkJarTypeSolver(this.classPool, (scala.collection.immutable.Set<String>)this.knownPackagePrefixes.toSet());
    }

    private Try<ClassPath> addPathToClassPool(String archivePath) {
        if (JdkJarTypeSolver$.MODULE$.isJarPath(archivePath)) {
            return Try$.MODULE$.apply(() -> this.addPathToClassPool$$anonfun$1(archivePath));
        }
        if (JdkJarTypeSolver$.MODULE$.isJmodPath(archivePath)) {
            JmodClassPath classPath = new JmodClassPath(archivePath);
            return Try$.MODULE$.apply(() -> this.addPathToClassPool$$anonfun$2(classPath));
        }
        return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException("$archivePath is not a path to a jar/jmod"));
    }

    public JdkJarTypeSolverBuilder withJars(Seq<String> archivePaths) {
        this.addArchives(archivePaths);
        return this;
    }

    private void addArchives(Seq<String> archivePaths) {
        archivePaths.foreach((Function1)(JProcedure1 & Serializable)archivePath -> {
            Try<ClassPath> try_ = this.addPathToClassPool((String)archivePath);
            if (try_ instanceof Success) {
                this.registerPackagesForJar((String)archivePath);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.logger.warn("Could not load jar at path " + archivePath, (Object)e.getMessage());
                return;
            }
            throw new MatchError(try_);
        });
    }

    private void registerPackagesForJar(String archivePath) {
        Function1 & Serializable entryNameConverter = JdkJarTypeSolver$.MODULE$.isJarPath(archivePath) ? (Function1 & Serializable)entryName -> JdkJarTypeSolver$.MODULE$.packagePrefixForJarEntry((String)entryName) : (Function1 & Serializable)entryName -> JdkJarTypeSolver$.MODULE$.packagePrefixForJmodEntry((String)entryName);
        try {
            Using$.MODULE$.apply(() -> JdkJarTypeSolverBuilder.registerPackagesForJar$$anonfun$1(archivePath), (Function1 & Serializable)jarFile -> {
                if (this.enableVerboseTypeLogging) {
                    this.logger.debug("Adding jar to JdkJarTypeSolver: " + archivePath);
                }
                List newPrefixes = CollectionConverters$.MODULE$.IteratorHasAsScala(jarFile.entries().asIterator()).asScala().filter((Function1 & Serializable)entry -> !entry.isDirectory() && entry.getName().endsWith(JdkJarTypeSolver$.MODULE$.ClassExtension())).map((Function1 & Serializable)entry -> {
                    if (this.enableVerboseTypeLogging) {
                        this.logger.debug(" - " + entry.getName());
                    }
                    return (String)entryNameConverter.apply((Object)entry.getName());
                }).toList();
                return (Set)this.knownPackagePrefixes.$plus$plus$eq((IterableOnce)newPrefixes);
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        catch (IOException ioException) {
            this.logger.warn("Could not register classes for archive at " + archivePath, (Object)ioException.getMessage());
        }
    }

    private final ClassPath addPathToClassPool$$anonfun$1(String archivePath$1) {
        return this.classPool.appendClassPath(archivePath$1);
    }

    private final ClassPath addPathToClassPool$$anonfun$2(JmodClassPath classPath$1) {
        return this.classPool.appendClassPath(classPath$1);
    }

    private static final JarFile registerPackagesForJar$$anonfun$1(String archivePath$2) {
        return new JarFile(archivePath$2);
    }
}

