/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import io.joern.javasrc2cpg.typesolvers.EagerSourceTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.SimpleCombinedTypeSolver;
import io.joern.javasrc2cpg.typesolvers.TypeSizeReducer$;
import io.joern.javasrc2cpg.util.SourceParser;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.math.Ordering;
import scala.util.Try$;

public class EagerSourceTypeSolver
implements TypeSolver {
    private final SourceParser sourceParser;
    private final SimpleCombinedTypeSolver combinedTypeSolver;
    private final JavaSymbolSolver symbolSolver;
    private final Logger logger;
    private TypeSolver parent;
    private final Map<String, SymbolReference<ResolvedReferenceTypeDeclaration>> foundTypes;

    public static EagerSourceTypeSolver apply(SourceParser sourceParser, SimpleCombinedTypeSolver simpleCombinedTypeSolver, JavaSymbolSolver javaSymbolSolver, boolean bl) {
        return EagerSourceTypeSolver$.MODULE$.apply(sourceParser, simpleCombinedTypeSolver, javaSymbolSolver, bl);
    }

    public EagerSourceTypeSolver(SourceParser sourceParser, SimpleCombinedTypeSolver combinedTypeSolver, JavaSymbolSolver symbolSolver, boolean enableVerboseTypeLogging) {
        this.sourceParser = sourceParser;
        this.combinedTypeSolver = combinedTypeSolver;
        this.symbolSolver = symbolSolver;
        this.logger = LoggerFactory.getLogger(this.getClass());
        Map result = sourceParser.relativeFilenames().flatMap((Function1 & Serializable)relativeFilename -> sourceParser.parseTypesFile((String)relativeFilename)).flatMap((Function1 & Serializable)cu -> {
            symbolSolver.inject(cu);
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(cu.findAll(TypeDeclaration.class)).asScala().map((Function1 & Serializable)typeDeclaration -> {
                String string;
                Optional optional = OptionConverters$.MODULE$.RichOptional(typeDeclaration.getFullyQualifiedName());
                Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
                if (option instanceof Some) {
                    String fullyQualifiedName;
                    string = fullyQualifiedName = (String)((Some)option).value();
                } else if (None$.MODULE$.equals(option)) {
                    String name = typeDeclaration.getNameAsString();
                    if (typeDeclaration.isTopLevelType() || typeDeclaration.isNestedType()) {
                        this.logger.warn("Could not find fully qualified name for typeDecl " + name);
                    }
                    string = name;
                } else {
                    throw new MatchError((Object)option);
                }
                String name = string;
                TypeSizeReducer$.MODULE$.simplifyType((TypeDeclaration<?>)typeDeclaration);
                SymbolReference resolvedSymbol = (SymbolReference)Try$.MODULE$.apply(() -> EagerSourceTypeSolver.$anonfun$3(combinedTypeSolver, typeDeclaration)).getOrElse(EagerSourceTypeSolver::$anonfun$4);
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)name);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)resolvedSymbol);
            })).toList();
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (enableVerboseTypeLogging) {
            this.logger.debug(((List)result.toList().sortBy((Function1 & Serializable)_$1 -> (String)_$1._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    SymbolReference resolveResult = (SymbolReference)tuple2._2();
                    return name + " isSolved=" + resolveResult.isSolved();
                }
                throw new MatchError((Object)tuple2);
            }).$colon$colon((Object)"EagerSourceTypeSolver found following types:").mkString(System.lineSeparator() + " - "));
        }
        this.foundTypes = result;
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        if (parent == null) {
            this.logger.warn("Cannot set parent of type solver to null. setParent will be ignored.");
            return;
        }
        if (this.parent != null) {
            this.logger.warn("Attempting to re-set type solver parent. setParent will be ignored.");
            return;
        }
        TypeSolver typeSolver = parent;
        EagerSourceTypeSolver eagerSourceTypeSolver = this;
        if (!(typeSolver != null ? !typeSolver.equals(eagerSourceTypeSolver) : eagerSourceTypeSolver != null)) {
            this.logger.warn("Parent of TypeSolver cannot be itself. setParent will be ignored.");
            return;
        }
        this.parent = parent;
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        return (SymbolReference)this.foundTypes.getOrElse((Object)name, EagerSourceTypeSolver::tryToSolveType$$anonfun$1);
    }

    private static final SymbolReference $anonfun$3(SimpleCombinedTypeSolver combinedTypeSolver$3, TypeDeclaration typeDeclaration$1) {
        return SymbolReference.solved((ResolvedDeclaration)JavaParserFacade.get((TypeSolver)combinedTypeSolver$3).getTypeDeclaration(typeDeclaration$1));
    }

    private static final SymbolReference $anonfun$4() {
        return SymbolReference.unsolved();
    }

    private static final SymbolReference tryToSolveType$$anonfun$1() {
        return SymbolReference.unsolved();
    }
}

