/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.passes;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import flatgraph.DiffGraphBuilder;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.JavaSrc2Cpg$JavaSrcEnvVar$;
import io.joern.javasrc2cpg.astcreation.AstCreator;
import io.joern.javasrc2cpg.passes.AstCreationPass$;
import io.joern.javasrc2cpg.typesolvers.EagerSourceTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.SimpleCombinedTypeSolver;
import io.joern.javasrc2cpg.util.SourceParser;
import io.joern.javasrc2cpg.util.SourceParser$;
import io.joern.x2cpg.datastructures.Global;
import io.joern.x2cpg.utils.dependency.DependencyResolver$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.ForkJoinParallelCpgPass;
import io.shiftleft.passes.ForkJoinParallelCpgPass$;
import io.shiftleft.semanticcpg.utils.FileUtil$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class AstCreationPass
extends ForkJoinParallelCpgPass<String> {
    private final Config config;
    private final Option<List<String>> sourcesOverride;
    private final Global global;
    private final Logger logger;
    private final Map<Class<?>, Object> loggedExceptionCounts;
    private final SourceParser sourceParser;
    private final JavaSymbolSolver symbolSolver;

    public static Option<List<String>> $lessinit$greater$default$3() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$3();
    }

    public AstCreationPass(Config config, Cpg cpg, Option<List<String>> sourcesOverride) {
        this.config = config;
        this.sourcesOverride = sourcesOverride;
        super(cpg, ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$2());
        this.global = new Global();
        this.logger = LoggerFactory.getLogger(AstCreationPass.class);
        this.loggedExceptionCounts = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        Tuple2<SourceParser, JavaSymbolSolver> tuple2 = this.initParserAndUtils(config);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SourceParser sourceParser = (SourceParser)tuple2._1();
        JavaSymbolSolver symbolSolver = (JavaSymbolSolver)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)sourceParser, (Object)symbolSolver);
        this.sourceParser = (SourceParser)tuple22._1();
        this.symbolSolver = (JavaSymbolSolver)tuple22._2();
    }

    public Global global() {
        return this.global;
    }

    public SourceParser sourceParser() {
        return this.sourceParser;
    }

    public JavaSymbolSolver symbolSolver() {
        return this.symbolSolver;
    }

    public String[] generateParts() {
        return (String[])this.sourceParser().relativeFilenames().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public void runOnPart(DiffGraphBuilder diffGraph, String filename) {
        Option option;
        Option<Tuple2<CompilationUnit, Option<String>>> option2 = this.sourceParser().parseAnalysisFile(filename, !this.config.disableFileContent());
        if (option2 instanceof Some && !(option = Some$.MODULE$.unapply((Some)option2)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            CompilationUnit compilationUnit = (CompilationUnit)tuple2._1();
            Option fileContent = (Option)tuple2._2();
            this.symbolSolver().inject(compilationUnit);
            None$ contentToUse = !this.config.disableFileContent() ? fileContent.map((Function1 & Serializable)_$1 -> _$1.replaceAll("\r\n", "\n")) : None$.MODULE$;
            diffGraph.absorb(new AstCreator(filename, compilationUnit, (Option<String>)contentToUse, this.global(), this.symbolSolver(), this.config.keepTypeArguments(), this.loggedExceptionCounts, this.config.schemaValidation(), this.config.disableTypeFallback()).createAst());
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            this.logger.warn("Skipping AST creation for " + filename);
            return;
        }
        throw new MatchError(option2);
    }

    public void clearJavaParserCaches() {
        JavaParserFacade.clearInstances();
    }

    private Tuple2<SourceParser, JavaSymbolSolver> initParserAndUtils(Config config) {
        List<String> dependencies = this.getDependencyList(config.inputPath());
        SourceParser sourceParser = SourceParser$.MODULE$.apply(config, this.sourcesOverride);
        JavaSymbolSolver symbolSolver = this.createSymbolSolver(config, dependencies, sourceParser);
        return Tuple2$.MODULE$.apply((Object)sourceParser, (Object)symbolSolver);
    }

    private List<String> getDependencyList(String inputPath) {
        boolean shouldFetch;
        boolean bl;
        Option envVarValue = Option$.MODULE$.apply((Object)System.getenv(JavaSrc2Cpg$JavaSrcEnvVar$.FetchDependencies.name()));
        if (envVarValue.contains((Object)"no-fetch")) {
            this.logger.info("Disabling dependency fetching as envvar is set to \"no-fetch\"");
            bl = false;
        } else if (envVarValue.exists((Function1 & Serializable)_$2 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$2)))) {
            this.logger.info("Enabling dependency fetching: Environment variable " + JavaSrc2Cpg$JavaSrcEnvVar$.FetchDependencies.name() + " is set");
            bl = true;
        } else if (this.config.fetchDependencies()) {
            this.logger.info("Enabling dependency fetching: --fetch-dependencies flag was set");
            bl = true;
        } else {
            this.logger.info("dependency resolving not enabled");
            bl = shouldFetch = false;
        }
        if (shouldFetch) {
            Option option = DependencyResolver$.MODULE$.getDependencies(Paths.get(inputPath, new String[0]), DependencyResolver$.MODULE$.getDependencies$default$2());
            if (option instanceof Some) {
                Seq deps = (Seq)((Some)option).value();
                return deps.toList();
            }
            if (None$.MODULE$.equals(option)) {
                this.logger.warn("Could not fetch dependencies for project at path " + inputPath);
                return (List)Nil$.MODULE$;
            }
            throw new MatchError((Object)option);
        }
        return (List)Nil$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private JavaSymbolSolver createSymbolSolver(Config config, List<String> dependencies, SourceParser sourceParser) {
        verboseDebugLoggingEnvVarValue = Option$.MODULE$.apply((Object)System.getenv(JavaSrc2Cpg$JavaSrcEnvVar$.EnableVerboseTypeLogging.name()));
        v0 = enableVerboseTypeLogging = verboseDebugLoggingEnvVarValue.isDefined() != false || config.enableVerboseTypeLogging() != false;
        if (enableVerboseTypeLogging) {
            this.logger.warn("Verbose type logging is enabled. This will impact performance and log size and should only be enabled for debugging specific issues!");
        }
        combinedTypeSolver = new SimpleCombinedTypeSolver(enableVerboseTypeLogging);
        symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        jdkPathFromEnvVar = Option$.MODULE$.apply((Object)System.getenv(JavaSrc2Cpg$JavaSrcEnvVar$.JdkPath.name()));
        var10_9 = Tuple2$.MODULE$.apply(config.jdkPath(), (Object)jdkPathFromEnvVar);
        if (var10_9 == null) ** GOTO lbl-1000
        var11_10 = (Option)var10_9._1();
        var12_11 = (Option)var10_9._2();
        if (!None$.MODULE$.equals(var11_10)) ** GOTO lbl-1000
        if (None$.MODULE$.equals(var12_11)) {
            javaHome = System.getProperty("java.home");
            this.logger.info("No explicit jdk-path set in , so using system java.home for JDK type information: " + javaHome);
            v1 = javaHome;
        } else if (var12_11 instanceof Some) {
            jdkPath = (String)((Some)var12_11).value();
            this.logger.info("Using JDK path from environment variable " + JavaSrc2Cpg$JavaSrcEnvVar$.JdkPath.name() + " for JDK type information: " + jdkPath);
            v1 = jdkPath;
        } else if (var11_10 instanceof Some) {
            jdkPath = (String)((Some)var11_10).value();
            this.logger.info("Using JDK path set with jdk-path option for JDK type information: " + jdkPath);
            v1 = jdkPath;
        } else lbl-1000:
        // 2 sources

        {
            throw new MatchError((Object)var10_9);
        }
        jdkPath = v1;
        combinedTypeSolver.addNonCachingTypeSolver(JdkJarTypeSolver$.MODULE$.fromJdkPath(jdkPath, config.cacheJdkTypeSolver(), enableVerboseTypeLogging));
        sourceTypeSolver = EagerSourceTypeSolver$.MODULE$.apply(sourceParser, combinedTypeSolver, symbolSolver, enableVerboseTypeLogging);
        combinedTypeSolver.addCachingTypeSolver(sourceTypeSolver);
        jarsList = ((IterableOnceOps)config.inferenceJarPaths().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(java.lang.String ), (Ljava/lang/String;)Lscala/collection/IterableOnce;)((AstCreationPass)this))).toList();
        if (config.inferenceJarPaths().isEmpty()) {
            this.logger.debug("No inference jar paths given");
        } else if (jarsList.isEmpty()) {
            this.logger.warn("Could not find any inference jars at provided paths: " + config.inferenceJarPaths().mkString(","));
        } else {
            this.logger.debug("Using inference jars: " + jarsList.mkString(":"));
        }
        ((List)jarsList.$plus$plus(dependencies)).foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, createSymbolSolver$$anonfun$1(io.joern.javasrc2cpg.typesolvers.SimpleCombinedTypeSolver boolean java.lang.String ), (Ljava/lang/String;)V)((AstCreationPass)this, (SimpleCombinedTypeSolver)combinedTypeSolver, (boolean)enableVerboseTypeLogging));
        return symbolSolver;
    }

    private List<String> recursiveJarsFromPath(String path) {
        Try try_ = Try$.MODULE$.apply(() -> AstCreationPass.recursiveJarsFromPath$$anonfun$1(path));
        if (try_ instanceof Success) {
            Path path2 = (Path)((Success)try_).value();
            Path file = path2;
            if (Files.isDirectory(file, new LinkOption[0])) {
                return FileUtil$.MODULE$.PathExt(file).walk().filterNot((Function1 & Serializable)_$3 -> {
                    Path path = _$3;
                    Path path2 = file;
                    return !(path != null ? !((Object)path).equals(path2) : path2 != null);
                }).map((Function1 & Serializable)_$4 -> FileUtil$.MODULE$.PathExt(_$4).absolutePathAsString()).filter((Function1 & Serializable)_$5 -> _$5.endsWith(".jar")).toList();
            }
            Path file2 = path2;
            if (FileUtil$.MODULE$.PathExt(file2).absolutePathAsString().endsWith(".jar")) {
                return (List)new .colon.colon((Object)FileUtil$.MODULE$.PathExt(file2).absolutePathAsString(), (List)Nil$.MODULE$);
            }
        }
        return package$.MODULE$.Nil();
    }

    private final /* synthetic */ IterableOnce $anonfun$3(String path) {
        return this.recursiveJarsFromPath(path);
    }

    private static final JarTypeSolver createSymbolSolver$$anonfun$1$$anonfun$1(String path$1) {
        return new JarTypeSolver(path$1);
    }

    private final /* synthetic */ void createSymbolSolver$$anonfun$1(SimpleCombinedTypeSolver combinedTypeSolver$1, boolean enableVerboseTypeLogging$1, String path) {
        Try try_ = Try$.MODULE$.apply(() -> AstCreationPass.createSymbolSolver$$anonfun$1$$anonfun$1(path));
        if (try_ instanceof Success) {
            JarTypeSolver jarTypeSolver = (JarTypeSolver)((Success)try_).value();
            combinedTypeSolver$1.addNonCachingTypeSolver((TypeSolver)jarTypeSolver);
            if (enableVerboseTypeLogging$1) {
                this.logger.debug("Added JarTypeSolver for jar at " + path);
                String string = "Known classes:";
                this.logger.debug(((List)CollectionConverters$.MODULE$.SetHasAsScala(jarTypeSolver.getKnownClasses()).asScala().toList().sorted((Ordering)Ordering.String$.MODULE$)).$colon$colon((Object)string).mkString(System.lineSeparator() + " - "));
                return;
            }
            return;
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.warn("Could not create JarTypeSolver for jar at " + path);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private static final Path recursiveJarsFromPath$$anonfun$1(String path$2) {
        return Paths.get(path$2, new String[0]);
    }
}

