/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.querying.dataflow;

import io.joern.dataflowengineoss.language.ExtendedCfgNode$;
import io.joern.dataflowengineoss.language.package$;
import io.joern.javasrc2cpg.testfixtures.JavaDataflowFixture;
import io.joern.javasrc2cpg.testfixtures.JavaDataflowFixture$;
import io.shiftleft.codepropertygraph.generated.nodes.Expression;
import io.shiftleft.codepropertygraph.generated.nodes.Literal;
import java.io.Serializable;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.compatible.Assertion;
import org.scalatest.flatspec.AnyFlatSpecLike;
import scala.CanEqual$;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class LoopTests
extends JavaDataflowFixture {
    private final String code;

    public LoopTests() {
        super(JavaDataflowFixture$.MODULE$.$lessinit$greater$default$1());
        AnyFlatSpecLike.BehaviorWord BehaviorWord_this = this.behavior();
        Position position = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 8);
        BehaviorWord_this.inline$ofImpl("Dataflow through loop structures", position);
        this.code = "\npublic class Foo {\n    public void test1(boolean b) {\n        String s = \"MALICIOUS\";\n        while (b) {\n            s = \"SAFE\";\n            b = !b;\n        }\n        System.out.println(s);\n    }\n\n    public void test2(boolean b) {\n        String s = \"SAFE\";\n        while (b) {\n            s = \"MALICIOUS\";\n            b = !b;\n        }\n        System.out.println(s);\n    }\n\n    public void test3(int maxLen) {\n        for (String s = \"SAFE\"; s.length() < maxLen; s += \"MALICIOUS\") {\n            System.out.println(s);\n        }\n    }\n\n    public void test4(int maxLen) {\n        for (String s = \"MALICIOUS\"; s.length() < maxLen; s += \"MALICIOUS\") {\n            s = \"SAFE\";\n            System.out.println(s);\n        }\n    }\n\n    public void test5(int maxLen) {\n        for (String s = \"MALICIOUS\"; s.length() < maxLen; s += \"SAFE\") {\n            System.out.println(s);\n        }\n    }\n\n    public void test6(int maxLen) {\n        String s = \"MALICIOUS\";\n        do {\n            s += \"SAFE\";\n            System.out.println(s);\n        } while (s.length() < maxLen);\n    }\n\n    public void test7(String[] prefixes) {\n        String s = \"MALICIOUS\";\n        for (String prefix : prefixes) {\n            String output = prefix + s;\n            System.out.println(output);\n        }\n    }\n\n    public void test8() {\n        String s = \"MALICIOUS\";\n        while (true) {\n            break;\n            System.out.println(s);\n        }\n    }\n\n    public void test9(String[] prefixes) {\n        String s = \"MALICIOUS\";\n        for (String prefix: prefixes) {\n            String output = prefix + s;\n            continue;\n            System.out.println(output);\n        }\n    }\n\n    public void test10(int count) {\n        String s = \"\";\n        for (int i = 0; i < count; i++) {\n            if (i == 6) {\n                s += \"MALICIOUS\";\n            } else {\n                s += \"SAFE\";\n            }\n        }\n        System.out.println(s);\n    }\n\n    public void test11(String[] prefixes) {\n        String s = \"MALICIOUS\";\n        for (String prefix: prefixes) {\n            String output = prefix + s;\n            System.out.println(output);\n        }\n    }\n\n    public void test12(boolean b) {\n        String s = \"MALICIOUS\";\n        do {\n            s = \"SAFE\";\n            b = !b;\n        } while (b);\n        System.out.println(s);\n    }\n}\n";
        AnyFlatSpecLike.ItVerbString ItVerbString_this = this.it().should("find a path if `MALICIOUS` is possibly reassigned in a `WHILE");
        LoopTests AnyFlatSpecLike_this = (LoopTests)ItVerbString_this.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position2 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114);
        AnyFlatSpecLike_this.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this.inline$verb().trim() + " " + ItVerbString_this.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy1$1(), position2);
        AnyFlatSpecLike.ItVerbString ItVerbString_this2 = this.it().should("find a path if `MALICIOUS` is possibly assigned in a `WHILE`");
        LoopTests AnyFlatSpecLike_this2 = (LoopTests)ItVerbString_this2.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position3 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119);
        AnyFlatSpecLike_this2.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this2.inline$verb().trim() + " " + ItVerbString_this2.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy2$1(), position3);
        AnyFlatSpecLike.ItVerbString ItVerbString_this3 = this.it().should("find a path if `MALICIOUS` is added in `FOR` update");
        LoopTests AnyFlatSpecLike_this3 = (LoopTests)ItVerbString_this3.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position4 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124);
        AnyFlatSpecLike_this3.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this3.inline$verb().trim() + " " + ItVerbString_this3.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy3$1(), position4);
        AnyFlatSpecLike.ItVerbString ItVerbString_this4 = this.it().should("not find a path if `MALICIOUS` is always reassigned before sink in loop");
        LoopTests AnyFlatSpecLike_this4 = (LoopTests)ItVerbString_this4.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position5 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129);
        AnyFlatSpecLike_this4.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this4.inline$verb().trim() + " " + ItVerbString_this4.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy4$1(), position5);
        AnyFlatSpecLike.ItVerbString ItVerbString_this5 = this.it().should("find a path if `MALICIOUS` is assigned in `FOR` init");
        LoopTests AnyFlatSpecLike_this5 = (LoopTests)ItVerbString_this5.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position6 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134);
        AnyFlatSpecLike_this5.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this5.inline$verb().trim() + " " + ItVerbString_this5.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy5$1(), position6);
        AnyFlatSpecLike.ItVerbString ItVerbString_this6 = this.it().should("find a path if sink is in a `DO` loop");
        LoopTests AnyFlatSpecLike_this6 = (LoopTests)ItVerbString_this6.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position7 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139);
        AnyFlatSpecLike_this6.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this6.inline$verb().trim() + " " + ItVerbString_this6.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy6$1(), position7);
        AnyFlatSpecLike.ItVerbString ItVerbString_this7 = this.it().should("find a path if sink is in `FOREACH` loop");
        LoopTests AnyFlatSpecLike_this7 = (LoopTests)ItVerbString_this7.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position8 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144);
        AnyFlatSpecLike_this7.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this7.inline$verb().trim() + " " + ItVerbString_this7.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy7$1(), position8);
        AnyFlatSpecLike.ItVerbString ItVerbString_this8 = this.it().should("not find a path if sink in loop is unreachable due to `BREAK`");
        LoopTests AnyFlatSpecLike_this8 = (LoopTests)ItVerbString_this8.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position9 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149);
        AnyFlatSpecLike_this8.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this8.inline$verb().trim() + " " + ItVerbString_this8.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy8$1(), position9);
        AnyFlatSpecLike.ItVerbString ItVerbString_this9 = this.it().should("not find a path if sink in loop is unreachable due to `CONTINUE`");
        LoopTests AnyFlatSpecLike_this9 = (LoopTests)ItVerbString_this9.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position10 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154);
        AnyFlatSpecLike_this9.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this9.inline$verb().trim() + " " + ItVerbString_this9.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy9$1(), position10);
        AnyFlatSpecLike.ItVerbString ItVerbString_this10 = this.it().should("find a path if `MALICIOUS` is possibly appended in `FOR`");
        LoopTests AnyFlatSpecLike_this10 = (LoopTests)ItVerbString_this10.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position11 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159);
        AnyFlatSpecLike_this10.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this10.inline$verb().trim() + " " + ItVerbString_this10.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy10$1(), position11);
        AnyFlatSpecLike.ItVerbString ItVerbString_this11 = this.it().should("find a path if `MALICIOUS` is appended to prefix in `FOREACH`");
        LoopTests AnyFlatSpecLike_this11 = (LoopTests)ItVerbString_this11.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position12 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164);
        AnyFlatSpecLike_this11.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this11.inline$verb().trim() + " " + ItVerbString_this11.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy11$1(), position12);
        AnyFlatSpecLike.ItVerbString ItVerbString_this12 = this.it().should("not find a path if `MALICIOUS` is reassigned before sink in `DO`");
        LoopTests AnyFlatSpecLike_this12 = (LoopTests)ItVerbString_this12.org$scalatest$flatspec$AnyFlatSpecLike$ItVerbString$$$outer();
        Position position13 = Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169);
        AnyFlatSpecLike_this12.org$scalatest$flatspec$AnyFlatSpecLike$$inline$registerTestToRun(ItVerbString_this12.inline$verb().trim() + " " + ItVerbString_this12.inline$name().trim(), "in", (List)Nil$.MODULE$, (Function0 & Serializable)() -> this.testFun$proxy12$1(), position13);
    }

    @Override
    public String code() {
        return this.code;
    }

    private final Assertion testFun$proxy1$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test1", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy2$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test2", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy3$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test3", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy4$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test4", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)0), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy5$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test5", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy6$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test6", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy7$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test7", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy8$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test8", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)0), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy9$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test9", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)0), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy10$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test10", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy11$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test11", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)1), CanEqual$.MODULE$.canEqualAny());
    }

    private final Assertion testFun$proxy12$1() {
        Tuple2<Iterator<Literal>, Iterator<Expression>> tuple2 = this.getConstSourceSink("test12", this.getConstSourceSink$default$2(), this.getConstSourceSink$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Iterator source = (Iterator)tuple2._1();
        Iterator sink = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)source, (Object)sink);
        Iterator source2 = (Iterator)tuple22._1();
        Iterator sink2 = (Iterator)tuple22._2();
        return this.shouldBe((Object)BoxesRunTime.boxToInteger((int)ExtendedCfgNode$.MODULE$.reachableBy$extension(package$.MODULE$.toExtendedCfgNode((IterableOnce)sink2), (IterableOnce)source2, (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[0]), this.engineContext()).size()), Position$.MODULE$.apply("LoopTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171), Prettifier$.MODULE$.default(), BoxesRunTime.boxToInteger((int)0), CanEqual$.MODULE$.canEqualAny());
    }
}

