/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.passes;

import better.files.File;
import better.files.File$;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.JavaSymbolSolver;
import com.github.javaparser.symbolsolver.javaparsermodel.JavaParserFacade;
import com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver;
import flatgraph.DiffGraphBuilder;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.JavaSrc2Cpg$JavaSrcEnvVar$;
import io.joern.javasrc2cpg.astcreation.AstCreator;
import io.joern.javasrc2cpg.passes.AstCreationPass$;
import io.joern.javasrc2cpg.typesolvers.EagerSourceTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.SimpleCombinedTypeSolver;
import io.joern.javasrc2cpg.util.SourceParser;
import io.joern.javasrc2cpg.util.SourceParser$;
import io.joern.x2cpg.datastructures.Global;
import io.joern.x2cpg.utils.dependency.DependencyResolver$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.ForkJoinParallelCpgPass;
import io.shiftleft.passes.ForkJoinParallelCpgPass$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Paths;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.concurrent.Map;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class AstCreationPass
extends ForkJoinParallelCpgPass<String> {
    private final Config config;
    private final Option<List<String>> sourcesOverride;
    private final Global global;
    private final Logger logger;
    private final Map<Class<?>, Object> loggedExceptionCounts;
    private final SourceParser sourceParser;
    private final JavaSymbolSolver symbolSolver;

    public static Option<List<String>> $lessinit$greater$default$3() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$3();
    }

    public AstCreationPass(Config config, Cpg cpg, Option<List<String>> sourcesOverride) {
        this.config = config;
        this.sourcesOverride = sourcesOverride;
        super(cpg, ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$2());
        this.global = new Global();
        this.logger = LoggerFactory.getLogger(AstCreationPass.class);
        this.loggedExceptionCounts = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(new ConcurrentHashMap()).asScala();
        Tuple2<SourceParser, JavaSymbolSolver> tuple2 = this.initParserAndUtils(config);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        SourceParser sourceParser = (SourceParser)tuple2._1();
        JavaSymbolSolver symbolSolver = (JavaSymbolSolver)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)sourceParser, (Object)symbolSolver);
        this.sourceParser = (SourceParser)tuple22._1();
        this.symbolSolver = (JavaSymbolSolver)tuple22._2();
    }

    public Global global() {
        return this.global;
    }

    public SourceParser sourceParser() {
        return this.sourceParser;
    }

    public JavaSymbolSolver symbolSolver() {
        return this.symbolSolver;
    }

    public String[] generateParts() {
        return (String[])this.sourceParser().relativeFilenames().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public void runOnPart(DiffGraphBuilder diffGraph, String filename) {
        Option option;
        Option<Tuple2<CompilationUnit, Option<String>>> option2 = this.sourceParser().parseAnalysisFile(filename, !this.config.disableFileContent());
        if (option2 instanceof Some && !(option = Some$.MODULE$.unapply((Some)option2)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            CompilationUnit compilationUnit = (CompilationUnit)tuple2._1();
            Option fileContent = (Option)tuple2._2();
            this.symbolSolver().inject(compilationUnit);
            Option contentToUse = !this.config.disableFileContent() ? fileContent : None$.MODULE$;
            diffGraph.absorb(new AstCreator(filename, compilationUnit, (Option<String>)contentToUse, this.global(), this.symbolSolver(), this.config.keepTypeArguments(), this.loggedExceptionCounts, this.config.schemaValidation(), this.config.disableTypeFallback()).createAst());
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            this.logger.warn("Skipping AST creation for " + filename);
            return;
        }
        throw new MatchError(option2);
    }

    public void clearJavaParserCaches() {
        JavaParserFacade.clearInstances();
    }

    private Tuple2<SourceParser, JavaSymbolSolver> initParserAndUtils(Config config) {
        List<String> dependencies = this.getDependencyList(config.inputPath());
        SourceParser sourceParser = SourceParser$.MODULE$.apply(config, this.sourcesOverride);
        JavaSymbolSolver symbolSolver = this.createSymbolSolver(config, dependencies, sourceParser);
        return Tuple2$.MODULE$.apply((Object)sourceParser, (Object)symbolSolver);
    }

    private List<String> getDependencyList(String inputPath) {
        boolean shouldFetch;
        boolean bl;
        Option envVarValue = Option$.MODULE$.apply((Object)System.getenv(JavaSrc2Cpg$JavaSrcEnvVar$.FetchDependencies.name()));
        if (envVarValue.contains((Object)"no-fetch")) {
            this.logger.info("Disabling dependency fetching as envvar is set to \"no-fetch\"");
            bl = false;
        } else if (envVarValue.exists((Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1)))) {
            this.logger.info("Enabling dependency fetching: Environment variable " + JavaSrc2Cpg$JavaSrcEnvVar$.FetchDependencies.name() + " is set");
            bl = true;
        } else if (this.config.fetchDependencies()) {
            this.logger.info("Enabling dependency fetching: --fetch-dependencies flag was set");
            bl = true;
        } else {
            this.logger.info("dependency resolving not enabled");
            bl = shouldFetch = false;
        }
        if (shouldFetch) {
            Option option = DependencyResolver$.MODULE$.getDependencies(Paths.get(inputPath, new String[0]), DependencyResolver$.MODULE$.getDependencies$default$2());
            if (option instanceof Some) {
                Seq deps = (Seq)((Some)option).value();
                return deps.toList();
            }
            if (None$.MODULE$.equals(option)) {
                this.logger.warn("Could not fetch dependencies for project at path " + inputPath);
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
            }
            throw new MatchError((Object)option);
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    /*
     * Unable to fully structure code
     */
    private JavaSymbolSolver createSymbolSolver(Config config, List<String> dependencies, SourceParser sourceParser) {
        combinedTypeSolver = new SimpleCombinedTypeSolver();
        symbolSolver = new JavaSymbolSolver((TypeSolver)combinedTypeSolver);
        jdkPathFromEnvVar = Option$.MODULE$.apply((Object)System.getenv(JavaSrc2Cpg$JavaSrcEnvVar$.JdkPath.name()));
        var8_7 = Tuple2$.MODULE$.apply(config.jdkPath(), (Object)jdkPathFromEnvVar);
        if (var8_7 == null) ** GOTO lbl-1000
        var9_8 = (Option)var8_7._1();
        var10_9 = (Option)var8_7._2();
        if (!None$.MODULE$.equals(var9_8)) ** GOTO lbl-1000
        if (None$.MODULE$.equals(var10_9)) {
            javaHome = System.getProperty("java.home");
            this.logger.info("No explicit jdk-path set in , so using system java.home for JDK type information: " + javaHome);
            v0 = javaHome;
        } else if (var10_9 instanceof Some) {
            jdkPath = (String)((Some)var10_9).value();
            this.logger.info("Using JDK path from environment variable " + JavaSrc2Cpg$JavaSrcEnvVar$.JdkPath.name() + " for JDK type information: " + jdkPath);
            v0 = jdkPath;
        } else if (var9_8 instanceof Some) {
            jdkPath = (String)((Some)var9_8).value();
            this.logger.info("Using JDK path set with jdk-path option for JDK type information: " + jdkPath);
            v0 = jdkPath;
        } else lbl-1000:
        // 2 sources

        {
            throw new MatchError((Object)var8_7);
        }
        jdkPath = v0;
        combinedTypeSolver.addNonCachingTypeSolver(JdkJarTypeSolver$.MODULE$.fromJdkPath(jdkPath, config.cacheJdkTypeSolver()));
        sourceTypeSolver = EagerSourceTypeSolver$.MODULE$.apply(sourceParser, combinedTypeSolver, symbolSolver);
        combinedTypeSolver.addCachingTypeSolver(sourceTypeSolver);
        jarsList = ((IterableOnceOps)config.inferenceJarPaths().flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$2(java.lang.String ), (Ljava/lang/String;)Lscala/collection/IterableOnce;)((AstCreationPass)this))).toList();
        if (config.inferenceJarPaths().isEmpty()) {
            this.logger.debug("No inference jar paths given");
        } else if (jarsList.isEmpty()) {
            this.logger.warn("Could not find any inference jars at provided paths: " + config.inferenceJarPaths().mkString(","));
        } else {
            this.logger.debug("Using inference jars: " + jarsList.mkString(":"));
        }
        ((List)jarsList.$plus$plus(dependencies)).flatMap((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, createSymbolSolver$$anonfun$1(java.lang.String ), (Ljava/lang/String;)Lscala/collection/IterableOnce;)()).foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, createSymbolSolver$$anonfun$2(io.joern.javasrc2cpg.typesolvers.SimpleCombinedTypeSolver com.github.javaparser.symbolsolver.resolution.typesolvers.JarTypeSolver ), (Lcom/github/javaparser/symbolsolver/resolution/typesolvers/JarTypeSolver;)V)((SimpleCombinedTypeSolver)combinedTypeSolver));
        return symbolSolver;
    }

    private List<String> recursiveJarsFromPath(String path) {
        Try try_ = Try$.MODULE$.apply(() -> AstCreationPass.recursiveJarsFromPath$$anonfun$1(path));
        if (try_ instanceof Success) {
            File file = (File)((Success)try_).value();
            File file2 = file;
            if (file2.isDirectory(file2.isDirectory$default$1())) {
                return file2.listRecursively(file2.listRecursively$default$1()).map((Function1 & Serializable)_$3 -> _$3.canonicalPath()).filter((Function1 & Serializable)_$4 -> _$4.endsWith(".jar")).toList();
            }
            File file3 = file;
            if (file3.canonicalPath().endsWith(".jar")) {
                return (List)new .colon.colon((Object)file3.canonicalPath(), (List)Nil$.MODULE$);
            }
        }
        return package$.MODULE$.Nil();
    }

    private final /* synthetic */ IterableOnce $anonfun$2(String path) {
        return this.recursiveJarsFromPath(path);
    }

    private static final JarTypeSolver createSymbolSolver$$anonfun$1$$anonfun$1(String path$1) {
        return new JarTypeSolver(path$1);
    }

    private static final /* synthetic */ IterableOnce createSymbolSolver$$anonfun$1(String path) {
        return Try$.MODULE$.apply(() -> AstCreationPass.createSymbolSolver$$anonfun$1$$anonfun$1(path)).toOption();
    }

    private static final /* synthetic */ void createSymbolSolver$$anonfun$2(SimpleCombinedTypeSolver combinedTypeSolver$1, JarTypeSolver _$2) {
        combinedTypeSolver$1.addNonCachingTypeSolver((TypeSolver)_$2);
    }

    private static final File recursiveJarsFromPath$$anonfun$1(String path$2) {
        return File$.MODULE$.apply(path$2, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

