/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import better.files.File;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolverBuilder;
import io.joern.x2cpg.SourceFiles$;
import java.io.Serializable;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class JdkJarTypeSolver$
implements Serializable {
    private static final String ClassExtension;
    private static final String JmodClassPrefix;
    private static final String JarExtension;
    private static final String JmodExtension;
    private static final Map<String, JdkJarTypeSolverBuilder> cache;
    public static final JdkJarTypeSolver$ MODULE$;

    private JdkJarTypeSolver$() {
    }

    static {
        MODULE$ = new JdkJarTypeSolver$();
        ClassExtension = ".class";
        JmodClassPrefix = "classes/";
        JarExtension = ".jar";
        JmodExtension = ".jmod";
        cache = (Map)Map$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JdkJarTypeSolver$.class);
    }

    public String ClassExtension() {
        return ClassExtension;
    }

    public String JmodClassPrefix() {
        return JmodClassPrefix;
    }

    public String JarExtension() {
        return JarExtension;
    }

    public String JmodExtension() {
        return JmodExtension;
    }

    public boolean isJarPath(String path) {
        return path.endsWith(this.JarExtension());
    }

    public boolean isJmodPath(String path) {
        return path.endsWith(this.JmodExtension());
    }

    private List<String> determineJarPaths(String jdkPath) {
        List jarPaths = SourceFiles$.MODULE$.determine(jdkPath, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.JarExtension(), this.JmodExtension()})), SourceFiles$.MODULE$.determine$default$3(), SourceFiles$.MODULE$.determine$default$4(), SourceFiles$.MODULE$.determine$default$5(), File.VisitOptions$.MODULE$.default());
        if (jarPaths.isEmpty()) {
            throw new IllegalArgumentException("No .jar or .jmod files found at JDK path " + jdkPath);
        }
        return jarPaths;
    }

    public JdkJarTypeSolver fromJdkPath(String jdkPath, boolean useCache) {
        if (useCache) {
            return ((JdkJarTypeSolverBuilder)cache.getOrElseUpdate((Object)jdkPath, () -> this.fromJdkPath$$anonfun$1(jdkPath))).build();
        }
        return this.createBuilder$1(jdkPath).build();
    }

    public boolean fromJdkPath$default$2() {
        return false;
    }

    public String packagePrefixForJavaParserName(String className) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])className.split("\\."));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 2)).mkString(".");
    }

    public String packagePrefixForJarEntry(String entryName) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])entryName.split("/"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 2)).mkString(".");
    }

    public String packagePrefixForJmodEntry(String entryName) {
        return this.packagePrefixForJarEntry(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(entryName), this.JmodClassPrefix()));
    }

    public List<String> possibleStandardNamesForJavaParser(String javaParserName) {
        Object[] nameParts = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(javaParserName), '.');
        Object object = Predef$.MODULE$.refArrayOps(nameParts);
        return ArrayOps$.MODULE$.indices$extension(object).reverse().map(arg_0 -> JdkJarTypeSolver$.possibleStandardNamesForJavaParser$$anonfun$adapted$1((String[])nameParts, arg_0)).toList();
    }

    private final JdkJarTypeSolverBuilder createBuilder$1(String jdkPath$1) {
        return new JdkJarTypeSolverBuilder().withJars((Seq<String>)this.determineJarPaths(jdkPath$1));
    }

    private final JdkJarTypeSolverBuilder fromJdkPath$$anonfun$1(String jdkPath$2) {
        return this.createBuilder$1(jdkPath$2);
    }

    private static final /* synthetic */ String possibleStandardNamesForJavaParser$$anonfun$1(String[] nameParts$1, int packageLength) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])nameParts$1);
        String packageName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, packageLength)).mkString(".");
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])nameParts$1);
        String className = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.drop$extension(object2, packageLength)).mkString("$");
        Object packagePrefix = packageLength > 0 ? packageName + "." : "";
        return (String)packagePrefix + className;
    }

    private static /* bridge */ /* synthetic */ String possibleStandardNamesForJavaParser$$anonfun$adapted$1(String[] nameParts$2, Object packageLength) {
        return JdkJarTypeSolver$.possibleStandardNamesForJavaParser$$anonfun$1(nameParts$2, BoxesRunTime.unboxToInt((Object)packageLength));
    }
}

