/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.util;

import better.files.File;
import better.files.File$;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.util.SourceParser$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

public class SourceParser {
    private final Path analysisRoot;
    private final Path typesRoot;
    private final Logger logger;

    public static SourceParser apply(Config config, boolean bl) {
        return SourceParser$.MODULE$.apply(config, bl);
    }

    public SourceParser(Path originalInputPath, Path analysisRoot, Path typesRoot) {
        this.analysisRoot = analysisRoot;
        this.typesRoot = typesRoot;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public Option<CompilationUnit> parseAnalysisFile(String relativeFilename) {
        String analysisFilename = this.analysisRoot.resolve(relativeFilename).toString();
        return this.fileIfExists(analysisFilename).flatMap((Function1 & Serializable)_$1 -> this.parse((File)_$1, true));
    }

    public Option<CompilationUnit> parseTypesFile(String relativeFilename) {
        String typesFilename = this.typesRoot.resolve(relativeFilename).toString();
        return this.fileIfExists(typesFilename).flatMap((Function1 & Serializable)_$2 -> this.parse((File)_$2, false));
    }

    public Option<File> fileIfExists(String filename) {
        File file = File$.MODULE$.apply(filename, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        return Option$.MODULE$.when(file.exists(file.exists$default$1()), () -> SourceParser.fileIfExists$$anonfun$1(file));
    }

    public Try<Iterable<String>> getTypesFileLines(String relativeFilename) {
        String typesFilename = this.typesRoot.resolve(relativeFilename).toString();
        return Try$.MODULE$.apply(() -> SourceParser.getTypesFileLines$$anonfun$1(typesFilename)).orElse(() -> SourceParser.getTypesFileLines$$anonfun$2(typesFilename));
    }

    public boolean doesTypesFileExist(String relativeFilename) {
        File file = File$.MODULE$.apply(this.typesRoot.resolve(relativeFilename));
        return file.isRegularFile(file.isRegularFile$default$1());
    }

    private Option<CompilationUnit> parse(File file, boolean storeTokens) {
        ParseResult parseResult;
        block6: {
            List list;
            block7: {
                List list2;
                Nil$ nil$;
                block5: {
                    ParserConfiguration javaParserConfig = new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE).setStoreTokens(storeTokens);
                    parseResult = new JavaParser(javaParserConfig).parse(file.toJava());
                    list = CollectionConverters$.MODULE$.ListHasAsScala(parseResult.getProblems()).asScala().toList();
                    nil$ = package$.MODULE$.Nil();
                    list2 = list;
                    if (nil$ != null) break block5;
                    if (list2 == null) break block6;
                    break block7;
                }
                if (nil$.equals(list2)) break block6;
            }
            List problems = list;
            this.logger.warn("Encountered problems while parsing file " + file.name() + ":");
            problems.foreach((Function1)(JProcedure1 & Serializable)problem -> this.logger.warn("- " + problem.getMessage()));
        }
        Optional optional = OptionConverters$.MODULE$.RichOptional(parseResult.getResult());
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
        if (option instanceof Some) {
            CompilationUnit result = (CompilationUnit)((Some)option).value();
            Node.Parsedness parsedness = result.getParsed();
            Node.Parsedness parsedness2 = Node.Parsedness.PARSED;
            if (!(parsedness != null ? !parsedness.equals(parsedness2) : parsedness2 != null)) {
                return Some$.MODULE$.apply((Object)result);
            }
        }
        this.logger.warn("Failed to parse file " + file.name());
        return None$.MODULE$;
    }

    private static final File fileIfExists$$anonfun$1(File file$1) {
        return file$1;
    }

    private static final Iterable getTypesFileLines$$anonfun$1(String typesFilename$1) {
        return File$.MODULE$.apply(typesFilename$1, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).lines(Charset.defaultCharset());
    }

    private static final Iterable getTypesFileLines$$anonfun$2$$anonfun$1(String typesFilename$3) {
        return File$.MODULE$.apply(typesFilename$3, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).lines(StandardCharsets.ISO_8859_1);
    }

    private static final Try getTypesFileLines$$anonfun$2(String typesFilename$2) {
        return Try$.MODULE$.apply(() -> SourceParser.getTypesFileLines$$anonfun$2$$anonfun$1(typesFilename$2));
    }
}

