/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.util;

import better.files.File;
import better.files.File$;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.util.SourceParser$;
import io.joern.javasrc2cpg.util.SourceParser$FileInfo$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;

public class SourceParser {
    private final List<String> relativeFilenames;
    private final Path analysisRoot;
    private final Path typesRoot;
    private final Option<Path> dirToDelete;
    private final Logger logger;

    public static SourceParser apply(Config config, Option<List<String>> option) {
        return SourceParser$.MODULE$.apply(config, option);
    }

    public static Option<File> fileIfExists(Path path) {
        return SourceParser$.MODULE$.fileIfExists(path);
    }

    public static Option<File> fileIfExists(String string) {
        return SourceParser$.MODULE$.fileIfExists(string);
    }

    public SourceParser(List<String> relativeFilenames, Path analysisRoot, Path typesRoot, Option<Path> dirToDelete) {
        this.relativeFilenames = relativeFilenames;
        this.analysisRoot = analysisRoot;
        this.typesRoot = typesRoot;
        this.dirToDelete = dirToDelete;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public List<String> relativeFilenames() {
        return this.relativeFilenames;
    }

    public Option<Tuple2<CompilationUnit, Option<String>>> parseAnalysisFile(String relativeFilename, boolean saveFileContent) {
        String analysisFilename = this.analysisRoot.resolve(relativeFilename).toString();
        return SourceParser$.MODULE$.fileIfExists(analysisFilename).flatMap((Function1 & Serializable)file -> {
            Option<CompilationUnit> compilationUnit = this.parse((File)file, true);
            Option fileContent = Option$.MODULE$.when(saveFileContent, () -> SourceParser.$anonfun$1(file)).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return compilationUnit.map((Function1 & Serializable)cu -> Tuple2$.MODULE$.apply(cu, (Object)fileContent));
        });
    }

    public Option<CompilationUnit> parseTypesFile(String relativeFilename) {
        String typesFilename = this.typesRoot.resolve(relativeFilename).toString();
        return SourceParser$.MODULE$.fileIfExists(typesFilename).flatMap((Function1 & Serializable)_$1 -> this.parse((File)_$1, false));
    }

    private Option<CompilationUnit> parse(File file, boolean storeTokens) {
        ParseResult parseResult;
        block6: {
            List list;
            block7: {
                List list2;
                Nil$ nil$;
                block5: {
                    ParserConfiguration javaParserConfig = new ParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.BLEEDING_EDGE).setStoreTokens(storeTokens);
                    parseResult = new JavaParser(javaParserConfig).parse(file.toJava());
                    list = CollectionConverters$.MODULE$.ListHasAsScala(parseResult.getProblems()).asScala().toList();
                    nil$ = package$.MODULE$.Nil();
                    list2 = list;
                    if (nil$ != null) break block5;
                    if (list2 == null) break block6;
                    break block7;
                }
                if (nil$.equals(list2)) break block6;
            }
            List problems = list;
            this.logger.warn("Encountered problems while parsing file " + file.name() + ":");
            problems.foreach((Function1)(JProcedure1 & Serializable)problem -> this.logger.warn("- " + problem.getMessage()));
        }
        Optional optional = OptionConverters$.MODULE$.RichOptional(parseResult.getResult());
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
        if (option instanceof Some) {
            CompilationUnit result = (CompilationUnit)((Some)option).value();
            Node.Parsedness parsedness = result.getParsed();
            Node.Parsedness parsedness2 = Node.Parsedness.PARSED;
            if (!(parsedness != null ? !parsedness.equals(parsedness2) : parsedness2 != null)) {
                return Some$.MODULE$.apply((Object)result);
            }
        }
        this.logger.warn("Failed to parse file " + file.name());
        return None$.MODULE$;
    }

    public void cleanupDelombokOutput() {
        this.dirToDelete.foreach((Function1 & Serializable)path -> {
            File file = File$.MODULE$.apply(path);
            return file.delete(file.delete$default$1(), file.delete$default$2());
        });
    }

    private static final String $anonfun$1$$anonfun$1(File file$2) {
        return IOUtils$.MODULE$.readEntireFile(file$2.path());
    }

    private static final String $anonfun$1$$anonfun$2$$anonfun$1(File file$4) {
        return file$4.contentAsString(Charset.defaultCharset());
    }

    private static final Try $anonfun$1$$anonfun$2(File file$3) {
        return Try$.MODULE$.apply(() -> SourceParser.$anonfun$1$$anonfun$2$$anonfun$1(file$3));
    }

    private static final String $anonfun$1$$anonfun$3$$anonfun$1(File file$6) {
        return file$6.contentAsString(StandardCharsets.ISO_8859_1);
    }

    private static final Try $anonfun$1$$anonfun$3(File file$5) {
        return Try$.MODULE$.apply(() -> SourceParser.$anonfun$1$$anonfun$3$$anonfun$1(file$5));
    }

    private static final Option $anonfun$1(File file$1) {
        return Try$.MODULE$.apply(() -> SourceParser.$anonfun$1$$anonfun$1(file$1)).orElse(() -> SourceParser.$anonfun$1$$anonfun$2(file$1)).orElse(() -> SourceParser.$anonfun$1$$anonfun$3(file$1)).toOption();
    }

    public static class FileInfo
    implements Product,
    Serializable {
        private final Path relativePath;
        private final Option<String> packageName;
        private final boolean usesLombok;

        public static FileInfo apply(Path path, Option<String> option, boolean bl) {
            return SourceParser$FileInfo$.MODULE$.apply(path, option, bl);
        }

        public static FileInfo fromProduct(Product product) {
            return SourceParser$FileInfo$.MODULE$.fromProduct(product);
        }

        public static Option<FileInfo> getFileInfo(Path path, String string) {
            return SourceParser$FileInfo$.MODULE$.getFileInfo(path, string);
        }

        public static FileInfo unapply(FileInfo fileInfo) {
            return SourceParser$FileInfo$.MODULE$.unapply(fileInfo);
        }

        public FileInfo(Path relativePath, Option<String> packageName, boolean usesLombok) {
            this.relativePath = relativePath;
            this.packageName = packageName;
            this.usesLombok = usesLombok;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.relativePath()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.packageName()));
            n = Statics.mix((int)n, (int)(this.usesLombok() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FileInfo)) return false;
            FileInfo fileInfo = (FileInfo)object;
            if (this.usesLombok() != fileInfo.usesLombok()) return false;
            Path path = this.relativePath();
            Path path2 = fileInfo.relativePath();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            Option<String> option = this.packageName();
            Option<String> option2 = fileInfo.packageName();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!fileInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FileInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "FileInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "relativePath";
                }
                case 1: {
                    return "packageName";
                }
                case 2: {
                    return "usesLombok";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path relativePath() {
            return this.relativePath;
        }

        public Option<String> packageName() {
            return this.packageName;
        }

        public boolean usesLombok() {
            return this.usesLombok;
        }

        public FileInfo copy(Path relativePath, Option<String> packageName, boolean usesLombok) {
            return new FileInfo(relativePath, packageName, usesLombok);
        }

        public Path copy$default$1() {
            return this.relativePath();
        }

        public Option<String> copy$default$2() {
            return this.packageName();
        }

        public boolean copy$default$3() {
            return this.usesLombok();
        }

        public Path _1() {
            return this.relativePath();
        }

        public Option<String> _2() {
            return this.packageName();
        }

        public boolean _3() {
            return this.usesLombok();
        }
    }
}

