/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.util;

import io.joern.javasrc2cpg.testfixtures.SourceCodeFixture;
import io.joern.javasrc2cpg.util.PackageRootFinder$;
import io.joern.javasrc2cpg.util.SourceParser;
import io.joern.x2cpg.utils.TestCodeWriter;
import java.io.Serializable;
import java.nio.file.Path;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.wordspec.AnyWordSpecLike;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class PackageRootFinderTests
extends SourceCodeFixture {
    public PackageRootFinderTests() {
        this.convertToStringShouldWrapperForVerb("the package root finder", Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32)).should((Function0 & Serializable)() -> {
            this.$init$$$anonfun$1();
            return BoxedUnit.UNIT;
        }, this.subjectRegistrationFunction());
    }

    public void rootFinderTest(List<Tuple2<String, String>> files, Set<String> expectedRoots, List<Tuple2<String, String>> nonSourceFiles) {
        Path testDir = ((TestCodeWriter)((LinearSeqOps)files.$plus$plus(nonSourceFiles)).foldLeft((Object)this.emptyWriter(), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                TestCodeWriter writer = (TestCodeWriter)tuple2._1();
                if (tuple22 != null) {
                    String code = (String)tuple22._1();
                    String fileName = (String)tuple22._2();
                    return writer.moreCode(code, fileName);
                }
            }
            throw new MatchError((Object)tuple2);
        })).writeCode(".java");
        List absoluteFilenames = files.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String filename = (String)tuple2._2();
                return testDir.resolve(filename);
            }
            throw new MatchError((Object)tuple2);
        });
        absoluteFilenames.permutations().foreach((Function1)(JProcedure1 & Serializable)filePermutation -> {
            Set foundRoots;
            List inputs = filePermutation.flatMap((Function1 & Serializable)input -> SourceParser.FileInfo$.MODULE$.getFileInfo(testDir, input.toString()));
            Set set = foundRoots = PackageRootFinder$.MODULE$.packageRootsFromFiles(testDir, inputs).toSet();
            Object object = expectedRoots.map((Function1 & Serializable)_$1 -> Path.of(_$1, new String[0]));
            if (set == null ? object != null : !set.equals(object)) {
                PackageRootFinderTests Assertions_this = this;
                String x$proxy1 = "Found package roots did not match expected package roots:\n                |Found roots   : " + ((IterableOnceOps)foundRoots.toList().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).mkString(",") + "\n                |Expected roots: " + ((IterableOnceOps)expectedRoots.toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(",") + "\n                |for input path permutation " + inputs.map((Function1 & Serializable)_$2 -> _$2.relativePath()).mkString(",");
                String message$proxy1 = StringOps$.MODULE$.stripMargin$extension(x$proxy1, '|');
                Position position = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 24);
                throw Assertions_this.org$scalatest$Assertions$$inline$failImpl(message$proxy1, position);
            }
        });
    }

    public List<Tuple2<String, String>> rootFinderTest$default$3() {
        return package$.MODULE$.Nil();
    }

    private final void f$proxy1$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"package foo;", (Object)"src/main/java/foo/A.java"), Tuple2$.MODULE$.apply((Object)"package foo.bar;", (Object)"src/main/java/foo/bar/B.java"), Tuple2$.MODULE$.apply((Object)"package baz;", (Object)"src/main/java/baz/C.java")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"src/main/java"}))), this.rootFinderTest$default$3());
    }

    private final void f$proxy2$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"package foo;", (Object)"src/main/java/foo/A.java"), Tuple2$.MODULE$.apply((Object)"package foo.bar;", (Object)"src/main/java/foo/bar/B.java"), Tuple2$.MODULE$.apply((Object)"package baz;", (Object)"src/test/java/baz/C.java")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"src/main/java", "src/test/java"}))), this.rootFinderTest$default$3());
    }

    private final void f$proxy3$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"package foo;", (Object)"src/main/java/foo/A.java"), Tuple2$.MODULE$.apply((Object)"package foo.bar;", (Object)"src/main/java/foo/bar/B.java"), Tuple2$.MODULE$.apply((Object)"package baz;", (Object)"src/test/java/baz/C.java")}));
        List nonSourceFiles = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"some stuff", (Object)"src/main/resources/stuff.config")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"src/main/java", "src/test/java"}))), (List<Tuple2<String, String>>)nonSourceFiles);
    }

    private final void f$proxy4$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"package unmatched;", (Object)"src/main/java/foo/A.java"), Tuple2$.MODULE$.apply((Object)"package unmatched.other;", (Object)"src/main/java/foo/bar/B.java"), Tuple2$.MODULE$.apply((Object)"package moreunmatched;", (Object)"src/test/java/baz/C.java")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)files.map((Function1 & Serializable)_$3 -> (String)_$3._2()).toSet(), this.rootFinderTest$default$3());
    }

    private final void f$proxy5$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"package unmatched;", (Object)"src/main/java/foo/A.java"), Tuple2$.MODULE$.apply((Object)"package foo.bar;", (Object)"src/main/java/foo/bar/B.java"), Tuple2$.MODULE$.apply((Object)"package more.unmatched;", (Object)"src/test/java/baz/C.java"), Tuple2$.MODULE$.apply((Object)"package even.more.unmatched;", (Object)"other/src/main/java/baz/D.java")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"src/main/java", "src/main/java/foo/A.java", "src/test/java/baz/C.java", "other/src/main/java/baz/D.java"}))), this.rootFinderTest$default$3());
    }

    private final void f$proxy6$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"", (Object)"A.java"), Tuple2$.MODULE$.apply((Object)"", (Object)"B.java")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A.java", "B.java"}))), this.rootFinderTest$default$3());
    }

    private final void f$proxy7$1() {
        List files = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Tuple2$.MODULE$.apply((Object)"", (Object)"A.java"), Tuple2$.MODULE$.apply((Object)"", (Object)"B.java"), Tuple2$.MODULE$.apply((Object)"package foo;", (Object)"src/foo/C.java")}));
        this.rootFinderTest((List<Tuple2<String, String>>)files, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"A.java", "B.java", "src"}))), this.rootFinderTest$default$3());
    }

    private final void $init$$$anonfun$1() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("find the package root for correctly structured code with a single root");
        PackageRootFinderTests AnyWordSpecLike_this = (PackageRootFinderTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy1$1();
            return BoxedUnit.UNIT;
        }, position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("find package roots for correctly structured code with multiple roots");
        PackageRootFinderTests AnyWordSpecLike_this2 = (PackageRootFinderTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy2$1();
            return BoxedUnit.UNIT;
        }, position2);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("find package roots for correctly structured code with multiple roots and non-source files");
        PackageRootFinderTests AnyWordSpecLike_this3 = (PackageRootFinderTests)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this3.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy3$1();
            return BoxedUnit.UNIT;
        }, position3);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this4 = this.convertToWordSpecStringWrapper("default to separate filenames for incorrectly structured code");
        PackageRootFinderTests AnyWordSpecLike_this4 = (PackageRootFinderTests)WordSpecStringWrapper_this4.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position4 = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65);
        AnyWordSpecLike_this4.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this4.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy4$1();
            return BoxedUnit.UNIT;
        }, position4);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this5 = this.convertToWordSpecStringWrapper("find the correct paths for mixed correctly and incorrectly structured code");
        PackageRootFinderTests AnyWordSpecLike_this5 = (PackageRootFinderTests)WordSpecStringWrapper_this5.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position5 = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75);
        AnyWordSpecLike_this5.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this5.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy5$1();
            return BoxedUnit.UNIT;
        }, position5);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this6 = this.convertToWordSpecStringWrapper("find the correct paths with only sources at the project root");
        PackageRootFinderTests AnyWordSpecLike_this6 = (PackageRootFinderTests)WordSpecStringWrapper_this6.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position6 = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91);
        AnyWordSpecLike_this6.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this6.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy6$1();
            return BoxedUnit.UNIT;
        }, position6);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this7 = this.convertToWordSpecStringWrapper("find the correct paths with some sources at the project root");
        PackageRootFinderTests AnyWordSpecLike_this7 = (PackageRootFinderTests)WordSpecStringWrapper_this7.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position7 = Position$.MODULE$.apply("PackageRootFinderTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96);
        AnyWordSpecLike_this7.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this7.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> {
            this.f$proxy7$1();
            return BoxedUnit.UNIT;
        }, position7);
    }
}

