/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import better.files.File;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolverBuilder;
import io.joern.x2cpg.SourceFiles$;
import java.io.Serializable;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;

public final class JdkJarTypeSolver$
implements Serializable {
    private static final String ClassExtension;
    private static final String JmodClassPrefix;
    private static final String JarExtension;
    private static final String JmodExtension;
    private static final Map<String, JdkJarTypeSolverBuilder> cache;
    public static final JdkJarTypeSolver$ MODULE$;

    private JdkJarTypeSolver$() {
    }

    static {
        MODULE$ = new JdkJarTypeSolver$();
        ClassExtension = ".class";
        JmodClassPrefix = "classes/";
        JarExtension = ".jar";
        JmodExtension = ".jmod";
        cache = (Map)Map$.MODULE$.empty();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JdkJarTypeSolver$.class);
    }

    public String ClassExtension() {
        return ClassExtension;
    }

    public String JmodClassPrefix() {
        return JmodClassPrefix;
    }

    public String JarExtension() {
        return JarExtension;
    }

    public String JmodExtension() {
        return JmodExtension;
    }

    public boolean isJarPath(String path) {
        return path.endsWith(this.JarExtension());
    }

    public boolean isJmodPath(String path) {
        return path.endsWith(this.JmodExtension());
    }

    private List<String> determineJarPaths(String jdkPath) {
        List jarPaths = SourceFiles$.MODULE$.determine(jdkPath, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.JarExtension(), this.JmodExtension()})), SourceFiles$.MODULE$.determine$default$3(), SourceFiles$.MODULE$.determine$default$4(), SourceFiles$.MODULE$.determine$default$5(), File.VisitOptions$.MODULE$.default());
        if (jarPaths.isEmpty()) {
            throw new IllegalArgumentException("No .jar or .jmod files found at JDK path " + jdkPath);
        }
        return jarPaths;
    }

    public JdkJarTypeSolver fromJdkPath(String jdkPath, boolean useCache) {
        if (useCache) {
            return ((JdkJarTypeSolverBuilder)cache.getOrElseUpdate((Object)jdkPath, () -> this.fromJdkPath$$anonfun$1(jdkPath))).build();
        }
        return this.createBuilder$1(jdkPath).build();
    }

    public boolean fromJdkPath$default$2() {
        return false;
    }

    public String packagePrefixForJavaParserName(String className) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])className.split("\\."));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 2)).mkString(".");
    }

    public String packagePrefixForJarEntry(String entryName) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])entryName.split("/"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.take$extension(object, 2)).mkString(".");
    }

    public String packagePrefixForJmodEntry(String entryName) {
        return this.packagePrefixForJarEntry(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(entryName), this.JmodClassPrefix()));
    }

    private boolean namePartsContainSubclass(String[] nameParts) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])nameParts);
        String[] stringArray = (String[])ArrayOps$.MODULE$.takeRight$extension(object, 2);
        if (stringArray != null) {
            Object object2 = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2, 0) == 0) {
                return false;
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2, 1) == 0) {
                String string;
                String singlePart = string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 0);
                return false;
            }
            if (Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2, 2) == 0) {
                String string = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 0);
                String string2 = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 1);
                String secondLast = string;
                String last = string2;
                return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(last)))) || RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(secondLast)))) && RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(last))));
            }
        }
        throw new MatchError((Object)stringArray);
    }

    public String convertJavaParserNameToStandard(String className) {
        Object[] objectArray = className.split(".");
        Object[] nameParts = objectArray;
        if (this.namePartsContainSubclass((String[])nameParts)) {
            Object object = Predef$.MODULE$.refArrayOps(nameParts);
            Tuple2 tuple2 = ArrayOps$.MODULE$.partition$extension(object, (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(_$1)))));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String[] packagePrefix = (String[])tuple2._1();
            String[] classNames = (String[])tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)packagePrefix, (Object)classNames);
            Object[] packagePrefix2 = (String[])tuple22._1();
            Object[] classNames2 = (String[])tuple22._2();
            return Predef$.MODULE$.wrapRefArray(packagePrefix2).mkString(".") + "." + Predef$.MODULE$.wrapRefArray(classNames2).mkString("$");
        }
        return className;
    }

    private final JdkJarTypeSolverBuilder createBuilder$1(String jdkPath$1) {
        return new JdkJarTypeSolverBuilder().withJars((Seq<String>)this.determineJarPaths(jdkPath$1));
    }

    private final JdkJarTypeSolverBuilder fromJdkPath$$anonfun$1(String jdkPath$2) {
        return this.createBuilder$1(jdkPath$2);
    }
}

