/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.JmodClassPath;
import io.joern.javasrc2cpg.typesolvers.NonCachingClassPool;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.JarFile;
import javassist.ClassPath;
import javassist.CtClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public class JdkJarTypeSolver
implements TypeSolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Option<TypeSolver> parent = None$.MODULE$;
    private final NonCachingClassPool classPool = new NonCachingClassPool();
    private final Set<String> knownPackagePrefixes = (Set)Set$.MODULE$.empty();

    public static String ClassExtension() {
        return JdkJarTypeSolver$.MODULE$.ClassExtension();
    }

    public static String JarExtension() {
        return JdkJarTypeSolver$.MODULE$.JarExtension();
    }

    public static String JmodClassPrefix() {
        return JdkJarTypeSolver$.MODULE$.JmodClassPrefix();
    }

    public static String JmodExtension() {
        return JdkJarTypeSolver$.MODULE$.JmodExtension();
    }

    public static String convertJavaParserNameToStandard(String string) {
        return JdkJarTypeSolver$.MODULE$.convertJavaParserNameToStandard(string);
    }

    public static JdkJarTypeSolver fromJdkPath(String string) {
        return JdkJarTypeSolver$.MODULE$.fromJdkPath(string);
    }

    public static boolean isJarPath(String string) {
        return JdkJarTypeSolver$.MODULE$.isJarPath(string);
    }

    public static boolean isJmodPath(String string) {
        return JdkJarTypeSolver$.MODULE$.isJmodPath(string);
    }

    public static String packagePrefixForJarEntry(String string) {
        return JdkJarTypeSolver$.MODULE$.packagePrefixForJarEntry(string);
    }

    public static String packagePrefixForJavaParserName(String string) {
        return JdkJarTypeSolver$.MODULE$.packagePrefixForJavaParserName(string);
    }

    public static String packagePrefixForJmodEntry(String string) {
        return JdkJarTypeSolver$.MODULE$.packagePrefixForJmodEntry(string);
    }

    public TypeSolver getParent() {
        return (TypeSolver)this.parent.get();
    }

    public void setParent(TypeSolver parent) {
        Option<TypeSolver> option = this.parent;
        if (None$.MODULE$.equals(option)) {
            this.parent = Some$.MODULE$.apply((Object)parent);
            return;
        }
        if (option instanceof Some) {
            throw new RuntimeException("JdkJarTypeSolver parent may only be set once");
        }
        throw new MatchError(option);
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String javaParserName) {
        String packagePrefix = JdkJarTypeSolver$.MODULE$.packagePrefixForJavaParserName(javaParserName);
        if (this.knownPackagePrefixes.contains((Object)packagePrefix)) {
            return this.lookupType(javaParserName);
        }
        return SymbolReference.unsolved();
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> lookupType(String javaParserName) {
        String name = JdkJarTypeSolver$.MODULE$.convertJavaParserNameToStandard(javaParserName);
        Try try_ = Try$.MODULE$.apply(() -> this.lookupType$$anonfun$1(name));
        if (try_ instanceof Success) {
            CtClass ctClass = (CtClass)((Success)try_).value();
            ResolvedReferenceTypeDeclaration refType = this.ctClassToRefType(ctClass);
            return this.refTypeToSymbolReference(refType);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            return SymbolReference.unsolved();
        }
        throw new MatchError((Object)try_);
    }

    public ResolvedReferenceTypeDeclaration solveType(String name) {
        SymbolReference<ResolvedReferenceTypeDeclaration> symbolReference = this.tryToSolveType(name);
        SymbolReference<ResolvedReferenceTypeDeclaration> symbolReference2 = symbolReference;
        if (symbolReference2.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)symbolReference2.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    private ResolvedReferenceTypeDeclaration ctClassToRefType(CtClass ctClass) {
        return JavassistFactory.toTypeDeclaration((CtClass)ctClass, (TypeSolver)this.getRoot());
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> refTypeToSymbolReference(ResolvedReferenceTypeDeclaration refType) {
        return SymbolReference.solved((ResolvedDeclaration)refType);
    }

    private Try<ClassPath> addPathToClassPool(String archivePath) {
        if (JdkJarTypeSolver$.MODULE$.isJarPath(archivePath)) {
            return Try$.MODULE$.apply(() -> this.addPathToClassPool$$anonfun$1(archivePath));
        }
        if (JdkJarTypeSolver$.MODULE$.isJmodPath(archivePath)) {
            JmodClassPath classPath = new JmodClassPath(archivePath);
            return Try$.MODULE$.apply(() -> this.addPathToClassPool$$anonfun$2(classPath));
        }
        return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException("$archivePath is not a path to a jar/jmod"));
    }

    public JdkJarTypeSolver withJars(Seq<String> archivePaths) {
        this.addArchives(archivePaths);
        return this;
    }

    public void addArchives(Seq<String> archivePaths) {
        archivePaths.foreach((Function1)(JProcedure1 & Serializable)archivePath -> {
            Try<ClassPath> try_ = this.addPathToClassPool((String)archivePath);
            if (try_ instanceof Success) {
                this.registerPackagesForJar((String)archivePath);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.logger.warn("Could not load jar at path " + archivePath, (Object)e.getMessage());
                return;
            }
            throw new MatchError(try_);
        });
    }

    private void registerPackagesForJar(String archivePath) {
        Function1 & Serializable entryNameConverter = JdkJarTypeSolver$.MODULE$.isJarPath(archivePath) ? (Function1 & Serializable)entryName -> JdkJarTypeSolver$.MODULE$.packagePrefixForJarEntry((String)entryName) : (Function1 & Serializable)entryName -> JdkJarTypeSolver$.MODULE$.packagePrefixForJmodEntry((String)entryName);
        try {
            Using$.MODULE$.apply(() -> JdkJarTypeSolver.registerPackagesForJar$$anonfun$1(archivePath), (Function1 & Serializable)jarFile -> (Set)this.knownPackagePrefixes.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.IteratorHasAsScala(jarFile.entries().asIterator()).asScala().filter((Function1 & Serializable)entry -> !entry.isDirectory() && entry.getName().endsWith(JdkJarTypeSolver$.MODULE$.ClassExtension())).map((Function1 & Serializable)entry -> (String)entryNameConverter.apply((Object)entry.getName()))), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        catch (IOException ioException) {
            this.logger.warn("Could register classes for archive at " + archivePath, (Object)ioException.getMessage());
        }
    }

    private final CtClass lookupType$$anonfun$1(String name$1) {
        return this.classPool.get(name$1);
    }

    private final ClassPath addPathToClassPool$$anonfun$1(String archivePath$1) {
        return this.classPool.appendClassPath(archivePath$1);
    }

    private final ClassPath addPathToClassPool$$anonfun$2(JmodClassPath classPath$1) {
        return this.classPool.appendClassPath(classPath$1);
    }

    private static final JarFile registerPackagesForJar$$anonfun$1(String archivePath$2) {
        return new JarFile(archivePath$2);
    }
}

