/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.symbolsolver.javassistmodel.JavassistFactory;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import io.joern.javasrc2cpg.typesolvers.JdkJarTypeSolver$;
import io.joern.javasrc2cpg.typesolvers.JmodClassPath;
import io.joern.javasrc2cpg.typesolvers.NonCachingClassPool;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPath;
import javassist.CtClass;
import javassist.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public class JdkJarTypeSolver
implements TypeSolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Option<TypeSolver> parent = None$.MODULE$;
    private final NonCachingClassPool classPool = new NonCachingClassPool();
    private final Map<String, String> javaParserToClassPoolNames = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));

    public static String ClassExtension() {
        return JdkJarTypeSolver$.MODULE$.ClassExtension();
    }

    public static String JarExtension() {
        return JdkJarTypeSolver$.MODULE$.JarExtension();
    }

    public static String JmodClassPrefix() {
        return JdkJarTypeSolver$.MODULE$.JmodClassPrefix();
    }

    public static String JmodExtension() {
        return JdkJarTypeSolver$.MODULE$.JmodExtension();
    }

    public static String convertEntryPathToClassPoolName(String string) {
        return JdkJarTypeSolver$.MODULE$.convertEntryPathToClassPoolName(string);
    }

    public static String convertEntryPathToJavaParserName(String string) {
        return JdkJarTypeSolver$.MODULE$.convertEntryPathToJavaParserName(string);
    }

    public static JdkJarTypeSolver fromJdkPath(String string) {
        return JdkJarTypeSolver$.MODULE$.fromJdkPath(string);
    }

    public static boolean isJarPath(String string) {
        return JdkJarTypeSolver$.MODULE$.isJarPath(string);
    }

    public static boolean isJmodPath(String string) {
        return JdkJarTypeSolver$.MODULE$.isJmodPath(string);
    }

    public JdkJarTypeSolver(String jdkPath) {
    }

    public TypeSolver getParent() {
        return (TypeSolver)this.parent.get();
    }

    public void setParent(TypeSolver parent) {
        Option<TypeSolver> option = this.parent;
        if (None$.MODULE$.equals(option)) {
            this.parent = Some$.MODULE$.apply((Object)parent);
            return;
        }
        if (option instanceof Some) {
            throw new RuntimeException("JdkJarTypeSolver parent may only be set once");
        }
        throw new MatchError(option);
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String javaParserName) {
        return (SymbolReference)this.javaParserToClassPoolNames.get((Object)javaParserName).flatMap((Function1 & Serializable)name -> this.lookupAndConvertClass((String)name)).getOrElse(JdkJarTypeSolver::tryToSolveType$$anonfun$2);
    }

    public ResolvedReferenceTypeDeclaration solveType(String name) {
        SymbolReference<ResolvedReferenceTypeDeclaration> symbolReference = this.tryToSolveType(name);
        SymbolReference<ResolvedReferenceTypeDeclaration> symbolReference2 = symbolReference;
        if (symbolReference2.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)symbolReference2.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    private ResolvedReferenceTypeDeclaration ctClassToRefType(CtClass ctClass) {
        return JavassistFactory.toTypeDeclaration((CtClass)ctClass, (TypeSolver)this.getRoot());
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> refTypeToSymbolReference(ResolvedReferenceTypeDeclaration refType) {
        return SymbolReference.solved((ResolvedDeclaration)refType);
    }

    private Option<SymbolReference<ResolvedReferenceTypeDeclaration>> lookupAndConvertClass(String name) {
        Try try_ = Try$.MODULE$.apply(() -> this.lookupAndConvertClass$$anonfun$1(name));
        if (try_ instanceof Success) {
            CtClass ctClass = (CtClass)((Success)try_).value();
            ResolvedReferenceTypeDeclaration refType = this.ctClassToRefType(ctClass);
            SymbolReference<ResolvedReferenceTypeDeclaration> solvedSymbol = this.refTypeToSymbolReference(refType);
            return Some$.MODULE$.apply(solvedSymbol);
        }
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            if (throwable instanceof NotFoundException) {
                this.logger.error("BUG! Could not find class " + name + " in class pool. This is not supposed to be possible!");
                return None$.MODULE$;
            }
            Throwable e = throwable;
            this.logger.warn("Unexpected exception getting $name from class pool", e);
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Try<ClassPath> addPathToClassPool(String archivePath) {
        if (JdkJarTypeSolver$.MODULE$.isJarPath(archivePath)) {
            return Try$.MODULE$.apply(() -> this.addPathToClassPool$$anonfun$1(archivePath));
        }
        if (JdkJarTypeSolver$.MODULE$.isJmodPath(archivePath)) {
            JmodClassPath classPath = new JmodClassPath(archivePath);
            return Try$.MODULE$.apply(() -> this.addPathToClassPool$$anonfun$2(classPath));
        }
        return Failure$.MODULE$.apply((Throwable)new IllegalArgumentException("$archivePath is not a path to a jar/jmod"));
    }

    public JdkJarTypeSolver withJars(Seq<String> archivePaths) {
        this.addArchives(archivePaths);
        return this;
    }

    public void addArchives(Seq<String> archivePaths) {
        archivePaths.foreach((Function1)(JProcedure1 & Serializable)archivePath -> {
            Try<ClassPath> try_ = this.addPathToClassPool((String)archivePath);
            if (try_ instanceof Success) {
                this.registerKnownClassesForJar((String)archivePath);
                return;
            }
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.logger.warn("Could not load jar at path " + archivePath, (Object)e.getMessage());
                return;
            }
            throw new MatchError(try_);
        });
    }

    private void registerJarEntry(JarEntry jarEntry) {
        String entryName = jarEntry.getName();
        if (!jarEntry.isDirectory() && entryName.endsWith(JdkJarTypeSolver$.MODULE$.ClassExtension())) {
            String javaParserName = JdkJarTypeSolver$.MODULE$.convertEntryPathToJavaParserName(entryName);
            String classPoolName = JdkJarTypeSolver$.MODULE$.convertEntryPathToClassPoolName(entryName);
            String string = javaParserName;
            String string2 = classPoolName;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.javaParserToClassPoolNames.put((Object)javaParserName, (Object)javaParserName);
                return;
            }
            this.javaParserToClassPoolNames.put((Object)javaParserName, (Object)classPoolName);
            return;
        }
    }

    private void registerKnownClassesForJar(String jarPath) {
        try {
            Using$.MODULE$.apply(() -> JdkJarTypeSolver.registerKnownClassesForJar$$anonfun$1(jarPath), (Function1)(JProcedure1 & Serializable)jarFile -> CollectionConverters$.MODULE$.IteratorHasAsScala(jarFile.entries().asIterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)jarEntry -> this.registerJarEntry((JarEntry)jarEntry)), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        catch (IOException ioException) {
            this.logger.warn("Could register classes for jar/jmod at " + jarPath, (Object)ioException.getMessage());
        }
    }

    private static final SymbolReference tryToSolveType$$anonfun$2() {
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }

    private final CtClass lookupAndConvertClass$$anonfun$1(String name$1) {
        return this.classPool.get(name$1);
    }

    private final ClassPath addPathToClassPool$$anonfun$1(String archivePath$1) {
        return this.classPool.appendClassPath(archivePath$1);
    }

    private final ClassPath addPathToClassPool$$anonfun$2(JmodClassPath classPath$1) {
        return this.classPool.appendClassPath(classPath$1);
    }

    private static final JarFile registerKnownClassesForJar$$anonfun$1(String jarPath$1) {
        return new JarFile(jarPath$1);
    }
}

