/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.jartypereader;

import io.joern.javasrc2cpg.jartypereader.descriptorparser.DescriptorParser$;
import io.joern.javasrc2cpg.jartypereader.model.ClassSignature;
import io.joern.javasrc2cpg.jartypereader.model.ClassSignature$;
import io.joern.javasrc2cpg.jartypereader.model.ClassTypeSignature;
import io.joern.javasrc2cpg.jartypereader.model.ClassTypeSignature$;
import io.joern.javasrc2cpg.jartypereader.model.MethodSignature;
import io.joern.javasrc2cpg.jartypereader.model.NameWithTypeArgs;
import io.joern.javasrc2cpg.jartypereader.model.NameWithTypeArgs$;
import io.joern.javasrc2cpg.jartypereader.model.ReferenceTypeSignature;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedMethod;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedMethod$;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedTypeDecl;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedTypeDecl$;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedVariableType;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedVariableType$;
import io.joern.javasrc2cpg.jartypereader.model.TypeArgument;
import io.joern.javasrc2cpg.jartypereader.model.TypeParameter;
import java.io.Serializable;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JarTypeReader$
implements Serializable {
    private static final Logger logger;
    private static final ClassTypeSignature ObjectTypeSignature;
    public static final JarTypeReader$ MODULE$;

    private JarTypeReader$() {
    }

    static {
        MODULE$ = new JarTypeReader$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        Some packageSpecifier = Some$.MODULE$.apply((Object)"java.lang");
        NameWithTypeArgs signature = NameWithTypeArgs$.MODULE$.apply("Object", (List<TypeArgument>)package$.MODULE$.Nil());
        ObjectTypeSignature = ClassTypeSignature$.MODULE$.apply((Option<String>)packageSpecifier, signature, (List<NameWithTypeArgs>)package$.MODULE$.Nil());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JarTypeReader$.class);
    }

    public ClassTypeSignature ObjectTypeSignature() {
        return ObjectTypeSignature;
    }

    public List<ResolvedTypeDecl> getTypes(String jarPath) {
        ClassPool cp = new ClassPool();
        cp.insertClassPath(jarPath);
        JarFile jarFile = new JarFile(jarPath);
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(jarFile.entries()).asScala().filter((Function1 & Serializable)_$1 -> _$1.getName().endsWith(".class")).map((Function1 & Serializable)entry -> StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entry.getRealName().replace("/", ".")), 6)).flatMap((Function1 & Serializable)_$2 -> this.getTypeDeclForEntry(cp, (String)_$2)).toList();
    }

    public ResolvedMethod getTypeEntryForMethod(CtMethod method, ResolvedTypeDecl parentDecl) {
        String name = method.getName();
        String signatureDescriptor = (String)Option$.MODULE$.apply((Object)method.getGenericSignature()).getOrElse(() -> this.$anonfun$1(method));
        MethodSignature signature = DescriptorParser$.MODULE$.parseMethodSignature(signatureDescriptor);
        boolean isAbstract = method.isEmpty();
        return ResolvedMethod$.MODULE$.apply(name, parentDecl, signature, isAbstract);
    }

    private ClassTypeSignature classTypeSignatureFromString(String signature) {
        List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(signature), '.')).toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            logger.warn(signature + " is not a valid class signature");
            return ClassTypeSignature$.MODULE$.apply((Option<String>)None$.MODULE$, NameWithTypeArgs$.MODULE$.apply("", (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            String name = (String)colon2.head();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return ClassTypeSignature$.MODULE$.apply((Option<String>)None$.MODULE$, NameWithTypeArgs$.MODULE$.apply(name, (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
            }
        }
        List nameWithPkg = list;
        String packagePrefix = ((IterableOnceOps)nameWithPkg.init()).mkString(".");
        String name = (String)nameWithPkg.last();
        return ClassTypeSignature$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)packagePrefix), NameWithTypeArgs$.MODULE$.apply(name, (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
    }

    private ClassSignature getCtClassSignature(CtClass ctClass) {
        ClassFile classFile = ctClass.getClassFile2();
        Nil$ typeParameters = package$.MODULE$.Nil();
        Option superclassSignature = Option$.MODULE$.unless(classFile.isInterface(), () -> this.$anonfun$2(classFile));
        Object object = Predef$.MODULE$.refArrayOps((Object[])classFile.getInterfaces());
        List interfacesSignatures = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)signature -> this.classTypeSignatureFromString((String)signature), ClassTag$.MODULE$.apply(ClassTypeSignature.class))).toList();
        return ClassSignature$.MODULE$.apply((List<TypeParameter>)typeParameters, (Option<ClassTypeSignature>)superclassSignature, (List<ClassTypeSignature>)interfacesSignatures);
    }

    private ResolvedVariableType getResolvedField(CtField ctField) {
        String name = ctField.getName();
        String signatureDescriptor = (String)Option$.MODULE$.apply((Object)ctField.getGenericSignature()).getOrElse(() -> this.$anonfun$4(ctField));
        ReferenceTypeSignature signature = DescriptorParser$.MODULE$.parseFieldSignature(signatureDescriptor);
        return ResolvedVariableType$.MODULE$.apply(name, signature);
    }

    public Option<ResolvedTypeDecl> getTypeDeclForEntry(ClassPool cp, String name) {
        Try try_ = Try$.MODULE$.apply(() -> this.getTypeDeclForEntry$$anonfun$1(cp, name));
        if (try_ instanceof Success) {
            CtClass ctClass = (CtClass)((Success)try_).value();
            String name2 = ctClass.getSimpleName();
            String packageSpecifier = ctClass.getPackageName();
            ClassSignature signature = (ClassSignature)Option$.MODULE$.apply((Object)ctClass.getGenericSignature()).map((Function1 & Serializable)descriptor -> DescriptorParser$.MODULE$.parseClassSignature((String)descriptor)).getOrElse(() -> this.$anonfun$6(ctClass));
            boolean isInterface = ctClass.isInterface();
            boolean isAbstract = !isInterface && ctClass.getClassFile2().isAbstract();
            Object object = Predef$.MODULE$.refArrayOps((Object[])ctClass.getFields());
            List fields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)ctField -> this.getResolvedField((CtField)ctField), ClassTag$.MODULE$.apply(ResolvedVariableType.class))).toList();
            ResolvedTypeDecl typeDecl = ResolvedTypeDecl$.MODULE$.apply(name2, (Option<String>)Some$.MODULE$.apply((Object)packageSpecifier), signature, isInterface, isAbstract, (List<ResolvedVariableType>)fields, ResolvedTypeDecl$.MODULE$.apply$default$7());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ctClass.getMethods());
            List methods = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$3 -> this.getTypeEntryForMethod((CtMethod)_$3, typeDecl), ClassTag$.MODULE$.apply(ResolvedMethod.class))).toList();
            typeDecl.addMethods((List<ResolvedMethod>)methods);
            return Some$.MODULE$.apply((Object)typeDecl);
        }
        if (try_ instanceof Failure) {
            if (((Failure)try_).exception() instanceof NotFoundException) {
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private final String $anonfun$1(CtMethod method$1) {
        return method$1.getSignature();
    }

    private final ClassTypeSignature $anonfun$2(ClassFile classFile$1) {
        return this.classTypeSignatureFromString(classFile$1.getSuperclass());
    }

    private final String $anonfun$4(CtField ctField$1) {
        return ctField$1.getSignature();
    }

    private final CtClass getTypeDeclForEntry$$anonfun$1(ClassPool cp$2, String name$1) {
        return cp$2.get(name$1);
    }

    private final ClassSignature $anonfun$6(CtClass ctClass$1) {
        return this.getCtClassSignature(ctClass$1);
    }
}

