/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.passes;

import better.files.File;
import better.files.File$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile$;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class ConfigFileCreationPass
extends ConcurrentWriterCpgPass<File> {
    private final String projectDir;
    private final Logger logger;
    private final List<Function1<File, Object>> configFileFilters;

    public ConfigFileCreationPass(String projectDir, Cpg cpg) {
        this.projectDir = projectDir;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
        this.configFileFilters = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable)file -> this.extensionFilter(".properties", (File)file), (Function1 & Serializable)file -> this.extensionFilter(".jsp", (File)file), (Function1 & Serializable)file -> this.extensionFilter(".vm", (File)file), (Function1 & Serializable)file -> this.extensionFilter(".tf", (File)file), (Function1 & Serializable)file -> this.extensionFilter(".tfvars", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("routes", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("application.conf", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("web.xml", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("faces-config.xml", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("struts.xml", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("dwr.xml", (File)file), (Function1 & Serializable)file -> this.mybatisFilter((File)file), (Function1 & Serializable)file -> this.pathEndFilter("build.gradle", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("build.gradle.kts", (File)file), (Function1 & Serializable)file -> this.pathEndFilter("AndroidManifest.xml", (File)file)}));
    }

    public File[] generateParts() {
        Try try_ = Try$.MODULE$.apply(this::generateParts$$anonfun$1);
        if (try_ instanceof Success) {
            File file2 = (File)((Success)try_).value();
            File file3 = file2;
            if (file3.isDirectory(file3.isDirectory$default$1())) {
                return (File[])file3.listRecursively(file3.listRecursively$default$1()).filter((Function1 & Serializable)file -> this.isConfigFile((File)file)).toArray(ClassTag$.MODULE$.apply(File.class));
            }
            File file4 = file2;
            if (this.isConfigFile(file4)) {
                return new File[]{file4};
            }
        }
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, File file) {
        Try try_ = Try$.MODULE$.apply(() -> ConfigFileCreationPass.runOnPart$$anonfun$1(file));
        if (try_ instanceof Success) {
            Seq fileContentsLines = (Seq)((Success)try_).value();
            String name = this.configFileName(file);
            String content = fileContentsLines.mkString("\n");
            NewConfigFile configNode = NewConfigFile$.MODULE$.apply().name(name).content(content);
            this.logger.debug(new StringBuilder(19).append("Adding config file ").append(name).toString());
            diffGraph.addNode((DetachedNodeData)configNode);
            return;
        }
        if (try_ instanceof Failure) {
            Throwable error = ((Failure)try_).exception();
            this.logger.warn(new StringBuilder(40).append("Unable to create config file node for ").append(file.canonicalPath()).append(": ").append(error).toString());
            return;
        }
        throw new MatchError((Object)try_);
    }

    private String configFileName(File configFile) {
        return (String)Try$.MODULE$.apply(this::configFileName$$anonfun$1).map((Function1 & Serializable)_$1 -> _$1.relativize(configFile.path().toAbsolutePath()).toString()).orElse(() -> ConfigFileCreationPass.configFileName$$anonfun$3(configFile)).getOrElse(() -> ConfigFileCreationPass.configFileName$$anonfun$4(configFile));
    }

    private boolean extensionFilter(String extension, File file) {
        return file.extension().contains((Object)extension);
    }

    private boolean pathEndFilter(String pathEnd, File file) {
        return file.canonicalPath().endsWith(pathEnd);
    }

    private boolean mybatisFilter(File file) {
        return file.canonicalPath().contains("batis") && file.extension().contains((Object)".xml");
    }

    private boolean isConfigFile(File file) {
        return this.configFileFilters.exists((Function1 & Serializable)predicate -> BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)file)));
    }

    private final File generateParts$$anonfun$1() {
        return File$.MODULE$.apply(this.projectDir, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private static final Seq runOnPart$$anonfun$1(File file$1) {
        return IOUtils$.MODULE$.readLinesInFile(file$1.path());
    }

    private final Path configFileName$$anonfun$1() {
        return Paths.get(this.projectDir, new String[0]).toAbsolutePath();
    }

    private static final String configFileName$$anonfun$3$$anonfun$1(File configFile$3) {
        return configFile$3.pathAsString();
    }

    private static final Try configFileName$$anonfun$3(File configFile$2) {
        return Try$.MODULE$.apply(() -> ConfigFileCreationPass.configFileName$$anonfun$3$$anonfun$1(configFile$2));
    }

    private static final String configFileName$$anonfun$4(File configFile$4) {
        return configFile$4.name();
    }
}

