/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.util;

import com.github.javaparser.resolution.declarations.ResolvedDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.declarations.ResolvedTypeDeclaration;
import com.github.javaparser.symbolsolver.cache.GuavaCache;
import com.github.javaparser.symbolsolver.model.resolution.SymbolReference;
import com.github.javaparser.symbolsolver.model.resolution.TypeSolver;
import com.github.javaparser.symbolsolver.reflectionmodel.ReflectionFactory;
import com.github.javaparser.symbolsolver.resolution.typesolvers.ReflectionTypeSolver;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Optional;
import scala.Function1;
import scala.Option;
import scala.jdk.CollectionConverters$;

public class CachingReflectionTypeSolver
extends ReflectionTypeSolver {
    private final GuavaCache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> cache = new GuavaCache(CacheBuilder.newBuilder().build());
    private final ClassLoader classLoader = CachingReflectionTypeSolver.class.getClassLoader();

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        if (this.filterName(name)) {
            SymbolReference symbolReference;
            if (this.classLoader == null) {
                throw new RuntimeException("The ClassLoaderTypeSolver has been probably loaded through the bootstrap class loader. This usage is not supported by the JavaSymbolSolver");
            }
            Optional symbolReferenceOption = this.cache.get((Object)name);
            if (symbolReferenceOption.isPresent()) {
                return (SymbolReference)symbolReferenceOption.get();
            }
            try {
                Class<?> clazz = this.classLoader.loadClass(name);
                SymbolReference symbolReference2 = SymbolReference.solved((ResolvedDeclaration)ReflectionFactory.typeDeclarationFor(clazz, (TypeSolver)this.getRoot()));
                this.cache.put((Object)name, (Object)symbolReference2);
                symbolReference = symbolReference2;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                symbolReference = SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                SymbolReference symbolReference3 = this.innerClassLookup(name);
                this.cache.put((Object)name, symbolReference3);
                symbolReference = symbolReference3;
            }
            return symbolReference;
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }

    private SymbolReference<ResolvedReferenceTypeDeclaration> innerClassLookup(String name) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
        }
        String parentName = name.substring(0, lastDot);
        String childName = name.substring(lastDot + 1);
        SymbolReference<ResolvedReferenceTypeDeclaration> parent = this.tryToSolveType(parentName);
        if (parent.isSolved()) {
            Option innerClass = CollectionConverters$.MODULE$.SetHasAsScala(((ResolvedTypeDeclaration)parent.getCorrespondingDeclaration()).internalTypes()).asScala().find((Function1 & Serializable)_$1 -> {
                String string = _$1.getName();
                String string2 = childName;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            return (SymbolReference)innerClass.map((Function1 & Serializable)x$0 -> SymbolReference.solved((ResolvedDeclaration)x$0)).getOrElse(CachingReflectionTypeSolver::innerClassLookup$$anonfun$2);
        }
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }

    private static final SymbolReference innerClassLookup$$anonfun$2() {
        return SymbolReference.unsolved(ResolvedReferenceTypeDeclaration.class);
    }
}

