/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg;

import better.files.File$;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.JavaSrc2Cpg$;
import io.joern.javasrc2cpg.SourceDirectoryInfo;
import io.joern.javasrc2cpg.SourceDirectoryInfo$;
import io.joern.javasrc2cpg.SourceFileInfo;
import io.joern.javasrc2cpg.SourceFileInfo$;
import io.joern.javasrc2cpg.passes.AstCreationPass;
import io.joern.javasrc2cpg.passes.ConfigFileCreationPass;
import io.joern.javasrc2cpg.util.Delombok;
import io.joern.javasrc2cpg.util.Delombok$;
import io.joern.javasrc2cpg.util.Delombok$DelombokMode$Default$;
import io.joern.javasrc2cpg.util.Delombok$DelombokMode$NoDelombok$;
import io.joern.javasrc2cpg.util.Delombok$DelombokMode$RunDelombok$;
import io.joern.javasrc2cpg.util.Delombok$DelombokMode$TypesOnly$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.TypeNodePass;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.joern.x2cpg.utils.dependency.DependencyResolver$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure2;
import scala.util.Try;

public class JavaSrc2Cpg
implements X2CpgFrontend<Config> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set sourceFileExtensions = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".java"}));

    public static JavaSrc2Cpg apply() {
        return JavaSrc2Cpg$.MODULE$.apply();
    }

    public static String language() {
        return JavaSrc2Cpg$.MODULE$.language();
    }

    public Set<String> sourceFileExtensions() {
        return this.sourceFileExtensions;
    }

    public Try<Cpg> createCpg(Config config2) {
        return X2Cpg$.MODULE$.withNewEmptyCpg(config2.outputPath(), (X2CpgConfig)config2, (Function2)(JProcedure2 & Serializable)(cpg, config) -> {
            new MetaDataPass(cpg, JavaSrc2Cpg$.MODULE$.language(), config.inputPath()).createAndApply();
            scala.collection.immutable.Seq<String> dependencies = this.getDependencyList((Config)config);
            boolean hasLombokDependency = dependencies.exists((Function1 & Serializable)_$1 -> _$1.contains("lombok"));
            SourceDirectoryInfo sourcesInfo = this.getSourcesFromDir((Config)config, hasLombokDependency);
            if (sourcesInfo.sourceFiles().isEmpty()) {
                this.logger.error(new StringBuilder(30).append("no source files found at path ").append(config.inputPath()).toString());
            } else {
                this.logger.info(new StringBuilder(19).append("found ").append(sourcesInfo.sourceFiles().size()).append(" source files").toString());
            }
            AstCreationPass astCreator = new AstCreationPass(sourcesInfo, (Config)config, (Cpg)cpg, dependencies);
            astCreator.createAndApply();
            new ConfigFileCreationPass(config.inputPath(), (Cpg)cpg).createAndApply();
            new TypeNodePass(CollectionConverters$.MODULE$.EnumerationHasAsScala(astCreator.global().usedTypes().keys()).asScala().toList(), cpg, TypeNodePass$.MODULE$.$lessinit$greater$default$3()).createAndApply();
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private scala.collection.immutable.Seq<String> getDependencyList(Config config) {
        scala.collection.immutable.Seq seq;
        String codeDir = config.inputPath();
        if (config.fetchDependencies()) {
            Option option = DependencyResolver$.MODULE$.getDependencies(Paths.get(codeDir, new String[0]), DependencyResolver$.MODULE$.getDependencies$default$2());
            if (option instanceof Some) {
                Seq deps = (Seq)((Some)option).value();
                seq = deps.toSeq();
                return seq;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                this.logger.warn(new StringBuilder(49).append("Could not fetch dependencies for project at path ").append(codeDir).toString());
                seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
            }
            return seq;
        } else {
            this.logger.info("dependency resolving disabled");
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        return seq;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Delombok.DelombokMode getDelombokMode(Config config) {
        Mirror.Singleton singleton;
        Option option = config.delombokMode().map((Function1 & Serializable)_$2 -> _$2.toLowerCase());
        if (None$.MODULE$.equals(option)) {
            singleton = Delombok$DelombokMode$Default$.MODULE$;
            return singleton;
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        String string = (String)((Some)option).value();
        switch (string == null ? 0 : string.hashCode()) {
            case -1298334985: {
                if (!"run-delombok".equals(string)) break;
                singleton = Delombok$DelombokMode$RunDelombok$.MODULE$;
                return singleton;
            }
            case -572240768: {
                if (!"types-only".equals(string)) break;
                singleton = Delombok$DelombokMode$TypesOnly$.MODULE$;
                return singleton;
            }
            case 663348353: {
                if (!"no-delombok".equals(string)) break;
                singleton = Delombok$DelombokMode$NoDelombok$.MODULE$;
                return singleton;
            }
            case 1544803905: {
                if (!"default".equals(string)) break;
                singleton = Delombok$DelombokMode$Default$.MODULE$;
                return singleton;
            }
        }
        String value = string;
        this.logger.warn(new StringBuilder(59).append("Found unrecognised delombok mode `").append(value).append("`. Using default instead.").toString());
        singleton = Delombok$DelombokMode$Default$.MODULE$;
        return singleton;
    }

    /*
     * Unable to fully structure code
     */
    private SourceDirectoryInfo getSourcesFromDir(Config config, boolean hasLombokDependency) {
        delombokMode = this.getDelombokMode(config);
        var5_4 = delombokMode;
        if (Delombok$DelombokMode$NoDelombok$.MODULE$.equals(var5_4)) {
            v0 = false;
        } else if (Delombok$DelombokMode$Default$.MODULE$.equals(var5_4)) {
            if (hasLombokDependency) {
                this.logger.info("Analysing delomboked code as lombok dependency was found.");
            }
            v0 = hasLombokDependency;
        } else if (Delombok$DelombokMode$RunDelombok$.MODULE$.equals(var5_4)) {
            v0 = true;
        } else if (Delombok$DelombokMode$TypesOnly$.MODULE$.equals(var5_4)) {
            v0 = true;
        } else {
            throw new MatchError((Object)var5_4);
        }
        runDelombok = v0;
        inputPathAsFile = File$.MODULE$.apply(config.inputPath(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (inputPathAsFile.isDirectory(inputPathAsFile.isDirectory$default$1())) {
            v1 = config.inputPath();
        } else {
            var10_7 = File$.MODULE$.newTemporaryDirectory$default$2();
            var9_8 = File$.MODULE$.newTemporaryDirectory("javasrc", var10_7, File$.MODULE$.newTemporaryDirectory$default$3("javasrc", var10_7));
            dir = var9_8.deleteOnExit(var9_8.deleteOnExit$default$1(), var9_8.deleteOnExit$default$2());
            var11_10 = inputPathAsFile.copyToDirectory(dir, inputPathAsFile.copyToDirectory$default$2(dir), inputPathAsFile.copyToDirectory$default$3(dir));
            var11_10.deleteOnExit(var11_10.deleteOnExit$default$1(), var11_10.deleteOnExit$default$2());
            v1 = dir.pathAsString();
        }
        originalSourcesDir = v1;
        delombokSourcesDir = Option$.MODULE$.when(runDelombok, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(io.joern.javasrc2cpg.Config java.lang.String ), ()Ljava/lang/String;)((Config)config, (String)originalSourcesDir));
        if (!runDelombok) ** GOTO lbl-1000
        v2 = delombokMode;
        var14_13 = Delombok$DelombokMode$TypesOnly$.MODULE$;
        if (v2 == null ? var14_13 != null : v2.equals(var14_13) == false) {
            v3 = (String)delombokSourcesDir.get();
        } else lbl-1000:
        // 2 sources

        {
            v3 = originalSourcesDir;
        }
        analysisSourceFilePath = v3;
        typeSourcesPath = (String)delombokSourcesDir.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$3(java.lang.String ), ()Ljava/lang/String;)((String)originalSourcesDir));
        sourceFileNames = SourceFiles$.MODULE$.determine(analysisSourceFilePath, this.sourceFileExtensions());
        var18_17 = delombokSourcesDir;
        if (var18_17 instanceof Some) {
            delombokSourcesDir = (String)((Some)var18_17).value();
            v4 = sourceFileNames.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$4(java.lang.String java.lang.String java.lang.String ), (Ljava/lang/String;)Lio/joern/javasrc2cpg/SourceFileInfo;)((String)originalSourcesDir, (String)delombokSourcesDir));
        } else if (None$.MODULE$.equals(var18_17)) {
            v4 = sourceFileNames.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$5(java.lang.String ), (Ljava/lang/String;)Lio/joern/javasrc2cpg/SourceFileInfo;)());
        } else {
            throw new MatchError((Object)var18_17);
        }
        sourceFileInfo = v4;
        return SourceDirectoryInfo$.MODULE$.apply(typeSourcesPath, (List<SourceFileInfo>)sourceFileInfo);
    }

    private static final String $anonfun$2(Config config$1, String originalSourcesDir$1) {
        return Delombok$.MODULE$.run(originalSourcesDir$1, config$1.delombokJavaHome());
    }

    private static final String $anonfun$3(String originalSourcesDir$2) {
        return originalSourcesDir$2;
    }

    private static final /* synthetic */ SourceFileInfo $anonfun$4(String originalSourcesDir$3, String delombokSourcesDir$1, String fileName) {
        String originalFileName = fileName.replace(delombokSourcesDir$1, originalSourcesDir$3);
        return SourceFileInfo$.MODULE$.apply(fileName, originalFileName);
    }

    private static final /* synthetic */ SourceFileInfo $anonfun$5(String filename) {
        return SourceFileInfo$.MODULE$.apply(filename, filename);
    }
}

