/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg;

import better.files.File;
import better.files.File$;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.JavaSrc2Cpg$;
import io.joern.javasrc2cpg.SourceDirectoryInfo;
import io.joern.javasrc2cpg.SourceDirectoryInfo$;
import io.joern.javasrc2cpg.passes.AstCreationPass;
import io.joern.javasrc2cpg.passes.ConfigFileCreationPass;
import io.joern.javasrc2cpg.util.Delombok$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.TypeNodePass;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure2;
import scala.util.Try;

public class JavaSrc2Cpg
implements X2CpgFrontend<Config> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set sourceFileExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".java"}));

    public static JavaSrc2Cpg apply() {
        return JavaSrc2Cpg$.MODULE$.apply();
    }

    public static String language() {
        return JavaSrc2Cpg$.MODULE$.language();
    }

    public Set<String> sourceFileExtensions() {
        return this.sourceFileExtensions;
    }

    public Try<Cpg> createCpg(Config config2) {
        return X2Cpg$.MODULE$.withNewEmptyCpg(config2.outputPath(), (X2CpgConfig)config2, (Function2)(JProcedure2 & Serializable)(cpg, config) -> {
            new MetaDataPass(cpg, JavaSrc2Cpg$.MODULE$.language(), config.inputPath()).createAndApply();
            SourceDirectoryInfo sourcesInfo = this.getSourcesFromDir((Config)config);
            if (sourcesInfo.sourceFiles().isEmpty()) {
                this.logger.error(new StringBuilder(30).append("no source files found at path ").append(config.inputPath()).toString());
            } else {
                this.logger.info(new StringBuilder(19).append("found ").append(sourcesInfo.sourceFiles().size()).append(" source files").toString());
            }
            AstCreationPass astCreator = new AstCreationPass(sourcesInfo.typeSolverSourceDir(), sourcesInfo.sourceFiles(), (Config)config, (Cpg)cpg);
            astCreator.createAndApply();
            new ConfigFileCreationPass(config.inputPath(), (Cpg)cpg).createAndApply();
            new TypeNodePass(CollectionConverters$.MODULE$.EnumerationHasAsScala(astCreator.global().usedTypes().keys()).asScala().toList(), cpg, TypeNodePass$.MODULE$.$lessinit$greater$default$3()).createAndApply();
        });
    }

    private SourceDirectoryInfo getSourcesFromDir(Config config) {
        String string;
        File inputPathAsFile = File$.MODULE$.apply(config.inputPath(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (inputPathAsFile.isDirectory(inputPathAsFile.isDirectory$default$1())) {
            string = config.inputPath();
        } else {
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            File file = File$.MODULE$.newTemporaryDirectory("javasrc", option, File$.MODULE$.newTemporaryDirectory$default$3("javasrc", option));
            File dir = file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
            File file2 = inputPathAsFile.copyToDirectory(dir, inputPathAsFile.copyToDirectory$default$2(dir), inputPathAsFile.copyToDirectory$default$3(dir));
            file2.deleteOnExit(file2.deleteOnExit$default$1(), file2.deleteOnExit$default$2());
            string = dir.pathAsString();
        }
        String originalSourcesDir = string;
        Option delombokSourcesDir = Option$.MODULE$.when(config.delombokFullAnalysis() || config.delombokTypesOnly(), () -> JavaSrc2Cpg.$anonfun$1(config, originalSourcesDir));
        String analysisSourceFilePath = config.delombokFullAnalysis() ? (String)delombokSourcesDir.get() : originalSourcesDir;
        String typeSourcesPath = config.delombokFullAnalysis() || config.delombokTypesOnly() ? (String)delombokSourcesDir.get() : originalSourcesDir;
        List sourceFileNames = SourceFiles$.MODULE$.determine(analysisSourceFilePath, this.sourceFileExtensions());
        return SourceDirectoryInfo$.MODULE$.apply(typeSourcesPath, (List<String>)sourceFileNames);
    }

    private static final String $anonfun$1(Config config$1, String originalSourcesDir$1) {
        return Delombok$.MODULE$.run(originalSourcesDir$1, config$1.delombokJavaHome());
    }
}

