/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg;

import better.files.File;
import better.files.File$;
import io.joern.javasrc2cpg.Config;
import io.joern.javasrc2cpg.JavaSrc2Cpg$;
import io.joern.javasrc2cpg.passes.AstCreationPass;
import io.joern.javasrc2cpg.passes.ConfigFileCreationPass;
import io.joern.javasrc2cpg.util.Delombok$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.TypeNodePass;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure2;
import scala.util.Try;

public class JavaSrc2Cpg
implements X2CpgFrontend<Config> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set sourceFileExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".java"}));

    public static JavaSrc2Cpg apply() {
        return JavaSrc2Cpg$.MODULE$.apply();
    }

    public static String language() {
        return JavaSrc2Cpg$.MODULE$.language();
    }

    public Set<String> sourceFileExtensions() {
        return this.sourceFileExtensions;
    }

    public Try<Cpg> createCpg(Config config2) {
        return X2Cpg$.MODULE$.withNewEmptyCpg(config2.outputPath(), (X2CpgConfig)config2, (Function2)(JProcedure2 & Serializable)(cpg, config) -> {
            new MetaDataPass(cpg, JavaSrc2Cpg$.MODULE$.language(), config.inputPath()).createAndApply();
            Tuple2<String, List<String>> tuple2 = this.getSourcesFromDir((Config)config);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String sourcesDir = (String)tuple2._1();
            List sourceFileNames = (List)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)sourcesDir, (Object)sourceFileNames);
            String sourcesDir2 = (String)tuple22._1();
            List sourceFileNames2 = (List)tuple22._2();
            if (sourceFileNames2.isEmpty()) {
                this.logger.error(new StringBuilder(25).append("no source files found in ").append(sourcesDir2).toString());
            } else {
                this.logger.info(new StringBuilder(19).append("found ").append(sourceFileNames2.size()).append(" source files").toString());
            }
            AstCreationPass astCreator = new AstCreationPass(sourcesDir2, (List<String>)sourceFileNames2, (Config)config, (Cpg)cpg);
            astCreator.createAndApply();
            new ConfigFileCreationPass(config.inputPath(), (Cpg)cpg).createAndApply();
            new TypeNodePass(CollectionConverters$.MODULE$.EnumerationHasAsScala(astCreator.global().usedTypes().keys()).asScala().toList(), cpg, TypeNodePass$.MODULE$.$lessinit$greater$default$3()).createAndApply();
        });
    }

    private Tuple2<String, List<String>> getSourcesFromDir(Config config) {
        Tuple2 tuple2;
        String sourceCodePath = config.runDelombok() ? Delombok$.MODULE$.run(config.inputPath(), config.delombokJavaHome()) : config.inputPath();
        File sourceFile = File$.MODULE$.apply(sourceCodePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (sourceFile.isDirectory(sourceFile.isDirectory$default$1())) {
            List sourceFileNames = SourceFiles$.MODULE$.determine(sourceCodePath, this.sourceFileExtensions());
            tuple2 = Tuple2$.MODULE$.apply((Object)sourceCodePath, (Object)sourceFileNames);
        } else {
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            File file = File$.MODULE$.newTemporaryDirectory("javasrc", option, File$.MODULE$.newTemporaryDirectory$default$3("javasrc", option));
            File dir = file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
            File file2 = sourceFile.copyToDirectory(dir, sourceFile.copyToDirectory$default$2(dir), sourceFile.copyToDirectory$default$3(dir));
            file2.deleteOnExit(file2.deleteOnExit$default$1(), file2.deleteOnExit$default$2());
            tuple2 = Tuple2$.MODULE$.apply((Object)dir.pathAsString(), package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sourceFile.pathAsString()})));
        }
        return tuple2;
    }
}

