/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.passes;

import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DiffGraphBuilder;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.util.DefinedDataIterator;
import io.joern.ghidra2cpg.Types$;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.PCodeMapper;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodParameterIn;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import io.shiftleft.passes.ForkJoinParallelCpgPass;
import io.shiftleft.passes.ForkJoinParallelCpgPass$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public class PCodePass
extends ForkJoinParallelCpgPass<Function> {
    private final Program currentProgram;
    private final String fileName;
    private final List<Function> functions;
    private final Decompiler decompiler;
    private final Map<Object, String> address2Literals;

    public PCodePass(Program currentProgram, String fileName, List<Function> functions, Cpg cpg, Decompiler decompiler) {
        this.currentProgram = currentProgram;
        this.fileName = fileName;
        this.functions = functions;
        this.decompiler = decompiler;
        super(cpg, ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$2());
        this.address2Literals = CollectionConverters$.MODULE$.IteratorHasAsScala(DefinedDataIterator.definedStrings((Program)currentProgram).iterator()).asScala().toList().map((Function1 & Serializable)x -> {
            Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)x.getAddress().getOffset()));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)x.getValue().toString());
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<Object, String> address2Literals() {
        return this.address2Literals;
    }

    public void handleParameters(DiffGraphBuilder diffGraphBuilder, Function function, NewMethod methodNode) {
        if (function.isThunk()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])function.getThunkedFunction(true).getParameters());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Parameter parameter = (Parameter)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    NewMethodParameterIn node = Utils$.MODULE$.createParameterNode(parameter.getName(), parameter.getName(), index + 1, parameter.getDataType().getName(), function.getEntryPoint().getOffsetAsBigInteger().intValue());
                    diffGraphBuilder.addNode((DNode)node);
                    return diffGraphBuilder.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)node, "AST", diffGraphBuilder.addEdge$default$4());
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        ((IterableOnceOps)CollectionConverters$.MODULE$.IteratorHasAsScala(((HighFunction)this.decompiler.toHighFunction(function).get()).getLocalSymbolMap().getSymbols()).asScala().toSeq().filter((Function1 & Serializable)_$1 -> _$1.isParameter())).foreach((Function1 & Serializable)parameter -> {
            String checkedParameterName = (String)Option$.MODULE$.apply((Object)parameter.getStorage()).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getRegister())).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getName())).getOrElse(() -> PCodePass.$anonfun$3(parameter));
            NewMethodParameterIn node = Utils$.MODULE$.createParameterNode(checkedParameterName, checkedParameterName, parameter.getCategoryIndex() + 1, parameter.getDataType().getName(), function.getEntryPoint().getOffsetAsBigInteger().intValue());
            diffGraphBuilder.addNode((DNode)node);
            return diffGraphBuilder.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)node, "AST", diffGraphBuilder.addEdge$default$4());
        });
    }

    public void handleLocals(DiffGraphBuilder diffGraphBuilder, Function function, NewBlock blockNode) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])function.getLocalVariables());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)local -> {
            NewLocal localNode = NewLocal$.MODULE$.apply().name(local.getName()).code(local.toString()).typeFullName(Types$.MODULE$.registerType(local.getDataType().toString()));
            NewIdentifier identifier = Utils$.MODULE$.createIdentifier(local.getName(), local.getSymbol().getName(), -1, local.getDataType().toString(), -1);
            diffGraphBuilder.addNode((DNode)localNode);
            diffGraphBuilder.addNode((DNode)identifier);
            diffGraphBuilder.addEdge((DNodeOrNode)blockNode, (DNodeOrNode)localNode, "AST", diffGraphBuilder.addEdge$default$4());
            diffGraphBuilder.addEdge((DNodeOrNode)blockNode, (DNodeOrNode)identifier, "AST", diffGraphBuilder.addEdge$default$4());
            return diffGraphBuilder.addEdge((DNodeOrNode)identifier, (DNodeOrNode)localNode, "REF", diffGraphBuilder.addEdge$default$4());
        });
    }

    public void handleBody(DiffGraphBuilder diffGraphBuilder, Function function, NewMethod methodNode, NewBlock blockNode) {
        List instructionNodes = CollectionConverters$.MODULE$.IteratorHasAsScala(this.currentProgram.getListing().getInstructions(function.getBody(), true).iterator()).asScala().toList().map((Function1 & Serializable)instruction -> {
            HighFunction highFunction = (HighFunction)this.decompiler.toHighFunction(function).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            return new PCodeMapper(diffGraphBuilder, (Instruction)instruction, this.functions, highFunction, this.address2Literals()).getNode();
        });
        instructionNodes.foreach((Function1 & Serializable)newNode -> diffGraphBuilder.addNode(newNode));
        if (instructionNodes.nonEmpty()) {
            diffGraphBuilder.addEdge((DNodeOrNode)blockNode, (DNodeOrNode)instructionNodes.head(), "AST", diffGraphBuilder.addEdge$default$4());
            diffGraphBuilder.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)instructionNodes.head(), "CFG", diffGraphBuilder.addEdge$default$4());
            instructionNodes.sliding(2).foreach((Function1 & Serializable)nodes -> {
                CfgNodeNew prevInstructionNode = (CfgNodeNew)nodes.head();
                CfgNodeNew instructionNode = (CfgNodeNew)nodes.last();
                diffGraphBuilder.addEdge((DNodeOrNode)blockNode, (DNodeOrNode)instructionNode, "AST", diffGraphBuilder.addEdge$default$4());
                return diffGraphBuilder.addEdge((DNodeOrNode)prevInstructionNode, (DNodeOrNode)instructionNode, "CFG", diffGraphBuilder.addEdge$default$4());
            });
            return;
        }
    }

    public void runOnPart(DiffGraphBuilder diffGraphBuilder, Function function) {
        DiffGraphBuilder localDiffGraph = Cpg$.MODULE$.newDiffGraphBuilder();
        NewBlock blockNode = NewBlock$.MODULE$.apply().code("").order(0);
        NewMethod methodNode = Utils$.MODULE$.createMethodNode(this.decompiler, function, this.fileName, Utils$.MODULE$.checkIfExternal(this.currentProgram, function.getName()));
        NewMethodReturn methodReturn = Utils$.MODULE$.createReturnNode();
        localDiffGraph.addNode((DNode)methodNode);
        localDiffGraph.addNode((DNode)blockNode);
        localDiffGraph.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)blockNode, "AST", localDiffGraph.addEdge$default$4());
        localDiffGraph.addNode((DNode)methodReturn);
        localDiffGraph.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)methodReturn, "AST", localDiffGraph.addEdge$default$4());
        this.handleParameters(diffGraphBuilder, function, methodNode);
        this.handleLocals(diffGraphBuilder, function, blockNode);
        this.handleBody(diffGraphBuilder, function, methodNode, blockNode);
        diffGraphBuilder.absorb(localDiffGraph);
    }

    public Function[] generateParts() {
        return (Function[])this.functions.toArray(ClassTag$.MODULE$.apply(Function.class));
    }

    private static final String $anonfun$3(HighSymbol parameter$1) {
        return parameter$1.getName();
    }
}

