/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.utils;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import io.joern.ghidra2cpg.utils.Decompiler$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class Decompiler {
    private final DecompInterface decompInterface;
    private final int timeoutInSeconds;
    private volatile HashMap<String, DecompileResults> cache;

    public static Option<Decompiler> apply(Program program) {
        return Decompiler$.MODULE$.apply(program);
    }

    public Decompiler(DecompInterface decompInterface) {
        this.decompInterface = decompInterface;
        this.timeoutInSeconds = 60;
        this.cache = (HashMap)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public DecompInterface decompInterface() {
        return this.decompInterface;
    }

    public int timeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public HashMap<String, DecompileResults> getCache() {
        return this.cache;
    }

    public Option<HighFunction> toHighFunction(Function function) {
        return this.decompile(function).flatMap((Function1 & Serializable)decompiled -> Option$.MODULE$.apply((Object)decompiled.getHighFunction()));
    }

    public Option<DecompiledFunction> toDecompiledFunction(Function function) {
        return this.decompile(function).flatMap((Function1 & Serializable)decompiled -> Option$.MODULE$.apply((Object)decompiled.getDecompiledFunction()));
    }

    private Option<DecompileResults> decompile(Function function) {
        Option option;
        block9: {
            HashMap<String, DecompileResults> ccOld = this.cache;
            String addr = function.getEntryPoint().toString(true);
            Option option2 = ccOld.get((Object)addr);
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                DecompileResults decompileResults = (DecompileResults)some.value();
                if (decompileResults == null) {
                    return None$.MODULE$;
                }
                DecompileResults res = decompileResults;
                Some some2 = some;
                return some2;
            }
            Decompiler decompiler = this;
            synchronized (decompiler) {
                None$ none$;
                block8: {
                    Option option3;
                    HashMap<String, DecompileResults> ccCurrent = this.cache;
                    if (ccOld != ccCurrent && (option3 = ccCurrent.get((Object)addr)) instanceof Some) {
                        Some some = (Some)option3;
                        DecompileResults decompileResults = (DecompileResults)some.value();
                        if (decompileResults == null) {
                            none$ = None$.MODULE$;
                        } else {
                            DecompileResults res = decompileResults;
                            Some some3 = some;
                            none$ = some3;
                        }
                        break block8;
                    }
                    DecompileResults res = this.decompInterface().decompileFunction(function, this.timeoutInSeconds(), null);
                    this.cache = ccCurrent.updated((Object)addr, (Object)res);
                    option = Option$.MODULE$.apply((Object)res);
                    break block9;
                }
                return none$;
            }
        }
        return option;
    }
}

