/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.passes.x86;

import flatgraph.DNode;
import flatgraph.DNodeOrNode;
import flatgraph.DiffGraphBuilder;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import io.joern.ghidra2cpg.passes.FunctionPass;
import io.joern.ghidra2cpg.processors.X86Processor$;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import java.io.Serializable;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class X86FunctionPass
extends FunctionPass {
    private final String filename;
    private final Decompiler decompiler;

    public X86FunctionPass(Program currentProgram, String filename, List<Function> functions, Cpg cpg, Decompiler decompiler) {
        this.filename = filename;
        this.decompiler = decompiler;
        super(X86Processor$.MODULE$, currentProgram, functions, cpg, decompiler);
    }

    @Override
    public void handleBody(DiffGraphBuilder diffGraphBuilder, Function function, NewMethod methodNode, NewBlock blockNode) {
        Seq<Instruction> instructions = this.getInstructions(function);
        if (instructions.nonEmpty()) {
            ObjectRef prevInstructionNode = ObjectRef.create((Object)this.addCallOrReturnNode((Instruction)instructions.head()));
            this.handleArguments(diffGraphBuilder, (Instruction)instructions.head(), (CfgNodeNew)prevInstructionNode.elem, function);
            diffGraphBuilder.addEdge((DNodeOrNode)blockNode, (DNodeOrNode)((CfgNodeNew)prevInstructionNode.elem), "AST", diffGraphBuilder.addEdge$default$4());
            diffGraphBuilder.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)((CfgNodeNew)prevInstructionNode.elem), "CFG", diffGraphBuilder.addEdge$default$4());
            ((IterableOnceOps)instructions.drop(1)).foreach((Function1)(JProcedure1 & Serializable)instruction -> {
                CfgNodeNew instructionNode = this.addCallOrReturnNode((Instruction)instruction);
                diffGraphBuilder.addNode((DNode)instructionNode);
                this.handleArguments(diffGraphBuilder, (Instruction)instruction, instructionNode, function);
                diffGraphBuilder.addEdge((DNodeOrNode)blockNode, (DNodeOrNode)instructionNode, "AST", diffGraphBuilder.addEdge$default$4());
                if (!((CfgNodeNew)prevInstructionNode$1.elem).code().startsWith("JMP")) {
                    diffGraphBuilder.addEdge((DNodeOrNode)((CfgNodeNew)prevInstructionNode$1.elem), (DNodeOrNode)instructionNode, "CFG", diffGraphBuilder.addEdge$default$4());
                }
                prevInstructionNode$1.elem = instructionNode;
            });
            return;
        }
    }

    public void runOnPart(DiffGraphBuilder diffGraphBuilder, Function function) {
        NewBlock blockNode = NewBlock$.MODULE$.apply().code("").order(0);
        NewMethod methodNode = Utils$.MODULE$.createMethodNode(this.decompiler, function, this.filename);
        DiffGraphBuilder localGraphBuilder = Cpg$.MODULE$.newDiffGraphBuilder();
        NewMethodReturn methodReturn = Utils$.MODULE$.createReturnNode();
        localGraphBuilder.addNode((DNode)methodNode);
        localGraphBuilder.addNode((DNode)blockNode);
        localGraphBuilder.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)blockNode, "AST", localGraphBuilder.addEdge$default$4());
        localGraphBuilder.addNode((DNode)methodReturn);
        localGraphBuilder.addEdge((DNodeOrNode)methodNode, (DNodeOrNode)methodReturn, "AST", localGraphBuilder.addEdge$default$4());
        this.handleParameters(localGraphBuilder, function, methodNode);
        this.handleLocals(localGraphBuilder, function, blockNode);
        this.handleBody(localGraphBuilder, function, methodNode, blockNode);
        diffGraphBuilder.absorb(localGraphBuilder);
    }
}

