/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.passes.x86;

import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import io.joern.ghidra2cpg.passes.FunctionPass;
import io.joern.ghidra2cpg.processors.X86Processor$;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import io.shiftleft.codepropertygraph.generated.DiffGraphBuilder;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import java.io.Serializable;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.NodeOrDetachedNode;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public class X86FunctionPass
extends FunctionPass {
    private final Program currentProgram;
    private final String filename;
    private final Decompiler decompiler;

    public X86FunctionPass(Program currentProgram, String filename, List<Function> functions, Cpg cpg, Decompiler decompiler) {
        this.currentProgram = currentProgram;
        this.filename = filename;
        this.decompiler = decompiler;
        super(X86Processor$.MODULE$, currentProgram, functions, cpg, decompiler);
    }

    @Override
    public void handleBody(DiffGraphBuilder diffGraphBuilder, Function function, NewMethod methodNode, NewBlock blockNode) {
        Seq<Instruction> instructions = this.getInstructions(function);
        if (instructions.nonEmpty()) {
            ObjectRef prevInstructionNode = ObjectRef.create((Object)this.addCallOrReturnNode((Instruction)instructions.head()));
            this.handleArguments(diffGraphBuilder, (Instruction)instructions.head(), (CfgNodeNew)prevInstructionNode.elem, function);
            diffGraphBuilder.addEdge((NodeOrDetachedNode)blockNode, (NodeOrDetachedNode)((CfgNodeNew)prevInstructionNode.elem), "AST");
            diffGraphBuilder.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)((CfgNodeNew)prevInstructionNode.elem), "CFG");
            ((IterableOnceOps)instructions.drop(1)).foreach((Function1)(JProcedure1 & Serializable)instruction -> {
                CfgNodeNew instructionNode = this.addCallOrReturnNode((Instruction)instruction);
                diffGraphBuilder.addNode((DetachedNodeData)instructionNode);
                this.handleArguments(diffGraphBuilder, (Instruction)instruction, instructionNode, function);
                diffGraphBuilder.addEdge((NodeOrDetachedNode)blockNode, (NodeOrDetachedNode)instructionNode, "AST");
                if (!((CfgNodeNew)prevInstructionNode$1.elem).code().startsWith("JMP")) {
                    diffGraphBuilder.addEdge((NodeOrDetachedNode)((CfgNodeNew)prevInstructionNode$1.elem), (NodeOrDetachedNode)instructionNode, "CFG");
                }
                prevInstructionNode$1.elem = instructionNode;
            });
            return;
        }
    }

    public void runOnPart(DiffGraphBuilder diffGraphBuilder, Function function) {
        NewBlock blockNode = NewBlock$.MODULE$.apply().code("").order(Predef$.MODULE$.int2Integer(0));
        NewMethod methodNode = Utils$.MODULE$.createMethodNode(this.decompiler, function, this.filename, Utils$.MODULE$.checkIfExternal(this.currentProgram, function.getName()));
        DiffGraphBuilder localGraphBuilder = Cpg$.MODULE$.newDiffGraphBuilder();
        NewMethodReturn methodReturn = Utils$.MODULE$.createReturnNode();
        localGraphBuilder.addNode((DetachedNodeData)methodNode);
        localGraphBuilder.addNode((DetachedNodeData)blockNode);
        localGraphBuilder.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)blockNode, "AST");
        localGraphBuilder.addNode((DetachedNodeData)methodReturn);
        localGraphBuilder.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)methodReturn, "AST");
        this.handleParameters(localGraphBuilder, function, methodNode);
        this.handleLocals(localGraphBuilder, function, blockNode);
        this.handleBody(localGraphBuilder, function, methodNode, blockNode);
        diffGraphBuilder.absorb((BatchedUpdate.DiffGraphBuilder)localGraphBuilder);
    }
}

