/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.passes.arm;

import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import io.joern.ghidra2cpg.passes.FunctionPass;
import io.joern.ghidra2cpg.processors.ArmProcessor$;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Cpg$;
import io.shiftleft.codepropertygraph.generated.DiffGraphBuilder;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.NodeOrDetachedNode;
import scala.Predef$;
import scala.collection.immutable.List;

public class ArmFunctionPass
extends FunctionPass {
    private final Program currentProgram;
    private final String filename;
    private final Decompiler decompiler;

    public ArmFunctionPass(Program currentProgram, String filename, List<Function> functions, Cpg cpg, Decompiler decompiler) {
        this.currentProgram = currentProgram;
        this.filename = filename;
        this.decompiler = decompiler;
        super(ArmProcessor$.MODULE$, currentProgram, functions, cpg, decompiler);
    }

    public void runOnPart(DiffGraphBuilder diffGraphBuilder, Function function) {
        DiffGraphBuilder localDiffGraph = Cpg$.MODULE$.newDiffGraphBuilder();
        NewBlock blockNode = NewBlock$.MODULE$.apply().code("").order(Predef$.MODULE$.int2Integer(0));
        try {
            NewMethod methodNode = Utils$.MODULE$.createMethodNode(this.decompiler, function, this.filename, Utils$.MODULE$.checkIfExternal(this.currentProgram, function.getName()));
            NewMethodReturn methodReturn = Utils$.MODULE$.createReturnNode();
            localDiffGraph.addNode((DetachedNodeData)methodNode);
            localDiffGraph.addNode((DetachedNodeData)blockNode);
            localDiffGraph.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)blockNode, "AST");
            localDiffGraph.addNode((DetachedNodeData)methodReturn);
            localDiffGraph.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)methodReturn, "AST");
            this.handleParameters(localDiffGraph, function, methodNode);
            this.handleLocals(localDiffGraph, function, blockNode);
            this.handleBody(localDiffGraph, function, methodNode, blockNode);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        diffGraphBuilder.absorb((BatchedUpdate.DiffGraphBuilder)localDiffGraph);
    }
}

