/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.passes.mips;

import ghidra.program.model.address.GenericAddress;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.scalar.Scalar;
import io.joern.ghidra2cpg.Types$;
import io.joern.ghidra2cpg.passes.FunctionPass;
import io.joern.ghidra2cpg.processors.MipsProcessor$;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewCall;
import io.shiftleft.codepropertygraph.generated.nodes.NewIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.NewLiteral;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.NodeOrDetachedNode;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class MipsFunctionPass
extends FunctionPass {
    private final Program currentProgram;
    private final Map<Object, String> address2Literal;
    private final String filename;
    private final Decompiler decompiler;
    private final Logger logger;

    public MipsFunctionPass(Program currentProgram, Map<Object, String> address2Literal, String filename, List<Function> functions, Cpg cpg, Decompiler decompiler) {
        this.currentProgram = currentProgram;
        this.address2Literal = address2Literal;
        this.filename = filename;
        this.decompiler = decompiler;
        super(MipsProcessor$.MODULE$, currentProgram, functions, cpg, decompiler);
        this.logger = LoggerFactory.getLogger(MipsFunctionPass.class);
    }

    public CfgNodeNew resolveVarNode(Instruction instruction, Varnode input, int index) {
        if (input.isRegister()) {
            String name = input.getHigh().getName();
            HighVariable high = input.getHigh();
            if (high != null && input.getDef() != null) {
                String string = high.getName();
                String string2 = "UNNAMED";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Option symbol;
                    if (input.getDef() != null && input.getDef().getInputs() != null && (symbol = Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().lastOption().flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getHigh())).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getSymbol()))).isDefined()) {
                        name = ((HighSymbol)symbol.get()).getName();
                    }
                }
            }
            if (name == null) {
                name = input.getHigh().getSymbol().getName();
            }
            return Utils$.MODULE$.createIdentifier(name, name, index + 1, Types$.MODULE$.registerType(name), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
        }
        if (input.isConstant()) {
            return Utils$.MODULE$.createLiteral("0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), index + 1, index + 1, "0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
        }
        if (input.isUnique()) {
            ObjectRef valueString = ObjectRef.create((Object)"");
            valueString.elem = ((PcodeOp)CollectionConverters$.MODULE$.IteratorHasAsScala(input.getDescendants()).asScala().toList().head()).getOutput() == null ? BoxesRunTime.boxToLong((long)((Varnode)Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().head()).getAddress().getOffset()).toString() : ((PcodeOp)CollectionConverters$.MODULE$.IteratorHasAsScala(input.getDescendants()).asScala().toList().head()).getOutput().getHigh().getName();
            String value = (String)this.address2Literal.getOrElse((Object)BoxesRunTime.boxToLong((long)((Varnode)Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().head()).getAddress().getOffset()), () -> MipsFunctionPass.$anonfun$3(valueString));
            return Utils$.MODULE$.createLiteral(value, index + 1, index + 1, RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
        }
        return Utils$.MODULE$.createLiteral(input.toString(), index + 1, index + 1, input.toString(), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
    }

    public void handleAssignment(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, Varnode to, int index) {
        CfgNodeNew node = this.resolveVarNode(instruction, to, index);
        this.connectCallToArgument(diffGraphBuilder, callNode, node);
    }

    public void handleTwoArguments(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, PcodeOp pcodeOp, String operand, String name) {
        CfgNodeNew firstOp = this.resolveVarNode(instruction, pcodeOp.getInput(0), 1);
        CfgNodeNew secondOp = this.resolveVarNode(instruction, pcodeOp.getInput(1), 2);
        String code = firstOp.code() + " " + operand + " " + secondOp.code();
        NewCall opNode = Utils$.MODULE$.createCallNode(code, name, Predef$.MODULE$.int2Integer(instruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
        this.connectCallToArgument(diffGraphBuilder, (CfgNodeNew)opNode, firstOp);
        this.connectCallToArgument(diffGraphBuilder, (CfgNodeNew)opNode, secondOp);
        this.connectCallToArgument(diffGraphBuilder, callNode, (CfgNodeNew)opNode);
    }

    public void handlePtrSub(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, Varnode varNode, int index) {
        CfgNodeNew arg = this.resolveVarNode(instruction, varNode, index);
        this.connectCallToArgument(diffGraphBuilder, callNode, arg);
    }

    public void handleDefault(PcodeOp varNode) {
        Predef$.MODULE$.println((Object)("Unsupported " + varNode.toString() + " " + varNode.getOpcode()));
    }

    public void resolveArgument(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, PcodeOp pcodeAst, int index) {
        int n = pcodeAst.getOpcode();
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.logger.warn("INT_EQUAL | INT_NOTEQUAL | INT_SLESS | INT_SLESSEQUAL | INT_LESS | INT_LESSEQUAL ");
                return;
            }
            case 7: 
            case 8: {
                this.handleAssignment(diffGraphBuilder, instruction, callNode, pcodeAst.getOutput(), index);
                return;
            }
            case 19: 
            case 47: {
                this.handleTwoArguments(diffGraphBuilder, instruction, callNode, pcodeAst, "+", "<operator>.addition");
                return;
            }
            case 33: 
            case 34: 
            case 48: {
                this.handleTwoArguments(diffGraphBuilder, instruction, callNode, pcodeAst, "/", "<operator>.division");
                return;
            }
            case 20: 
            case 50: {
                this.handleTwoArguments(diffGraphBuilder, instruction, callNode, pcodeAst, "-", "<operator>.subtraction");
                return;
            }
            case 32: 
            case 49: {
                this.handleTwoArguments(diffGraphBuilder, instruction, callNode, pcodeAst, "*", "<operator>.multiplication");
                return;
            }
            case 60: 
            case 61: 
            case 62: {
                return;
            }
            case 26: {
                this.handleTwoArguments(diffGraphBuilder, instruction, callNode, pcodeAst, "^", "<operator>.xor");
                return;
            }
            case 28: {
                this.handleTwoArguments(diffGraphBuilder, instruction, callNode, pcodeAst, "^", "<operator>.xor");
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 63: {
                this.handleAssignment(diffGraphBuilder, instruction, callNode, pcodeAst.getOutput(), index);
                return;
            }
            case 64: {
                if (pcodeAst.getInput(0).getDef() != null) {
                    this.resolveArgument(diffGraphBuilder, instruction, callNode, pcodeAst.getInput(0).getDef(), index);
                    return;
                }
                return;
            }
            case 65: 
            case 66: {
                this.handlePtrSub(diffGraphBuilder, instruction, callNode, pcodeAst.getOutput(), index);
                return;
            }
        }
    }

    public void addCallArguments(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, HighFunction highFunction) {
        List opCodes = CollectionConverters$.MODULE$.IteratorHasAsScala(highFunction.getPcodeOps(instruction.getAddress())).asScala().toList();
        if (opCodes.size() < 2) {
            return;
        }
        List arguments = (List)Predef$.MODULE$.wrapRefArray((Object[])((PcodeOp)opCodes.head()).getInputs()).toList().drop(1);
        ((List)arguments.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Varnode value = (Varnode)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (value.getDef() != null) {
                    this.resolveArgument(diffGraphBuilder, instruction, callNode, value.getDef(), index);
                    return;
                }
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public void addInstructionArguments(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew instructionNode) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), instruction.getNumOperands()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            Object[] opObjects = instruction.getOpObjects(index);
            Object object = Predef$.MODULE$.refArrayOps(opObjects);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)opObject -> {
                Object object = opObject;
                if (object instanceof Register) {
                    Register register = (Register)object;
                    NewIdentifier node = Utils$.MODULE$.createIdentifier(register.getName(), register.getName(), index + 1, Types$.MODULE$.registerType(register.getName()), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
                    this.connectCallToArgument(diffGraphBuilder, instructionNode, (CfgNodeNew)node);
                    return;
                }
                if (object instanceof Scalar) {
                    Scalar scalar = (Scalar)object;
                    NewLiteral node = Utils$.MODULE$.createLiteral(scalar.toString(16, false, false, "", ""), index + 1, index + 1, scalar.toString(16, false, false, "", ""), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
                    this.connectCallToArgument(diffGraphBuilder, instructionNode, (CfgNodeNew)node);
                    return;
                }
                if (object instanceof GenericAddress) {
                    GenericAddress genericAddress = (GenericAddress)object;
                    NewLiteral node = Utils$.MODULE$.createLiteral(genericAddress.toString(), index + 1, index + 1, genericAddress.toString(), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
                    this.connectCallToArgument(diffGraphBuilder, instructionNode, (CfgNodeNew)node);
                    return;
                }
                Predef$.MODULE$.println((Object)("Unsupported argument: " + opObject + " " + opObject.getClass().getSimpleName()));
            });
        });
    }

    @Override
    public void handleArguments(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, Function function) {
        if (Predef$.MODULE$.wrapRefArray((Object[])instruction.getPcode()).toList().isEmpty()) {
            return;
        }
        List opCodes = Predef$.MODULE$.wrapRefArray((Object[])instruction.getPcode()).toList();
        int n = ((PcodeOp)opCodes.last()).getOpcode();
        if (8 == n || 7 == n) {
            this.getHighFunction(function).foreach((Function1)(JProcedure1 & Serializable)highFunction -> this.addCallArguments(diffGraphBuilder, instruction, callNode, (HighFunction)highFunction));
            return;
        }
        this.addInstructionArguments(diffGraphBuilder, instruction, callNode);
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Function function) {
        BatchedUpdate.DiffGraphBuilder localDiffGraph = new BatchedUpdate.DiffGraphBuilder();
        NewBlock blockNode = NewBlock$.MODULE$.apply().code("").order(0);
        NewMethod methodNode = Utils$.MODULE$.createMethodNode(this.decompiler, function, this.filename, Utils$.MODULE$.checkIfExternal(this.currentProgram, function.getName()));
        NewMethodReturn methodReturn = Utils$.MODULE$.createReturnNode();
        localDiffGraph.addNode((DetachedNodeData)methodNode);
        localDiffGraph.addNode((DetachedNodeData)blockNode);
        localDiffGraph.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)blockNode, "AST");
        localDiffGraph.addNode((DetachedNodeData)methodReturn);
        localDiffGraph.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)methodReturn, "AST");
        this.handleParameters(diffGraphBuilder, function, methodNode);
        this.handleLocals(diffGraphBuilder, function, blockNode);
        this.handleBody(diffGraphBuilder, function, methodNode, blockNode);
        diffGraphBuilder.absorb(localDiffGraph);
    }

    private static final String $anonfun$3(ObjectRef valueString$1) {
        return (String)valueString$1.elem;
    }
}

