/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.querying.mips;

import io.joern.dataflowengineoss.language.ExtendedCfgNode$;
import io.joern.dataflowengineoss.language.Path;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlow;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlow$;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlowOptions;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlowOptions$;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.dataflowengineoss.queryengine.EngineContext$;
import io.joern.ghidra2cpg.fixtures.GhidraBinToCpgSuite;
import io.joern.x2cpg.X2Cpg$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.traversal.CallTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.CfgNodeTraversalExtGen$;
import io.shiftleft.semanticcpg.language.ICallResolver;
import io.shiftleft.semanticcpg.language.NoResolve$;
import io.shiftleft.semanticcpg.language.types.expressions.CallTraversal$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.AstNodeTraversal$;
import io.shiftleft.semanticcpg.language.types.expressions.generalizations.CfgNodeTraversal$;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext$;
import java.io.Serializable;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalactic.source.Position$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.compatible.Assertion;
import org.scalatest.wordspec.AnyWordSpecLike;
import overflowdb.traversal.TraversalLogicExt$;
import overflowdb.traversal.TraversalSugarExt$;
import scala.CanEqual$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class DataFlowTests
extends GhidraBinToCpgSuite
implements BeforeAndAfterAll {
    private final ICallResolver resolver = NoResolve$.MODULE$;
    private EngineContext context = EngineContext$.MODULE$.apply(EngineContext$.MODULE$.$lessinit$greater$default$1(), EngineContext$.MODULE$.$lessinit$greater$default$2());

    public DataFlowTests() {
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this = this.convertToWordSpecStringWrapper("should find flows through `add*` instructions");
        DataFlowTests AnyWordSpecLike_this = (DataFlowTests)WordSpecStringWrapper_this.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position = Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29);
        AnyWordSpecLike_this.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> this.f$proxy1$1(), position);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this2 = this.convertToWordSpecStringWrapper("should find flows through `and*` instructions");
        DataFlowTests AnyWordSpecLike_this2 = (DataFlowTests)WordSpecStringWrapper_this2.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position2 = Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53);
        AnyWordSpecLike_this2.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this2.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> this.f$proxy2$1(), position2);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this3 = this.convertToWordSpecStringWrapper("should find flows through `ori/nor` instructions");
        DataFlowTests AnyWordSpecLike_this3 = (DataFlowTests)WordSpecStringWrapper_this3.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position3 = Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71);
        AnyWordSpecLike_this3.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this3.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> this.f$proxy3$1(), position3);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this4 = this.convertToWordSpecStringWrapper("should find flows through _shift_ instructions");
        DataFlowTests AnyWordSpecLike_this4 = (DataFlowTests)WordSpecStringWrapper_this4.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position4 = Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89);
        AnyWordSpecLike_this4.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this4.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> this.f$proxy4$1(), position4);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this5 = this.convertToWordSpecStringWrapper("should find flows through `sub*` instructions");
        DataFlowTests AnyWordSpecLike_this5 = (DataFlowTests)WordSpecStringWrapper_this5.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position5 = Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118);
        AnyWordSpecLike_this5.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this5.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> this.f$proxy5$1(), position5);
        AnyWordSpecLike.WordSpecStringWrapper WordSpecStringWrapper_this6 = this.convertToWordSpecStringWrapper("should find flows through `xor*` instructions");
        DataFlowTests AnyWordSpecLike_this6 = (DataFlowTests)WordSpecStringWrapper_this6.org$scalatest$wordspec$AnyWordSpecLike$WordSpecStringWrapper$$$outer();
        Position position6 = Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136);
        AnyWordSpecLike_this6.org$scalatest$wordspec$AnyWordSpecLike$$inline$registerTestToRun(WordSpecStringWrapper_this6.inline$string(), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0])), "in", (Function0 & Serializable)() -> this.f$proxy6$1(), position6);
    }

    public ICallResolver resolver() {
        return this.resolver;
    }

    public EngineContext context() {
        return this.context;
    }

    public void context_$eq(EngineContext x$1) {
        this.context = x$1;
    }

    @Override
    public void passes(Cpg cpg) {
        X2Cpg$.MODULE$.applyDefaultOverlays(cpg);
        LayerCreatorContext context = new LayerCreatorContext(cpg, LayerCreatorContext$.MODULE$.$lessinit$greater$default$2());
        OssDataFlowOptions options = new OssDataFlowOptions(OssDataFlowOptions$.MODULE$.$lessinit$greater$default$1(), OssDataFlowOptions$.MODULE$.$lessinit$greater$default$2());
        OssDataFlow ossDataFlow = new OssDataFlow(options, OssDataFlow$.MODULE$.$lessinit$greater$default$2(options));
        ossDataFlow.run(context, ossDataFlow.run$default$2());
    }

    @Override
    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
        this.buildCpgForBin("linux/mips/t1_to_t9");
    }

    private final Iterator source$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "li t1,0x2a")), Predef$.MODULE$.int2Integer(1));
    }

    private final Iterator sink$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t9,t6,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$1 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$1);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgPrev$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "add.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Assertion f$proxy1$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)ExtendedCfgNode$.MODULE$.reachableByFlows$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$1()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[]{this.source$1()}), this.context()));
        List flowsThroughAddXInstructions = TraversalSugarExt$.MODULE$.l$extension(iterator);
        return this.shouldBe((Object)flowsThroughAddXInstructions.map((Function1 & Serializable)path -> this.flowToResultPairs((Path)path)).toSet(), Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"li t1,0x2a", "add t2,t0,t1", "addu t3,t2,t0", "addu t4,t3,t0", "addi t5,t4,0x1", "addiu t6,t5,0x1", "or t9,t6,zero"}))})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString())));
    }

    private final Iterator source$2() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t1,t9,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$2 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$2);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgNext$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "and.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Iterator sink$2() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t9,t3,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$3 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$3);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgPrev$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "and.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Assertion f$proxy2$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)ExtendedCfgNode$.MODULE$.reachableByFlows$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$2()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[]{this.source$2()}), this.context()));
        List flowsThroughAndXInstructions = TraversalSugarExt$.MODULE$.l$extension(iterator);
        return this.shouldBe((Object)flowsThroughAndXInstructions.map((Function1 & Serializable)path -> this.flowToResultPairs((Path)path)).toSet(), Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"or t1,t9,zero", "and t2,t1,t0", "andi t3,t2,0xffff", "or t9,t3,zero"}))})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString())));
    }

    private final Iterator source$3() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t1,t9,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$4 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$4);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgNext$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCfgNodeTraversalExtGen((IterableOnce)CfgNodeTraversal$.MODULE$.cfgNext$extension(iterator2));
            return CfgNodeTraversalExtGen$.MODULE$.code$extension(iterator3, "nor.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Iterator sink$3() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t9,t4,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$5 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$5);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgPrev$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "or.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Assertion f$proxy3$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)ExtendedCfgNode$.MODULE$.reachableByFlows$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$3()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[]{this.source$3()}), this.context()));
        List flowsThroughOrXInstructions = TraversalSugarExt$.MODULE$.l$extension(iterator);
        return this.shouldBe((Object)flowsThroughOrXInstructions.map((Function1 & Serializable)path -> this.flowToResultPairs((Path)path)).toSet(), Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"or t1,t9,zero", "nor t3,t1,t2", "ori t4,t3,0x30", "or t9,t4,zero"}))})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString())));
    }

    private final Iterator source$4() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t1,t9,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$6 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$6);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgNext$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "sll.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Iterator sink$4() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t9,t6,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$7 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$7);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgPrev$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "srlv.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Assertion f$proxy4$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)ExtendedCfgNode$.MODULE$.reachableByFlows$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$4()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[]{this.source$4()}), this.context()));
        List flowsThroughShiftXInstructions = TraversalSugarExt$.MODULE$.l$extension(iterator);
        return this.shouldBe((Object)flowsThroughShiftXInstructions.map((Function1 & Serializable)path -> this.flowToResultPairs((Path)path)).toSet(), Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"or t1,t9,zero", "sll t2,t1,0x1", "sllv t3,t2,t0", "sra t4,t3,0x1", "srav t5,t4,t0", "srl t6,t5,0x0", "srlv t7,t6,zero", "or t9,t6,zero"}))})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString())));
    }

    private final Iterator source$5() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t1,t9,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$8 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$8);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgNext$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "sub.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Iterator sink$5() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t9,t3,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$9 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$9);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgPrev$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "sub.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Assertion f$proxy5$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)ExtendedCfgNode$.MODULE$.reachableByFlows$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$5()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[]{this.source$5()}), this.context()));
        List flowsThroughSubXInstructions = TraversalSugarExt$.MODULE$.l$extension(iterator);
        return this.shouldBe((Object)flowsThroughSubXInstructions.map((Function1 & Serializable)path -> this.flowToResultPairs((Path)path)).toSet(), Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"or t1,t9,zero", "sub t2,t1,t0", "subu t3,t2,t0", "or t9,t3,zero"}))})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString())));
    }

    private final Iterator source$6() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t1,t9,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$10 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$10);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgNext$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "xor.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Iterator sink$6() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg()).call());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalLogicExt((IterableOnce)CallTraversalExtGen$.MODULE$.code$extension(iterator, "or t9,t3,zero"));
        return CallTraversal$.MODULE$.argument$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToOriginalCallTrav((IterableOnce)TraversalLogicExt$.MODULE$.where$extension(iterator2, (Function1 & Serializable)_$11 -> {
            Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToCfgNodeTraversal((IterableOnce)_$11);
            Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.iterOnceToAstNodeTraversal((IterableOnce)CfgNodeTraversal$.MODULE$.cfgPrev$extension(iterator));
            Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)AstNodeTraversal$.MODULE$.isCall$extension(iterator2));
            return CallTraversalExtGen$.MODULE$.code$extension(iterator3, "xor.*");
        })), Predef$.MODULE$.int2Integer(1));
    }

    private final Assertion f$proxy6$1() {
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)ExtendedCfgNode$.MODULE$.reachableByFlows$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)this.sink$6()), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new IterableOnce[]{this.source$6()}), this.context()));
        List flowsThroughXorXInstructions = TraversalSugarExt$.MODULE$.l$extension(iterator);
        return this.shouldBe((Object)flowsThroughXorXInstructions.map((Function1 & Serializable)path -> this.flowToResultPairs((Path)path)).toSet(), Position$.MODULE$.apply("DataFlowTests.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150), Prettifier$.MODULE$.default(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"or t1,t9,zero", "xor t2,t1,zero", "xori t3,t2,0x4", "or t9,t3,zero"}))})), CanEqual$.MODULE$.canEqualSet(CanEqual$.MODULE$.canEqualSeqs(CanEqual$.MODULE$.canEqualString())));
    }
}

