/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.utils;

import ghidra.app.util.template.TemplateSimplifier;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import io.joern.ghidra2cpg.Types$;
import io.joern.ghidra2cpg.utils.State;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewCall;
import io.shiftleft.codepropertygraph.generated.nodes.NewIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.NewLiteral;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.NodeOrDetachedNode;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure1;

public class PCodeMapper {
    private final BatchedUpdate.DiffGraphBuilder diffGraphBuilder;
    private final Instruction nativeInstruction;
    private final HighFunction highFunction;
    private final Map<Object, String> address2Literal;
    private final Logger logger;
    private final List<PcodeOp> pcodeOps;
    private final State state;
    private final CodeUnitFormat codeUnitFormat;

    public PCodeMapper(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction nativeInstruction, List<Function> functions, HighFunction highFunction, Map<Object, String> address2Literal) {
        this.diffGraphBuilder = diffGraphBuilder;
        this.nativeInstruction = nativeInstruction;
        this.highFunction = highFunction;
        this.address2Literal = address2Literal;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.pcodeOps = Predef$.MODULE$.wrapRefArray((Object[])nativeInstruction.getPcode()).toList();
        this.state = new State(-1);
        this.codeUnitFormat = new CodeUnitFormat(new CodeUnitFormatOptions(CodeUnitFormatOptions.ShowBlockName.NEVER, CodeUnitFormatOptions.ShowNamespace.NEVER, "", true, true, true, true, true, true, true, new TemplateSimplifier()));
    }

    public State state() {
        return this.state;
    }

    public CodeUnitFormat codeUnitFormat() {
        return this.codeUnitFormat;
    }

    public CfgNodeNew getNode() {
        if (this.pcodeOps.isEmpty()) {
            this.logger.info("NO pcodes for " + this.nativeInstruction);
            return Utils$.MODULE$.createCallNode(this.nativeInstruction.toString(), this.nativeInstruction.toString(), Predef$.MODULE$.int2Integer(this.nativeInstruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
        }
        return this.mapCallNode((PcodeOp)this.pcodeOps.last(), this.mapCallNode$default$2());
    }

    public CfgNodeNew createCall(String name, String code, int index) {
        return Utils$.MODULE$.createCallNode(code, name, Predef$.MODULE$.int2Integer(this.nativeInstruction.getMinAddress().getOffsetAsBigInteger().intValue()), index);
    }

    public int createCall$default$3() {
        return 1;
    }

    public CfgNodeNew handleSingleArgument(PcodeOp pcodeOp, String cpgOperationName, String operation) {
        CfgNodeNew firstOp = this.resolveVarNode(pcodeOp.getInput(0), 1);
        CfgNodeNew callNode = this.createCall(cpgOperationName, this.nativeInstruction.toString(), this.createCall$default$3());
        this.connectCallToArgument(callNode, firstOp);
        return callNode;
    }

    public CfgNodeNew handleTwoArguments(PcodeOp pcodeOp, String cpgOperationName, String code, int callIndex) {
        CfgNodeNew callNode = this.createCall(cpgOperationName, this.nativeInstruction.toString(), callIndex);
        if (pcodeOp.getOutput().isRegister()) {
            CfgNodeNew firstOp = this.resolveVarNode(pcodeOp.getOutput(), 1);
            CfgNodeNew secondOp = this.resolveVarNode(pcodeOp.getInput(0), 2);
            CfgNodeNew thirdOp = this.resolveVarNode(pcodeOp.getInput(1), 3);
            this.connectCallToArgument(callNode, firstOp);
            this.connectCallToArgument(callNode, secondOp);
            this.connectCallToArgument(callNode, thirdOp);
        } else {
            CfgNodeNew firstOp = this.resolveVarNode(pcodeOp.getInput(0), 1);
            CfgNodeNew secondOp = this.resolveVarNode(pcodeOp.getInput(1), 2);
            this.connectCallToArgument(callNode, firstOp);
            this.connectCallToArgument(callNode, secondOp);
        }
        return callNode;
    }

    public int handleTwoArguments$default$4() {
        return -1;
    }

    public CfgNodeNew handleStore(PcodeOp pcodeOp) {
        CfgNodeNew firstOp = this.resolveVarNode(pcodeOp.getInput(1), 1);
        CfgNodeNew secondOp = this.resolveVarNode(pcodeOp.getInput(2), 2);
        CfgNodeNew callNode = this.createCall("<operator>.assignment", this.nativeInstruction.toString(), this.createCall$default$3());
        this.connectCallToArgument(callNode, firstOp);
        this.connectCallToArgument(callNode, secondOp);
        return callNode;
    }

    public CfgNodeNew resolveVarNode(Instruction instruction, Varnode input, int index) {
        if (input.isRegister()) {
            String name = input.getHigh().getName();
            HighVariable high = input.getHigh();
            if (high != null && input.getDef() != null) {
                String string = high.getName();
                String string2 = "UNNAMED";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    Option symbol;
                    if (input.getDef() != null && input.getDef().getInputs() != null && (symbol = Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().lastOption().flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getHigh())).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getSymbol()))).isDefined()) {
                        name = ((HighSymbol)symbol.get()).getName();
                    }
                }
            }
            if (name == null) {
                name = input.getHigh().getSymbol().getName();
            }
            return Utils$.MODULE$.createIdentifier(name, name, index, Types$.MODULE$.registerType(name), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
        }
        if (input.isConstant()) {
            return Utils$.MODULE$.createLiteral("0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), index, index, "0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
        }
        if (input.isUnique()) {
            ObjectRef valueString = ObjectRef.create((Object)"");
            if (((PcodeOp)CollectionConverters$.MODULE$.IteratorHasAsScala(input.getDescendants()).asScala().toList().head()).getOutput() == null) {
                String string = BoxesRunTime.boxToLong((long)((Varnode)Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().head()).getAddress().getOffset()).toString();
                valueString.elem = string;
                string = null;
            } else {
                String string = ((PcodeOp)CollectionConverters$.MODULE$.IteratorHasAsScala(input.getDescendants()).asScala().toList().head()).getOutput().getHigh().getName();
                valueString.elem = string;
                string = null;
            }
            String value = (String)this.address2Literal.getOrElse((Object)BoxesRunTime.boxToLong((long)((Varnode)Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().head()).getAddress().getOffset()), () -> PCodeMapper.$anonfun$3(valueString));
            return Utils$.MODULE$.createLiteral(value, index, index, RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
        }
        return Utils$.MODULE$.createLiteral(input.toString(), index, index, input.toString(), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
    }

    public CfgNodeNew handleAssignment(PcodeOp pcodeOp, String code) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])pcodeOp.getInputs());
        CfgNodeNew secondOp = this.resolveVarNode((Varnode)ArrayOps$.MODULE$.headOption$extension(object).get(), 2);
        CfgNodeNew callNode = this.createCall("<operator>.assignment", code, this.createCall$default$3());
        this.connectCallToArgument(callNode, secondOp);
        if (pcodeOp.getOutput().isRegister()) {
            CfgNodeNew firstOp = this.resolveVarNode(pcodeOp.getOutput(), 1);
            this.connectCallToArgument(callNode, firstOp);
        } else {
            NewIdentifier firstOp = Utils$.MODULE$.createIdentifier(pcodeOp.getOutput().toString(), pcodeOp.getOutput().toString(), 1, "TODO", pcodeOp.getSeqnum().getTarget().getOffsetAsBigInteger().intValue());
            this.connectCallToArgument(callNode, (CfgNodeNew)firstOp);
        }
        return callNode;
    }

    public void handleTwoArguments(Instruction instruction, CfgNodeNew callNode, PcodeOp pcodeOp, String operand, String name) {
        CfgNodeNew firstOp = this.resolveVarNode(instruction, pcodeOp.getInput(0), 1);
        CfgNodeNew secondOp = this.resolveVarNode(instruction, pcodeOp.getInput(1), 2);
        String code = firstOp.code() + " " + operand + " " + secondOp.code();
        NewCall opNode = Utils$.MODULE$.createCallNode(code, name, Predef$.MODULE$.int2Integer(instruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
        this.connectCallToArgument((CfgNodeNew)opNode, firstOp);
        this.connectCallToArgument((CfgNodeNew)opNode, secondOp);
        this.connectCallToArgument(callNode, (CfgNodeNew)opNode);
    }

    public void handlePtrSub(Instruction instruction, CfgNodeNew callNode, Varnode varNode, int index) {
        CfgNodeNew arg = this.resolveVarNode(instruction, varNode, index);
        this.connectCallToArgument(callNode, arg);
    }

    public void handleAssignment(Instruction instruction, CfgNodeNew callNode, Varnode to, int index) {
        CfgNodeNew node = this.resolveVarNode(instruction, to, index);
        this.connectCallToArgument(callNode, node);
    }

    public void resolveArgument(Instruction instruction, CfgNodeNew callNode, PcodeOp pcodeAst, int index) {
        int n = pcodeAst.getOpcode();
        switch (n) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                this.logger.warn("INT_EQUAL | INT_NOTEQUAL | INT_SLESS | INT_SLESSEQUAL | INT_LESS | INT_LESSEQUAL ");
                return;
            }
            case 7: 
            case 8: {
                this.handleAssignment(instruction, callNode, pcodeAst.getOutput(), index);
                return;
            }
            case 19: 
            case 47: {
                this.handleTwoArguments(instruction, callNode, pcodeAst, "+", "<operator>.addition");
                return;
            }
            case 33: 
            case 34: 
            case 48: {
                this.handleTwoArguments(instruction, callNode, pcodeAst, "/", "<operator>.division");
                return;
            }
            case 20: 
            case 50: {
                this.handleTwoArguments(instruction, callNode, pcodeAst, "-", "<operator>.subtraction");
                return;
            }
            case 32: 
            case 49: {
                this.handleTwoArguments(instruction, callNode, pcodeAst, "*", "<operator>.multiplication");
                return;
            }
            case 60: 
            case 61: 
            case 62: {
                return;
            }
            case 26: {
                this.handleTwoArguments(instruction, callNode, pcodeAst, "^", "<operator>.xor");
                return;
            }
            case 28: {
                this.handleTwoArguments(instruction, callNode, pcodeAst, "^", "<operator>.xor");
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 63: {
                this.handleAssignment(instruction, callNode, pcodeAst.getOutput(), index);
                return;
            }
            case 64: {
                if (pcodeAst.getInput(0).getDef() != null) {
                    this.resolveArgument(instruction, callNode, pcodeAst.getInput(0).getDef(), index);
                    return;
                }
                return;
            }
            case 65: 
            case 66: {
                this.handlePtrSub(instruction, callNode, pcodeAst.getOutput(), index);
                return;
            }
        }
    }

    private CfgNodeNew mapCallNode(PcodeOp pcodeOp, int index) {
        CfgNodeNew cfgNodeNew;
        int n = pcodeOp.getOpcode();
        switch (n) {
            case 4: 
            case 5: 
            case 6: {
                Object object = Predef$.MODULE$.refArrayOps((Object[])pcodeOp.getInputs());
                CfgNodeNew destination = this.resolveVarNode((Varnode)ArrayOps$.MODULE$.head$extension(object), 1);
                NewCall callNode = Utils$.MODULE$.createCallNode(this.nativeInstruction.toString(), "<operator>.goto", Predef$.MODULE$.int2Integer(this.nativeInstruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
                this.connectCallToArgument((CfgNodeNew)callNode, destination);
                cfgNodeNew = callNode;
                break;
            }
            case 10: {
                cfgNodeNew = this.createCall("ret", "ret", this.createCall$default$3());
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                Object object = Predef$.MODULE$.refArrayOps((Object[])this.codeUnitFormat().getOperandRepresentationString((CodeUnit)this.nativeInstruction, 0).split(">"));
                String calledFunction = ((String)ArrayOps$.MODULE$.last$extension(object)).replace("[", "").replace("]", "");
                NewCall _callNode = Utils$.MODULE$.createCallNode(calledFunction, calledFunction, Predef$.MODULE$.int2Integer(this.nativeInstruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
                List opCodes = CollectionConverters$.MODULE$.IteratorHasAsScala(this.highFunction.getPcodeOps(this.nativeInstruction.getAddress())).asScala().toList();
                if (opCodes.size() < 1) {
                    return _callNode;
                }
                ((List)((StrictOptimizedIterableOps)Predef$.MODULE$.wrapRefArray((Object[])((PcodeOp)opCodes.head()).getInputs()).toList().drop(1)).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Varnode value = (Varnode)tuple2._1();
                        int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        if (value.getDef() != null) {
                            this.resolveArgument(this.nativeInstruction, (CfgNodeNew)_callNode, value.getDef(), index);
                            return;
                        }
                        NewLiteral literalNode = Utils$.MODULE$.createLiteral("0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(value.getWordOffset())), index + 1, index + 1, "0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(value.getWordOffset())), this.nativeInstruction.getMinAddress().getOffsetAsBigInteger().intValue());
                        this.connectCallToArgument((CfgNodeNew)_callNode, (CfgNodeNew)literalNode);
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                cfgNodeNew = _callNode;
                break;
            }
            case 39: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.and", "&&", this.handleTwoArguments$default$4());
                break;
            }
            case 37: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.negate", pcodeOp.getMnemonic());
                break;
            }
            case 40: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.or", "||", this.handleTwoArguments$default$4());
                break;
            }
            case 38: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.xor", "^^", this.handleTwoArguments$default$4());
                break;
            }
            case 64: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.cast", pcodeOp.getMnemonic());
                break;
            }
            case 68: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.cpoolref", pcodeOp.getMnemonic());
                break;
            }
            case 71: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.extract", pcodeOp.getMnemonic());
                break;
            }
            case 52: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.abs", pcodeOp.getMnemonic());
                break;
            }
            case 57: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.ceil", pcodeOp.getMnemonic());
                break;
            }
            case 55: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.float2float", pcodeOp.getMnemonic());
                break;
            }
            case 58: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.floor", pcodeOp.getMnemonic());
                break;
            }
            case 54: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.int2float", pcodeOp.getMnemonic());
                break;
            }
            case 13: 
            case 15: 
            case 43: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.goto", "<", this.handleTwoArguments$default$4());
                break;
            }
            case 14: 
            case 16: 
            case 44: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.lessThanEqual", "<=", this.handleTwoArguments$default$4());
                break;
            }
            case 46: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.nan", pcodeOp.getMnemonic());
                break;
            }
            case 59: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.round", pcodeOp.getMnemonic());
                break;
            }
            case 53: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.sqrt", pcodeOp.getMnemonic());
                break;
            }
            case 56: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.trunc", pcodeOp.getMnemonic());
                break;
            }
            case 70: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.insert", pcodeOp.getMnemonic());
                break;
            }
            case 24: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.int2comp", pcodeOp.getMnemonic());
                break;
            }
            case 19: 
            case 47: 
            case 65: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.addition", "+", index);
                break;
            }
            case 27: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.and", "TODO: AND", this.handleTwoArguments$default$4());
                break;
            }
            case 21: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.TODO", "TODO: INT_CARRY", this.handleTwoArguments$default$4());
                break;
            }
            case 33: 
            case 34: 
            case 48: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.division", "/", this.handleTwoArguments$default$4());
                break;
            }
            case 11: 
            case 41: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.equal", "==", this.handleTwoArguments$default$4());
                break;
            }
            case 12: 
            case 42: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.notEqual", "!=", this.handleTwoArguments$default$4());
                break;
            }
            case 29: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.shiftLeft", "<<", this.handleTwoArguments$default$4());
                break;
            }
            case 32: 
            case 49: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.multiplication", "*", this.handleTwoArguments$default$4());
                break;
            }
            case 25: 
            case 51: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.negation", pcodeOp.getMnemonic());
                break;
            }
            case 28: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.or", "||", this.handleTwoArguments$default$4());
                break;
            }
            case 35: 
            case 36: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.modolo", "%", this.handleTwoArguments$default$4());
                break;
            }
            case 30: 
            case 31: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.shiftRight", ">>", this.handleTwoArguments$default$4());
                break;
            }
            case 23: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.sborrow", pcodeOp.getMnemonic());
                break;
            }
            case 22: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.scarry", pcodeOp.getMnemonic());
                break;
            }
            case 17: 
            case 18: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.extend", pcodeOp.getMnemonic());
                break;
            }
            case 20: 
            case 50: 
            case 66: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.subtraction", "-", this.handleTwoArguments$default$4());
                break;
            }
            case 26: {
                cfgNodeNew = this.handleTwoArguments(pcodeOp, "<operator>.xor", "^", this.handleTwoArguments$default$4());
                break;
            }
            case 1: 
            case 2: 
            case 63: {
                cfgNodeNew = this.handleAssignment(pcodeOp, this.nativeInstruction.toString());
                break;
            }
            case 3: {
                cfgNodeNew = this.handleStore(pcodeOp);
                break;
            }
            case 69: {
                cfgNodeNew = this.handleSingleArgument(pcodeOp, "<operator>.new", pcodeOp.getMnemonic());
                break;
            }
            case 0: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 74: {
                cfgNodeNew = this.createCall("TODO: UNIMPLEMENTED | SEGMENTOP | MULTIEQUAL | INDIRECT | PIECE | PCODE_MAX | POPCOUNT ", "TODO: UNIMPLEMENTED | SEGMENTOP | MULTIEQUAL | INDIRECT | PIECE | PCODE_MAX | POPCOUNT ", this.createCall$default$3());
                break;
            }
            case 72: {
                cfgNodeNew = this.handleAssignment(pcodeOp, this.nativeInstruction.toString());
                break;
            }
            default: {
                cfgNodeNew = this.createCall("NOT HANDLED", "NOT HANDLED", this.createCall$default$3());
                break;
            }
        }
        CfgNodeNew callNode = cfgNodeNew;
        return callNode;
    }

    private int mapCallNode$default$2() {
        return -1;
    }

    public CfgNodeNew resolveVarNode(Varnode input, int index) {
        if (input.isRegister()) {
            return Utils$.MODULE$.createIdentifier(this.nativeInstruction.getProgram().getRegister(input).getName(), this.nativeInstruction.getProgram().getRegister(input).getName(), index, Types$.MODULE$.registerType(this.nativeInstruction.getProgram().getRegister(input).getName()), input.getAddress().getOffsetAsBigInteger().intValue());
        }
        if (input.isUnique()) {
            if (this.address2Literal.contains((Object)BoxesRunTime.boxToLong((long)input.getOffset()))) {
                String value = (String)this.address2Literal.apply((Object)BoxesRunTime.boxToLong((long)((Varnode)Predef$.MODULE$.wrapRefArray((Object[])input.getDef().getInputs()).toList().head()).getAddress().getOffset()));
                return Utils$.MODULE$.createLiteral(value, index, index, RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), this.nativeInstruction.getMinAddress().getOffsetAsBigInteger().intValue());
            }
            List uniques = this.pcodeOps.filter((Function1 & Serializable)x -> {
                Varnode varnode = x.getOutput();
                Varnode varnode2 = input;
                return !(varnode != null ? !varnode.equals(varnode2) : varnode2 != null);
            }).filterNot((Function1 & Serializable)x -> {
                Varnode varnode = x.getInput(0);
                Varnode varnode2 = input;
                return !(varnode != null ? !varnode.equals(varnode2) : varnode2 != null);
            });
            return this.mapCallNode((PcodeOp)uniques.last(), index);
        }
        return Utils$.MODULE$.createLiteral("0x" + RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset())), index, index, Types$.MODULE$.registerType(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(input.getWordOffset()))), -1);
    }

    public void connectCallToArgument(CfgNodeNew call, CfgNodeNew argument) {
        this.diffGraphBuilder.addNode((DetachedNodeData)argument);
        this.diffGraphBuilder.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)argument, "ARGUMENT");
        this.diffGraphBuilder.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)argument, "AST");
    }

    private static final String $anonfun$3(ObjectRef valueString$1) {
        return (String)valueString$1.elem;
    }
}

