/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg.passes;

import ghidra.app.util.template.TemplateSimplifier;
import ghidra.program.model.address.GenericAddress;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.CodeUnitFormatOptions;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.scalar.Scalar;
import io.joern.ghidra2cpg.Types$;
import io.joern.ghidra2cpg.processors.Processor;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.Utils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.CfgNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.NewLiteral;
import io.shiftleft.codepropertygraph.generated.nodes.NewLiteral$;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodParameterIn;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.NodeOrDetachedNode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public abstract class FunctionPass
extends ConcurrentWriterCpgPass<Function> {
    private final Processor processor;
    private final Program currentProgram;
    private final List<Function> functions;
    private final Decompiler decompiler;
    private final Map functionByName;
    private final CodeUnitFormat codeUnitFormat;

    public FunctionPass(Processor processor, Program currentProgram, List<Function> functions, Cpg cpg, Decompiler decompiler) {
        this.processor = processor;
        this.currentProgram = currentProgram;
        this.functions = functions;
        this.decompiler = decompiler;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.functionByName = (Map)HashMap$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        functions.foreach((Function1)(JProcedure1 & Serializable)fn -> {
            Function other = (Function)this.functionByName().getOrElseUpdate((Object)fn.getName(), () -> FunctionPass.$anonfun$1(fn));
            if (other != fn) {
                this.baseLogger().warn("Multiple functions with same name " + fn.getName() + ", can't disambiguate: " + fn + ", " + other);
                return;
            }
        });
        this.codeUnitFormat = new CodeUnitFormat(new CodeUnitFormatOptions(CodeUnitFormatOptions.ShowBlockName.NEVER, CodeUnitFormatOptions.ShowNamespace.NEVER, "", true, true, true, true, true, true, true, new TemplateSimplifier()));
    }

    public Map<String, Function> functionByName() {
        return this.functionByName;
    }

    public Option<HighFunction> getHighFunction(Function function) {
        return this.decompiler.toHighFunction(function);
    }

    public Seq<Instruction> getInstructions(Function function) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.currentProgram.getListing().getInstructions(function.getBody(), true).iterator()).asScala().toList();
    }

    public CodeUnitFormat codeUnitFormat() {
        return this.codeUnitFormat;
    }

    public Function[] generateParts() {
        return (Function[])this.functions.toArray(ClassTag$.MODULE$.apply(Function.class));
    }

    public Option<Integer> intToIntegerOption(Option<Object> intOption) {
        return intOption.map((Function1 & Serializable)intValue -> FunctionPass.intToIntegerOption$$anonfun$1(BoxesRunTime.unboxToInt((Object)intValue)));
    }

    public void handleParameters(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Function function, NewMethod methodNode) {
        if (function.isThunk()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])function.getThunkedFunction(true).getParameters());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Parameter parameter = (Parameter)tuple2._1();
                    int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    NewMethodParameterIn node = Utils$.MODULE$.createParameterNode(parameter.getName(), parameter.getName(), index + 1, parameter.getDataType().getName(), function.getEntryPoint().getOffsetAsBigInteger().intValue());
                    diffGraphBuilder.addNode((DetachedNodeData)node);
                    return diffGraphBuilder.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)node, "AST");
                }
                throw new MatchError((Object)tuple2);
            });
            return;
        }
        this.getHighFunction(function).foreach((Function1)(JProcedure1 & Serializable)highFunction -> ((IterableOnceOps)CollectionConverters$.MODULE$.IteratorHasAsScala(highFunction.getLocalSymbolMap().getSymbols()).asScala().toSeq().filter((Function1 & Serializable)_$1 -> _$1.isParameter())).foreach((Function1 & Serializable)parameter -> {
            String checkedParameter = (String)Option$.MODULE$.apply((Object)parameter.getStorage()).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getRegister())).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getName())).getOrElse(() -> FunctionPass.$anonfun$4(parameter));
            NewMethodParameterIn node = Utils$.MODULE$.createParameterNode(checkedParameter, checkedParameter, parameter.getCategoryIndex() + 1, parameter.getDataType().getName(), function.getEntryPoint().getOffsetAsBigInteger().intValue());
            diffGraphBuilder.addNode((DetachedNodeData)node);
            return diffGraphBuilder.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)node, "AST");
        }));
    }

    public void handleLocals(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Function function, NewBlock blockNode) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])function.getLocalVariables());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)local -> {
            NewLocal localNode = NewLocal$.MODULE$.apply().name(local.getName()).code(local.toString()).typeFullName(Types$.MODULE$.registerType(local.getDataType().toString()));
            NewIdentifier identifier = Utils$.MODULE$.createIdentifier(local.getName(), local.getSymbol().getName(), -1, local.getDataType().toString(), -1);
            diffGraphBuilder.addNode((DetachedNodeData)localNode);
            diffGraphBuilder.addNode((DetachedNodeData)identifier);
            diffGraphBuilder.addEdge((NodeOrDetachedNode)blockNode, (NodeOrDetachedNode)localNode, "AST");
            diffGraphBuilder.addEdge((NodeOrDetachedNode)blockNode, (NodeOrDetachedNode)identifier, "AST");
            return diffGraphBuilder.addEdge((NodeOrDetachedNode)identifier, (NodeOrDetachedNode)localNode, "REF");
        });
    }

    public void handleBody(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Function function, NewMethod methodNode, NewBlock blockNode) {
        Seq<Instruction> instructions = this.getInstructions(function);
        if (instructions.nonEmpty()) {
            ObjectRef prevInstructionNode = ObjectRef.create((Object)this.addCallOrReturnNode((Instruction)instructions.head()));
            this.handleArguments(diffGraphBuilder, (Instruction)instructions.head(), (CfgNodeNew)prevInstructionNode.elem, function);
            diffGraphBuilder.addEdge((NodeOrDetachedNode)blockNode, (NodeOrDetachedNode)((CfgNodeNew)prevInstructionNode.elem), "AST");
            diffGraphBuilder.addEdge((NodeOrDetachedNode)methodNode, (NodeOrDetachedNode)((CfgNodeNew)prevInstructionNode.elem), "CFG");
            ((IterableOnceOps)instructions.drop(1)).foreach((Function1)(JProcedure1 & Serializable)instruction -> {
                CfgNodeNew instructionNode = this.addCallOrReturnNode((Instruction)instruction);
                diffGraphBuilder.addNode((DetachedNodeData)instructionNode);
                this.handleArguments(diffGraphBuilder, (Instruction)instruction, instructionNode, function);
                diffGraphBuilder.addEdge((NodeOrDetachedNode)blockNode, (NodeOrDetachedNode)instructionNode, "AST");
                diffGraphBuilder.addEdge((NodeOrDetachedNode)((CfgNodeNew)prevInstructionNode$1.elem), (NodeOrDetachedNode)instructionNode, "CFG");
                CfgNodeNew cfgNodeNew = instructionNode;
                prevInstructionNode$1.elem = cfgNodeNew;
                cfgNodeNew = null;
            });
            return;
        }
    }

    public void handleArguments(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, Instruction instruction, CfgNodeNew callNode, Function function) {
        String mnemonicString = (String)this.processor.getInstructions().getOrElse((Object)instruction.getMnemonicString(), FunctionPass::$anonfun$5);
        if (mnemonicString.equals("CALL")) {
            String calledFunction = this.codeUnitFormat().getOperandRepresentationString((CodeUnit)instruction, 0);
            this.functionByName().get((Object)calledFunction).map((Function1)(JProcedure1 & Serializable)callee -> {
                Object[] checkedParameters = (Tuple3[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple3.class));
                if (callee.isThunk()) {
                    Object[] parameters = callee.getParameters();
                    Object object = Predef$.MODULE$.refArrayOps(parameters);
                    checkedParameters = (Tuple3[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)parameter -> {
                        String checkedParameter = parameter.getRegister() == null ? parameter.getName() : parameter.getRegister().getName();
                        return Tuple3$.MODULE$.apply((Object)checkedParameter, (Object)BoxesRunTime.boxToInteger((int)(parameter.getOrdinal() + 1)), (Object)parameter.getDataType().getName());
                    }, ClassTag$.MODULE$.apply(Tuple3.class));
                } else {
                    Object[] parameters = (HighSymbol[])this.decompiler.toHighFunction((Function)callee).map((Function1 & Serializable)highFunction -> (HighSymbol[])((IterableOnceOps)CollectionConverters$.MODULE$.IteratorHasAsScala(highFunction.getLocalSymbolMap().getSymbols()).asScala().toSeq().filter((Function1 & Serializable)_$2 -> _$2.isParameter())).toArray(ClassTag$.MODULE$.apply(HighSymbol.class))).getOrElse(FunctionPass::$anonfun$7);
                    Object object = Predef$.MODULE$.refArrayOps(parameters);
                    checkedParameters = (Tuple3[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)parameter -> {
                        String checkedParameter = parameter.getStorage().getRegister() == null ? parameter.getName() : parameter.getStorage().getRegister().getName();
                        return Tuple3$.MODULE$.apply((Object)checkedParameter, (Object)BoxesRunTime.boxToInteger((int)(parameter.getCategoryIndex() + 1)), (Object)parameter.getDataType().getName());
                    }, ClassTag$.MODULE$.apply(Tuple3.class));
                }
                Object object = Predef$.MODULE$.refArrayOps(checkedParameters);
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple3 tuple3 = x$1;
                    if (tuple3 != null) {
                        String checkedParameter = (String)tuple3._1();
                        int index = BoxesRunTime.unboxToInt((Object)tuple3._2());
                        String dataType = (String)tuple3._3();
                        NewIdentifier node = Utils$.MODULE$.createIdentifier(checkedParameter, checkedParameter, index, Types$.MODULE$.registerType(dataType), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
                        this.connectCallToArgument(diffGraphBuilder, callNode, (CfgNodeNew)node);
                        return;
                    }
                    throw new MatchError((Object)tuple3);
                });
            });
            return;
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), instruction.getNumOperands()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            Object[] opObjects = instruction.getOpObjects(index);
            if (opObjects.length > 1) {
                String argument = String.valueOf(instruction.getDefaultOperandRepresentation(index));
                NewIdentifier node = Utils$.MODULE$.createIdentifier(argument, argument, index + 1, Types$.MODULE$.registerType(argument), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
                this.connectCallToArgument(diffGraphBuilder, callNode, (CfgNodeNew)node);
                return;
            }
            Object object = Predef$.MODULE$.refArrayOps(opObjects);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)opObject -> {
                String className = opObject.getClass().getSimpleName();
                String string = opObject.getClass().getSimpleName();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1824322548: {
                        if (!"Scalar".equals(string)) break;
                        String scalar = ((Scalar)opObject).toString(16, false, false, "", "");
                        NewLiteral node = NewLiteral$.MODULE$.apply().code("0x" + scalar).order(index + 1).typeFullName(scalar).lineNumber(this.intToIntegerOption((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)instruction.getMinAddress().getOffsetAsBigInteger().intValue()))));
                        this.connectCallToArgument(diffGraphBuilder, callNode, (CfgNodeNew)node);
                        return;
                    }
                    case -1368488387: {
                        if (!"GenericAddress".equals(string)) break;
                        String genericAddress = ((GenericAddress)opObject).toString();
                        NewLiteral node = NewLiteral$.MODULE$.apply().code("0x" + genericAddress).order(index + 1).typeFullName(genericAddress).lineNumber(this.intToIntegerOption((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)instruction.getMinAddress().getOffsetAsBigInteger().intValue()))));
                        this.connectCallToArgument(diffGraphBuilder, callNode, (CfgNodeNew)node);
                        return;
                    }
                    case -625569085: {
                        if (!"Register".equals(string)) break;
                        Register register = (Register)opObject;
                        NewIdentifier node = Utils$.MODULE$.createIdentifier(register.getName(), register.getName(), index + 1, Types$.MODULE$.registerType(register.getName()), instruction.getMinAddress().getOffsetAsBigInteger().intValue());
                        this.connectCallToArgument(diffGraphBuilder, callNode, (CfgNodeNew)node);
                        return;
                    }
                }
                Predef$.MODULE$.println((Object)("Unsupported argument: " + opObject + " " + className));
            });
        });
    }

    public void connectCallToArgument(BatchedUpdate.DiffGraphBuilder diffGraphBuilder, CfgNodeNew call, CfgNodeNew argument) {
        diffGraphBuilder.addNode((DetachedNodeData)argument);
        diffGraphBuilder.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)argument, "ARGUMENT");
        diffGraphBuilder.addEdge((NodeOrDetachedNode)call, (NodeOrDetachedNode)argument, "AST");
    }

    /*
     * Unable to fully structure code
     */
    public CfgNodeNew addCallOrReturnNode(Instruction instruction) {
        var2_2 = (String)this.processor.getInstructions().getOrElse((Object)instruction.getMnemonicString(), (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, addCallOrReturnNode$$anonfun$1(), ()Ljava/lang/String;)());
        switch (var2_2 == null ? 0 : var2_2.hashCode()) {
            case 81025: {
                if (!"RET".equals(var2_2)) ** break;
                return Utils$.MODULE$.createReturnNode(instruction.toString(), Predef$.MODULE$.int2Integer(instruction.getMinAddress().getOffsetAsBigInteger().intValue()));
            }
            case 2060894: {
                if ("CALL".equals(var2_2)) break;
                ** break;
            }
            case 72308375: {
                if ("LEAVE".equals(var2_2)) break;
                ** break;
            }
            case 433141802: {
                if (!"UNKNOWN".equals(var2_2)) ** break;
                return Utils$.MODULE$.createCallNode(instruction.toString(), "UNKNOWN", Predef$.MODULE$.int2Integer(instruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
            }
        }
        code = this.sanitizeMethodName(this.codeUnitFormat().getOperandRepresentationString((CodeUnit)instruction, 0));
        return Utils$.MODULE$.createCallNode(code, code, Predef$.MODULE$.int2Integer(instruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
lbl17:
        // 5 sources

        operator = var2_2;
        return Utils$.MODULE$.createCallNode(instruction.toString(), operator, Predef$.MODULE$.int2Integer(instruction.getMinAddress().getOffsetAsBigInteger().intValue()), Utils$.MODULE$.createCallNode$default$4());
    }

    public String sanitizeMethodName(String methodName) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])methodName.split(">"));
        return ((String)ArrayOps$.MODULE$.lastOption$extension(object).getOrElse(() -> FunctionPass.sanitizeMethodName$$anonfun$1(methodName))).replace("[", "").replace("]", "");
    }

    private static final Function $anonfun$1(Function fn$1) {
        return fn$1;
    }

    private static final /* synthetic */ Integer intToIntegerOption$$anonfun$1(int intValue) {
        int integerValue = intValue;
        return Predef$.MODULE$.int2Integer(integerValue);
    }

    private static final String $anonfun$4(HighSymbol parameter$1) {
        return parameter$1.getName();
    }

    private static final String $anonfun$5() {
        return "UNKNOWN";
    }

    private static final HighSymbol[] $anonfun$7() {
        return (HighSymbol[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(HighSymbol.class));
    }

    private static final String addCallOrReturnNode$$anonfun$1() {
        return "UNKNOWN";
    }

    private static final String sanitizeMethodName$$anonfun$1(String methodName$1) {
        return methodName$1;
    }
}

