/*
 * Decompiled with CFR 0.152.
 */
package flatgraph.traversal;

import flatgraph.help.Doc;
import flatgraph.traversal.GenericSteps;
import flatgraph.traversal.PathAwareRepeatStep$;
import flatgraph.traversal.PathAwareTraversal;
import flatgraph.traversal.RepeatBehaviour;
import flatgraph.traversal.RepeatBehaviour$;
import flatgraph.traversal.RepeatStep$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Growable;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class GenericSteps$
implements Serializable {
    public static final GenericSteps$ MODULE$ = new GenericSteps$();

    private GenericSteps$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GenericSteps$.class);
    }

    public final <A> int hashCode$extension(Iterator $this) {
        return $this.hashCode();
    }

    public final <A> boolean equals$extension(Iterator $this, Object x$0) {
        Object object = x$0;
        if (object instanceof GenericSteps) {
            Iterator iterator = object == null ? null : ((GenericSteps)object).flatgraph$traversal$GenericSteps$$iterator();
            Iterator iterator2 = $this;
            Iterator iterator3 = iterator;
            return !(iterator2 != null ? !iterator2.equals(iterator3) : iterator3 != null);
        }
        return false;
    }

    @Doc(info="Execute the traversal and convert the result to a list - shorthand for `toList`")
    public final <A> List<A> l$extension(Iterator $this) {
        return $this.toList();
    }

    @Doc(info="group elements and count how often they appear")
    public final <B, A> Map<B, Object> groupCount$extension(Iterator $this) {
        return this.groupCount$extension($this, (Function1 & Serializable)x -> Predef$.MODULE$.identity(x));
    }

    @Doc(info="group elements by a given transformation function and count how often the results appear")
    public final <B, A> Map<B, Object> groupCount$extension(Iterator $this, Function1<A, B> by) {
        scala.collection.mutable.Map counts = ((scala.collection.mutable.Map)Map$.MODULE$.empty()).withDefaultValue((Object)BoxesRunTime.boxToInteger((int)0));
        $this.foreach((Function1)(JProcedure1 & Serializable)a -> {
            Object b = by.apply(a);
            int newValue = BoxesRunTime.unboxToInt((Object)counts.apply(b)) + 1;
            counts.update(b, (Object)BoxesRunTime.boxToInteger((int)newValue));
        });
        return (Map)counts.to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
    }

    public final <K, A> Map<K, List<A>> groupBy$extension(Iterator $this, Function1<A, K> f) {
        return this.l$extension($this).groupBy(f);
    }

    public final <K, B, A> Map<K, List<B>> groupMap$extension(Iterator $this, Function1<A, K> key, Function1<A, B> f) {
        return this.l$extension($this).groupMap(key, f);
    }

    public final <K, B, A> Map<K, B> groupMapReduce$extension(Iterator $this, Function1<A, K> key, Function1<A, B> f, Function2<B, B, B> reduce) {
        return this.l$extension($this).groupMapReduce(key, f, reduce);
    }

    public final <B, A> LinkedHashSet<B> toSetMutable$extension(Iterator $this) {
        return LinkedHashSet$.MODULE$.from((IterableOnce)$this);
    }

    public final <B, A> Set<B> toSetImmutable$extension(Iterator $this) {
        return $this.toSet();
    }

    @Doc(info="Execute the traversal without returning anything")
    public final <A> void iterate$extension(Iterator $this) {
        while ($this.hasNext()) {
            $this.next();
        }
    }

    public final <A> Iterator<Object> countTrav$extension(Iterator $this) {
        return Iterator$.MODULE$.single((Object)BoxesRunTime.boxToInteger((int)$this.size()));
    }

    public final <A> A head$extension(Iterator $this) {
        return (A)$this.next();
    }

    public final <A> Option<A> headOption$extension(Iterator $this) {
        return $this.nextOption();
    }

    public final <A> A last$extension(Iterator $this) {
        $this.hasNext();
        Object res = $this.next();
        while ($this.hasNext()) {
            res = $this.next();
        }
        return (A)res;
    }

    public final <A> Option<A> lastOption$extension(Iterator $this) {
        if ($this.hasNext()) {
            return Some$.MODULE$.apply(this.last$extension($this));
        }
        return None$.MODULE$;
    }

    @Doc(info="casts all elements to given type")
    public final <B, A> Iterator<B> cast$extension(Iterator $this) {
        return $this;
    }

    @Doc(info="collects all elements of the provided class (beware of type-erasure)")
    public final <B, A> Iterator<B> collectAll$extension(Iterator $this, ClassTag<B> ev) {
        Class clazz = ev.runtimeClass();
        return $this.filter((Function1 & Serializable)x$0 -> clazz.isInstance(x$0));
    }

    @Doc(info="deduplicate elements of this traversal - a.k.a. distinct, unique, ...")
    public final <A> Iterator<A> dedup$extension(Iterator $this) {
        return $this.distinct();
    }

    @Doc(info="deduplicate elements of this traversal by a given function")
    public final <A> Iterator<A> dedupBy$extension(Iterator $this, Function1<A, Object> fun) {
        return $this.distinctBy(fun);
    }

    @Doc(info="sort elements by their natural order")
    public final <B, A> Seq<B> sorted$extension(Iterator $this, Ordering<B> ord) {
        return ((ArraySeq)$this.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ArraySeq$.MODULE$.untagged()))).sorted(ord);
    }

    @Doc(info="sort elements by the value of the given transformation function")
    public final <B, A> Seq<A> sortBy$extension(Iterator $this, Function1<A, B> f, Ordering<B> ord) {
        return (Seq)((SeqOps)$this.to(IterableFactory$.MODULE$.toFactory((IterableFactory)ArraySeq$.MODULE$.untagged()))).sortBy(f, ord);
    }

    @Doc(info="filters out everything that is _not_ the given value")
    public final <B, A> Iterator<A> is$extension(Iterator $this, B value) {
        return $this.filter((Function1 & Serializable)_$1 -> BoxesRunTime.equals((Object)_$1, (Object)value));
    }

    @Doc(info="filters out all elements that are _not_ in the provided set")
    public final <B, A> Iterator<A> within$extension(Iterator $this, Set<B> values) {
        return $this.filter((Function1 & Serializable)elem -> values.contains(elem));
    }

    @Doc(info="filters out all elements that _are_ in the provided set")
    public final <B, A> Iterator<A> without$extension(Iterator $this, Set<B> values) {
        return $this.filterNot((Function1 & Serializable)elem -> values.contains(elem));
    }

    @Doc(info="perform side effect without changing the contents of the traversal")
    public final <A> Iterator<A> sideEffect$extension(Iterator $this, Function1<A, ?> fun) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._sideEffect(fun);
        }
        return $this.map((Function1 & Serializable)a -> {
            fun.apply(a);
            return a;
        });
    }

    @Doc(info="perform side effect without changing the contents of the traversal")
    public final <A> Iterator<A> sideEffectPF$extension(Iterator $this, PartialFunction<A, ?> pf) {
        return this.sideEffect$extension($this, pf.lift());
    }

    @Doc(info="only preserves elements if the provided traversal has at least one result")
    public final <A> Iterator<A> where$extension(Iterator $this, Function1<Iterator<A>, Iterator<?>> trav) {
        return $this.filter((Function1 & Serializable)a -> ((Iterator)trav.apply((Object)Iterator$.MODULE$.single(a))).hasNext());
    }

    @Doc(info="only preserves elements if the provided traversal does _not_ have any results")
    public final <A> Iterator<A> whereNot$extension(Iterator $this, Function1<Iterator<A>, Iterator<?>> trav) {
        return $this.filter((Function1 & Serializable)a -> !((Iterator)trav.apply((Object)Iterator$.MODULE$.single(a))).hasNext());
    }

    @Doc(info="only preserves elements if the provided traversal does _not_ have any results - alias for whereNot")
    public final <A> Iterator<A> not$extension(Iterator $this, Function1<Iterator<A>, Iterator<?>> trav) {
        return this.whereNot$extension($this, trav);
    }

    @Doc(info="only preserves elements for which _at least one of_ the given traversals has at least one result")
    public final <A> Iterator<A> or$extension(Iterator $this, Seq<Function1<Iterator<A>, Iterator<?>>> traversals) {
        return $this.filter((Function1 & Serializable)a -> traversals.exists((Function1 & Serializable)trav -> ((Iterator)trav.apply((Object)Iterator$.MODULE$.single(a))).hasNext()));
    }

    @Doc(info="only preserves elements for which _all of_ the given traversals have at least one result")
    public final <A> Iterator<A> and$extension(Iterator $this, Seq<Function1<Iterator<A>, Iterator<?>>> traversals) {
        return $this.filter((Function1 & Serializable)a -> traversals.forall((Function1 & Serializable)trav -> ((Iterator)trav.apply((Object)Iterator$.MODULE$.single(a))).hasNext()));
    }

    @Doc(info="union/sum/aggregate/join given traversals from the current point")
    public final <B, A> Iterator<B> union$extension(Iterator $this, Seq<Function1<Iterator<A>, Iterator<B>>> traversals) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._union(traversals);
        }
        return $this.flatMap((Function1 & Serializable)a -> (IterableOnce)traversals.flatMap((Function1 & Serializable)_$2 -> (IterableOnce)_$2.apply((Object)Iterator$.MODULE$.single(a))));
    }

    @Doc(info="allows to implement conditional semantics: if, if/else, if/elseif, if/elseif/else, ...")
    public final <BranchOn, NewEnd, A> Iterator<NewEnd> choose$extension(Iterator $this, Function1<Iterator<A>, Iterator<BranchOn>> on, PartialFunction<BranchOn, Function1<Iterator<A>, Iterator<NewEnd>>> options) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._choose(on, options);
        }
        return $this.flatMap((Function1 & Serializable)a -> {
            Object branchOnValue = ((Iterator)on.apply((Object)Iterator$.MODULE$.single(a))).nextOption().getOrElse(GenericSteps$::$anonfun$1);
            return (IterableOnce)((Function1)options.applyOrElse(branchOnValue, (Function1 & Serializable)failState -> (Function1 & Serializable)unused -> Iterator$.MODULE$.empty())).apply((Object)Iterator$.MODULE$.single(a));
        });
    }

    @Doc(info="evaluates the provided traversals in order and returns the first traversal that emits at least one element")
    public final <NewEnd, A> Iterator<NewEnd> coalesce$extension(Iterator $this, Seq<Function1<Iterator<A>, Iterator<NewEnd>>> options) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal._coalesce(options);
        }
        return $this.flatMap((Function1 & Serializable)a -> (IterableOnce)options.iterator().map((Function1 & Serializable)_$3 -> (Iterator)_$3.apply((Object)Iterator$.MODULE$.single(a))).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Iterator x) {
                Iterator iterator = x;
                Iterator option = iterator;
                return option.nonEmpty();
            }

            public final Object applyOrElse(Iterator x, Function1 function1) {
                Iterator iterator = x;
                Iterator option = iterator;
                if (option.nonEmpty()) {
                    return option;
                }
                return function1.apply((Object)x);
            }
        }).getOrElse(GenericSteps$::coalesce$extension$$anonfun$1$$anonfun$2));
    }

    @Doc(info="enable path tracking - prerequisite for path/simplePath steps")
    public final <A> PathAwareTraversal<A> enablePathTracking$extension(Iterator $this) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            throw new RuntimeException("path tracking is already enabled");
        }
        return new PathAwareTraversal($this.map((Function1 & Serializable)a -> Tuple2$.MODULE$.apply(a, (Object)package$.MODULE$.Vector().empty())));
    }

    @Doc(info="enable path tracking - prerequisite for path/simplePath steps")
    public final <A> Iterator<A> discardPathTracking$extension(Iterator $this) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal pathAwareTraversal = (PathAwareTraversal)iterator;
            return pathAwareTraversal.wrapped().map((Function1 & Serializable)_$4 -> _$4._1());
        }
        return $this;
    }

    public final <A> boolean isPathTracking$extension(Iterator $this) {
        return $this instanceof PathAwareTraversal;
    }

    @Doc(info="retrieve entire path that has been traversed thus far")
    public final <A> Iterator<Vector<Object>> path$extension(Iterator $this) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal tracked = (PathAwareTraversal)iterator;
            return tracked.wrapped().map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Vector p = (Vector)tuple2._2();
                    return p.appended(a);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        throw new AssertionError((Object)"path tracking not enabled, please make sure you have a `PathAwareTraversal`, e.g. via `Traversal.enablePathTracking`");
    }

    public final <A> Iterator<A> simplePath$extension(Iterator $this) {
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal tracked = (PathAwareTraversal)iterator;
            return new PathAwareTraversal(tracked.wrapped().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Vector p = (Vector)tuple2._2();
                    return ((IterableOnceOps)((Growable)Set$.MODULE$.from((IterableOnce)p)).addOne(a)).size() == 1 + p.size();
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        throw new AssertionError((Object)"path tracking not enabled, please make sure you have a `PathAwareTraversal`, e.g. via `Traversal.enablePathTracking`");
    }

    @Doc(info="repeat the given traversal")
    public final <B, A> Iterator<B> repeat$extension(Iterator $this, Function1<Iterator<A>, Iterator<B>> repeatTraversal, Function1<RepeatBehaviour.Builder<B>, RepeatBehaviour.Builder<B>> behaviourBuilder) {
        RepeatBehaviour behaviour = ((RepeatBehaviour.Builder)behaviourBuilder.apply(new RepeatBehaviour.Builder())).build();
        Function1<Iterator<A>, Iterator<B>> _repeatTraversal = repeatTraversal;
        Iterator iterator = $this;
        if (iterator instanceof PathAwareTraversal) {
            PathAwareTraversal tracked = (PathAwareTraversal)iterator;
            Function1 step = PathAwareRepeatStep$.MODULE$.apply(_repeatTraversal, behaviour);
            return new PathAwareTraversal(tracked.wrapped().flatMap((Function1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    Object a = tuple2._1();
                    Vector p = (Vector)tuple2._2();
                    return ((PathAwareTraversal)step.apply(a)).wrapped().map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            Object aa = tuple2._1();
                            Vector pp = (Vector)tuple2._2();
                            return Tuple2$.MODULE$.apply(aa, p.$plus$plus((IterableOnce)pp));
                        }
                        throw new MatchError((Object)tuple2);
                    });
                }
                throw new MatchError((Object)tuple2);
            }));
        }
        return $this.flatMap(RepeatStep$.MODULE$.apply(_repeatTraversal, behaviour));
    }

    public final <B, A> Function1<RepeatBehaviour.Builder<B>, RepeatBehaviour.Builder<B>> repeat$default$2$extension(Iterator $this, Function1<Iterator<A>, Iterator<B>> repeatTraversal) {
        return (Function1 & Serializable)builder -> RepeatBehaviour$.MODULE$.noop(builder);
    }

    private static final Object $anonfun$1() {
        return null;
    }

    private static final Iterator coalesce$extension$$anonfun$1$$anonfun$2() {
        return Iterator$.MODULE$.empty();
    }
}

